/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.projectiles.EntityHook;
import com.pixelmonmod.pixelmon.enums.items.EnumRodType;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFishingRod
extends PixelmonItem {
    private EnumRodType rodType;

    public ItemFishingRod(EnumRodType rodType, String name) {
        super(name);
        this.rodType = rodType;
        this.canRepair = false;
        this.func_77656_e(rodType.maxDamage);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.field_71104_cf != null) {
            boolean canPull = true;
            if (playerIn.field_71104_cf.field_146043_c != null) {
                canPull = playerIn.field_71104_cf.field_146043_c.func_70104_M();
            }
            if (canPull) {
                int i = playerIn.field_71104_cf.func_146034_e();
                playerIn.func_184586_b(hand).func_77972_a(i, (EntityLivingBase)playerIn);
            }
        } else if (Pixelmon.storageManager.getParty(playerIn.func_110124_au()).getTeam().stream().anyMatch(Pokemon::canBattle)) {
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u + 0.5, playerIn.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 0.5f, 1.0f);
            int rodLevel = -1;
            if (playerIn.func_184586_b(hand).func_77942_o()) {
                rodLevel = playerIn.func_184586_b(hand).func_77978_p().func_74762_e("rodQuality");
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d((Entity)new EntityHook(worldIn, playerIn, this.rodType, rodLevel));
            }
        } else {
            ChatHandler.sendChat((Entity)playerIn, "pixelmon.projectiles.teamfainted", new Object[0]);
        }
        playerIn.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    public EnumRodType getRodType() {
        return this.rodType;
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        int rodLevel = -1;
        if (stack.func_77942_o()) {
            rodLevel = stack.func_77978_p().func_74762_e("rodQuality");
        }
        if (rodLevel > -1) {
            tooltip.add(I18n.func_74838_a((String)("item." + this.rodType.name().toLowerCase() + ".quality_" + rodLevel)));
        }
        super.func_77624_a(stack, world, tooltip, advanced);
    }
}

