/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.heldItems;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.config.PixelmonCreativeTabs;
import com.pixelmonmod.pixelmon.config.PixelmonItemsTMs;
import com.pixelmonmod.pixelmon.enums.ITechnicalMove;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemBlankTechnicalRecord
extends ItemHeld {
    public static final Map<ITechnicalMove, Integer> maxImprintCount = Maps.newHashMap();

    public ItemBlankTechnicalRecord() {
        super(EnumHeldItems.other, "tr8_blank");
        this.func_77637_a(PixelmonCreativeTabs.tms);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound compound = stack.func_190925_c("tr8");
        if (compound.func_74762_e("id") != 0) {
            int trId = compound.func_74762_e("id");
            short count = compound.func_74765_d("count");
            ITechnicalMove move = ITechnicalMove.Gen8TechnicalRecords.getTr(trId);
            int maxCount = compound.func_74764_b("max_count") ? compound.func_74765_d("max_count") : maxImprintCount.getOrDefault(move, 25).intValue();
            tooltip.add(I18n.func_135052_a((String)"tm.blankdata.tooltip", (Object[])new Object[]{move.getAttack().getLocalizedName(), count, maxCount}));
        } else {
            super.func_77624_a(stack, world, tooltip, advanced);
        }
    }

    @Override
    public void onAttackUsed(PixelmonWrapper user, Attack attack) {
        ItemStack stack = user.pokemon.getHeldItem();
        if (stack.func_77973_b() != this) {
            return;
        }
        ITechnicalMove move = ITechnicalMove.Gen8TechnicalRecords.getTr(attack.getActualMove().getAttackName());
        if (move != null) {
            int maxCount;
            NBTTagCompound compound = stack.func_190925_c("tr8");
            if (compound.func_74762_e("id") == 0) {
                if (maxImprintCount.get(move) == -1) {
                    return;
                }
                compound.func_74768_a("id", move.getId());
                compound.func_74777_a("count", (short)1);
                return;
            }
            if (compound.func_74762_e("id") == move.getId()) {
                compound.func_74777_a("count", (short)((byte)(compound.func_74765_d("count") + 1)));
            }
            int n = maxCount = compound.func_74764_b("max_count") ? compound.func_74765_d("max_count") : maxImprintCount.getOrDefault(move, 25).intValue();
            if (maxCount <= compound.func_74765_d("count")) {
                user.pokemon.setHeldItem(new ItemStack(PixelmonItemsTMs.gen8TRs.get(move)));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tr8")) {
            stack.func_190919_e("tr8");
        }
    }
}

