/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.quests.QuestRegistry;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.comm.SendQuestData;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.IInserter;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.Inserter;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.entity.DialogueInjectObjective;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.ISaveData;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class QuestProgress
implements ISaveData {
    private short stage;
    private HashMap<String, Long> data1;
    private HashMap<String, String> data2;
    private short[] objectiveCompletion;
    private short[] objectiveCompletionReference;
    private boolean started;
    private boolean complete;
    private boolean failed;
    private String questFilename;
    private UUID identifier;
    private transient Quest quest = null;

    public QuestProgress(Quest quest) {
        this.questFilename = quest.getFilename();
        this.identifier = UUID.randomUUID();
        this.stage = 0;
        this.data1 = new HashMap();
        this.data2 = new HashMap();
        Stage stage = quest.getStage(this);
        int objArrSize = stage.getParsedObjectives().size();
        this.objectiveCompletion = new short[objArrSize];
        this.objectiveCompletionReference = new short[objArrSize];
        for (int i = 0; i < this.objectiveCompletion.length; ++i) {
            this.objectiveCompletion[i] = stage.getParsedObjectives().get(i).getQuantity();
            this.objectiveCompletionReference[i] = this.objectiveCompletion[i];
        }
        this.started = false;
        this.complete = false;
        this.failed = false;
    }

    public void start() {
        this.started = true;
    }

    public void fail(EntityPlayerMP player) {
        this.failed = true;
        this.stage = 0;
        this.data1.clear();
        this.data2.clear();
        this.complete(player);
        Stage stage = this.quest.getStage(this);
        int objArrSize = stage.getParsedObjectives().size();
        this.objectiveCompletion = new short[objArrSize];
        this.objectiveCompletionReference = new short[objArrSize];
        for (int i = 0; i < this.objectiveCompletion.length; ++i) {
            this.objectiveCompletion[i] = stage.getParsedObjectives().get(i).getQuantity();
            this.objectiveCompletionReference[i] = this.objectiveCompletion[i];
        }
    }

    public void complete(EntityPlayerMP player) {
        this.complete = true;
        this.objectiveCompletion = new short[0];
        this.objectiveCompletionReference = new short[0];
        this.sendTo(player);
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isComplete() {
        return this.complete && !this.failed;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void reopen() {
        this.complete = false;
        this.failed = false;
    }

    public Long getDataLong(String key) {
        return this.data1.getOrDefault(key, null);
    }

    public String getDataString(String key) {
        return this.data2.getOrDefault(key, null);
    }

    public HashMap<String, Long> getDataLongMap() {
        return this.data1;
    }

    public HashMap<String, String> getDataStringMap() {
        return this.data2;
    }

    public ArrayList<UUID> getDataUUIDs() {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (String str : this.data2.values()) {
            try {
                uuids.add(UUID.fromString(str));
            }
            catch (Exception exception) {}
        }
        return uuids;
    }

    public void setData(String key, long value) {
        this.data1.put(key, value);
    }

    public void setData(String key, String value) {
        this.data2.put(key, value);
    }

    public void sendTo(EntityPlayerMP player) {
        if (!(player instanceof FakePlayer)) {
            Pixelmon.network.sendTo((IMessage)new SendQuestData(this), player);
        }
    }

    public short getStage() {
        return this.stage;
    }

    public Stage getCurrentStage() {
        return this.getQuest().getStage(this);
    }

    public Stage getNextStage() {
        return this.getQuest().getNextStage(this.stage);
    }

    public boolean setStage(short stage) {
        short prevStage = this.stage;
        this.stage = stage;
        Stage s = this.getQuest().getStage(this);
        if (s == null || s.getParsedObjectives() == null) {
            this.stage = prevStage;
            return false;
        }
        int objArrSize = s.getParsedObjectives().size();
        this.objectiveCompletion = new short[objArrSize];
        this.objectiveCompletionReference = new short[objArrSize];
        for (int i = 0; i < this.objectiveCompletion.length; ++i) {
            this.objectiveCompletion[i] = s.getParsedObjectives().get(i).getQuantity();
            if (Pixelmon.devEnvironment) {
                System.out.println("o: " + s.getParsedObjectives().get(i));
            }
            this.objectiveCompletionReference[i] = this.objectiveCompletion[i];
        }
        return true;
    }

    public boolean moveStage(QuestData quest, Stage oldStage, short newStageID, QuestProgress progress) throws InvalidQuestArgsException {
        progress.setStage(newStageID);
        Stage newStage = progress.getCurrentStage();
        if (newStage != null && oldStage.getParsedObjectives().size() >= 2 && newStage.getParsedObjectives().size() >= 2) {
            Objective oldFirst = oldStage.getParsedObjectives().get(0);
            Objective newFirst = newStage.getParsedObjectives().get(0);
            if (oldFirst.getInternalObjective() instanceof DialogueInjectObjective && newFirst.getInternalObjective() instanceof DialogueInjectObjective) {
                UUID newUUID;
                DialogueInjectObjective oldObj = (DialogueInjectObjective)oldFirst.getInternalObjective();
                DialogueInjectObjective newObj = (DialogueInjectObjective)newFirst.getInternalObjective();
                UUID oldUUID = oldObj.getUUID(oldFirst.getData(), progress, oldStage);
                if (oldUUID.equals(newUUID = newObj.getUUID(newFirst.getData(), progress, newStage))) {
                    newObj.test(newStage, quest, progress, newFirst, newFirst.getData(), quest.getPlayer().func_71121_q().func_175733_a(newUUID));
                    return true;
                }
            }
        }
        return false;
    }

    public void completeObjective(int index) {
        if (this.objectiveCompletion[index] > 0) {
            int n = index;
            this.objectiveCompletion[n] = (short)(this.objectiveCompletion[n] - 1);
        }
    }

    public void resetObjective(int index) {
        if (this.objectiveCompletion.length > index) {
            this.objectiveCompletion[index] = 1;
        }
    }

    public boolean isObjectiveComplete(int index) {
        if (index >= this.objectiveCompletion.length) {
            return false;
        }
        return this.objectiveCompletion[index] == 0;
    }

    public short getObjectiveQuantityComplete(int index) {
        if (index >= this.objectiveCompletion.length) {
            return 0;
        }
        return (short)(this.objectiveCompletionReference[index] - this.objectiveCompletion[index]);
    }

    public short getObjectiveTotalQuantity(int index) {
        if (index >= this.objectiveCompletion.length) {
            return 0;
        }
        return this.objectiveCompletionReference[index];
    }

    public boolean canProgress() {
        for (short shrt : this.objectiveCompletion) {
            if (shrt <= 0) continue;
            return false;
        }
        return true;
    }

    public IInserter getValidInserter(Inserter inserter) {
        Quest quest = this.getQuest();
        Stage stage = quest.getStage(this.stage);
        int i = 0;
        for (Objective objective : stage.getParsedObjectives()) {
            if (this.isObjectiveComplete(i++) || !objective.hasInserter() || objective.getInserter().inserter() != inserter) continue;
            return objective.getInserter();
        }
        return null;
    }

    public QuestMarker.Type getMarkerType() {
        return this.getNextStage() == null ? QuestMarker.Type.QUESTION : QuestMarker.Type.EXCLAMATION;
    }

    public ArrayList<QuestMarker> getMarkers() {
        Stage stage = this.getCurrentStage();
        ArrayList<QuestMarker> markers = new ArrayList<QuestMarker>();
        for (Objective objective : stage.getParsedObjectives()) {
            markers.addAll(objective.mark(stage, this, objective.getData()));
        }
        return markers;
    }

    public String getQuestFilename() {
        return this.questFilename;
    }

    public Quest getQuest() {
        if (this.quest == null) {
            for (Quest quest : QuestRegistry.getInstance().getQuestCollection()) {
                if (!quest.getFilename().equals(this.getQuestFilename())) continue;
                this.quest = quest;
                break;
            }
        }
        return this.quest;
    }

    public void invalidate() {
        this.quest = null;
    }

    public UUID getIdentifier() {
        return this.identifier;
    }

    public QuestProgress(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        void var5_13;
        nbt.func_74777_a("QuestStage", this.stage);
        NBTTagList data1TagList = new NBTTagList();
        for (Map.Entry<String, Long> entry : this.data1.entrySet()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74778_a("QuestDataKey", entry.getKey());
            nBTTagCompound.func_74772_a("QuestDataValue", entry.getValue().longValue());
            data1TagList.func_74742_a((NBTBase)nBTTagCompound);
        }
        nbt.func_74782_a("QuestData1", (NBTBase)data1TagList);
        NBTTagList data2TagList = new NBTTagList();
        for (Map.Entry<String, String> entry : this.data2.entrySet()) {
            NBTTagCompound kvPair = new NBTTagCompound();
            kvPair.func_74778_a("QuestDataKey", entry.getKey());
            kvPair.func_74778_a("QuestDataValue", entry.getValue());
            data2TagList.func_74742_a((NBTBase)kvPair);
        }
        nbt.func_74782_a("QuestData2", (NBTBase)data2TagList);
        nbt.func_74757_a("QuestStarted", this.started);
        nbt.func_74757_a("QuestComplete", this.complete);
        nbt.func_74757_a("QuestFailed", this.failed);
        if (this.objectiveCompletion == null) {
            void var4_7;
            this.objectiveCompletion = new short[this.getCurrentStage().getParsedObjectives().size()];
            boolean bl = false;
            while (var4_7 < this.objectiveCompletion.length) {
                this.objectiveCompletion[var4_7] = this.getCurrentStage().getParsedObjectives().get((int)var4_7).getQuantity();
                ++var4_7;
            }
        }
        int[] nArray = new int[this.objectiveCompletion.length];
        boolean bl = false;
        while (var5_13 < nArray.length) {
            nArray[var5_13] = this.objectiveCompletion[var5_13];
            ++var5_13;
        }
        nbt.func_74783_a("QuestCompletion", nArray);
        int[] nArray2 = new int[this.objectiveCompletionReference.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = this.objectiveCompletionReference[i];
        }
        nbt.func_74783_a("QuestCompletionRef", nArray2);
        nbt.func_74778_a("QuestFilename", this.questFilename);
        nbt.func_186854_a("QuestIdentifier", this.identifier);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int i;
        NBTTagList list;
        this.questFilename = nbt.func_74779_i("QuestFilename");
        this.identifier = nbt.func_186857_a("QuestIdentifier");
        this.stage = nbt.func_74765_d("QuestStage");
        if (this.data1 == null) {
            this.data1 = new HashMap();
        } else {
            this.data1.clear();
        }
        if (nbt.func_74764_b("QuestData1")) {
            list = nbt.func_150295_c("QuestData1", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nBTTagCompound = (NBTTagCompound)list.func_179238_g(i);
                this.data1.put(nBTTagCompound.func_74779_i("QuestDataKey"), nBTTagCompound.func_74763_f("QuestDataValue"));
            }
        }
        if (this.data2 == null) {
            this.data2 = new HashMap();
        } else {
            this.data2.clear();
        }
        if (nbt.func_74764_b("QuestData2")) {
            list = nbt.func_150295_c("QuestData2", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nBTTagCompound = (NBTTagCompound)list.func_179238_g(i);
                this.data2.put(nBTTagCompound.func_74779_i("QuestDataKey"), nBTTagCompound.func_74779_i("QuestDataValue"));
            }
        }
        this.started = nbt.func_74767_n("QuestStarted");
        this.complete = nbt.func_74767_n("QuestComplete");
        this.failed = nbt.func_74767_n("QuestFailed");
        int size = this.getCurrentStage().getParsedObjectives().size();
        this.objectiveCompletion = new short[size];
        this.objectiveCompletionReference = new short[size];
        i = 0;
        for (int value : nbt.func_74759_k("QuestCompletion")) {
            this.objectiveCompletion[i++] = (short)value;
        }
        boolean bl = false;
        for (int value : nbt.func_74759_k("QuestCompletionRef")) {
            this.objectiveCompletionReference[++var4_10] = (short)value;
        }
    }
}

