/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.quests.actions.IAction;
import com.pixelmonmod.pixelmon.quests.actions.actions.CommandAction;
import com.pixelmonmod.pixelmon.quests.actions.actions.DialogueInjectAction;
import com.pixelmonmod.pixelmon.quests.actions.actions.EndDialogueAction;
import com.pixelmonmod.pixelmon.quests.actions.actions.FinishQuestAction;
import com.pixelmonmod.pixelmon.quests.actions.actions.GiveItemAction;
import com.pixelmonmod.pixelmon.quests.actions.actions.GivePokemonAction;
import com.pixelmonmod.pixelmon.quests.actions.actions.KeyItemAction;
import com.pixelmonmod.pixelmon.quests.actions.actions.SendMessageAction;
import com.pixelmonmod.pixelmon.quests.actions.actions.SetStageAction;
import com.pixelmonmod.pixelmon.quests.actions.actions.SpawnPokemonAction;
import com.pixelmonmod.pixelmon.quests.actions.actions.TeleportAction;
import com.pixelmonmod.pixelmon.quests.listeners.BlockListeners;
import com.pixelmonmod.pixelmon.quests.listeners.EntityListeners;
import com.pixelmonmod.pixelmon.quests.listeners.ItemListeners;
import com.pixelmonmod.pixelmon.quests.listeners.PlayerListeners;
import com.pixelmonmod.pixelmon.quests.listeners.TickListeners;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.battle.AttackObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.battle.TrainerDefeatObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.entity.DialogueInjectObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.entity.EntityInteractObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.entity.EntityVicinityObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.entity.NPCObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.entity.PokemonObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.entity.TileEntityVicinityObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.location.AbsolutePositionObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.meta.BlockerObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.meta.FollowthroughObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.meta.RandomObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.meta.ServerTimeObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.player.ItemObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.world.DimensionObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.world.StructureObjective;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.world.WorldTimeObjective;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.QuestTypeAdapter;
import com.pixelmonmod.pixelmon.util.helpers.RCFileHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;

public class QuestRegistry {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Quest.class, (Object)new QuestTypeAdapter()).create();
    private static final QuestRegistry instance = new QuestRegistry();
    private final HashMap<String, Quest> quests = new HashMap();
    private final HashMap<String, IAction> actions = new HashMap();
    private final HashMap<String, IObjective> objectives = new HashMap();

    public static QuestRegistry getInstance() {
        return instance;
    }

    private HashMap<String, Quest> getQuests() {
        return this.quests;
    }

    public void addQuest(Quest quest) {
        this.quests.put(quest.getFilename(), quest);
    }

    public void removeQuest(Quest quest) {
        this.quests.remove(quest.getFilename());
    }

    private HashMap<String, IAction> getActions() {
        return this.actions;
    }

    private HashMap<String, IObjective> getObjectives() {
        return this.objectives;
    }

    public Quest getQuest(String filepath) {
        return this.quests.get(filepath);
    }

    public IAction getAction(String id) {
        return this.actions.get(id);
    }

    public IObjective getObjective(String id) {
        return this.objectives.get(id);
    }

    public Collection<Quest> getQuestCollection() {
        return this.quests.values();
    }

    public Set<String> getQuestFilepaths(boolean underscoreSpaces) {
        HashSet<String> filepaths;
        if (underscoreSpaces) {
            filepaths = new HashSet();
            for (String filepath : this.quests.keySet()) {
                filepaths.add(filepath.replace(" ", "_").replace(".json", ""));
            }
        } else {
            filepaths = new HashSet<String>(this.quests.keySet());
        }
        return filepaths;
    }

    public static void registerQuests(boolean classes) throws Exception {
        Pixelmon.LOGGER.info("Registering quests.");
        if (classes) {
            QuestRegistry.getInstance().registerClasses();
        }
        QuestRegistry.getInstance().getQuests().clear();
        File file = new File("pixelmon/quests");
        if (!PixelmonConfig.useExternalJSONFilesQuests || !file.exists()) {
            try {
                Path rootPath = RCFileHelper.pathFromResourceLocation(new ResourceLocation("pixelmon", "quests"));
                List<Path> ls = RCFileHelper.listFilesRecursively(rootPath, p -> true, true);
                for (Path path : ls) {
                    InputStream is = Quest.class.getResourceAsStream(path.toUri().toString().substring(path.toUri().toString().indexOf("/assets")).replace("%20", " "));
                    Scanner s = new Scanner(is);
                    s.useDelimiter("\\A");
                    String json = s.hasNext() ? s.next() : "";
                    s.close();
                    Quest quest = null;
                    try {
                        quest = (Quest)GSON.fromJson(json, Quest.class);
                        quest.setFilename(path.getFileName().toString());
                    }
                    catch (JsonSyntaxException e) {
                        e.printStackTrace();
                    }
                    if (quest == null) {
                        Pixelmon.LOGGER.error("Unable to load quest JSON: " + path.toString());
                        continue;
                    }
                    if (QuestRegistry.getInstance().getQuest(quest.getFilename()) != null) {
                        Pixelmon.LOGGER.error("Duplicate quest JSON: " + path.toString());
                        continue;
                    }
                    QuestRegistry.getInstance().addQuest(quest);
                    if (!PixelmonConfig.useExternalJSONFilesQuests) continue;
                    file.mkdirs();
                    PrintWriter pw = new PrintWriter(new File("pixelmon/quests/" + quest.getFilename()));
                    pw.write(json);
                    pw.close();
                }
            }
            catch (IOException | URISyntaxException ioe) {
                ioe.printStackTrace();
            }
        }
        file.mkdirs();
        ArrayList<File> files = new ArrayList<File>();
        RCFileHelper.recursiveJSONSearch("pixelmon/quests", files);
        for (File questFile : files) {
            try {
                Quest quest = (Quest)GSON.fromJson((Reader)new FileReader(questFile), Quest.class);
                quest.setFilename(questFile.getName());
                if (QuestRegistry.getInstance().getQuest(quest.getFilename()) != null) {
                    Pixelmon.LOGGER.error("Duplicate quest JSON: " + questFile.toString());
                    continue;
                }
                QuestRegistry.getInstance().addQuest(quest);
            }
            catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
                Pixelmon.LOGGER.error("Unable to load external quest JSON " + questFile.getName());
                e.printStackTrace();
            }
        }
        for (Quest quest : QuestRegistry.getInstance().getQuestCollection()) {
            quest.parseAndMap();
        }
        Pixelmon.LOGGER.info("Loaded " + QuestRegistry.getInstance().getQuestCollection().size() + " Quests.");
    }

    private void registerClasses() throws Exception {
        QuestRegistry.registerObjectives(new ItemObjective("BLOCK_USE"), new ItemObjective("BLOCK_BREAK"), new ItemObjective("BLOCK_PLACE"), new ItemObjective("ITEM_USE"), new ItemObjective("APRICORN_HARVEST"), new ItemObjective("ITEM_PICKUP"), new ItemObjective("ITEM_CRAFT"), new ItemObjective("ITEM_SMELT"), new ItemObjective("ITEM_DROP"), new PokemonObjective("POKEMON_HAS"), new PokemonObjective("POKEMON_CAPTURE"), new PokemonObjective("POKEMON_DEFEAT"), new PokemonObjective("POKEMON_HATCH"), new PokemonObjective("POKEMON_EVOLVE_PRE"), new PokemonObjective("POKEMON_EVOLVE_POST"), new PokemonObjective("POKEMON_TRADE_GET"), new PokemonObjective("POKEMON_TRADE_GIVE"), new NPCObjective("NPC_RESPOND", NPCObjective.Type.RESPOND), new NPCObjective("NPC_GIVE", NPCObjective.Type.GIVE), new NPCObjective("NPC_SHOW", NPCObjective.Type.SHOW), new NPCObjective("NPC_TALK", NPCObjective.Type.TALK), new AttackObjective("BATTLE_MOVE_TARGET"), new AttackObjective("BATTLE_MOVE_USER"), new TrainerDefeatObjective(), new DialogueInjectObjective(), new WorldTimeObjective(), new ServerTimeObjective(), new AbsolutePositionObjective(), new StructureObjective(), new DimensionObjective(), new EntityInteractObjective(), new EntityVicinityObjective(), new TileEntityVicinityObjective(), new BlockerObjective(), new RandomObjective(), new FollowthroughObjective());
        QuestRegistry.registerActions(new SendMessageAction(false), new SendMessageAction(true), new SetStageAction(), new TeleportAction(), new FinishQuestAction(true), new FinishQuestAction(false), new GivePokemonAction(), new SpawnPokemonAction(), new GiveItemAction(), new CommandAction(), new KeyItemAction(true), new KeyItemAction(false), new DialogueInjectAction(), new EndDialogueAction());
        MinecraftForge.EVENT_BUS.register((Object)new BlockListeners());
        MinecraftForge.EVENT_BUS.register((Object)new EntityListeners());
        MinecraftForge.EVENT_BUS.register((Object)new ItemListeners());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerListeners());
        MinecraftForge.EVENT_BUS.register((Object)new TickListeners());
        Pixelmon.EVENT_BUS.register((Object)new BlockListeners());
        Pixelmon.EVENT_BUS.register((Object)new EntityListeners());
        Pixelmon.EVENT_BUS.register((Object)new ItemListeners());
        Pixelmon.EVENT_BUS.register((Object)new PlayerListeners());
        Pixelmon.EVENT_BUS.register((Object)new TickListeners());
    }

    public static void registerActions(IAction ... actions) throws Exception {
        for (IAction action : actions) {
            QuestRegistry.registerAction(action);
        }
    }

    public static void registerObjectives(IObjective ... objectives) throws Exception {
        for (IObjective objective : objectives) {
            QuestRegistry.registerObjective(objective);
        }
    }

    public static void registerAction(IAction action) throws Exception {
        if (QuestRegistry.getInstance().getActions().containsKey(action.identifier())) {
            throw new Exception("Action identifier " + action.identifier() + " collision!");
        }
        QuestRegistry.getInstance().getActions().put(action.identifier(), action);
    }

    public static void registerObjective(IObjective objective) throws Exception {
        if (QuestRegistry.getInstance().getObjectives().containsKey(objective.identifier())) {
            throw new Exception("Objective identifier " + objective.identifier() + " collision!");
        }
        QuestRegistry.getInstance().getObjectives().put(objective.identifier(), objective);
    }

    private static void extractQuestsDir(File questsDir) {
        File[] dir = questsDir.listFiles();
        if (dir != null) {
            for (File questFile : dir) {
                try {
                    QuestRegistry.extractFile("/assets/pixelmon/quests/" + questFile.getName(), questsDir, questFile.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void extractFile(String resourceName, File dir, String filename) {
        try {
            File file = new File(dir, filename);
            if (!file.exists()) {
                int nBytes;
                InputStream link = ServerNPCRegistry.class.getResourceAsStream(resourceName);
                BufferedInputStream in = new BufferedInputStream(link);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
                byte[] buffer = new byte[2048];
                while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, nBytes);
                }
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
                ((InputStream)in).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

