/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.actions.actions;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.actions.IAction;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnPokemonAction
implements IAction {
    @Override
    public String identifier() {
        return "POKEMON_SPAWN";
    }

    @Override
    public Object[] parse(Quest quest, Stage stage, String ... args) {
        String[] objects = Arrays.copyOfRange(args, 5, args.length);
        String x = args[2];
        String y = args[3];
        String z = args[4];
        Pos pos = new Pos(Integer.parseInt(x.replace("~", "").replace("r", "")), Integer.parseInt(y.replace("~", "").replace("r", "")), Integer.parseInt(z.replace("~", "").replace("r", "")), x.contains("~"), y.contains("~"), z.contains("~"), x.contains("r"), y.contains("r"), z.contains("r"));
        StringBuilder specString = new StringBuilder();
        for (String o : objects) {
            specString.append(o.toString()).append(" ");
        }
        PokemonSpec spec = new PokemonSpec(specString.toString());
        return new Object[]{pos, spec};
    }

    @Override
    public void execute(Quest quest, Stage stage, QuestData data, QuestProgress progress, Object ... args) {
        EntityPlayerMP player = data.getPlayer();
        Pos pos = (Pos)args[0];
        EntityPixelmon pixelmon = ((PokemonSpec)args[1]).create((World)player.func_71121_q());
        BlockPos blockPos = pos.toBlockPos(player.func_180425_c());
        pixelmon.func_70634_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        player.func_71121_q().func_72838_d((Entity)pixelmon);
        pixelmon.func_70634_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    private static class Pos {
        private final int x;
        private final int y;
        private final int z;
        private final boolean pX;
        private final boolean pY;
        private final boolean pZ;
        private final boolean rX;
        private final boolean rY;
        private final boolean rZ;

        public Pos(int x, int y, int z, boolean pX, boolean pY, boolean pZ, boolean rX, boolean rY, boolean rZ) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.pX = pX;
            this.pY = pY;
            this.pZ = pZ;
            this.rX = rX;
            this.rY = rY;
            this.rZ = rZ;
        }

        public BlockPos toBlockPos(BlockPos playerPos) {
            int x = (this.rX || this.pX ? playerPos.func_177958_n() : 0) + (this.rX ? RandomHelper.rand.nextInt(this.x * 2) - this.x : this.x);
            int y = (this.rY || this.pY ? playerPos.func_177956_o() : 0) + (this.rY ? RandomHelper.rand.nextInt(this.y * 2) - this.y : this.y);
            int z = (this.rZ || this.pZ ? playerPos.func_177952_p() : 0) + (this.rZ ? RandomHelper.rand.nextInt(this.z * 2) - this.z : this.z);
            return new BlockPos(x, y, z);
        }
    }
}

