/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives;

import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.QuestRegistry;
import com.pixelmonmod.pixelmon.quests.actions.Action;
import com.pixelmonmod.pixelmon.quests.actions.ExecutorMode;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.EntityInserter;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.IInserter;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.PokemonInserter;
import com.pixelmonmod.pixelmon.quests.objectives.objectives.entity.NPCObjective;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;

public class Objective {
    private final IObjective objective;
    private IInserter inserter = null;
    private final Object[] data;

    public Objective(String[] args, Quest quest, Stage stage) throws InvalidQuestArgsException {
        this.objective = QuestRegistry.getInstance().getObjective(args[0]);
        for (Object object : this.data = this.objective.parse(quest, stage, args)) {
            String str;
            if (!(object instanceof String) || !(str = (String)object).startsWith("#!")) continue;
            switch (this.objective.inserter()) {
                case ENTITY: {
                    this.inserter = new EntityInserter(str.replace("#!", ""));
                    break;
                }
                case POKEMON: {
                    this.inserter = new PokemonInserter(str.replace("#!", ""));
                }
            }
            break;
        }
    }

    public IObjective getInternalObjective() {
        return this.objective;
    }

    public Object[] getData() {
        return this.data;
    }

    public boolean hasInserter() {
        return this.inserter != null;
    }

    public IInserter getInserter() {
        return this.inserter;
    }

    public boolean test(Stage stageIn, QuestData dataIn, QuestProgress progressIn, Object ... argsIn) throws InvalidQuestArgsException {
        return this.objective.test(stageIn, dataIn, progressIn, this, this.data, argsIn);
    }

    public short getQuantity() {
        return this.objective.quantity(this.getData());
    }

    public ArrayList<QuestMarker> mark(Stage stageIn, QuestProgress progressIn, Object ... argsIn) {
        return this.objective.mark(stageIn, progressIn, this, this.data, argsIn);
    }

    public boolean receive(String identifierIn, Stage stageIn, QuestData dataIn, QuestProgress progressIn, int index, Object ... argsIn) throws InvalidQuestArgsException {
        if (!progressIn.isObjectiveComplete(index) && this.objective.identifier().equalsIgnoreCase(identifierIn) && this.test(stageIn, dataIn, progressIn, argsIn)) {
            progressIn.completeObjective(index);
            if (progressIn.isObjectiveComplete(index)) {
                for (Action action : stageIn.getParsedActions()) {
                    boolean hasIndex = false;
                    boolean canExecute = true;
                    if (action.getMode() == ExecutorMode.AND) {
                        for (int executor : action.getExecutors()) {
                            if (executor == index) {
                                hasIndex = true;
                            }
                            if (progressIn.isObjectiveComplete(executor)) continue;
                            canExecute = false;
                        }
                    } else {
                        for (int executor : action.getExecutors()) {
                            if (executor == index) {
                                hasIndex = true;
                                continue;
                            }
                            if (!progressIn.isObjectiveComplete(executor)) continue;
                            canExecute = false;
                        }
                    }
                    if (!(canExecute = canExecute && hasIndex)) continue;
                    action.execute(progressIn.getQuest(), stageIn, dataIn, progressIn);
                }
                if (progressIn.canProgress()) {
                    if (stageIn.getNextStage() < 0) {
                        progressIn.complete(dataIn.getPlayer());
                    } else {
                        progressIn.moveStage(dataIn, stageIn, stageIn.getNextStage(), progressIn);
                    }
                    progressIn.sendTo(dataIn.getPlayer());
                    return true;
                }
            }
            if (stageIn.getStage() == progressIn.getStage() && this.objective instanceof NPCObjective) {
                progressIn.resetObjective(index);
            }
            progressIn.sendTo(dataIn.getPlayer());
            return true;
        }
        return false;
    }
}

