/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.inserters;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.NPCQuestGiver;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.IInserter;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.Inserter;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class EntityInserter
implements IInserter {
    private static final String DATA_TAG = "NPC";
    private Type type;
    private Mode mode;
    private double chance;
    private int range;
    private long[] times;

    public EntityInserter(String arg) {
        this.parse(arg);
    }

    @Override
    public Inserter inserter() {
        return Inserter.ENTITY;
    }

    @Override
    public void parse(String ... argsIn) {
        String[] split = argsIn[0].split(",");
        this.type = Type.valueOf(split[0]);
        this.mode = Mode.valueOf(split[1]);
        this.chance = Double.parseDouble(split[2]);
        if (this.mode == Mode.Time) {
            this.range = Integer.parseInt(split[3]);
            this.times = new long[split.length - 4];
            for (int i = 4; i < split.length; ++i) {
                this.times[i - 4] = Long.parseLong(split[i]);
            }
        }
    }

    @Override
    public boolean execute(Quest questIn, Stage stageIn, QuestData dataIn, QuestProgress progressIn, Object ... argsIn) {
        EntityPlayerMP player = dataIn.getPlayer();
        if (player == null || player.func_130014_f_() == null || player.func_130014_f_().field_72996_f == null) {
            return false;
        }
        if (this.mode == Mode.Time) {
            boolean carryOn = false;
            long time = player.func_130014_f_().func_72820_D() % 24000L;
            for (long testTime : this.times) {
                if (time != testTime) continue;
                carryOn = true;
                break;
            }
            if (!carryOn) {
                return false;
            }
            Object object = player.func_130014_f_().field_72996_f.iterator();
            while (object.hasNext()) {
                Entity entity = (Entity)object.next();
                if (!(entity.func_70032_d((Entity)player) < (float)this.range) || !this.attemptInsertion(dataIn, entity, progressIn, stageIn, player)) continue;
                return true;
            }
        } else if (argsIn.length > 0) {
            return this.attemptInsertion(dataIn, (Entity)argsIn[0], progressIn, stageIn, player);
        }
        return false;
    }

    private boolean attemptInsertion(QuestData dataIn, Entity entityIn, QuestProgress progressIn, Stage stageIn, EntityPlayerMP playerIn) {
        MinecraftServer server;
        Entity testEnt;
        String testStr = progressIn.getDataString(DATA_TAG + stageIn.getStage());
        if (testStr != null && !testStr.isEmpty() && (testEnt = (server = FMLCommonHandler.instance().getMinecraftServerInstance()).func_175576_a(UUID.fromString(testStr))) != null && testEnt.func_70032_d((Entity)playerIn) < (float)PixelmonConfig.questMaxRange) {
            return false;
        }
        if (PixelmonConfig.questRandomNPCs && RandomHelper.rand.nextDouble() < this.chance) {
            String key = DATA_TAG + stageIn.getStage();
            String value = entityIn.getPersistentID().toString();
            for (QuestProgress progress : dataIn.getProgress()) {
                String potentialUUID;
                if (progress.isComplete() || progress.isFailed() || (potentialUUID = progress.getDataString(key)) == null || !potentialUUID.equalsIgnoreCase(value)) continue;
                return false;
            }
            switch (this.type) {
                case Pixelmon: {
                    if (entityIn instanceof EntityPixelmon) {
                        progressIn.setData(key, value);
                        progressIn.sendTo(playerIn);
                    }
                    return true;
                }
                case NPC: {
                    if (entityIn instanceof NPCQuestGiver) {
                        progressIn.setData(key, value);
                        progressIn.sendTo(playerIn);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static enum Mode {
        Time,
        Spawn;

    }

    private static enum Type {
        Pixelmon,
        NPC;

    }
}

