/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.inserters;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.IInserter;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.Inserter;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;

public class PokemonInserter
implements IInserter {
    private static final String DATA_TAG = "POKEMON";
    private boolean dex;
    private boolean dexRange;
    private int[] dexValues;
    private EnumType[] types;
    private EnumNature[] natures;
    private EnumGrowth[] growths;

    public PokemonInserter(String arg) {
        this.parse(arg);
    }

    @Override
    public Inserter inserter() {
        return Inserter.POKEMON;
    }

    @Override
    public void parse(String ... argsIn) {
        int i;
        int i2;
        String[] split = argsIn[0].split(",");
        if (split[0].equalsIgnoreCase("dex")) {
            String[] dex = split[1].split(";");
            this.dex = true;
            this.dexRange = false;
            if (dex[0].equalsIgnoreCase("any")) {
                this.dexValues = new int[0];
            } else {
                this.dexValues = new int[dex.length];
                for (i2 = 0; i2 < dex.length; ++i2) {
                    this.dexValues[i2] = Integer.parseInt(dex[i2]);
                }
            }
        } else if (split[0].equalsIgnoreCase("dexrange")) {
            String[] dexRange = split[1].split("-");
            this.dex = true;
            this.dexRange = true;
            this.dexValues = new int[dexRange.length];
            for (i2 = 0; i2 < dexRange.length; ++i2) {
                this.dexValues[i2] = Integer.parseInt(dexRange[i2]);
            }
        } else if (split[0].equalsIgnoreCase("types")) {
            String[] types = split[1].split(";");
            this.dex = false;
            if (types[0].equalsIgnoreCase("any")) {
                this.types = new EnumType[0];
            } else {
                this.types = new EnumType[types.length];
                for (i2 = 0; i2 < types.length; ++i2) {
                    this.types[i2] = EnumType.parseType(types[i2]);
                }
            }
        }
        String[] natureSplit = split[2].split(";");
        String[] growthSplit = split[3].split(";");
        this.natures = new EnumNature[natureSplit[0].equalsIgnoreCase("any") ? 0 : natureSplit.length];
        this.growths = new EnumGrowth[growthSplit[0].equalsIgnoreCase("any") ? 0 : growthSplit.length];
        for (i = 0; i < this.natures.length; ++i) {
            this.natures[i] = EnumNature.natureFromString(natureSplit[i]);
        }
        for (i = 0; i < this.growths.length; ++i) {
            this.growths[i] = EnumGrowth.growthFromString(growthSplit[i]);
        }
    }

    @Override
    public boolean execute(Quest questIn, Stage stageIn, QuestData dataIn, QuestProgress progressIn, Object ... argsIn) {
        int index;
        String testStr = progressIn.getDataString(DATA_TAG + stageIn.getStage());
        if (testStr != null && !testStr.isEmpty()) {
            return false;
        }
        EnumType type = null;
        EnumGrowth growth = null;
        EnumSpecies species = null;
        EnumNature nature = null;
        StringBuilder spec = new StringBuilder();
        if (this.dex) {
            if (this.dexRange) {
                int dexID = this.dexValues[0] + RandomHelper.rand.nextInt(this.dexValues[1] + 1);
                species = EnumSpecies.getFromDex(dexID);
                spec.append(species.getPokemonName());
            } else {
                if (this.dexValues.length == 0) {
                    species = EnumSpecies.randomPoke(false);
                } else {
                    index = RandomHelper.rand.nextInt(this.dexValues.length);
                    species = EnumSpecies.getFromDex(this.dexValues[index]);
                }
                spec.append(species.getPokemonName());
            }
        } else {
            if (this.types.length == 0) {
                while ((type = EnumType.values()[RandomHelper.rand.nextInt(EnumType.values().length)]) == EnumType.Mystery) {
                }
            } else {
                index = RandomHelper.rand.nextInt(this.types.length);
                type = this.types[index];
            }
            spec.append("type:").append(type.func_176610_l());
        }
        if (this.natures.length > 0) {
            index = RandomHelper.rand.nextInt(this.natures.length);
            nature = this.natures[index];
            spec.append(" nature:").append(nature.name());
        }
        if (this.growths.length > 0) {
            index = RandomHelper.rand.nextInt(this.growths.length);
            growth = this.growths[index];
            spec.append(" growth:").append(growth.name());
        }
        progressIn.setData(DATA_TAG + stageIn.getStage(), spec.toString());
        if (species != null) {
            progressIn.setData(DATA_TAG + stageIn.getStage() + "S", species.getUnlocalizedName());
        }
        if (type != null) {
            progressIn.setData(DATA_TAG + stageIn.getStage() + "T", type.getUnlocalizedName());
        }
        if (nature != null) {
            progressIn.setData(DATA_TAG + stageIn.getStage() + "N", nature.getUnlocalizedName());
        }
        if (growth != null) {
            progressIn.setData(DATA_TAG + stageIn.getStage() + "G", growth.getUnlocalizedName());
        }
        progressIn.sendTo(dataIn.getPlayer());
        return true;
    }
}

