/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.entity;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.Inserter;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;

public class PokemonObjective
implements IObjective {
    private static final String DATA_TAG = "POKEMON";
    private final String identifier;

    public PokemonObjective(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public short quantity(Object[] objectiveArgsIn) {
        return ((Comparison)objectiveArgsIn[0]).count;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public Inserter inserter() {
        return Inserter.POKEMON;
    }

    @Override
    public Object[] parse(Quest questIn, Stage stageIn, String ... argsIn) throws InvalidQuestArgsException {
        String inserter = null;
        Comparison comparison = new Comparison();
        comparison.count = Short.parseShort(argsIn[argsIn.length - 1]);
        for (int i = 1; i < argsIn.length - 1; ++i) {
            String arg = argsIn[i];
            if (arg.equalsIgnoreCase("any")) {
                comparison.any = true;
                break;
            }
            if (arg.startsWith("#!")) {
                comparison.inserted = true;
                comparison.stage = stageIn.getStage();
                inserter = arg;
                break;
            }
            comparison.specs.add(arg);
        }
        if (inserter != null) {
            return new Object[]{comparison, inserter};
        }
        return new Object[]{comparison};
    }

    @Override
    public boolean test(Stage stageIn, QuestData dataIn, QuestProgress progressIn, Objective objectiveIn, Object[] objectiveArgsIn, Object ... argsIn) throws InvalidQuestArgsException {
        Comparison comparison = (Comparison)objectiveArgsIn[0];
        Pokemon pokemon = (Pokemon)argsIn[0];
        PokemonSpec spec = this.getInsertedSpec(objectiveArgsIn, progressIn, stageIn);
        if (spec != null) {
            StringBuilder sb = new StringBuilder();
            for (String s : spec.args) {
                if (sb.length() != 0) {
                    sb.append(" ");
                }
                sb.append(s);
            }
            comparison.specs.add(sb.toString());
        }
        return comparison.compare(pokemon);
    }

    private PokemonSpec getInsertedSpec(Object[] objectiveArgsIn, QuestProgress progressIn, Stage stageIn) {
        Comparison comparison = (Comparison)objectiveArgsIn[0];
        PokemonSpec spec = null;
        if (comparison.inserted) {
            String key = DATA_TAG + comparison.stage;
            String data = progressIn.getDataString(key);
            if (data == null) {
                return null;
            }
            spec = new PokemonSpec(data);
        }
        return spec;
    }

    @Override
    public ArrayList<QuestMarker> mark(Stage stageIn, QuestProgress progressIn, Objective objectiveIn, Object[] objectiveArgsIn, Object ... argsIn) {
        return new ArrayList<QuestMarker>();
    }

    static class Comparison {
        public short count;
        public ArrayList<String> specs = new ArrayList();
        public boolean any = false;
        public boolean inserted = false;
        public short stage;

        Comparison() {
        }

        public boolean compare(Pokemon pokemon) {
            if (this.any) {
                return true;
            }
            for (String spec : this.specs) {
                PokemonSpec ps = PokemonSpec.from(pokemon.getSpecies().getPokemonName(), spec);
                if (ps.matches(pokemon)) continue;
                return false;
            }
            return true;
        }
    }
}

