/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.player;

import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.Inserter;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemObjective
implements IObjective {
    private String identifier;

    public ItemObjective(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public short quantity(Object[] objectiveArgsIn) {
        return ((Comparison)objectiveArgsIn[0]).count;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public Inserter inserter() {
        return Inserter.NONE;
    }

    @Override
    public Object[] parse(Quest questIn, Stage stageIn, String ... argsIn) throws InvalidQuestArgsException {
        Comparison comparison = new Comparison();
        block8: for (String arg : argsIn) {
            String[] split;
            Type type;
            if (!arg.contains("=") || (type = Type.get((split = arg.split("="))[0])) == null) continue;
            switch (type) {
                case ITEM: {
                    comparison.item = Item.func_111206_d((String)split[1]);
                    continue block8;
                }
                case MOD: {
                    comparison.mod = split[1];
                    continue block8;
                }
                case TAG: {
                    comparison.tags.add(split[1]);
                    continue block8;
                }
                case NAME: {
                    comparison.name = split[1];
                    continue block8;
                }
                case DAMAGE: {
                    comparison.damage = Integer.parseInt(split[1]);
                    continue block8;
                }
                case COUNT: {
                    comparison.count = Short.parseShort(split[1]);
                }
            }
        }
        return new Object[]{comparison};
    }

    @Override
    public boolean test(Stage stageIn, QuestData dataIn, QuestProgress progressIn, Objective objectiveIn, Object[] objectiveArgsIn, Object ... argsIn) throws InvalidQuestArgsException {
        return ((Comparison)objectiveArgsIn[0]).compare((ItemStack)argsIn[0]);
    }

    @Override
    public ArrayList<QuestMarker> mark(Stage stageIn, QuestProgress progressIn, Objective objectiveIn, Object[] objectiveArgsIn, Object ... argsIn) {
        return new ArrayList<QuestMarker>();
    }

    public class Comparison {
        public short count;
        private Item item = null;
        private String mod = "";
        private String name = "";
        private ArrayList<String> tags = new ArrayList();
        private int damage = -1;

        public boolean compare(ItemStack stack) {
            if (this.item != null && this.item != stack.func_77973_b()) {
                return false;
            }
            if (!this.mod.isEmpty() && stack.func_77973_b().getRegistryName() != null && !stack.func_77973_b().getRegistryName().func_110624_b().equalsIgnoreCase(this.mod)) {
                return false;
            }
            if (!this.name.isEmpty() && !stack.func_82833_r().equalsIgnoreCase(this.name)) {
                return false;
            }
            if (!this.tags.isEmpty()) {
                if (!stack.func_77942_o()) {
                    return false;
                }
                for (String tag : this.tags) {
                    if (stack.func_77978_p().func_74764_b(tag)) continue;
                    return false;
                }
            }
            return this.damage == -1 || stack.func_77952_i() == this.damage;
        }
    }

    static enum Type {
        ITEM,
        MOD,
        NAME,
        TAG,
        DAMAGE,
        COUNT;


        public static Type get(String str) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(str)) continue;
                return type;
            }
            return null;
        }
    }
}

