/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.quest;

import com.pixelmonmod.pixelmon.quests.actions.Action;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import java.util.ArrayList;

public class Stage {
    private short stage = 0;
    private short nextStage;
    private ArrayList<String> objectives = new ArrayList();
    private ArrayList<String> actions = new ArrayList();
    private transient ArrayList<Objective> parsedObjectives = new ArrayList();
    private transient ArrayList<Action> parsedActions = new ArrayList();

    public Stage() {
        this.nextStage = (short)10;
    }

    public short getStage() {
        return this.stage;
    }

    public short getNextStage() {
        return this.nextStage;
    }

    public ArrayList<Objective> getParsedObjectives() {
        return this.parsedObjectives;
    }

    public ArrayList<Action> getParsedActions() {
        return this.parsedActions;
    }

    protected void parse(Quest quest) throws InvalidQuestArgsException {
        String[] args;
        for (String objectiveString : this.objectives) {
            args = objectiveString.split(" ");
            this.parsedObjectives.add(new Objective(args, quest, this));
        }
        for (String actionString : this.actions) {
            args = actionString.split(" ");
            this.parsedActions.add(new Action(args, quest, this));
        }
    }

    public static class Builder {
        private final Quest.Builder questBuilder;
        private final Stage stage;

        public Builder(Quest.Builder questBuilder) {
            this.questBuilder = questBuilder;
            this.stage = new Stage();
        }

        public Builder setStage(short stage) {
            this.stage.stage = stage;
            return this;
        }

        public Builder setNextStage(short nextStage) {
            this.stage.nextStage = nextStage;
            return this;
        }

        public Builder setStage(int stage) {
            this.stage.stage = (short)stage;
            return this;
        }

        public Builder setNextStage(int nextStage) {
            this.stage.nextStage = (short)nextStage;
            return this;
        }

        public Builder addObjective(String objective) {
            this.stage.objectives.add(objective);
            return this;
        }

        public Builder addAction(String action) {
            this.stage.actions.add(action);
            return this;
        }

        public Quest.Builder build() {
            this.questBuilder.addStage(this.stage);
            return this.questBuilder;
        }
    }
}

