/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.TickHandler;
import com.pixelmonmod.pixelmon.api.economy.IPixelmonBankAccount;
import com.pixelmonmod.pixelmon.api.economy.IPixelmonBankAccountManager;
import com.pixelmonmod.pixelmon.api.storage.IStorageManager;
import com.pixelmonmod.pixelmon.api.storage.IStorageSaveAdapter;
import com.pixelmonmod.pixelmon.api.storage.IStorageSaveScheduler;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc.ClientInitializePC;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ReforgedStorageManager
implements IStorageManager,
IPixelmonBankAccountManager {
    protected Map<UUID, PlayerPartyStorage> parties = new ConcurrentHashMap<UUID, PlayerPartyStorage>();
    protected Map<UUID, PCStorage> pcs = new ConcurrentHashMap<UUID, PCStorage>();
    public Queue<PokemonStorage> extraStorages = new ConcurrentLinkedQueue<PokemonStorage>();
    protected IStorageSaveScheduler scheduler;
    protected IStorageSaveAdapter adapter;
    public final List<UUID> playersWithSyncedPCs = new ArrayList<UUID>();

    public ReforgedStorageManager(IStorageSaveScheduler scheduler, IStorageSaveAdapter adapter) {
        this.scheduler = scheduler;
        this.adapter = adapter;
    }

    @Override
    public IStorageSaveScheduler getSaveScheduler() {
        return this.scheduler;
    }

    @Override
    public IStorageSaveAdapter getSaveAdapter() {
        return this.adapter;
    }

    public void setSaveScheduler(IStorageSaveScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setSaveAdapter(IStorageSaveAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public PlayerPartyStorage getParty(UUID uuid) {
        PlayerPartyStorage partyStorage = this.parties.get(uuid);
        if (partyStorage == null) {
            partyStorage = this.getSaveAdapter().load(uuid, PlayerPartyStorage.class);
            partyStorage.tryUpdatePlayerName();
            this.parties.put(uuid, partyStorage);
        }
        if (partyStorage.countAll() == 0 && !partyStorage.starterPicked && PixelmonConfig.giveStarter && partyStorage.getPlayer() != null) {
            TickHandler.registerStarterList(partyStorage.getPlayer());
        }
        return partyStorage;
    }

    @Override
    public PCStorage getPCForPlayer(UUID playerUUID) {
        EntityPlayerMP player;
        PCStorage pc = this.pcs.get(playerUUID);
        if (pc == null) {
            pc = this.getSaveAdapter().load(playerUUID, PCStorage.class);
            if (pc == null) {
                pc = new PCStorage(playerUUID);
            }
            this.pcs.put(playerUUID, pc);
            EntityPlayerMP playerOwner = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(pc.uuid);
            if (playerOwner != null) {
                pc.setPlayer(playerOwner.func_110124_au(), playerOwner.func_70005_c_());
            }
            for (EntityPlayerMP player2 : pc.getPlayersToUpdate()) {
                Pixelmon.network.sendTo((IMessage)new ClientInitializePC(pc), player2);
            }
        }
        if (!this.playersWithSyncedPCs.contains(playerUUID) && (player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(playerUUID)) != null) {
            this.initializePCForPlayer(player, pc);
            this.playersWithSyncedPCs.add(playerUUID);
        }
        return pc;
    }

    @Nullable
    public PokemonStorage getExtraStorage(UUID uuid) {
        for (PokemonStorage storage : this.extraStorages) {
            if (!storage.uuid.equals(uuid)) continue;
            return storage;
        }
        return null;
    }

    @Override
    public Iterable<PokemonStorage> getAllCachedStorages() {
        ArrayList<PokemonStorage> allStorages = new ArrayList<PokemonStorage>();
        allStorages.addAll(this.parties.values());
        allStorages.addAll(this.pcs.values());
        allStorages.addAll(this.extraStorages);
        return allStorages;
    }

    @Override
    public void onStorageSaved(PokemonStorage storage) {
        if ((storage instanceof PartyStorage || storage instanceof PCStorage) && FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(storage.uuid) == null) {
            if (storage instanceof PartyStorage) {
                this.parties.remove(storage.uuid);
            } else {
                this.pcs.remove(storage.uuid);
            }
        }
    }

    @Override
    public void clearAll() {
        this.pcs.clear();
        this.parties.clear();
        this.extraStorages.clear();
    }

    @Override
    public Optional<? extends IPixelmonBankAccount> getBankAccount(UUID uuid) {
        return Optional.of(this.getParty(uuid));
    }

    @Override
    public Optional<? extends IPixelmonBankAccount> getBankAccount(EntityPlayerMP player) {
        return this.getBankAccount(player.func_110124_au());
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        if (this.parties.containsKey(event.player.func_110124_au())) {
            this.parties.get(event.player.func_110124_au()).tryUpdatePlayerName();
        }
        if (this.pcs.containsKey(event.player.func_110124_au())) {
            PCStorage pc = this.pcs.get(event.player.func_110124_au());
            pc.setPlayer(event.player.func_110124_au(), event.player.func_70005_c_());
            Pixelmon.network.sendTo((IMessage)new ClientInitializePC(pc), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.playersWithSyncedPCs.remove(event.player.func_110124_au());
    }
}

