/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.helpers;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.Pixelmon;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class BlockHelper {
    public static <T extends TileEntity> T findClosestTileEntity(Class<T> tileEntity, Entity entity, double range, Predicate<T> predicate) {
        Map<BlockPos, T> map = BlockHelper.findAllTileEntityWithinRange(tileEntity, entity, range, predicate);
        if (map.size() == 0) {
            return null;
        }
        Map.Entry<BlockPos, T> closest = null;
        double distance = range + 0.1;
        for (Map.Entry<BlockPos, T> entry : map.entrySet()) {
            double dis = BlockHelper.getDistance(entity, entry.getKey());
            if (!(dis < distance)) continue;
            closest = entry;
            distance = dis;
        }
        return (T)(closest == null ? null : (TileEntity)closest.getValue());
    }

    public static <T extends TileEntity> Map<BlockPos, T> findAllTileEntityWithinRange(Class<T> tileEntity, Entity entity, double range, Predicate<T> predicate) {
        int chunkXPos = entity.func_180425_c().func_177958_n() >> 4;
        int chunkZPos = entity.func_180425_c().func_177952_p() >> 4;
        WorldServer world = (WorldServer)entity.func_130014_f_();
        int chunkRange = Math.max((int)(range / 16.0), 1) + 1;
        HashMap map = Maps.newHashMap();
        for (int x = chunkXPos - chunkRange + 1; x < chunkXPos + chunkRange; ++x) {
            for (int z = chunkZPos - chunkRange + 1; z < chunkZPos + chunkRange; ++z) {
                if (!world.func_72863_F().func_73149_a(x, z)) continue;
                Chunk chunk = world.func_72964_e(x, z);
                for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                    if (!tileEntity.isAssignableFrom(((TileEntity)entry.getValue()).getClass()) || !(BlockHelper.getDistance(entity, (BlockPos)entry.getKey()) <= range) || !predicate.test((TileEntity)entry.getValue())) continue;
                    map.put(entry.getKey(), (TileEntity)entry.getValue());
                }
            }
        }
        return map;
    }

    public static int countTileEntitiesOfType(World world, ChunkPos pos, Class<? extends TileEntity> clazz) {
        int count = 0;
        Chunk chunk = world.func_72964_e(pos.field_77276_a, pos.field_77275_b);
        for (TileEntity te : chunk.func_177434_r().values()) {
            if (!clazz.isInstance(te)) continue;
            ++count;
        }
        return count;
    }

    public static <T extends TileEntity> T getTileEntity(Class<T> clazz, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && !clazz.isInstance(te)) {
            te.func_145843_s();
            te = world.func_175625_s(pos);
            if (te != null && !clazz.isInstance(te)) {
                te.func_145843_s();
                Pixelmon.LOGGER.info("Bad TileEntity " + pos.toString() + " expected " + clazz.getSimpleName() + " got " + te.getClass().getSimpleName());
                return null;
            }
            if (te != null && world instanceof WorldServer) {
                te.func_70296_d();
                ((WorldServer)world).func_184164_w().func_180244_a(pos);
            }
        }
        try {
            return (T)te;
        }
        catch (Exception e) {
            te.func_145843_s();
            return null;
        }
    }

    private static double getDistance(Entity entity, BlockPos pos) {
        return entity.func_70011_f((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }
}

