/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.helpers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.gui.IGuiHideMouse;
import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class CursorHelper {
    private static final Cursor DEFAULT_CURSOR = Mouse.getNativeCursor();
    private static final Cursor TRANSPARENT_CURSOR = CursorHelper.createTransparentCursor();

    private static Cursor createTransparentCursor() {
        try {
            BufferedImage image = new BufferedImage(16, 16, 2);
            return new Cursor(16, 16, 0, 0, 1, IntBuffer.wrap(image.getRGB(0, 0, 16, 16, null, 0, 16)), null);
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("Couldn't load the transparent cursor.", (Throwable)e);
            return DEFAULT_CURSOR;
        }
    }

    private static void setCursor(Cursor cursor) {
        block3: {
            try {
                Mouse.setNativeCursor((Cursor)cursor);
            }
            catch (LWJGLException e) {
                if (cursor == DEFAULT_CURSOR) {
                    Pixelmon.LOGGER.error("Panic! Couldn't set the default cursor!", (Throwable)e);
                }
                Pixelmon.LOGGER.error("Couldn't set the cursor to a default one.", (Throwable)e);
                if (Mouse.getNativeCursor() == DEFAULT_CURSOR) break block3;
                CursorHelper.setCursor(DEFAULT_CURSOR);
            }
        }
    }

    @SubscribeEvent
    public static void onInitGui(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof IGuiHideMouse) {
            CursorHelper.setCursor(TRANSPARENT_CURSOR);
        }
    }

    @SubscribeEvent
    public static void onGuiOpen(GuiOpenEvent event) {
        if (Minecraft.func_71410_x().field_71462_r instanceof IGuiHideMouse) {
            CursorHelper.setCursor(DEFAULT_CURSOR);
        }
    }
}

