/*
 * Decompiled with CFR 0.152.
 */
package info.pixelmon.repack.ninja.leaping.configurate.objectmapping;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import info.pixelmon.repack.ninja.leaping.configurate.objectmapping.ObjectMapper;
import info.pixelmon.repack.ninja.leaping.configurate.objectmapping.ObjectMapperFactory;
import info.pixelmon.repack.ninja.leaping.configurate.objectmapping.ObjectMappingException;
import java.util.concurrent.ExecutionException;

public class DefaultObjectMapperFactory
implements ObjectMapperFactory {
    private static final ObjectMapperFactory INSTANCE = new DefaultObjectMapperFactory();
    private final LoadingCache<Class<?>, ObjectMapper<?>> mapperCache = CacheBuilder.newBuilder().weakKeys().maximumSize(500L).build(new CacheLoader<Class<?>, ObjectMapper<?>>(){

        public ObjectMapper<?> load(Class<?> key) throws Exception {
            return new ObjectMapper(key);
        }
    });

    @Override
    public <T> ObjectMapper<T> getMapper(Class<T> type) throws ObjectMappingException {
        Preconditions.checkNotNull(type, (Object)"type");
        try {
            return (ObjectMapper)this.mapperCache.get(type);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ObjectMappingException) {
                throw (ObjectMappingException)e.getCause();
            }
            throw new ObjectMappingException(e);
        }
    }

    public static ObjectMapperFactory getInstance() {
        return INSTANCE;
    }
}

