/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network.packet.client;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import jds.bibliocraft.helpers.BiblioSortingHelper;
import jds.bibliocraft.helpers.SortedListItem;
import jds.bibliocraft.network.packet.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BiblioStockLog
implements IMessage {
    NBTTagCompound tags;

    public BiblioStockLog() {
    }

    public BiblioStockLog(NBTTagCompound tags) {
        this.tags = tags;
    }

    public void fromBytes(ByteBuf buf) {
        this.tags = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tags);
    }

    public static class Handler
    implements IMessageHandler<BiblioStockLog, IMessage> {
        public IMessage onMessage(BiblioStockLog message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                NBTTagCompound tags = message.tags;
                if (tags != null) {
                    NBTTagList comp = tags.func_150295_c("compasses", 10);
                    int[] compasses = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};
                    ItemStack[] compassStacks = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                    for (int i = 0; i < comp.func_74745_c(); ++i) {
                        int compSlot;
                        NBTTagCompound compTag = comp.func_150305_b(i);
                        if (compTag == null) continue;
                        String invSlotName = "slot" + i;
                        compasses[i] = compSlot = compTag.func_74762_e(invSlotName);
                        if (compSlot == -1) continue;
                        compassStacks[i] = new ItemStack(compTag);
                    }
                    NBTTagList alphaTagList = tags.func_150295_c("alphaList", 10);
                    final ArrayList<SortedListItem> alphaList = BiblioSortingHelper.convertNBTTagListToArrayList(alphaTagList);
                    NBTTagList quanaTagList = tags.func_150295_c("quantaList", 10);
                    final ArrayList<SortedListItem> quantaList = BiblioSortingHelper.convertNBTTagListToArrayList(quanaTagList);
                    final int[] finalCompasses = compasses;
                    final ItemStack[] finalCompassStacks = compassStacks;
                    final String title = tags.func_74779_i("title");
                    Minecraft.func_71410_x().func_152344_a(new Runnable(){

                        @Override
                        public void run() {
                            Utils.openCatalogGUI((EntityPlayer)Minecraft.func_71410_x().field_71439_g, alphaList, quantaList, finalCompassStacks, finalCompasses, title);
                        }
                    });
                }
            });
            return null;
        }
    }
}

