/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.config.cavern;

import com.yungnickyoung.minecraft.bettercaves.noise.FastNoise;
import net.minecraftforge.common.config.Config;

public class ConfigLiquidCavern {
    @Config.Name(value="Liquid Cavern Minimum Altitude")
    @Config.Comment(value={"The minimum y-coordinate at which Liquid Caverns can generate.\nDefault: 1"})
    @Config.RangeInt(min=0, max=255)
    @Config.RequiresWorldRestart
    public int cavernBottom = 1;
    @Config.Name(value="Liquid Cavern Maximum Altitude")
    @Config.Comment(value={"The maximum y-coordinate at which Liquid Caverns can generate.\n    Caverns will attempt to close off anyway if this value is greater than the surface's altitude.\nDefault: 35"})
    @Config.RangeInt(min=0, max=255)
    @Config.RequiresWorldRestart
    public int cavernTop = 35;
    @Config.Name(value="Compression - Vertical")
    @Config.Comment(value={"Stretches caverns vertically. Lower value = more open caverns with larger features.\nDefault: 1.3"})
    @Config.RangeDouble(min=0.0, max=100.0)
    @Config.RequiresWorldRestart
    public float yCompression = 1.3f;
    @Config.Name(value="Compression - Horizontal")
    @Config.Comment(value={"Stretches caverns horizontally. Lower value = more open caverns with larger features.\nDefault: 0.7"})
    @Config.RangeDouble(min=0.0, max=100.0)
    @Config.RequiresWorldRestart
    public float xzCompression = 0.7f;
    @Config.Name(value="Liquid Cavern Priority")
    @Config.Comment(value={"Determines how frequently Liquid Caverns spawn. 0 = will not spawn at all.\nDefault: 10"})
    @Config.RangeInt(min=0, max=10)
    @Config.RequiresWorldRestart
    public int cavernPriority = 10;
    @Config.Ignore
    @Config.Name(value="Advanced Settings")
    @Config.Comment(value={"Don't mess with these if you don't know what you're doing."})
    public Advanced advancedSettings = new Advanced();

    public class Advanced {
        @Config.Name(value="Noise Threshold")
        @Config.Comment(value={"Noise threshold for determining which blocks get mined out as part of cavern generation\n    Blocks with generated noise values lower than this threshold will be dug out.\nDefault: 0.6"})
        @Config.RangeDouble(min=-1.0, max=1.0)
        @Config.RequiresWorldRestart
        public float noiseThreshold = 0.6f;
        @Config.Name(value="Fractal Octaves")
        @Config.Comment(value={"The number of octaves used for ridged multi-fractal noise generation.\nDefault: 1"})
        @Config.RequiresWorldRestart
        public int fractalOctaves = 1;
        @Config.Name(value="Fractal Gain")
        @Config.Comment(value={"The gain for successive octaves of ridged multi-fractal noise generation.\nDefault: 0.3"})
        @Config.RequiresWorldRestart
        public float fractalGain = 0.3f;
        @Config.Name(value="Fractal Frequency")
        @Config.Comment(value={"The frequency for ridged multi-fractal noise generation.\n    This determines how spread out or tightly knit the formations in caverns are.\nDefault: 0.03"})
        @Config.RequiresWorldRestart
        public float fractalFrequency = 0.03f;
        @Config.Name(value="Number of Generators")
        @Config.Comment(value={"The number of noise generation functions used.\n    The intersection of these functions is used to calculate a single noise value.\n    Increasing this may decrease performance.\nDefault: 2"})
        @Config.RequiresWorldRestart
        public int numGenerators = 2;
        @Config.Name(value="Noise Type")
        @Config.Comment(value={"Type of noise to use for this cavern. \nDefault: SimplexFractal"})
        public FastNoise.NoiseType noiseType = FastNoise.NoiseType.SimplexFractal;
    }
}

