/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar.resource;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class EntityIconDefinition {
    public static final ResourceLocation MODEL_TYPE = new ResourceLocation("xaerominimap", "entity/icon/model");
    public static final ResourceLocation DOT_TYPE = new ResourceLocation("xaerominimap", "entity/icon/dot");
    private String variantIdMethod;
    private HashMap<String, String> variants;
    private Method variantIdMethodReflect;
    private HashMap<String, ResourceLocation> variantTypes;

    public String getVariantIdMethodString() {
        return this.variantIdMethod;
    }

    public Method getVariantIdMethod() {
        return this.variantIdMethodReflect;
    }

    public void setVariantIdMethod(Method variantIdMethodReflect) {
        this.variantIdMethodReflect = variantIdMethodReflect;
    }

    public ResourceLocation getVariantType(String variantId) {
        if (this.variantTypes == null) {
            return MODEL_TYPE;
        }
        return this.variantTypes.getOrDefault(variantId, this.variantTypes.get("default"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onConstruct(ResourceLocation entityId) {
        int lastDot = this.variantIdMethod.lastIndexOf(46);
        String classPath = this.variantIdMethod.substring(0, lastDot);
        String methodName = this.variantIdMethod.substring(lastDot + 1);
        try {
            Class<?> c = Class.forName(classPath);
            this.variantIdMethodReflect = c.getDeclaredMethod(methodName, Render.class, Entity.class);
            if (this.variantIdMethodReflect.getReturnType() != String.class) {
                System.out.println("The return type of the variant ID method for " + entityId + " is not String. Can't use it.");
                this.variantIdMethodReflect = null;
            }
        }
        catch (Exception e) {
            System.out.println("Could not find variant ID method " + this.variantIdMethod + " defined for " + entityId);
            e.printStackTrace();
        }
        if (this.variants.get("default") == null) {
            this.variants.put("default", "model");
        }
        Iterator<Map.Entry<String, String>> iterator = this.variants.entrySet().iterator();
        while (true) {
            ResourceLocation type;
            Map.Entry<String, String> entry;
            block13: {
                block14: {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    entry = iterator.next();
                    String value = entry.getValue();
                    if (value.equals("model")) break block14;
                    String[] valueSplit = value.split(":");
                    String iconType = valueSplit[0];
                    if (iconType.equals("sprite")) {
                        if (valueSplit.length != 2) {
                            System.out.println("Skipping invalid icon type: " + value);
                            continue;
                        }
                        type = new ResourceLocation("xaerominimap", "entity/icon/sprite/" + valueSplit[1]);
                        break block13;
                    } else if (iconType.equals("dot")) {
                        if (valueSplit.length != 1) {
                            System.out.println("Skipping invalid icon type: " + value);
                            continue;
                        }
                        type = DOT_TYPE;
                        break block13;
                    } else {
                        System.out.println("Skipping invalid icon type: " + value);
                        continue;
                    }
                }
                type = MODEL_TYPE;
            }
            if (this.variantTypes == null) {
                this.variantTypes = new HashMap();
            }
            this.variantTypes.put(entry.getKey(), type);
        }
    }
}

