/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.weather.tracker;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.dimension.IDimensionInfo;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.dsurround.client.weather.tracker.Tracker;
import org.orecruncher.dsurround.event.ThunderEvent;
import org.orecruncher.lib.PlayerUtils;
import org.orecruncher.lib.TimeUtils;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class SimulationTracker
extends Tracker {
    protected float intensityLevel = 0.0f;
    protected float maxIntensityLevel = 0.0f;
    protected int nextThunderEvent = 0;
    protected Weather.Properties intensity = Weather.Properties.NONE;
    protected Random random;

    @Override
    protected String type() {
        return "SIMULATION";
    }

    @Override
    @Nonnull
    public Weather.Properties getWeatherProperties() {
        return this.intensity;
    }

    @Override
    public float getIntensityLevel() {
        return this.intensityLevel;
    }

    @Override
    public float getMaxIntensityLevel() {
        return this.maxIntensityLevel;
    }

    @Override
    public int getNextThunderEvent() {
        return this.nextThunderEvent;
    }

    @Override
    public boolean doVanilla() {
        return false;
    }

    @Override
    public boolean backgroundThunderPossible() {
        if (!ModOptions.rain.allowBackgroundThunder) {
            return false;
        }
        int dimId = EnvironStateHandler.EnvironState.getDimensionId();
        return dimId != -1 && dimId != 1 && this.isThundering() && this.getIntensityLevel() >= ModOptions.rain.stormThunderThreshold;
    }

    @Override
    public void update() {
        IDimensionInfo info = EnvironStateHandler.EnvironState.getDimensionInfo();
        if (info != null && info.hasWeather()) {
            this.updateRainState();
            this.doAmbientThunder();
        } else {
            this.intensity = Weather.Properties.NONE;
            this.intensityLevel = 0.0f;
            this.maxIntensityLevel = 0.0f;
            this.nextThunderEvent = 0;
        }
    }

    private void updateRainState() {
        float vanillaIntensity = super.getIntensityLevel();
        if (vanillaIntensity > 0.0f && this.intensityLevel == 0.0f) {
            float result;
            this.random = new XorShiftRandom(SimulationTracker.generateSeed());
            float delta = ModOptions.rain.defaultMaxRainStrength - ModOptions.rain.defaultMinRainStrength;
            if (delta <= 0.0f) {
                result = ModOptions.rain.defaultMinRainStrength;
            } else {
                float mid = delta / 2.0f;
                result = ModOptions.rain.defaultMinRainStrength + (this.random.nextFloat() + this.random.nextFloat()) * mid;
            }
            this.maxIntensityLevel = MathStuff.clamp((float)result, (float)0.01f, (float)1.0f);
        } else if (vanillaIntensity == 0.0f && this.intensityLevel > 0.0f) {
            this.maxIntensityLevel = 0.0f;
            this.nextThunderEvent = 0;
            this.random = null;
        }
        float newIntensity = MathStuff.clamp((float)vanillaIntensity, (float)0.0f, (float)this.maxIntensityLevel);
        this.setCurrentIntensity(newIntensity);
    }

    protected void setCurrentIntensity(float level) {
        this.intensity = Weather.Properties.mapRainStrength(level);
        this.intensityLevel = this.intensity == Weather.Properties.VANILLA ? 0.0f : MathStuff.clamp((float)level, (float)0.0f, (float)1.0f);
    }

    private static long generateSeed() {
        return TimeUtils.getGMTDaySeedBase() + (long)EnvironStateHandler.EnvironState.getClock().getDay();
    }

    private void doAmbientThunder() {
        if (this.backgroundThunderPossible()) {
            int time = this.nextThunderEvent - 1;
            if (time <= 0) {
                EntityPlayer player2;
                float intensity = this.getIntensityLevel();
                if (time == 0 && (player2 = PlayerUtils.getRandomPlayer((World)EnvironStateHandler.EnvironState.getWorld())) != null) {
                    float theY = EnvironStateHandler.EnvironState.getDimensionInfo().getSkyHeight();
                    BlockPos pos = new BlockPos(player2.field_70165_t, (double)theY, player2.field_70161_v);
                    MinecraftForge.EVENT_BUS.post((Event)new ThunderEvent(player2.func_130014_f_().field_73011_w.getDimension(), this.doFlash(intensity), pos));
                }
                time = this.nextThunderEvent(intensity);
            }
            this.nextThunderEvent = time;
        } else {
            this.nextThunderEvent = 0;
        }
    }

    private int nextThunderEvent(float rainIntensity) {
        float scale = 2.0f - rainIntensity;
        return this.random.nextInt((int)(450.0f * scale)) + 300;
    }

    protected boolean doFlash(float rainIntensity) {
        int randee = (int)(rainIntensity * 100.0f);
        return this.random.nextInt(150) <= randee;
    }
}

