/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.annotations.SerializedName;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.lib.JsonUtils;

public class Profiles {
    private static final String PROFILE_PATH = "/assets/dsurround/profiles/";
    private static Profiles profiles;
    private final List<ProfileEntry> entries = ImmutableList.of();

    public static void tickle() {
        if (profiles != null) {
            Profiles.profiles.entries.forEach(ProfileEntry::isEnabled);
        }
    }

    public static List<ProfileScript> getProfileStreams() {
        return profiles != null ? Profiles.profiles.entries.stream().filter(ProfileEntry::isEnabled).map(ProfileScript::new).collect(Collectors.toList()) : ImmutableList.of();
    }

    static {
        String index = "/assets/dsurround/profiles/_index.json";
        try {
            profiles = (Profiles)JsonUtils.loadFromJar(Profiles.class, (String)"/assets/dsurround/profiles/_index.json");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class ProfileScript {
        public final String packName;
        public final InputStream stream;

        public ProfileScript(@Nonnull ProfileEntry entry) {
            this.packName = entry.profileName;
            this.stream = entry.getStream();
        }
    }

    private static class ProfileEntry {
        @SerializedName(value="profileName")
        public String profileName;
        @SerializedName(value="optionName")
        public String optionName;
        @SerializedName(value="optionDescription")
        public String optionDescription;

        private ProfileEntry() {
        }

        public boolean isValid() {
            return !StringUtils.isEmpty((CharSequence)this.profileName) && !StringUtils.isEmpty((CharSequence)this.optionName) && !StringUtils.isEmpty((CharSequence)this.optionDescription);
        }

        public boolean isEnabled() {
            if (!this.isValid()) {
                return false;
            }
            ConfigCategory cat = ModBase.config().getCategory("profiles");
            Property prop = cat.get(this.optionName);
            if (prop == null) {
                prop = new Property(this.optionName, "false", Property.Type.BOOLEAN);
                cat.put(this.optionName, prop);
                prop.setValue(false);
            }
            prop.setComment(this.optionDescription);
            prop.setLanguageKey(this.optionName);
            prop.setRequiresMcRestart(false);
            prop.setRequiresWorldRestart(false);
            prop.setDefaultValue(false);
            return prop.getBoolean();
        }

        public InputStream getStream() {
            String path = Profiles.PROFILE_PATH + this.profileName + ".json";
            return Profiles.class.getResourceAsStream(path);
        }
    }
}

