/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks;

import net.minecraft.block.BlockDispenser;
import net.minecraft.command.ICommand;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bensam.tpworks.CreativeTab;
import org.bensam.tpworks.block.ModBlocks;
import org.bensam.tpworks.capability.teleportation.CommandTeleportation;
import org.bensam.tpworks.capability.teleportation.TeleportationHandlerCapabilityProvider;
import org.bensam.tpworks.client.particle.ModParticlesBase;
import org.bensam.tpworks.entity.EntityTeleportationSplashPotion;
import org.bensam.tpworks.entity.EntityTeleportationTippedArrow;
import org.bensam.tpworks.item.ModItems;
import org.bensam.tpworks.network.PacketRequestUpdateTeleportTileEntity;
import org.bensam.tpworks.network.PacketUpdateTeleportIncoming;
import org.bensam.tpworks.network.PacketUpdateTeleportTileEntity;
import org.bensam.tpworks.proxy.IProxy;

@Mod(modid="tpworks", name="Teleportation Works", version="1.12.2-2.1.0", acceptedMinecraftVersions="[1.12.2]", certificateFingerprint="8d6adeb651e78da00458bf87eb9848f871f8e72a", dependencies="required-after:minecraft;required-after:forge@[14.23.5.2768,);", updateJSON="https://raw.githubusercontent.com/willihay/teleportation-works/master/update.json")
public class TeleportationWorks {
    public static final String MODID = "tpworks";
    public static final String NAME = "Teleportation Works";
    public static final String VERSION = "1.12.2-2.1.0";
    public static final String ACCEPTED_MINECRAFT_VERSIONS = "[1.12.2]";
    public static final String FINGERPRINT = "8d6adeb651e78da00458bf87eb9848f871f8e72a";
    public static final String DEPENDENCIES = "required-after:minecraft;required-after:forge@[14.23.5.2768,);";
    @SidedProxy(clientSide="org.bensam.tpworks.proxy.ClientProxy", serverSide="org.bensam.tpworks.proxy.ServerProxy")
    public static IProxy proxy;
    @SidedProxy(clientSide="org.bensam.tpworks.client.particle.ModParticlesClient", serverSide="org.bensam.tpworks.client.particle.ModParticlesBase")
    public static ModParticlesBase particles;
    @Mod.Instance(value="tpworks")
    public static TeleportationWorks instance;
    public static final CreativeTab CREATIVE_TAB;
    public static final Logger MOD_LOGGER;
    public static SimpleNetworkWrapper network;
    private static int networkPacketID;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
        TeleportationHandlerCapabilityProvider.registerCapability();
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        network.registerMessage((IMessageHandler)new PacketUpdateTeleportTileEntity.Handler(), PacketUpdateTeleportTileEntity.class, networkPacketID++, Side.CLIENT);
        network.registerMessage((IMessageHandler)new PacketRequestUpdateTeleportTileEntity.Handler(), PacketRequestUpdateTeleportTileEntity.class, networkPacketID++, Side.SERVER);
        network.registerMessage((IMessageHandler)new PacketUpdateTeleportIncoming.Handler(), PacketUpdateTeleportIncoming.class, networkPacketID++, Side.CLIENT);
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "chests/spawn_bonus_chest"));
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        proxy.init(event);
        ModBlocks.registerOreDictionaryEntries();
        ModItems.registerOreDictionaryEntries();
        BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.TELEPORTATION_SPLASH_POTION, (Object)new IBehaviorDispenseItem(){

            public ItemStack func_82482_a(final IBlockSource source, ItemStack stack) {
                return new BehaviorProjectileDispense(){

                    protected IProjectile func_82499_a(World world, IPosition position, ItemStack stack) {
                        return new EntityTeleportationSplashPotion(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), source, false);
                    }

                    protected float func_82498_a() {
                        return super.func_82498_a() * 0.5f;
                    }

                    protected float func_82500_b() {
                        return super.func_82500_b() * 1.25f;
                    }
                }.func_82482_a(source, stack);
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.TELEPORTATION_SPLASH_POTION_EXTENDED, (Object)new IBehaviorDispenseItem(){

            public ItemStack func_82482_a(final IBlockSource source, ItemStack stack) {
                return new BehaviorProjectileDispense(){

                    protected IProjectile func_82499_a(World world, IPosition position, ItemStack stack) {
                        return new EntityTeleportationSplashPotion(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), source, true);
                    }

                    protected float func_82498_a() {
                        return super.func_82498_a() * 0.5f;
                    }

                    protected float func_82500_b() {
                        return super.func_82500_b() * 1.25f;
                    }
                }.func_82482_a(source, stack);
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.TELEPORTATION_TIPPED_ARROW, (Object)new IBehaviorDispenseItem(){

            public ItemStack func_82482_a(final IBlockSource source, ItemStack stack) {
                return new BehaviorProjectileDispense(){

                    protected IProjectile func_82499_a(World world, IPosition position, ItemStack stack) {
                        EntityTeleportationTippedArrow entityArrow = new EntityTeleportationTippedArrow(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), source);
                        entityArrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                        return entityArrow;
                    }
                }.func_82482_a(source, stack);
            }
        });
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (event.isDirectory()) {
            MOD_LOGGER.info("Fingerprint Violation detected in '{}' though this is expected because we're in a development environment", (Object)event.getSource().getName());
        } else {
            MOD_LOGGER.warn("*****          WARNING!");
            MOD_LOGGER.warn("***** The signature of the mod file '{}' does not match the expected", (Object)event.getSource().getName());
            MOD_LOGGER.warn("***** value! This means the mod file has been tampered with since its official release");
            MOD_LOGGER.warn("***** by the author. The mod may not work, may contain malware, or may in general");
            MOD_LOGGER.warn("***** not function as expected or advertised.");
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandTeleportation());
    }

    static {
        CREATIVE_TAB = new CreativeTab();
        MOD_LOGGER = LogManager.getLogger((String)MODID);
    }
}

