/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.item;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.bensam.tpworks.TeleportationWorks;
import org.bensam.tpworks.block.teleportbeacon.TileEntityTeleportBeacon;
import org.bensam.tpworks.block.teleportrail.TileEntityTeleportRail;
import org.bensam.tpworks.capability.teleportation.ITeleportationBlock;
import org.bensam.tpworks.capability.teleportation.ITeleportationHandler;
import org.bensam.tpworks.capability.teleportation.ITeleportationTileEntity;
import org.bensam.tpworks.capability.teleportation.TeleportDestination;
import org.bensam.tpworks.capability.teleportation.TeleportationHandler;
import org.bensam.tpworks.capability.teleportation.TeleportationHandlerCapabilityProvider;
import org.bensam.tpworks.capability.teleportation.TeleportationHelper;
import org.bensam.tpworks.network.PacketUpdateTeleportIncoming;
import org.bensam.tpworks.network.PacketUpdateTeleportTileEntity;
import org.bensam.tpworks.sound.ModSounds;
import org.bensam.tpworks.util.ModConfig;
import org.bensam.tpworks.util.ModSetup;
import org.bensam.tpworks.util.ModUtil;

public class ItemTeleportationWand
extends Item {
    public static final int CHARGE_ANIMATION_DELAY_TICKS = 10;
    public static final int CHARGE_ANIMATION_FRAMES = 5;
    public static final int CHARGE_UP_TIME_TICKS = 40;
    public static final int COOLDOWN_TIME_TICKS = 40;

    public ItemTeleportationWand(@Nonnull String name) {
        ModSetup.setRegistryNames(this, name);
        ModSetup.setCreativeTab(this);
        this.func_77625_d(1);
        this.func_77656_e(25);
        this.func_185043_a(new ResourceLocation("animationIndex"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity == null || !entity.func_184587_cr()) {
                    return 0.0f;
                }
                int animationFrame = stack.func_77988_m() - entity.func_184605_cv() - 10;
                return animationFrame <= 0 ? 0.0f : (float)(animationFrame % 5) / 5.0f;
            }
        });
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        Item repairIngredient = repair.func_77973_b();
        return repairIngredient == Items.field_151079_bi || repairIngredient == Items.field_151061_bv || repairIngredient == Items.field_151100_aR && repair.func_77960_j() == 4;
    }

    public int func_77619_b() {
        return 1;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return super.onEntitySwing(entityLiving, stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        Block clickedBlock = world.func_180495_p(pos).func_177230_c();
        if (!world.field_72995_K) {
            ITeleportationHandler playerTeleportationHandler = (ITeleportationHandler)player.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
            if (playerTeleportationHandler != null) {
                if (clickedBlock == Blocks.field_150367_z) {
                    TileEntityDispenser te = (TileEntityDispenser)world.func_175625_s(pos);
                    ITeleportationHandler dispenserTeleportationHandler = (ITeleportationHandler)te.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
                    if (dispenserTeleportationHandler != null) {
                        TeleportDestination dispenserDestination = dispenserTeleportationHandler.getActiveDestination();
                        if (player.func_70093_af()) {
                            TeleportDestination nextDestination = TeleportationHelper.getNextDestination((Entity)player, TeleportDestination.DestinationType.BEACON, dispenserDestination, null);
                            if (nextDestination != null) {
                                dispenserTeleportationHandler.replaceOrAddFirstDestination(nextDestination);
                                te.func_70296_d();
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.destination.set.confirmation", new Object[]{TextFormatting.DARK_GREEN + nextDestination.friendlyName}));
                            } else if (dispenserDestination == null) {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.destination.none_available", new Object[0]));
                            } else {
                                dispenserTeleportationHandler.removeDestination(0);
                                te.func_70296_d();
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.destination.cleared.confirmation", new Object[0]));
                            }
                        } else if (dispenserDestination == null) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.dispenser.display.no_destination", new Object[0]));
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.dispenser.display.with_destination", new Object[]{playerTeleportationHandler.getShortFormattedName(player, dispenserDestination)}));
                        }
                    }
                    player.func_184811_cZ().func_185145_a((Item)this, 1);
                    return EnumActionResult.FAIL;
                }
                if (clickedBlock instanceof ITeleportationBlock && !player.func_184811_cZ().func_185141_a((Item)this)) {
                    ITeleportationTileEntity te = (ITeleportationTileEntity)world.func_175625_s(pos);
                    int dimension = world.field_73011_w.getDimension();
                    UUID uuid = te.getUniqueID();
                    String name = te.getTeleportName();
                    TeleportationHandler teleportationHandler = te.getTeleportationHandler();
                    TeleportDestination destination = teleportationHandler.getActiveDestination();
                    if (player.func_70093_af()) {
                        TeleportDestination nextDestination = null;
                        if (te instanceof TileEntityTeleportRail) {
                            nextDestination = ModConfig.teleportBlockSettings.railDestinationsIncludeBeacons ? TeleportationHelper.getNextDestination((Entity)player, null, destination, uuid) : TeleportationHelper.getNextDestination((Entity)player, TeleportDestination.DestinationType.RAIL, destination, uuid);
                        } else if (te instanceof TileEntityTeleportBeacon) {
                            UUID exceptThisID = ModConfig.teleportBlockSettings.beaconDestinationsIncludeSelf ? null : uuid;
                            nextDestination = ModConfig.teleportBlockSettings.beaconDestinationsIncludeRails ? TeleportationHelper.getNextDestination((Entity)player, null, destination, exceptThisID) : TeleportationHelper.getNextDestination((Entity)player, TeleportDestination.DestinationType.BEACON, destination, exceptThisID);
                        }
                        if (nextDestination != null) {
                            teleportationHandler.replaceOrAddFirstDestination(nextDestination);
                            te.setSender(true);
                            ((TileEntity)te).func_70296_d();
                            TeleportationWorks.network.sendToAll((IMessage)new PacketUpdateTeleportTileEntity(pos, dimension, null, Boolean.TRUE));
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.destination.set.confirmation", new Object[]{TextFormatting.DARK_GREEN + nextDestination.friendlyName}));
                        } else if (destination == null) {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.destination.none_available", new Object[0]));
                        } else {
                            teleportationHandler.removeDestination(0);
                            te.setSender(false);
                            ((TileEntity)te).func_70296_d();
                            TeleportationWorks.network.sendToAll((IMessage)new PacketUpdateTeleportTileEntity(pos, dimension, null, Boolean.FALSE));
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.destination.cleared.confirmation", new Object[0]));
                        }
                    } else {
                        String messageAddConfirmation = "message.td.add.confirmation";
                        String messageDeleteConfirmation = "message.td.delete.confirmation";
                        TeleportDestination.DestinationType destinationType = TeleportDestination.DestinationType.BLOCKPOS;
                        if (te instanceof TileEntityTeleportRail) {
                            messageAddConfirmation = "message.td.rail.add.confirmation";
                            messageDeleteConfirmation = "message.td.rail.delete.confirmation";
                            destinationType = TeleportDestination.DestinationType.RAIL;
                        } else if (te instanceof TileEntityTeleportBeacon) {
                            messageAddConfirmation = "message.td.beacon.add.confirmation";
                            messageDeleteConfirmation = "message.td.beacon.delete.confirmation";
                            destinationType = TeleportDestination.DestinationType.BEACON;
                        }
                        if (playerTeleportationHandler.hasDestination(uuid)) {
                            playerTeleportationHandler.removeDestination(uuid);
                            TeleportationWorks.network.sendTo((IMessage)new PacketUpdateTeleportTileEntity(pos, dimension, Boolean.FALSE, null), (EntityPlayerMP)player);
                            player.func_145747_a((ITextComponent)new TextComponentTranslation(messageDeleteConfirmation, new Object[]{TextFormatting.DARK_GREEN + name + TextFormatting.RESET}));
                        } else if (playerTeleportationHandler.getDestinationCount() < playerTeleportationHandler.getDestinationLimit()) {
                            TeleportDestination newDestination = new TeleportDestination(uuid, name, destinationType, world.field_73011_w.getDimension(), pos);
                            if (playerTeleportationHandler.replaceOrAddDestination(newDestination)) {
                                TeleportationWorks.network.sendTo((IMessage)new PacketUpdateTeleportTileEntity(pos, dimension, Boolean.TRUE, null), (EntityPlayerMP)player);
                                player.func_145747_a((ITextComponent)new TextComponentTranslation(messageAddConfirmation, new Object[]{TextFormatting.DARK_GREEN + name + TextFormatting.RESET}));
                            }
                        } else {
                            TextComponentTranslation message = new TextComponentTranslation("message.td.network.full", new Object[]{playerTeleportationHandler.getDestinationLimit()});
                            message.func_150256_b().func_150238_a(TextFormatting.RED);
                            player.func_145747_a((ITextComponent)message);
                        }
                    }
                    player.func_184811_cZ().func_185145_a((Item)this, 1);
                }
            }
        } else if (clickedBlock instanceof ITeleportationBlock && !player.func_70093_af()) {
            ITeleportationTileEntity te = (ITeleportationTileEntity)world.func_175625_s(pos);
            if (te.isStoredByPlayer()) {
                world.func_184133_a(player, pos, ModSounds.REMOVE_TELEPORT_BEACON, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                world.func_184133_a(player, pos, ModSounds.STORE_TELEPORT_BEACON, SoundCategory.HOSTILE, 0.8f, 1.0f);
            }
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        TeleportDestination destination;
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            if (this.func_77626_a(stack) - count > 10) {
                boolean isRightHand;
                Random rand = ModUtil.RANDOM;
                Vec3d playerPos = player.func_174791_d();
                Vec3d particleOffset = Vec3d.func_189986_a((float)0.0f, (float)player.field_70177_z);
                boolean bl = isRightHand = player.func_184600_cs() == EnumHand.MAIN_HAND;
                if (player.func_184591_cq() == EnumHandSide.LEFT) {
                    isRightHand = !isRightHand;
                }
                particleOffset = isRightHand ? particleOffset.func_178785_b(-0.5235988f) : particleOffset.func_178785_b(0.5235988f);
                for (int i = 0; i < 6; ++i) {
                    double x = playerPos.field_72450_a + particleOffset.field_72450_a + (rand.nextDouble() - 0.5) * 0.5;
                    double y = playerPos.field_72448_b + rand.nextDouble() * 0.5;
                    double z = playerPos.field_72449_c + particleOffset.field_72449_c + (rand.nextDouble() - 0.5) * 0.5;
                    double speedX = (rand.nextDouble() - 0.5) * 0.5;
                    double speedY = (rand.nextDouble() - 0.5) * 0.5;
                    double speedZ = (rand.nextDouble() - 0.5) * 0.5;
                    world.func_175688_a(EnumParticleTypes.PORTAL, x, y, z, speedX, speedY, speedZ, new int[0]);
                }
            }
        } else if (this.func_77626_a(stack) - count == 10 && (destination = TeleportationHelper.getActiveDestination((Entity)player)) != null) {
            TeleportationWorks.network.sendToAllAround((IMessage)new PacketUpdateTeleportIncoming(destination.position, destination.dimension), new NetworkRegistry.TargetPoint(destination.dimension, (double)destination.position.func_177958_n(), (double)destination.position.func_177956_o(), (double)destination.position.func_177952_p(), 50.0));
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        TeleportDestination destination;
        ITeleportationHandler teleportationHandler;
        if (!world.field_72995_K && (teleportationHandler = (ITeleportationHandler)entityLiving.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null)) != null && (destination = teleportationHandler.getActiveDestination()) != null) {
            if (teleportationHandler.validateDestination((Entity)entityLiving, destination)) {
                if (entityLiving.func_184218_aH() && (entityLiving.func_184187_bx() instanceof IAnimals && ModConfig.equippedItemSettings.wandTeleportsCreaturesRidden || entityLiving.func_184187_bx() instanceof EntityBoat && ModConfig.equippedItemSettings.wandTeleportsBoatsRidden || entityLiving.func_184187_bx() instanceof EntityMinecart && ModConfig.equippedItemSettings.wandTeleportsMinecartsRidden)) {
                    Entity entityRidden = TeleportationHelper.teleport(entityLiving.func_184187_bx(), destination);
                    TeleportationHelper.teleport((Entity)entityLiving, destination);
                    TeleportationHelper.remountRider((Entity)entityLiving, entityRidden);
                } else {
                    TeleportationHelper.teleport((Entity)entityLiving, destination);
                }
            } else if (destination.destinationType != TeleportDestination.DestinationType.SPAWNBED || destination.dimension != 0) {
                entityLiving.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.destination.removed.invalid", new Object[]{TextFormatting.DARK_GRAY + destination.friendlyName + TextFormatting.RESET}));
                teleportationHandler.removeDestination(destination.getUUID());
            }
            stack.func_77972_a(1, entityLiving);
        }
        if (entityLiving instanceof EntityPlayer) {
            ((EntityPlayer)entityLiving).func_184811_cZ().func_185145_a((Item)this, 40);
            ((EntityPlayer)entityLiving).func_71029_a(StatList.func_188057_b((Item)this));
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        ITeleportationHandler teleportationHandler;
        if (!world.field_72995_K && stack.func_77988_m() - timeLeft <= 10 && !((EntityPlayer)entityLiving).func_184811_cZ().func_185141_a((Item)this) && (teleportationHandler = (ITeleportationHandler)entityLiving.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null)) != null) {
            TeleportDestination activeDestination = entityLiving.func_70093_af() ? teleportationHandler.setActiveDestinationToNext() : teleportationHandler.getActiveDestination();
            if (activeDestination == null) {
                entityLiving.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.destination.none", new Object[0]));
            } else {
                entityLiving.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.active.confirmation", new Object[]{teleportationHandler.getShortFormattedName((EntityPlayer)entityLiving, activeDestination)}));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        String sneakBind = Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName();
        String useItemBind = Minecraft.func_71410_x().field_71474_y.field_74313_G.getDisplayName();
        tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"item.teleportation_wand.tipLine1", (Object[])new Object[0]));
        tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"item.teleportation_wand.tipLine2", (Object[])new Object[]{useItemBind}));
        tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"item.teleportation_wand.tipLine3", (Object[])new Object[0]));
        tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"item.teleportation_wand.tipLine4", (Object[])new Object[]{sneakBind, useItemBind}));
    }
}

