/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.bensam.tpworks.capability.teleportation.ITeleportationHandler;
import org.bensam.tpworks.capability.teleportation.ITeleportationTileEntity;
import org.bensam.tpworks.capability.teleportation.TeleportDestination;
import org.bensam.tpworks.capability.teleportation.TeleportationHandlerCapabilityProvider;
import org.bensam.tpworks.network.PacketUpdateTeleportTileEntity;

public class PacketRequestUpdateTeleportTileEntity
implements IMessage {
    private BlockPos pos;
    private int dimension;

    public PacketRequestUpdateTeleportTileEntity(BlockPos pos, int dimension) {
        this.pos = pos;
        this.dimension = dimension;
    }

    public PacketRequestUpdateTeleportTileEntity(ITeleportationTileEntity te) {
        this(((TileEntity)te).func_174877_v(), ((TileEntity)te).func_145831_w().field_73011_w.getDimension());
    }

    public PacketRequestUpdateTeleportTileEntity() {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.dimension = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.dimension);
    }

    public static class Handler
    implements IMessageHandler<PacketRequestUpdateTeleportTileEntity, PacketUpdateTeleportTileEntity> {
        public PacketUpdateTeleportTileEntity onMessage(PacketRequestUpdateTeleportTileEntity message, MessageContext ctx) {
            ITeleportationHandler teleportationHandler;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.dimension);
            TileEntity te = world.func_175625_s(message.pos);
            if (te instanceof ITeleportationTileEntity && (teleportationHandler = (ITeleportationHandler)player.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null)) != null) {
                ITeleportationTileEntity teTeleportationTileEntity = (ITeleportationTileEntity)te;
                TeleportDestination destination = teleportationHandler.getDestinationFromUUID(teTeleportationTileEntity.getUniqueID());
                if (destination != null) {
                    teleportationHandler.validateDestination((Entity)player, destination);
                    return new PacketUpdateTeleportTileEntity(message.pos, message.dimension, Boolean.TRUE, teTeleportationTileEntity.isSender());
                }
                return new PacketUpdateTeleportTileEntity(message.pos, message.dimension, Boolean.FALSE, teTeleportationTileEntity.isSender());
            }
            return null;
        }
    }
}

