/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;
import xaero.deallocator.ByteBufferDeallocator;
import xaero.map.MapLimiter;
import xaero.map.MapRunner;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.biome.MapBiomes;
import xaero.map.controls.ControlsRegister;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.RegionDetection;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.graphics.TextureUploader;
import xaero.map.gui.GuiMap;
import xaero.map.mcworld.WorldMapClientWorldData;
import xaero.map.mcworld.WorldMapClientWorldDataHelper;
import xaero.map.pool.MapTilePool;
import xaero.map.region.LeveledRegion;
import xaero.map.region.LeveledRegionManager;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayManager;
import xaero.map.region.texture.BranchTextureRenderer;
import xaero.map.region.texture.RegionTexture;
import xaero.map.task.MapRunnerTask;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class MapProcessor {
    public static final int DEFAULT_LIGHT_LEVELS = 4;
    private MapSaveLoad mapSaveLoad;
    private MapWriter mapWriter;
    private MapLimiter mapLimiter;
    private WorldDataHandler worldDataHandler;
    private ByteBufferDeallocator bufferDeallocator;
    private TextureUploader textureUploader;
    private BranchTextureRenderer branchTextureRenderer;
    private WorldClient world;
    private WorldClient newWorld;
    public final Object mainStuffSync;
    public WorldClient mainWorld;
    public double mainPlayerX;
    public double mainPlayerY;
    public double mainPlayerZ;
    private boolean mainWorldUnloaded;
    private ArrayList<Double[]> footprints = new ArrayList();
    private int footprintsTimer;
    private boolean mapWorldUsable;
    private MapWorld mapWorld;
    private String currentWorldId;
    private String currentDimId;
    private String currentMWId;
    private boolean mapWorldUsableRequest;
    private boolean caveStartDetermined;
    private int caveStart;
    public final Object renderThreadPauseSync = new Object();
    private int pauseUploading;
    private int pauseRendering;
    private int pauseWriting;
    public final Object processorThreadPauseSync = new Object();
    private int pauseProcessing;
    public final Object loadingSync = new Object();
    public final Object uiSync = new Object();
    private boolean waitingForWorldUpdate;
    private ArrayList<LeveledRegion<?>>[] toProcessLevels;
    private ArrayList<MapRegion> toRefresh = new ArrayList();
    private static final int SPAWNPOINT_TIMEOUT = 3000;
    private BlockPos spawnToRestore;
    private long mainWorldChangedTime = -1L;
    private MapTilePool tilePool;
    private int firstBranchLevel;
    private long lastRenderProcessTime = -1L;
    private int workingFramesCount;
    public long freeFramePeriod = -1L;
    private int testingFreeFrame = 1;
    private boolean currentMapNeedsDeletion;
    private OverlayManager overlayManager;
    private MapBiomes mapBiomes;
    private long renderStartTime;
    private Field scheduledTasksField;
    private Callable<Object> renderStartTimeUpdater;
    private int state;
    private String[] dimensionsToIgnore = new String[]{"FZHammer"};
    public Field selectedField = null;

    public MapProcessor(MapSaveLoad mapSaveLoad, MapWriter mapWriter, MapLimiter mapLimiter, ByteBufferDeallocator bufferDeallocator, MapTilePool tilePool, OverlayManager overlayManager, TextureUploader textureUploader, WorldDataHandler worldDataHandler, MapBiomes mapBiomes, BranchTextureRenderer branchTextureRenderer) throws NoSuchFieldException {
        this.branchTextureRenderer = branchTextureRenderer;
        this.mapSaveLoad = mapSaveLoad;
        this.mapWriter = mapWriter;
        this.mapLimiter = mapLimiter;
        this.bufferDeallocator = bufferDeallocator;
        this.tilePool = tilePool;
        this.overlayManager = overlayManager;
        this.textureUploader = textureUploader;
        this.worldDataHandler = worldDataHandler;
        this.mapBiomes = mapBiomes;
        try {
            this.scheduledTasksField = Minecraft.class.getDeclaredField("field_152351_aB");
        }
        catch (NoSuchFieldException e) {
            try {
                this.scheduledTasksField = Minecraft.class.getDeclaredField("scheduledTasks");
            }
            catch (NoSuchFieldException nsfe) {
                throw nsfe;
            }
            catch (SecurityException se) {
                throw se;
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        Runnable renderStartTimeUpdaterRunnable = new Runnable(){

            @Override
            public void run() {
                MapProcessor.this.updateRenderStartTime();
            }
        };
        this.renderStartTimeUpdater = Executors.callable(renderStartTimeUpdaterRunnable);
        this.mainStuffSync = new Object();
        this.caveStart = -1;
        this.toProcessLevels = new ArrayList[4];
        for (int i = 0; i < this.toProcessLevels.length; ++i) {
            this.toProcessLevels[i] = new ArrayList();
        }
    }

    public void onInit() {
        this.mapWorld = new MapWorld(this.getMainId(true), this.getMainId(false), this);
        this.mapWorld.loadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(MapRunner runner) {
        if (this.state < 2) {
            try {
                while (this.state < 2 && WorldMap.crashHandler.getCrashedBy() == null) {
                    Object object = this.processorThreadPauseSync;
                    synchronized (object) {
                        if (!this.isProcessingPaused()) {
                            this.updateWorld();
                            if (this.world != null) {
                                this.updateCaveStart(this.mainPlayerX, this.mainPlayerZ, (World)this.world);
                                this.updateFootprints((World)this.world, Minecraft.func_71410_x().field_71462_r instanceof GuiMap ? 1 : 10);
                            }
                            if (this.mapWorldUsable) {
                                this.mapLimiter.applyLimit(this.mapWorld, this);
                                long currentTime = System.currentTimeMillis();
                                block11: for (int l = 0; l < this.toProcessLevels.length; ++l) {
                                    ArrayList<LeveledRegion<?>> regionsToProcess = this.toProcessLevels[l];
                                    for (int i = 0; i < regionsToProcess.size(); ++i) {
                                        LeveledRegion<?> leveledRegion;
                                        ArrayList<LeveledRegion<?>> arrayList = regionsToProcess;
                                        synchronized (arrayList) {
                                            if (i >= regionsToProcess.size()) {
                                                continue block11;
                                            }
                                            leveledRegion = regionsToProcess.get(i);
                                        }
                                        this.mapSaveLoad.updateSave(leveledRegion, currentTime);
                                    }
                                }
                            }
                            this.mapSaveLoad.run((World)this.world);
                            this.handleRefresh((World)this.world);
                            runner.doTasks(this);
                        }
                    }
                    try {
                        Thread.sleep(this.world == null || Minecraft.func_71410_x().field_71462_r instanceof GuiMap ? 40L : 1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable e) {
                WorldMap.crashHandler.setCrashedBy(e);
            }
            if (this.state < 2) {
                this.forceClean();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRenderProcess(Minecraft mc, ScaledResolution scaledRes) throws RuntimeException {
        this.mapWriter.onRender();
        try {
            long renderProcessTime = System.nanoTime();
            if (this.testingFreeFrame == 1) {
                this.testingFreeFrame = 2;
            } else {
                Object object = this.renderThreadPauseSync;
                synchronized (object) {
                    if (this.lastRenderProcessTime == -1L) {
                        this.lastRenderProcessTime = renderProcessTime;
                    }
                    long sinceLastProcessTime = renderProcessTime - this.lastRenderProcessTime;
                    if (this.testingFreeFrame == 2) {
                        this.freeFramePeriod = sinceLastProcessTime;
                        this.testingFreeFrame = 0;
                    }
                    if (this.pauseUploading == 0 && this.mapWorldUsable && this.currentWorldId != null) {
                        boolean branchesCatchup;
                        while (GL11.glGetError() != 0) {
                        }
                        GlStateManager.func_187425_g((int)3317, (int)4);
                        GlStateManager.func_187425_g((int)3316, (int)0);
                        GlStateManager.func_187425_g((int)3315, (int)0);
                        GlStateManager.func_187425_g((int)3314, (int)0);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        int globalRegionCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                        boolean detailedDebug = WorldMap.settings.detailed_debug;
                        long uploadStart = System.nanoTime();
                        long totalTime = Math.min(sinceLastProcessTime, this.freeFramePeriod);
                        long passed = uploadStart - this.renderStartTime;
                        long timeAvailable = Math.max(3000000L, totalTime - passed);
                        long uploadUntil = uploadStart + timeAvailable / 4L;
                        long gpuLimit = Minecraft.func_71410_x().field_71462_r instanceof GuiMap ? Math.max(1000000L, totalTime * 5L / 12L) : Math.min(totalTime / 5L, timeAvailable);
                        int firstLevel = 0;
                        boolean bl = branchesCatchup = (int)(Math.random() * 5.0) == 0;
                        if (branchesCatchup) {
                            firstLevel = 1 + this.firstBranchLevel;
                        }
                        this.firstBranchLevel = (this.firstBranchLevel + 1) % (this.toProcessLevels.length - 1);
                        block15: for (int j = 0; j < this.toProcessLevels.length; ++j) {
                            int level = (firstLevel + j) % this.toProcessLevels.length;
                            ArrayList<LeveledRegion<?>> toProcess = this.toProcessLevels[level];
                            for (int i = 0; i < toProcess.size(); ++i) {
                                LeveledRegion<?> region;
                                Object object2 = toProcess;
                                synchronized (object2) {
                                    if (i >= toProcess.size()) {
                                        continue block15;
                                    }
                                    region = toProcess.get(i);
                                }
                                if (region == null) continue;
                                object2 = region;
                                synchronized (object2) {
                                    if (region.shouldBeProcessed()) {
                                        boolean cleanAndCacheRequestsBlocked = region.cleanAndCacheRequestsBlocked();
                                        boolean allCleaned = true;
                                        boolean allCached = true;
                                        boolean allUploaded = true;
                                        boolean isEmpty = true;
                                        boolean hasLoadedChunks = false;
                                        for (int x = 0; x < 8; ++x) {
                                            for (int z = 0; z < 8; ++z) {
                                                Object texture = region.getTexture(x, z);
                                                if (texture == null) continue;
                                                isEmpty = false;
                                                if (((RegionTexture)texture).canUpload()) {
                                                    hasLoadedChunks = true;
                                                    if (gpuLimit > 0L && System.nanoTime() < uploadUntil) {
                                                        ((RegionTexture)texture).preUpload(this, region, detailedDebug);
                                                        if (((RegionTexture)texture).shouldUpload()) {
                                                            if (((RegionTexture)texture).getTimer() == 0) {
                                                                gpuLimit -= ((RegionTexture)texture).uploadBuffer(this.textureUploader, region, this.branchTextureRenderer, x, z, scaledRes);
                                                            } else {
                                                                ((RegionTexture)texture).decTimer();
                                                            }
                                                        }
                                                    }
                                                    ((RegionTexture)texture).postUpload(this, region, cleanAndCacheRequestsBlocked);
                                                }
                                                if (((RegionTexture)texture).hasSourceData()) {
                                                    allCleaned = false;
                                                }
                                                if (!((RegionTexture)texture).isCachePrepared()) {
                                                    allCached = false;
                                                }
                                                if (((RegionTexture)texture).isUploaded()) continue;
                                                allUploaded = false;
                                            }
                                        }
                                        if (hasLoadedChunks) {
                                            region.processWhenLoadedChunksExist(globalRegionCacheHashCode);
                                        }
                                        allUploaded = allUploaded && region.isLoaded() && !cleanAndCacheRequestsBlocked;
                                        boolean bl2 = allCached = allCached && allUploaded && !isEmpty;
                                        if ((!region.shouldCache() || !region.recacheHasBeenRequested()) && region.shouldEndProcessingAfterUpload() && allCleaned && allUploaded) {
                                            region.onProcessingEnd();
                                            region.deleteGLBuffers();
                                            ArrayList<LeveledRegion<?>> arrayList = toProcess;
                                            synchronized (arrayList) {
                                                if (i < toProcess.size()) {
                                                    toProcess.remove(i);
                                                    --i;
                                                }
                                            }
                                            if (WorldMap.settings.debug) {
                                                System.out.println("Region freed: " + region + " " + this.mapWriter.getUpdateCounter() + " " + this.currentWorldId + " " + this.currentDimId);
                                            }
                                        }
                                        if (allCached && !region.isAllCachePrepared()) {
                                            region.setAllCachePrepared(true);
                                        }
                                        if (region.shouldCache() && region.isAllCachePrepared() && !cleanAndCacheRequestsBlocked) {
                                            this.getMapSaveLoad().requestCache(region);
                                        }
                                    }
                                    continue;
                                }
                            }
                        }
                        ++this.workingFramesCount;
                        if (this.workingFramesCount >= 30) {
                            this.testingFreeFrame = 1;
                            this.workingFramesCount = 0;
                        }
                        this.textureUploader.uploadTextures();
                    }
                }
            }
            this.mapLimiter.updateAvailableVRAM();
            this.lastRenderProcessTime = renderProcessTime;
        }
        catch (Throwable e) {
            WorldMap.crashHandler.setCrashedBy(e);
        }
        WorldMap.crashHandler.checkForCrashes();
    }

    public boolean ignoreWorld(World world) {
        for (int i = 0; i < this.dimensionsToIgnore.length; ++i) {
            if (!this.dimensionsToIgnore[i].equals(world.field_73011_w.func_186058_p().func_186065_b())) continue;
            return true;
        }
        return false;
    }

    public String getDimensionName(int id) {
        String name = "null";
        if (id != 0) {
            name = "DIM" + id;
        }
        return name;
    }

    public String getDimensionLegacyName(WorldProvider worldProvider) {
        String legacyName = worldProvider.getSaveFolder();
        if (legacyName != null) {
            legacyName = legacyName.replaceAll("_", "^us^");
        }
        return legacyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changeWorld(WorldClient world) {
        this.pushWriterPause();
        Object object = this.loadingSync;
        synchronized (object) {
            this.waitingForWorldUpdate = true;
        }
        this.newWorld = world;
        if (world == null) {
            this.mapWorldUsableRequest = false;
        } else {
            this.mapWorldUsableRequest = true;
            int dimId = world.field_73011_w.getDimension();
            Object autoIdBase = this.getAutoIdBase(world);
            MapDimension mapDimension = this.mapWorld.getDimension(dimId);
            if (mapDimension == null) {
                mapDimension = this.mapWorld.createDimensionUnsynced((World)world, dimId);
            }
            this.mapWorld.setFutureDimensionId(dimId);
            mapDimension.updateFutureAutomaticUnsynced(Minecraft.func_71410_x(), autoIdBase);
            mapDimension.resetCustomMultiworldUnsynced();
        }
        this.popWriterPause();
    }

    private String getMainId(boolean rootFolderFormat) {
        Minecraft mc = Minecraft.func_71410_x();
        String result = null;
        if (mc.func_71401_C() != null) {
            result = mc.func_71401_C().func_71270_I().replaceAll("_", "^us^");
            if (this.isWorldMultiplayer(this.isWorldRealms(result), result)) {
                result = "^e^" + result;
            }
        } else if (mc.func_181540_al() && WorldMap.events.getLatestRealm() != null) {
            result = "Realms_" + WorldMap.events.getLatestRealm().ownerUUID + "." + WorldMap.events.getLatestRealm().id;
        } else if (mc.func_147104_D() != null) {
            String serverIP;
            String string = serverIP = WorldMap.settings.differentiateByServerAddress ? mc.func_147104_D().field_78845_b : "Any Address";
            if (serverIP.contains(":")) {
                serverIP = serverIP.substring(0, serverIP.indexOf(":"));
            }
            while (rootFolderFormat && serverIP.endsWith(".")) {
                serverIP = serverIP.substring(0, serverIP.length() - 1);
            }
            result = "Multiplayer_" + serverIP.replaceAll(":", "\u00a7");
        } else {
            result = "Multiplayer_Unknown";
        }
        return result;
    }

    public synchronized void toggleMultiworldType(MapDimension dim) {
        if (this.mapWorldUsable && !this.waitingForWorldUpdate && this.mapWorld.isMultiplayer() && this.mapWorld.getCurrentDimension() == dim) {
            this.mapWorld.toggleMultiworldTypeUnsynced();
        }
    }

    public synchronized void quickConfirmMultiworld() {
        if (this.mapWorldUsable && this.mapWorld.getCurrentDimension().hasConfirmedMultiworld()) {
            this.confirmMultiworld(this.mapWorld.getCurrentDimension());
        }
    }

    public synchronized boolean confirmMultiworld(MapDimension dim) {
        if (this.mapWorldUsable && this.mapWorld.isMultiplayer() && this.mainWorld != null && this.mainWorld.field_73011_w.getDimension() == this.mapWorld.getCurrentDimensionId().intValue() && this.mapWorld.getCurrentDimension() == dim) {
            this.mapWorld.confirmMultiworldTypeUnsynced();
            this.mapWorld.getCurrentDimension().confirmMultiworldUnsynced();
            return true;
        }
        return false;
    }

    public synchronized void setMultiworld(MapDimension dimToCompare, String customMW) {
        if (this.mapWorldUsable && this.mapWorld.isMultiplayer() && dimToCompare == this.mapWorld.getCurrentDimension()) {
            this.mapWorld.getCurrentDimension().setMultiworldUnsynced(customMW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCrosshairMessage() {
        Object object = this.uiSync;
        synchronized (object) {
            if (this.mapWorldUsable && !this.mapWorld.getCurrentDimension().futureMultiworldWritable && this.mainWorld.field_73011_w.getDimension() == this.mapWorld.getCurrentDimensionId().intValue()) {
                String selectedMWName = this.mapWorld.getCurrentDimension().getMultiworldName(this.mapWorld.getCurrentDimension().getFutureMultiworldUnsynced());
                String message = "\u00a72(" + ControlsRegister.keyOpenMap.getDisplayName().toUpperCase() + ")\u00a7r " + I18n.func_135052_a((String)"gui.xaero_map_unconfirmed", (Object[])new Object[0]);
                if (this.mapWorld.getCurrentDimension().hasConfirmedMultiworld()) {
                    message = message + " \u00a72" + ControlsRegister.keyQuickConfirm.getDisplayName().toUpperCase() + "\u00a7r for map \"" + selectedMWName + "\"";
                }
                return message;
            }
        }
        return null;
    }

    private synchronized void checkForWorldUpdate() {
        Object autoIdBase;
        if (this.mainWorld != null && (autoIdBase = this.getAutoIdBase(this.mainWorld)) != null) {
            Object updatedAutoIdBase;
            MapDimension mapDimension;
            boolean baseChanged;
            boolean bl = baseChanged = !autoIdBase.equals(this.getUsedAutoIdBase(this.mainWorld));
            if (baseChanged && this.mapWorldUsable && (mapDimension = this.mapWorld.getDimension(this.mainWorld.field_73011_w.getDimension())) != null) {
                mapDimension.updateFutureAutomaticUnsynced(Minecraft.func_71410_x(), autoIdBase);
            }
            if (this.mainWorld != this.world) {
                this.changeWorld(this.mainWorld);
            }
            if ((updatedAutoIdBase = this.getAutoIdBase(this.mainWorld)) != null) {
                this.setUsedAutoIdBase(this.mainWorld, updatedAutoIdBase);
            } else {
                this.removeUsedAutoIdBase(this.mainWorld);
            }
        }
    }

    private void updateWorld() throws IOException {
        this.updateWorldSynced();
        if (this.mapWorldUsable && !this.mapSaveLoad.isRegionDetectionComplete()) {
            this.mapSaveLoad.detectRegions();
            this.mapSaveLoad.setRegionDetectionComplete(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateWorldSynced() throws IOException {
        Object object = this.uiSync;
        synchronized (object) {
            if (this.mapWorldUsable != this.mapWorldUsableRequest || this.mapWorldUsableRequest && (this.mapWorld.getFutureDimension() != this.mapWorld.getCurrentDimension() || !this.mapWorld.getFutureDimension().getFutureMultiworldUnsynced().equals(this.mapWorld.getFutureDimension().getCurrentMultiworld()))) {
                String newMultiworldId = !this.mapWorldUsableRequest ? null : this.mapWorld.getFutureMultiworldUnsynced();
                this.pushRenderPause(true, true);
                this.pushWriterPause();
                String newWorldId = !this.mapWorldUsableRequest ? null : this.mapWorld.getMainId();
                String newMWId = !this.mapWorld.isMultiplayer() ? null : newMultiworldId;
                boolean shouldClearAllDimensions = this.state == 1;
                boolean shouldClearNewDimension = this.mapWorldUsableRequest && !this.mapWorld.getFutureMultiworldUnsynced().equals(this.mapWorld.getFutureDimension().getCurrentMultiworld());
                this.mapSaveLoad.getToSave().clear();
                if (this.mapWorld.getCurrentDimensionId() != null) {
                    MapDimension currentDim = this.mapWorld.getCurrentDimension();
                    MapDimension reqDim = !this.mapWorldUsableRequest ? null : this.mapWorld.getFutureDimension();
                    boolean shouldFinishCurrentDim = this.mapWorldUsable && !this.currentMapNeedsDeletion;
                    boolean currentDimChecked = false;
                    if (shouldFinishCurrentDim) {
                        this.mapSaveLoad.saveAll = true;
                    }
                    if (shouldFinishCurrentDim || shouldClearNewDimension && reqDim == currentDim) {
                        for (LeveledRegion<?> leveledRegion : currentDim.getMapRegions().getUnsyncedList()) {
                            if (shouldFinishCurrentDim) {
                                if (leveledRegion.getLevel() == 0 && leveledRegion.recacheHasBeenRequested() && leveledRegion.getCacheFile() != null) {
                                    Files.deleteIfExists(leveledRegion.getCacheFile().toPath());
                                    if (WorldMap.settings.debug) {
                                        System.out.println(String.format("Deleting cache for region %s because it might be outdated.", leveledRegion));
                                    }
                                }
                                leveledRegion.setReloadHasBeenRequested(false, "world/dim change");
                                leveledRegion.onCurrentDimFinish(this.mapSaveLoad, this);
                            }
                            if (!shouldClearAllDimensions && (!shouldClearNewDimension || reqDim != currentDim)) continue;
                            leveledRegion.onDimensionClear(this);
                        }
                        currentDimChecked = true;
                    }
                    if (reqDim != currentDim && shouldClearNewDimension) {
                        for (LeveledRegion leveledRegion : reqDim.getMapRegions().getUnsyncedList()) {
                            leveledRegion.onDimensionClear(this);
                        }
                    }
                    if (shouldClearAllDimensions) {
                        for (MapDimension mapDimension : this.mapWorld.getDimensionsList()) {
                            if (currentDimChecked && mapDimension == currentDim) continue;
                            for (LeveledRegion<?> region : mapDimension.getMapRegions().getUnsyncedList()) {
                                region.onDimensionClear(this);
                            }
                        }
                    }
                    if (this.currentMapNeedsDeletion) {
                        this.mapWorld.getCurrentDimension().deleteMultiworldMapDataUnsynced(this.mapWorld.getCurrentDimension().getCurrentMultiworld());
                    }
                }
                this.currentMapNeedsDeletion = false;
                if (shouldClearAllDimensions) {
                    if (this.mapWorld.getCurrentDimensionId() != null) {
                        for (MapDimension dim : this.mapWorld.getDimensionsList()) {
                            dim.clearLists();
                        }
                    }
                    if (WorldMap.settings.debug) {
                        System.out.println("All map data cleared!");
                    }
                    if (this.state == 1) {
                        System.out.println("World map cleaned normally!");
                        this.state = 2;
                    }
                } else if (shouldClearNewDimension) {
                    this.mapWorld.getFutureDimension().regionsToCache.clear();
                    this.mapWorld.getFutureDimension().clearLists();
                    if (WorldMap.settings.debug) {
                        System.out.println("Dimension map data cleared!");
                    }
                }
                if (WorldMap.settings.debug) {
                    System.out.println("World changed!");
                }
                this.mapWorldUsable = this.mapWorldUsableRequest;
                if (this.mapWorldUsableRequest) {
                    this.mapWorld.switchToFutureUnsynced();
                }
                this.caveStartDetermined = false;
                this.caveStart = -1;
                this.currentWorldId = newWorldId;
                this.currentDimId = !this.mapWorldUsableRequest ? null : this.getDimensionName(this.mapWorld.getFutureDimensionId());
                this.currentMWId = newMWId;
                this.footprints.clear();
                this.mapSaveLoad.clearToLoad();
                this.mapSaveLoad.setNextToLoadByViewing((MapRegion)null);
                this.clearToRefresh();
                for (int i = 0; i < this.toProcessLevels.length; ++i) {
                    this.toProcessLevels[i].clear();
                }
                if (this.mapWorldUsable) {
                    for (LeveledRegion<?> region : this.mapWorld.getCurrentDimension().getMapRegions().getUnsyncedList()) {
                        if (!region.shouldBeProcessed()) continue;
                        this.addToProcess(region);
                    }
                }
                this.mapSaveLoad.updateCacheFolderList(this.mapSaveLoad.getMWSubFolder(this.currentWorldId, this.currentDimId, this.currentMWId));
                this.mapWriter.resetPosition();
                this.world = this.newWorld;
                if (WorldMap.settings.debug) {
                    System.out.println("World/dimension changed to: " + this.currentWorldId + " " + this.currentDimId + " " + this.currentMWId);
                }
                this.worldDataHandler.prepareSingleplayer((World)this.world, this);
                if (this.worldDataHandler.getWorldDir() == null && this.currentWorldId != null && !this.mapWorld.isMultiplayer()) {
                    this.currentDimId = null;
                    this.currentWorldId = null;
                }
                boolean shouldDetect = this.mapWorldUsable && this.mapWorld.getCurrentDimension().getDetectedRegions() == null;
                this.mapSaveLoad.setRegionDetectionComplete(!shouldDetect);
                this.popRenderPause(true, true);
                this.popWriterPause();
            } else if (this.newWorld != this.world) {
                this.pushWriterPause();
                this.world = this.newWorld;
                this.popWriterPause();
            }
            if (this.mapWorldUsable) {
                this.mapWorld.getCurrentDimension().switchToFutureMultiworldWritableValueUnsynced();
                this.mapWorld.switchToFutureMultiworldTypeUnsynced();
            }
            this.waitingForWorldUpdate = false;
        }
    }

    public void updateFootprints(World world, int step) {
        if (WorldMap.settings.footsteps) {
            if (this.footprintsTimer > 0) {
                this.footprintsTimer -= step;
            } else {
                Double[] coords = new Double[]{this.mainPlayerX, this.mainPlayerZ};
                this.footprints.add(coords);
                if (this.footprints.size() > 32) {
                    this.footprints.remove(0);
                }
                this.footprintsTimer = 20;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRefresh(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            if (!this.toRefresh.contains(region)) {
                this.toRefresh.add(0, region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToRefresh(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            this.toRefresh.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearToRefresh() {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            this.toRefresh.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRefresh(World world) throws RuntimeException {
        Object object = this.loadingSync;
        synchronized (object) {
            if (!this.waitingForWorldUpdate && !this.toRefresh.isEmpty()) {
                MapRegion region = this.toRefresh.get(0);
                if (region.isRefreshing()) {
                    boolean regionLoaded;
                    int globalReloadVersion = WorldMap.settings.reloadVersion;
                    int globalCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                    MapRegion mapRegion = region;
                    synchronized (mapRegion) {
                        boolean bl = regionLoaded = region.getLoadState() == 2;
                        if (regionLoaded) {
                            if (WorldMap.settings.reloadEverything && region.getReloadVersion() != globalReloadVersion || region.getCacheHashCode() != globalCacheHashCode || region.hasVersion() && region.getVersion() != WorldMap.globalVersion || !region.hasVersion() && region.getInitialVersion() != WorldMap.globalVersion) {
                                region.setRecacheHasBeenRequested(true, "refresh handle");
                                region.setShouldCache(true, "refresh handle");
                            }
                            region.setVersion(WorldMap.globalVersion);
                            region.setCacheHashCode(globalCacheHashCode);
                            region.setReloadVersion(globalReloadVersion);
                        }
                    }
                    boolean isEmpty = true;
                    if (regionLoaded) {
                        MapRegion mapRegion2 = region;
                        synchronized (mapRegion2) {
                            region.setAllCachePrepared(false);
                        }
                        for (int i = 0; i < 8; ++i) {
                            for (int j = 0; j < 8; ++j) {
                                MapTileChunk chunk = region.getChunk(i, j);
                                if (chunk == null || chunk.getLoadState() != 2) continue;
                                chunk.setToUpdateBuffers(true);
                                isEmpty = false;
                            }
                        }
                        if (WorldMap.settings.debug) {
                            System.out.println("Region refreshed: " + region + " " + region + " " + this.mapWriter.getUpdateCounter());
                        }
                    }
                    MapRegion mapRegion3 = region;
                    synchronized (mapRegion3) {
                        region.setRefreshing(false);
                        if (isEmpty) {
                            region.setRecacheHasBeenRequested(false, "refresh handle");
                            region.setShouldCache(false, "refresh handle");
                        }
                    }
                }
                throw new RuntimeException(String.format("Trying to refresh region %s, which is not marked as being refreshed!", region));
                this.removeToRefresh(region);
            }
        }
    }

    public boolean regionExists(int x, int z) {
        if (!this.mapSaveLoad.isRegionDetectionComplete()) {
            return false;
        }
        Hashtable<Integer, RegionDetection> column = this.mapWorld.getCurrentDimension().getDetectedRegions().get(x);
        return column != null && column.containsKey(z);
    }

    public void addRegionDetection(MapDimension dimension, RegionDetection regionDetection) {
        Hashtable<Integer, Hashtable<Integer, RegionDetection>> current = dimension.getDetectedRegions();
        Hashtable<Integer, RegionDetection> column = current.get(regionDetection.getRegionX());
        if (column == null) {
            column = new Hashtable();
            current.put(regionDetection.getRegionX(), column);
        }
        column.put(regionDetection.getRegionZ(), regionDetection);
    }

    public RegionDetection getRegionDetection(int x, int z) {
        Hashtable<Integer, RegionDetection> column = this.mapWorld.getCurrentDimension().getDetectedRegions().get(x);
        if (column != null) {
            return column.get(z);
        }
        return null;
    }

    private void removeRegionDetection(int x, int z) {
        Hashtable<Integer, Hashtable<Integer, RegionDetection>> current = this.mapWorld.getCurrentDimension().getDetectedRegions();
        Hashtable<Integer, RegionDetection> column = current.get(x);
        if (column != null) {
            column.remove(z);
        }
        if (column.isEmpty()) {
            current.remove(x);
        }
    }

    public void removeMapRegion(LeveledRegion<?> region) {
        MapDimension regionDim = region.getDim();
        LeveledRegionManager regions = regionDim.getMapRegions();
        if (region.getLevel() == 0) {
            regions.remove(region.getRegionX(), region.getRegionZ(), region.getLevel());
        }
        regions.removeListRegion(region);
        this.removeToProcess(region);
    }

    public LeveledRegion<?> getLeveledRegion(int leveledRegX, int leveledRegZ, int level) {
        MapDimension mapDimension = this.mapWorld.getCurrentDimension();
        LeveledRegionManager regions = mapDimension.getMapRegions();
        return regions.get(leveledRegX, leveledRegZ, level);
    }

    public MapRegion getMapRegion(int regX, int regZ, boolean create) {
        MapDimension mapDimension = this.mapWorld.getCurrentDimension();
        LeveledRegionManager regions = mapDimension.getMapRegions();
        MapRegion region = regions.getLeaf(regX, regZ);
        if (region == null) {
            if (create) {
                if (!Minecraft.func_71410_x().func_152345_ab()) {
                    throw new IllegalAccessError();
                }
                region = new MapRegion(this.currentWorldId, this.currentDimId, this.currentMWId, mapDimension, regX, regZ, this.getGlobalVersion(), this.mapWorld.isMultiplayer());
                RegionDetection regionDetection = this.getRegionDetection(regX, regZ);
                if (regionDetection != null) {
                    regionDetection.transferInfoTo(region);
                    this.removeRegionDetection(regX, regZ);
                }
                regions.putLeaf(regX, regZ, region);
                regions.addListRegion(region);
                if (regionDetection != null) {
                    regionDetection.transferInfoPostAddTo(region, this);
                }
            } else {
                return null;
            }
        }
        return region;
    }

    public MapTileChunk getMapChunk(int chunkX, int chunkZ) {
        int regionX = chunkX >> 3;
        int regionZ = chunkZ >> 3;
        MapRegion region = this.getMapRegion(regionX, regionZ, false);
        if (region == null) {
            return null;
        }
        int localChunkX = chunkX & 7;
        int localChunkZ = chunkZ & 7;
        return region.getChunk(localChunkX, localChunkZ);
    }

    public MapTile getMapTile(int x, int z) {
        MapTileChunk tileChunk = this.getMapChunk(x >> 2, z >> 2);
        if (tileChunk == null) {
            return null;
        }
        int tileX = x & 3;
        int tileZ = z & 3;
        return tileChunk.getTile(tileX, tileZ);
    }

    public void updateWorldSpawn(BlockPos newSpawn, WorldClient world) {
        int dimId = world.field_73011_w.getDimension();
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(world);
        worldData.latestSpawn = newSpawn;
        if (WorldMap.settings.debug) {
            System.out.println("Updated spawn for dimension " + dimId + " " + newSpawn);
        }
        this.spawnToRestore = newSpawn;
        if (world == this.mainWorld) {
            this.mainWorldChangedTime = -1L;
            if (WorldMap.settings.debug) {
                System.out.println("Done waiting for main spawn.");
            }
        }
        this.checkForWorldUpdate();
    }

    public void onServerLevelId(int serverLevelId) {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getCurrentWorldData();
        worldData.serverLevelId = serverLevelId;
        if (WorldMap.settings.debug) {
            System.out.println("Updated server level id " + serverLevelId);
        }
        this.checkForWorldUpdate();
    }

    public void onWorldUnload() {
        if (this.mainWorldUnloaded) {
            return;
        }
        if (WorldMap.settings.debug) {
            System.out.println("Changing worlds, pausing the world map...");
        }
        this.mainWorldUnloaded = true;
        this.mainWorldChangedTime = -1L;
        this.changeWorld(null);
    }

    public void onClientTickStart() throws RuntimeException {
        if (this.mainWorld != null && this.spawnToRestore != null && this.mainWorldChangedTime != -1L && System.currentTimeMillis() - this.mainWorldChangedTime >= 3000L) {
            if (WorldMap.settings.debug) {
                System.out.println("SPAWN SET TIME OUT");
            }
            this.updateWorldSpawn(this.spawnToRestore, this.mainWorld);
        }
    }

    private void updateRenderStartTime() {
        if (this.renderStartTime == -1L) {
            this.renderStartTime = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushWriterPause() {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            ++this.pauseWriting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popWriterPause() {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            --this.pauseWriting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushRenderPause(boolean rendering, boolean uploading) {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            if (rendering) {
                ++this.pauseRendering;
            }
            if (uploading) {
                ++this.pauseUploading;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popRenderPause(boolean rendering, boolean uploading) {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            if (rendering) {
                --this.pauseRendering;
            }
            if (uploading) {
                --this.pauseUploading;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushProcessorPause() {
        Object object = this.processorThreadPauseSync;
        synchronized (object) {
            ++this.pauseProcessing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popProcessorPause() {
        Object object = this.processorThreadPauseSync;
        synchronized (object) {
            --this.pauseProcessing;
        }
    }

    public boolean isWritingPaused() {
        return this.pauseWriting > 0;
    }

    public boolean isRenderingPaused() {
        return this.pauseRendering > 0;
    }

    public boolean isUploadingPaused() {
        return this.pauseUploading > 0;
    }

    public boolean isProcessingPaused() {
        return this.pauseProcessing > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessed(LeveledRegion<?> region) {
        ArrayList<LeveledRegion<?>> toProcess;
        ArrayList<LeveledRegion<?>> arrayList = toProcess = this.toProcessLevels[region.getLevel()];
        synchronized (arrayList) {
            return toProcess.contains(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToProcess(LeveledRegion<?> region) {
        ArrayList<LeveledRegion<?>> toProcess;
        ArrayList<LeveledRegion<?>> arrayList = toProcess = this.toProcessLevels[region.getLevel()];
        synchronized (arrayList) {
            toProcess.add(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToProcess(LeveledRegion<?> region) {
        ArrayList<LeveledRegion<?>> toProcess;
        ArrayList<LeveledRegion<?>> arrayList = toProcess = this.toProcessLevels[region.getLevel()];
        synchronized (arrayList) {
            toProcess.remove(region);
        }
    }

    public int getProcessedCount() {
        int total = 0;
        for (int i = 0; i < this.toProcessLevels.length; ++i) {
            total += this.toProcessLevels[i].size();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAffectingLoadingFrequencyCount() {
        int total = 0;
        block3: for (int i = 0; i < this.toProcessLevels.length; ++i) {
            ArrayList<LeveledRegion<?>> processed = this.toProcessLevels[i];
            for (int j = 0; j < processed.size(); ++j) {
                ArrayList<LeveledRegion<?>> arrayList = processed;
                synchronized (arrayList) {
                    if (j >= processed.size()) {
                        continue block3;
                    }
                    if (processed.get(j).shouldAffectLoadingRequestFrequency()) {
                        ++total;
                    }
                    continue;
                }
            }
        }
        return total;
    }

    public MapSaveLoad getMapSaveLoad() {
        return this.mapSaveLoad;
    }

    public WorldClient getWorld() {
        return this.world;
    }

    public WorldClient getNewWorld() {
        return this.newWorld;
    }

    public String getCurrentWorldId() {
        return this.currentWorldId;
    }

    public String getCurrentDimId() {
        return this.currentDimId;
    }

    public String getCurrentMWId() {
        return this.currentMWId;
    }

    public MapWriter getMapWriter() {
        return this.mapWriter;
    }

    public MapLimiter getMapLimiter() {
        return this.mapLimiter;
    }

    public ArrayList<Double[]> getFootprints() {
        return this.footprints;
    }

    public ByteBufferDeallocator getBufferDeallocator() {
        return this.bufferDeallocator;
    }

    public MapTilePool getTilePool() {
        return this.tilePool;
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public int getGlobalVersion() {
        return WorldMap.globalVersion;
    }

    public void setGlobalVersion(int globalVersion) {
        WorldMap.globalVersion = globalVersion;
    }

    public long getRenderStartTime() {
        return this.renderStartTime;
    }

    public void resetRenderStartTime() {
        this.renderStartTime = -1L;
    }

    public Queue<FutureTask<?>> getMinecraftScheduledTasks() {
        Queue result;
        this.scheduledTasksField.setAccessible(true);
        try {
            result = (Queue)this.scheduledTasksField.get(Minecraft.func_71410_x());
        }
        catch (IllegalArgumentException e) {
            result = null;
        }
        catch (IllegalAccessException e) {
            result = null;
        }
        this.scheduledTasksField.setAccessible(false);
        return result;
    }

    public Callable<Object> getRenderStartTimeUpdater() {
        return this.renderStartTimeUpdater;
    }

    public boolean isWaitingForWorldUpdate() {
        return this.waitingForWorldUpdate;
    }

    public WorldDataHandler getWorldDataHandler() {
        return this.worldDataHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainValues() {
        Object object = this.mainStuffSync;
        synchronized (object) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                boolean worldChanging;
                WorldClient worldToChangeTo = this.ignoreWorld(player.field_70170_p) || !(player.field_70170_p instanceof WorldClient) ? this.mainWorld : (WorldClient)player.field_70170_p;
                boolean bl = worldChanging = worldToChangeTo != this.mainWorld;
                if (worldChanging) {
                    this.mainWorldChangedTime = -1L;
                    if (this.spawnToRestore != null) {
                        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(worldToChangeTo);
                        if (worldData.latestSpawn == null) {
                            this.mainWorldChangedTime = System.currentTimeMillis();
                        }
                    }
                    this.mainWorldUnloaded = false;
                }
                this.mainWorld = worldToChangeTo;
                this.mainPlayerX = player.field_70165_t;
                this.mainPlayerY = player.field_70163_u;
                this.mainPlayerZ = player.field_70161_v;
                if (worldChanging) {
                    this.checkForWorldUpdate();
                }
            } else {
                if (this.mainWorld != null && !this.mainWorldUnloaded) {
                    this.onWorldUnload();
                }
                this.mainWorld = null;
            }
        }
    }

    public void updateCaveStart(double playerX, double playerZ, World world) {
        int chunkZ;
        int chunkX;
        Chunk chunk;
        if (!this.caveStartDetermined && (chunk = world.func_72964_e(chunkX = (int)Math.floor(playerX) >> 4, chunkZ = (int)Math.floor(playerZ) >> 4)) != null && chunk.func_177410_o()) {
            if (world.func_72940_L() < 256 && (world.field_73011_w.func_186058_p() == DimensionType.NETHER || Math.abs(chunk.func_76611_b(0, 0) - world.func_72940_L()) < 16)) {
                this.caveStart = world.func_72940_L() - 1;
            }
            this.caveStartDetermined = true;
        }
    }

    public boolean caveStartIsDetermined() {
        return this.caveStartDetermined;
    }

    public int getCaveStart() {
        return this.caveStart;
    }

    public float getBrightness() {
        return this.getBrightness(WorldMap.settings.lighting);
    }

    public float getBrightness(boolean lighting) {
        if (this.world == null) {
            return 1.0f;
        }
        float sunBrightness = lighting && this.caveStart == -1 ? this.world.getSunBrightnessFactor(1.0f) : 1.0f;
        return 0.375f + 0.625f * MathHelper.func_76131_a((float)sunBrightness, (float)0.0f, (float)1.0f);
    }

    public MapBiomes getMapBiomes() {
        return this.mapBiomes;
    }

    public boolean isWorldRealms(String world) {
        return world.startsWith("Realms_");
    }

    public boolean isWorldMultiplayer(boolean realms, String world) {
        return realms || world.startsWith("Multiplayer_");
    }

    public MapWorld getMapWorld() {
        return this.mapWorld;
    }

    public boolean isCurrentMultiworldWritable() {
        return this.mapWorldUsable && this.mapWorld.getCurrentDimension().currentMultiworldWritable;
    }

    public String getCurrentDimension() {
        return "placeholder";
    }

    public void requestCurrentMapDeletion() {
        if (this.currentMapNeedsDeletion) {
            throw new RuntimeException("Requesting map deletion at a weird time!");
        }
        this.currentMapNeedsDeletion = true;
    }

    public void stop() {
        WorldMap.mapRunner.addTask(new MapRunnerTask(){

            @Override
            public void run(MapProcessor doNotUse) {
                if (MapProcessor.this.state == 0) {
                    MapProcessor.this.state = 1;
                    if (!MapProcessor.this.mapWorldUsable) {
                        MapProcessor.this.forceClean();
                    } else {
                        MapProcessor.this.changeWorld(null);
                    }
                }
            }
        });
    }

    private synchronized void forceClean() {
        this.pushRenderPause(true, true);
        this.pushWriterPause();
        if (this.mapWorld != null) {
            for (MapDimension dim : this.mapWorld.getDimensionsList()) {
                for (LeveledRegion<?> region : dim.getMapRegions().getUnsyncedList()) {
                    region.onDimensionClear(this);
                }
            }
        }
        this.popRenderPause(true, true);
        this.popWriterPause();
        this.state = 2;
        System.out.println("World map force-cleaned!");
    }

    public boolean isMapWorldUsable() {
        return this.mapWorldUsable;
    }

    private Object getAutoIdBase(WorldClient world) {
        return this.hasServerLevelId() ? WorldMapClientWorldDataHelper.getCurrentWorldData().serverLevelId : WorldMapClientWorldDataHelper.getWorldData((WorldClient)world).latestSpawn;
    }

    private Object getUsedAutoIdBase(WorldClient world) {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(world);
        return this.hasServerLevelId() ? WorldMapClientWorldDataHelper.getCurrentWorldData().usedServerLevelId : worldData.usedSpawn;
    }

    private void setUsedAutoIdBase(WorldClient world, Object autoIdBase) {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(world);
        if (this.hasServerLevelId()) {
            WorldMapClientWorldDataHelper.getCurrentWorldData().usedServerLevelId = (Integer)autoIdBase;
        } else {
            worldData.usedSpawn = (BlockPos)autoIdBase;
        }
    }

    private void removeUsedAutoIdBase(WorldClient world) {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getWorldData(world);
        if (this.hasServerLevelId()) {
            WorldMapClientWorldDataHelper.getCurrentWorldData().usedServerLevelId = null;
        } else {
            worldData.usedSpawn = null;
        }
    }

    private boolean hasServerLevelId() {
        WorldMapClientWorldData worldData = WorldMapClientWorldDataHelper.getCurrentWorldData();
        if (worldData == null) {
            return false;
        }
        return worldData.serverLevelId != null && !this.mapWorld.isIgnoreServerLevelId();
    }

    public boolean isEqual(String worldId, String dimId, String mwId) {
        return worldId.equals(this.currentWorldId) && dimId.equals(this.currentDimId) && (mwId == this.currentMWId || mwId != null && mwId.equals(this.currentMWId));
    }

    @Deprecated
    public String getCurrentWorldString() {
        return this.getCurrentWorldId();
    }
}

