/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import xaero.deallocator.ByteBufferDeallocator;
import xaero.map.CrashHandler;
import xaero.map.MapLimiter;
import xaero.map.MapProcessor;
import xaero.map.MapRunner;
import xaero.map.WorldMapClient;
import xaero.map.biome.MapBiomes;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.controls.ControlsRegister;
import xaero.map.events.Events;
import xaero.map.events.FMLEvents;
import xaero.map.file.PNGExporter;
import xaero.map.graphics.GLObjectDeleter;
import xaero.map.graphics.TextureUploadBenchmark;
import xaero.map.message.LevelMapPropertiesConsumer;
import xaero.map.misc.Internet;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointSymbolCreator;
import xaero.map.pool.MapTilePool;
import xaero.map.pool.TextureUploadPool;
import xaero.map.region.OverlayManager;
import xaero.map.region.texture.BranchTextureRenderer;
import xaero.map.server.WorldMapServer;
import xaero.map.server.core.XaeroWorldMapServerCore;
import xaero.map.server.level.LevelMapProperties;
import xaero.map.settings.ModSettings;
import xaero.map.task.MapRunnerTask;
import xaero.patreon.Patreon6;
import xaero.patreon.PatreonMod4;

@Mod(modid="xaeroworldmap", name="Xaero's World Map", version="1.13.2", guiFactory="xaero.map.gui.ConfigGuiFactory", acceptedMinecraftVersions="[1.12,1.12.2]", acceptableRemoteVersions="*")
public class WorldMap {
    @Mod.Instance(value="xaeroworldmap")
    public static WorldMap instance;
    public static int MINIMAP_COMPATIBILITY_VERSION;
    public static final String versionID = "1.12_1.13.2";
    public static int newestUpdateID;
    public static boolean isOutdated;
    public static String fileLayout;
    public static String fileLayoutID;
    public static String latestVersion;
    public static String latestVersionMD5;
    public static Events events;
    public static FMLEvents fmlEvents;
    public static ControlsRegister controlsRegister;
    public static WaypointSymbolCreator waypointSymbolCreator;
    public static ByteBufferDeallocator bufferDeallocator;
    public static TextureUploadBenchmark textureUploadBenchmark;
    public static OverlayManager overlayManager;
    public static PNGExporter pngExporter;
    public static TextureUploadPool.Normal normalTextureUploadPool;
    public static TextureUploadPool.NormalWithDownload normalWithDownloadTextureUploadPool;
    public static TextureUploadPool.Compressed compressedTextureUploadPool;
    public static TextureUploadPool.BranchUpdate branchUpdatePool;
    public static TextureUploadPool.BranchUpdate branchUpdateAllocatePool;
    public static TextureUploadPool.BranchDownload branchDownloadPool;
    public static MapTilePool tilePool;
    public static MapLimiter mapLimiter;
    public static GLObjectDeleter glObjectDeleter;
    public static MapRunner mapRunner;
    public static CrashHandler crashHandler;
    public static MapBiomes mapBiomes;
    public static BranchTextureRenderer branchTextureRenderer;
    public static final ResourceLocation guiTextures;
    public static File oldOptionsFile;
    public static File oldSaveFolder;
    public static File oldSaveFolder2;
    public static ModSettings settings;
    public static int globalVersion;
    public static WorldMapClient worldMapClient;
    public static final SimpleNetworkWrapper network;
    private WorldMapServer worldmapServer;
    public static File modJAR;
    public static File configFolder;
    public static File optionsFile;
    public static File saveFolder;

    public static PatreonMod4 getPatreon() {
        return Patreon6.mods.get(fileLayoutID);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws IOException {
        if (event.getSide() == Side.SERVER) {
            return;
        }
        String modId = this.getClass().getAnnotation(Mod.class).modid();
        worldMapClient = new WorldMapClient();
        worldMapClient.preInit(event, modId);
        if (event.getSourceFile().getName().endsWith(".jar")) {
            modJAR = event.getSourceFile();
        }
        Path gameDir = new File("./").toPath().toAbsolutePath();
        configFolder = event.getModConfigurationDirectory();
        optionsFile = configFolder.toPath().resolve("xaeroworldmap.txt").toFile();
        saveFolder = gameDir.resolve("XaeroWorldMap").toFile();
        Path oldSaveFolder3 = configFolder.toPath().getParent().resolve("XaeroWorldMap");
        if (oldOptionsFile.exists() && !optionsFile.exists()) {
            Files.move(oldOptionsFile.toPath(), optionsFile.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder.exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder.toPath(), saveFolder.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder2.exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder2.toPath(), saveFolder.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder3.toFile().exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder3, saveFolder.toPath(), new CopyOption[0]);
        }
        if (!saveFolder.exists()) {
            Files.createDirectories(saveFolder.toPath(), new FileAttribute[0]);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        PatreonMod4 patreonEntry;
        if (event.getSide() == Side.SERVER) {
            this.worldmapServer = new WorldMapServer();
            this.worldmapServer.load(event);
            XaeroWorldMapServerCore.worldmapServer = this.worldmapServer;
            return;
        }
        events = new Events();
        fmlEvents = new FMLEvents();
        MinecraftForge.EVENT_BUS.register((Object)events);
        MinecraftForge.EVENT_BUS.register((Object)fmlEvents);
        Patreon6.checkPatreon();
        Patreon6.rendersCapes = fileLayoutID;
        settings = new ModSettings();
        settings.loadSettings();
        Internet.checkModVersion();
        if (isOutdated && (patreonEntry = WorldMap.getPatreon()) != null) {
            patreonEntry.modJar = modJAR;
            patreonEntry.currentVersion = versionID;
            patreonEntry.latestVersion = latestVersion;
            patreonEntry.md5 = latestVersionMD5;
            patreonEntry.onVersionIgnore = new Runnable(){

                @Override
                public void run() {
                    ModSettings.ignoreUpdate = newestUpdateID;
                    try {
                        settings.saveSettings();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            Patreon6.addOutdatedMod(patreonEntry);
        }
        waypointSymbolCreator = new WaypointSymbolCreator();
        controlsRegister = new ControlsRegister();
        ServerWorldCapabilities.registerCapabilities();
        bufferDeallocator = new ByteBufferDeallocator();
        tilePool = new MapTilePool();
        overlayManager = new OverlayManager();
        pngExporter = new PNGExporter(configFolder.toPath().getParent().resolve("map exports"));
        mapLimiter = new MapLimiter();
        normalTextureUploadPool = new TextureUploadPool.Normal(256);
        normalWithDownloadTextureUploadPool = new TextureUploadPool.NormalWithDownload(256);
        compressedTextureUploadPool = new TextureUploadPool.Compressed(256);
        branchUpdatePool = new TextureUploadPool.BranchUpdate(256, false);
        branchUpdateAllocatePool = new TextureUploadPool.BranchUpdate(256, true);
        branchDownloadPool = new TextureUploadPool.BranchDownload(256);
        textureUploadBenchmark = new TextureUploadBenchmark(512, 512, 512, 256, 256, 256);
        glObjectDeleter = new GLObjectDeleter();
        crashHandler = new CrashHandler();
        mapBiomes = new MapBiomes();
        mapRunner = new MapRunner();
        new Thread(mapRunner).start();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide() == Side.SERVER) {
            this.worldmapServer.loadLater();
            this.worldmapServer = null;
            return;
        }
        settings.updateRegionCacheHashCode();
        network.registerMessage(LevelMapPropertiesConsumer.class, LevelMapProperties.class, 0, Side.CLIENT);
        SupportMods.load();
    }

    public static void incrementGlobalVersion() {
        mapRunner.addTask(new MapRunnerTask(){

            @Override
            public void run(MapProcessor mapProcessor) {
                ++globalVersion;
                if (SupportMods.minimap()) {
                    waypointSymbolCreator.resetChars();
                }
                if (mapProcessor != null) {
                    mapProcessor.getMapSaveLoad().updateCacheFolderList(mapProcessor.getMapSaveLoad().getMWSubFolder(mapProcessor.getCurrentWorldId(), mapProcessor.getCurrentDimId(), mapProcessor.getCurrentMWId()));
                }
                if (WorldMap.settings.debug) {
                    System.out.println("Version incremented to " + globalVersion);
                }
                try {
                    settings.saveSettings();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    static {
        MINIMAP_COMPATIBILITY_VERSION = 7;
        isOutdated = true;
        fileLayout = "XaerosWorldMap_&mod_Forge_&mc.jar";
        fileLayoutID = "worldmap";
        guiTextures = new ResourceLocation("xaeroworldmap", "gui/gui.png");
        oldOptionsFile = new File("./xaeroworldmap.txt");
        oldSaveFolder = new File("./mods/XaeroWorldMap");
        oldSaveFolder2 = new File("./config/XaeroWorldMap");
        globalVersion = 1;
        network = NetworkRegistry.INSTANCE.newSimpleChannel("xaeroworldmap:main");
        modJAR = null;
    }
}

