/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiMapName;
import xaero.map.gui.GuiMapSettingsButton;
import xaero.map.gui.IDropDownCallback;
import xaero.map.gui.KeySortableByOther;
import xaero.map.gui.YesNoCallbackImplementation;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class GuiDimensionSettings {
    private MapProcessor mapProcessor;
    private MapDimension settingsDimension;
    private String[] mwDropdownValues;
    private GuiButton settingsButton;
    private GuiButton multiworldTypeOptionButton;
    private GuiButton renameButton;
    private GuiButton deleteButton;
    private CursorBox serverSelectionModeBox = new CursorBox("gui.xaero_mw_server_box");
    private CursorBox mapSelectionBox = new CursorBox("gui.xaero_map_selection_box");
    public boolean active;
    private boolean writableOnInit;

    public GuiDimensionSettings(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    public void init(final GuiMap mapScreen, List<GuiDropDown> dropdowns, final Minecraft minecraft, int width, int height) {
        this.multiworldTypeOptionButton = null;
        MapWorld mapWorld = this.mapProcessor.getMapWorld();
        MapDimension mapDimension = this.settingsDimension = mapWorld == null || mapWorld.getCurrentDimensionId() == null ? null : mapWorld.getCurrentDimension();
        if (this.settingsDimension != null && mapWorld.isMultiplayer()) {
            this.writableOnInit = this.settingsDimension.futureMultiworldWritable;
            this.settingsButton = new GuiMapSettingsButton(this.active, 0, height - 20);
            mapScreen.addGuiButton(this.settingsButton);
            if (this.active) {
                String currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced();
                ArrayList<KeySortableByOther<String>> sortableList = new ArrayList<KeySortableByOther<String>>();
                for (String string : this.settingsDimension.getMultiworldIdsCopy()) {
                    sortableList.add(new KeySortableByOther<String>(string, new Comparable[]{this.settingsDimension.getMultiworldName(string).toLowerCase()}));
                }
                Collections.sort(sortableList);
                ArrayList<String> dropdownValuesList = new ArrayList<String>();
                for (KeySortableByOther keySortableByOther : sortableList) {
                    dropdownValuesList.add((String)keySortableByOther.getKey());
                }
                int n = this.getDropdownSelectionIdFromValue(dropdownValuesList, currentMultiworld);
                if (n == dropdownValuesList.size()) {
                    dropdownValuesList.add(currentMultiworld);
                }
                this.mwDropdownValues = dropdownValuesList.toArray(new String[0]);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String s : dropdownValuesList) {
                    arrayList.add(this.settingsDimension.getMultiworldName(s));
                }
                if (this.settingsDimension.getMapWorld().isMultiplayer()) {
                    arrayList.add("\u00a78" + I18n.func_135052_a((String)"gui.xaero_create_new_map", (Object[])new Object[0]));
                }
                GuiDropDown createdDropdown = new GuiDropDown(arrayList.toArray(new String[0]), width / 2 - 100, 30, 200, n, new IDropDownCallback(){

                    @Override
                    public boolean onSelected(GuiDropDown dd, int i) {
                        if (i < GuiDimensionSettings.this.mwDropdownValues.length) {
                            GuiDimensionSettings.this.mapProcessor.setMultiworld(GuiDimensionSettings.this.settingsDimension, GuiDimensionSettings.this.mwDropdownValues[i]);
                            GuiDimensionSettings.this.updateButtons();
                            return true;
                        }
                        minecraft.func_147108_a((GuiScreen)new GuiMapName(GuiDimensionSettings.this.mapProcessor, mapScreen, GuiDimensionSettings.this.settingsDimension, null));
                        return false;
                    }
                });
                dropdowns.add(createdDropdown);
                this.multiworldTypeOptionButton = new GuiButton(-1, 0, height - 45, 150, 20, this.getMultiworldTypeButtonMessage());
                mapScreen.addGuiButton(this.multiworldTypeOptionButton);
                this.renameButton = new GuiButton(-1, width / 2 + 109, 26, 60, 20, I18n.func_135052_a((String)"gui.xaero_rename", (Object[])new Object[0]));
                mapScreen.addGuiButton(this.renameButton);
                this.deleteButton = new GuiButton(-1, width / 2 - 168, 26, 60, 20, I18n.func_135052_a((String)"gui.xaero_delete", (Object[])new Object[0]));
                mapScreen.addGuiButton(this.deleteButton);
                this.updateButtons();
                this.multiworldTypeOptionButton.field_146124_l = this.isMapSelectionOptionEnabled();
                this.renameButton.field_146124_l = this.settingsDimension.getMapWorld().isMultiplayer();
                mapScreen.addGuiButton(new GuiButton(200, width / 2 - 50, 50, 100, 20, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])));
            }
        }
    }

    private boolean isMapSelectionOptionEnabled() {
        return !this.settingsDimension.isFutureMultiworldServerBased() && this.settingsDimension.getMapWorld().isMultiplayer();
    }

    private void updateButtons() {
        this.settingsButton.field_146124_l = this.settingsDimension != null && this.settingsDimension.futureMultiworldWritable;
        this.deleteButton.field_146124_l = this.settingsDimension.getMapWorld().isMultiplayer() && this.mwDropdownValues.length > 1 && this.settingsDimension.getFutureCustomSelectedMultiworld() != null;
    }

    private String getMultiworldTypeButtonMessage() {
        int multiworldType = this.settingsDimension.getMapWorld().getFutureMultiworldType(this.settingsDimension);
        return I18n.func_135052_a((String)"gui.xaero_map_selection", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.settingsDimension.isFutureMultiworldServerBased() ? "gui.xaero_mw_server" : (multiworldType == 0 ? "gui.xaero_mw_single" : (multiworldType == 1 ? "gui.xaero_mw_manual" : "gui.xaero_mw_spawn"))), (Object[])new Object[0]);
    }

    public void confirm(GuiMap mapScreen, Minecraft minecraft, int width, int height) {
        if (this.mapProcessor.confirmMultiworld(this.settingsDimension)) {
            this.active = false;
            mapScreen.func_146280_a(minecraft, width, height);
        }
    }

    private int getDropdownSelectionIdFromValue(List<String> values, String value) {
        int selected = 0;
        for (selected = 0; selected < values.size() && !values.get(selected).equals(value); ++selected) {
        }
        return selected;
    }

    public void preMapRender(GuiMap mapScreen, List<GuiDropDown> dropdowns, Minecraft minecraft, int width, int height) {
        String currentDropdownSelection;
        String currentMultiworld;
        MapDimension currentDim;
        MapDimension mapDimension = currentDim = !this.mapProcessor.isMapWorldUsable() ? null : this.mapProcessor.getMapWorld().getCurrentDimension();
        if (currentDim != this.settingsDimension) {
            this.active = false;
            mapScreen.func_146280_a(minecraft, width, height);
        }
        if (!this.active && this.settingsDimension != null && !this.settingsDimension.futureMultiworldWritable) {
            this.active = true;
            mapScreen.func_146280_a(minecraft, width, height);
        }
        if (this.active && this.settingsDimension != null && dropdowns.get(0).isClosed() && (!(currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced()).equals(currentDropdownSelection = this.mwDropdownValues[dropdowns.get(0).getSelected()]) || this.writableOnInit != this.settingsDimension.futureMultiworldWritable)) {
            mapScreen.func_146280_a(minecraft, width, height);
        }
    }

    public void renderText(Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
        if (!this.active) {
            return;
        }
        String selectMapString = I18n.func_135052_a((String)"gui.xaero_select_map", (Object[])new Object[0]) + ":";
        minecraft.field_71466_p.func_175063_a(selectMapString, (float)(width / 2 - minecraft.field_71466_p.func_78256_a(selectMapString) / 2), 19.0f, -1);
    }

    public void postMapRender(Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
        if (this.multiworldTypeOptionButton != null && mouseX >= this.multiworldTypeOptionButton.field_146128_h && mouseX < this.multiworldTypeOptionButton.field_146128_h + this.multiworldTypeOptionButton.func_146117_b() && mouseY >= this.multiworldTypeOptionButton.field_146129_i && mouseY < this.multiworldTypeOptionButton.field_146129_i + this.multiworldTypeOptionButton.field_146121_g) {
            CursorBox box = this.mapSelectionBox;
            if (this.settingsDimension.isFutureMultiworldServerBased()) {
                box = this.serverSelectionModeBox;
            }
            box.drawBox(this.multiworldTypeOptionButton.field_146128_h + this.multiworldTypeOptionButton.func_146117_b(), mouseY, width, height);
        }
    }

    public void actionPerformed(final GuiMap mapScreen, final Minecraft minecraft, final int width, final int height, GuiButton b) {
        if (b.field_146124_l) {
            if (b == this.settingsButton) {
                this.active = !this.active;
                mapScreen.func_146280_a(minecraft, width, height);
            } else if (b == this.multiworldTypeOptionButton) {
                if (this.isMapSelectionOptionEnabled()) {
                    this.mapProcessor.toggleMultiworldType(this.settingsDimension);
                    b.field_146126_j = this.getMultiworldTypeButtonMessage();
                }
            } else if (b == this.renameButton) {
                minecraft.func_147108_a((GuiScreen)new GuiMapName(this.mapProcessor, mapScreen, this.settingsDimension, this.settingsDimension.getFutureMultiworldUnsynced()));
            } else if (b == this.deleteButton) {
                if (this.settingsDimension.getFutureCustomSelectedMultiworld() != null) {
                    final String selectedMWId = this.settingsDimension.getFutureCustomSelectedMultiworld();
                    minecraft.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)new YesNoCallbackImplementation(){

                        @Override
                        public void func_73878_a(boolean result, int id) {
                            if (result) {
                                String mapNameAndIdLine = I18n.func_135052_a((String)"gui.xaero_delete_map_msg4", (Object[])new Object[0]) + ": " + GuiDimensionSettings.this.settingsDimension.getMultiworldName(selectedMWId) + " (" + selectedMWId + ")";
                                minecraft.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)new YesNoCallbackImplementation(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void func_73878_a(boolean result2, int id) {
                                        if (result2) {
                                            Object object = ((GuiDimensionSettings)GuiDimensionSettings.this).mapProcessor.uiSync;
                                            synchronized (object) {
                                                if (GuiDimensionSettings.this.mapProcessor.getMapWorld() == GuiDimensionSettings.this.settingsDimension.getMapWorld()) {
                                                    MapDimension currentDimension;
                                                    MapDimension mapDimension = currentDimension = !GuiDimensionSettings.this.mapProcessor.isMapWorldUsable() ? null : GuiDimensionSettings.this.mapProcessor.getMapWorld().getCurrentDimension();
                                                    if (GuiDimensionSettings.this.settingsDimension == currentDimension && GuiDimensionSettings.this.settingsDimension.getCurrentMultiworld().equals(selectedMWId)) {
                                                        if (WorldMap.settings.debug) {
                                                            System.out.println("Delayed map deletion!");
                                                        }
                                                        GuiDimensionSettings.this.mapProcessor.requestCurrentMapDeletion();
                                                    } else {
                                                        if (WorldMap.settings.debug) {
                                                            System.out.println("Instant map deletion!");
                                                        }
                                                        GuiDimensionSettings.this.settingsDimension.deleteMultiworldMapDataUnsynced(selectedMWId);
                                                    }
                                                    GuiDimensionSettings.this.settingsDimension.deleteMultiworldId(selectedMWId);
                                                    GuiDimensionSettings.this.settingsDimension.pickDefaultCustomMultiworldUnsynced();
                                                    GuiDimensionSettings.this.settingsDimension.saveConfigUnsynced();
                                                    ((GuiDimensionSettings)GuiDimensionSettings.this).settingsDimension.futureMultiworldWritable = false;
                                                    mapScreen.func_146280_a(minecraft, width, height);
                                                }
                                            }
                                        }
                                        minecraft.func_147108_a((GuiScreen)mapScreen);
                                    }
                                }, I18n.func_135052_a((String)"gui.xaero_delete_map_msg3", (Object[])new Object[0]), mapNameAndIdLine, -1));
                            } else {
                                minecraft.func_147108_a((GuiScreen)mapScreen);
                            }
                        }
                    }, I18n.func_135052_a((String)"gui.xaero_delete_map_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_delete_map_msg2", (Object[])new Object[0]), -1));
                }
            } else if (b.field_146127_k == 200) {
                this.confirm(mapScreen, minecraft, width, height);
            }
        }
    }
}

