/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.awt.Desktop;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.OpenGLException;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.gui.GuiSettings;
import xaero.map.gui.MySmallButton;
import xaero.map.gui.MyTinyButton;
import xaero.map.settings.ModOptions;

public class GuiWorldMapSettings
extends GuiSettings {
    private static final int PAGES = 2;
    public GuiButton pngButton;
    public GuiButton prevButton;
    public GuiButton nextButton;
    private int page;

    public GuiWorldMapSettings() {
        this(null);
    }

    public GuiWorldMapSettings(GuiScreen parent) {
        super(parent, WorldMap.settings);
    }

    @Override
    public void func_73866_w_() {
        this.screenTitle = "Xaero's World Map Settings";
        this.options = this.page == 0 ? new ModOptions[]{ModOptions.LIGHTING, ModOptions.COLOURS, ModOptions.LOAD, ModOptions.UPDATE, ModOptions.DEPTH, ModOptions.SLOPES, ModOptions.STEPS, ModOptions.COORDINATES, ModOptions.WAYPOINTS, ModOptions.BIOMES, ModOptions.WAYPOINT_SCALE} : new ModOptions[]{ModOptions.FLOWERS, ModOptions.DISPLAY_ZOOM, ModOptions.COMPRESSION, ModOptions.ARROW, ModOptions.IGNORE_HEIGHTMAPS, ModOptions.OPEN_ANIMATION, ModOptions.DEBUG, ModOptions.RELOAD};
        super.func_73866_w_();
        if (this.page == 0) {
            this.pngButton = new MySmallButton(201, this.field_146294_l / 2 + 5, this.field_146295_m / 7 + 120, "Export PNG");
            this.func_189646_b(this.pngButton);
            this.pngButton.field_146124_l = Minecraft.func_71410_x().field_71439_g != null;
        }
        this.nextButton = new MyTinyButton(202, this.field_146294_l / 2 + 80, this.field_146295_m / 7 + 144, I18n.func_135052_a((String)"gui.xaero_wm_next", (Object[])new Object[0]));
        this.func_189646_b(this.nextButton);
        this.nextButton.field_146124_l = this.isNextButtonEnabled();
        this.prevButton = new MyTinyButton(203, this.field_146294_l / 2 - 155, this.field_146295_m / 7 + 144, I18n.func_135052_a((String)"gui.xaero_wm_previous", (Object[])new Object[0]));
        this.func_189646_b(this.prevButton);
        this.prevButton.field_146124_l = this.isPrevButtonEnabled();
    }

    @Override
    protected void func_146284_a(GuiButton par1GuiButton) {
        super.func_146284_a(par1GuiButton);
        if (par1GuiButton.field_146127_k == 201) {
            this.pngButton.field_146124_l = false;
            try {
                WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
                MapProcessor mapProcessor = worldmapSession.getMapProcessor();
                mapProcessor.getMapSaveLoad().exportPNG();
                Desktop d = Desktop.getDesktop();
                try {
                    d.open(WorldMap.configFolder.toPath().getParent().resolve("map exports").toFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (OpenGLException e) {
                WorldMap.crashHandler.setCrashedBy(e);
            }
            this.pngButton.field_146124_l = true;
        } else if (par1GuiButton == this.prevButton) {
            this.onPrevButton();
        } else if (par1GuiButton == this.nextButton) {
            this.onNextButton();
        }
    }

    private void onPrevButton() {
        --this.page;
        if (this.page < 0) {
            this.page = 0;
        }
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }

    private void onNextButton() {
        ++this.page;
        if (this.page >= 2) {
            this.page = 1;
        }
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }

    private boolean isPrevButtonEnabled() {
        return this.page > 0;
    }

    private boolean isNextButtonEnabled() {
        return this.page < 1;
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            GuiButton b = (GuiButton)this.field_146292_n.get(k);
            if (par1 >= b.field_146128_h && par2 >= b.field_146129_i && par1 < b.field_146128_h + 150 && par2 >= b.field_146129_i + 20) continue;
        }
    }
}

