/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.settings.KeyBinding;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.mods.SupportXaeroWorldmap;
import xaero.common.settings.ModSettings;
import xaero.map.WorldMap;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportBetterPVP;
import xaero.map.mods.SupportMinimap;
import xaero.map.mods.gui.Waypoint;

public class SupportXaeroMinimap {
    IXaeroMinimap modMain;
    public int compatibilityVersion;
    private boolean deathpoints = true;
    private boolean refreshWaypoints = true;
    private WaypointWorld waypointWorld;
    private WaypointSet waypointSet;
    private boolean allSets;
    private ArrayList<Waypoint> waypoints;

    public SupportXaeroMinimap() {
        try {
            Class<?> mmClassTest = Class.forName("xaero.pvp.BetterPVP");
            this.modMain = SupportBetterPVP.getMain();
            System.out.println("Xaero's WorldMap Mod: Better PVP found!");
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> mmClassTest = Class.forName("xaero.minimap.XaeroMinimap");
                this.modMain = SupportMinimap.getMain();
                System.out.println("Xaero's WorldMap Mod: Xaero's minimap found!");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.modMain != null) {
            try {
                this.compatibilityVersion = SupportXaeroWorldmap.WORLDMAP_COMPATIBILITY_VERSION;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            if (this.compatibilityVersion < 3) {
                throw new RuntimeException("Xaero's Minimap 20.23.0 or newer required!");
            }
        }
    }

    public boolean waypointIsGood(Waypoint w) {
        return w != null && !w.isDisabled() && (w.getType() != 1 || this.deathpoints);
    }

    public ArrayList<Waypoint> convertWaypoints() {
        if (this.waypointSet == null) {
            return null;
        }
        ArrayList<Waypoint> result = new ArrayList<Waypoint>();
        if (!this.allSets) {
            this.convertSet(this.waypointSet, result);
        } else {
            HashMap sets = this.waypointWorld.getSets();
            for (WaypointSet set : sets.values()) {
                this.convertSet(set, result);
            }
        }
        this.deathpoints = this.modMain.getSettings().getDeathpoints();
        return result;
    }

    private void convertSet(WaypointSet set, ArrayList<Waypoint> result) {
        ArrayList list = set.getList();
        for (int i = 0; i < list.size(); ++i) {
            xaero.common.minimap.waypoints.Waypoint w = (xaero.common.minimap.waypoints.Waypoint)list.get(i);
            result.add(this.convertWaypoint(w, true));
        }
    }

    public Waypoint convertWaypoint(xaero.common.minimap.waypoints.Waypoint w, boolean editable) {
        Waypoint converted = new Waypoint(w, w.getX(), w.getY(), w.getZ(), w.getName(), w.getSymbol(), ModSettings.COLORS[w.getColor()], w.getType(), editable);
        converted.setDisabled(w.isDisabled());
        converted.setYaw(w.getYaw());
        converted.setRotation(w.isRotation());
        return converted;
    }

    public void openWaypoint(GuiScreen parent, Waypoint waypoint) {
        if (!waypoint.isEditable()) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), parent, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld));
    }

    public void createWaypoint(GuiScreen parent, int x, int y, int z) {
        if (this.waypointWorld == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        double dimDiv = this.compatibilityVersion < 2 ? (waypointsManager.divideBy8(this.waypointWorld.getContainer().getKey()) ? 8.0 : 1.0) : waypointsManager.getDimensionDivision(this.waypointWorld.getContainer().getKey());
        xaero.common.minimap.waypoints.Waypoint w = new xaero.common.minimap.waypoints.Waypoint(Misc.myFloor((double)x * dimDiv), y, Misc.myFloor((double)z * dimDiv), "", "", -1);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), parent, w, this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld));
    }

    public void createTempWaypoint(int x, int y, int z) {
        if (this.waypointWorld == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        waypointsManager.createTemporaryWaypoints(this.waypointWorld, x, y, z);
        this.requestWaypointsRefresh();
    }

    public boolean canTeleport() {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        return this.waypointWorld != null && waypointsManager.canTeleport(waypointsManager.isWorldTeleportable(this.waypointWorld), this.waypointWorld);
    }

    public void teleportToWaypoint(GuiScreen screen, Waypoint w) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        waypointsManager.teleportToWaypoint((xaero.common.minimap.waypoints.Waypoint)w.getOriginal(), this.waypointWorld, screen);
    }

    public void disableWaypoint(Waypoint waypoint) {
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setDisabled(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        waypoint.setDisabled(!waypoint.isDisabled());
    }

    public void deleteWaypoint(Waypoint waypoint) {
        if (!this.allSets) {
            this.waypointSet.getList().remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal());
        } else {
            WaypointSet set;
            HashMap sets = this.waypointWorld.getSets();
            Iterator iterator = sets.values().iterator();
            while (iterator.hasNext() && !(set = (WaypointSet)iterator.next()).getList().remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal())) {
            }
        }
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.waypoints.remove(waypoint);
    }

    public boolean isOnScreen(Waypoint w, double cameraX, double cameraZ, int width, int height, double scale) {
        double xOnScreen = ((double)w.getX() - cameraX) * scale + (double)(width / 2);
        double zOnScreen = ((double)w.getZ() - cameraZ) * scale + (double)(height / 2);
        return xOnScreen < (double)width && xOnScreen > 0.0 && zOnScreen < (double)height && zOnScreen > 0.0;
    }

    public void checkWaypoints(boolean multiplayer, int dimId, String multiworldId) {
        WaypointSet checkingSet;
        String containerId;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        WaypointWorldContainer container = waypointsManager.getWorldContainerNullable(containerId = waypointsManager.getAutoRootContainerID() + "/" + waypointsManager.getDimensionDirectoryName(dimId));
        WaypointWorld checkingWaypointWorld = container == null ? null : (WaypointWorld)container.worlds.get(!multiplayer ? "waypoints" : multiworldId);
        boolean shouldRefresh = this.refreshWaypoints;
        if (checkingWaypointWorld != this.waypointWorld) {
            this.waypointWorld = checkingWaypointWorld;
            shouldRefresh = true;
        }
        WaypointSet waypointSet = checkingSet = checkingWaypointWorld == null ? null : checkingWaypointWorld.getCurrentSet();
        if (checkingSet != this.waypointSet) {
            this.waypointSet = checkingSet;
            shouldRefresh = true;
        }
        if (this.allSets != this.modMain.getSettings().renderAllSets) {
            this.allSets = this.modMain.getSettings().renderAllSets;
            shouldRefresh = true;
        }
        if (shouldRefresh) {
            this.waypoints = this.convertWaypoints();
            if (this.waypoints != null) {
                Collections.sort(this.waypoints);
            }
        }
        this.refreshWaypoints = false;
    }

    public ArrayList<Waypoint> renderWaypoints(GuiScreen gui, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double scale, double mouseX, double mouseZ, Pattern regex, Pattern regexStartsWith, float brightness, ScaledResolution scaledRes) {
        if (this.waypoints == null) {
            return null;
        }
        Waypoint viewed = null;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        double wpScale = guiBasedScale * (double)WorldMap.settings.worldmapWaypointsScale / scale;
        for (int i = this.waypoints.size() - 1; i >= 0; --i) {
            Waypoint w = this.waypoints.get(i);
            if (!this.waypointIsGood(w) || !((double)w.getZ() > mouseZ) || !((double)w.getZ() - 41.0 * wpScale < mouseZ)) continue;
            double d = Math.abs((double)w.getX() - mouseX);
            float f = w.getSymbol().length() > 1 ? 20.5f : 14.0f;
            if (!(d <= (double)f * wpScale)) continue;
            viewed = w;
            break;
        }
        ArrayList<Waypoint> outsideWaypoints = new ArrayList<Waypoint>();
        for (Waypoint w : this.waypoints) {
            if (!this.waypointIsGood(w)) continue;
            if (this.isOnScreen(w, cameraX, cameraZ, width, height, scale)) {
                w.renderShadow(brightness, gui, wpScale, (float)((double)w.getX() - cameraX), (float)((double)w.getZ() - cameraZ));
                continue;
            }
            if (regex == null) {
                outsideWaypoints.add(w);
                continue;
            }
            if (regexStartsWith.matcher(w.getName().toLowerCase()).find()) {
                outsideWaypoints.add(0, w);
                continue;
            }
            if (!regex.matcher(w.getName().toLowerCase()).find()) continue;
            outsideWaypoints.add(w);
        }
        for (Waypoint w : this.waypoints) {
            if (!this.waypointIsGood(w) || w == viewed || !this.isOnScreen(w, cameraX, cameraZ, width, height, scale)) continue;
            w.renderWaypoint(gui, wpScale, (float)((double)w.getX() - cameraX), (float)((double)w.getZ() - cameraZ), false, scaledRes);
        }
        if (viewed != null) {
            viewed.renderWaypoint(gui, wpScale, (float)((double)viewed.getX() - cameraX), (float)((double)viewed.getZ() - cameraZ), true, scaledRes);
        }
        outsideWaypoints.add(0, viewed);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        return outsideWaypoints;
    }

    public void renderSideWaypoints(GuiScreen gui, ArrayList<Waypoint> sideWaypoints, double scale, int width, int height, int offset, int selected) {
        int yPos = height - 2;
        if (offset > 0) {
            yPos = this.drawThreeDots(yPos, width);
        }
        for (int i = offset; i < sideWaypoints.size(); ++i) {
            float wpScale = i == selected ? 1.5f : 1.0f;
            yPos = (int)((float)yPos - 5.0f * wpScale);
            sideWaypoints.get(i).renderSideWaypoint(gui, (float)(width - 2) - 5.0f * wpScale, yPos, wpScale);
            yPos = (int)((float)yPos - (1.0f + 4.0f * wpScale));
            if (i + 1 >= sideWaypoints.size() || i - offset != 6) continue;
            yPos = this.drawThreeDots(yPos, width);
            break;
        }
    }

    private int drawThreeDots(int yPos, int width) {
        Minecraft.func_71410_x().field_71466_p.func_175065_a("...", (float)(width - 7 - Minecraft.func_71410_x().field_71466_p.func_78256_a("...") / 2), (float)((yPos -= 9) - 4), -1, true);
        return yPos -= 5;
    }

    public void requestWaypointsRefresh() {
        this.refreshWaypoints = true;
    }

    public int getWaypointKeyCode() {
        return ModSettings.newWaypoint.func_151463_i();
    }

    public int getTempWaypointKeyCode() {
        return ModSettings.keyInstantWaypoint.func_151463_i();
    }

    public void onMapKeyPressed(int par0, int par1) {
        KeyBinding kb = null;
        if (par1 == ModSettings.keySwitchSet.func_151463_i()) {
            kb = ModSettings.keySwitchSet;
        }
        if (par1 == ModSettings.keyAllSets.func_151463_i()) {
            kb = ModSettings.keyAllSets;
        }
        if (kb != null) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getControls().keyDown(kb, false, false);
        }
    }

    public void drawSetChange(ScaledResolution resolution) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawSetChange(minimapSession.getWaypointsManager(), resolution);
    }

    public float getMinimapBrightnessOldCompatibility() {
        return this.modMain.getSupportMods().worldmapSupport.getMinimapBrightness();
    }
}

