/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.file.MapRegionInfo;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.RegionDetection;
import xaero.map.region.BranchLeveledRegion;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapTileChunk;
import xaero.map.region.texture.LeafRegionTexture;
import xaero.map.world.MapDimension;

public class MapRegion
extends LeveledRegion<LeafRegionTexture>
implements MapRegionInfo {
    public static final int SIDE_LENGTH = 8;
    private Boolean saveExists;
    private File regionFile;
    private boolean beingWritten;
    private long lastVisited;
    private byte loadState;
    private int version = -1;
    private int initialVersion;
    private int reloadVersion;
    private final boolean isMultiplayer;
    private MapTileChunk[][] chunks = new MapTileChunk[8][8];
    private boolean isRefreshing;
    public final Object writerThreadPauseSync = new Object();
    private int pauseWriting;
    public boolean loadingPrioritized;
    public int loadingNeededForBranchLevel;
    private int cacheHashCode;
    private int[] pixelResultBuffer = new int[4];
    private BlockPos.MutableBlockPos mutableGlobalPos = new BlockPos.MutableBlockPos();

    public MapRegion(String worldId, String dimId, String mwId, MapDimension dim, int x, int z, int initialVersion, boolean isMultiplayer) {
        super(worldId, dimId, mwId, dim, 0, x, z, null);
        this.initialVersion = initialVersion;
        this.isMultiplayer = isMultiplayer;
        this.lastSaveTime = System.currentTimeMillis();
    }

    public void setParent(BranchLeveledRegion parent) {
        this.parent = parent;
    }

    public void destroyBufferUpdateObjects() {
        this.pixelResultBuffer = null;
        this.mutableGlobalPos = null;
    }

    public void restoreBufferUpdateObjects() {
        this.pixelResultBuffer = new int[4];
        this.mutableGlobalPos = new BlockPos.MutableBlockPos();
    }

    public void requestRefresh(MapProcessor mapProcessor) {
        if (!this.isRefreshing) {
            this.isRefreshing = true;
            mapProcessor.addToRefresh(this);
            if (WorldMap.settings.debug) {
                System.out.println(String.format("Requesting refresh for region %s.", this));
            }
        }
    }

    public void cancelRefresh(MapProcessor mapProcessor) {
        if (this.isRefreshing) {
            this.isRefreshing = false;
            mapProcessor.removeToRefresh(this);
            if (WorldMap.settings.debug) {
                System.out.println(String.format("Canceling refresh for region %s.", this));
            }
        }
    }

    @Override
    protected int distanceFromPlayer() {
        return this.leafDistanceFromPlayer();
    }

    @Override
    protected int leafDistanceFromPlayer() {
        return super.leafDistanceFromPlayer() + (comparisonLevel == 0 ? this.loadState * 3 / 2 : 0);
    }

    public void clean(MapProcessor mapProcessor) {
        for (int i = 0; i < this.chunks.length; ++i) {
            for (int j = 0; j < this.chunks.length; ++j) {
                MapTileChunk c = this.chunks[i][j];
                if (c == null) continue;
                c.clean(mapProcessor);
                this.chunks[i][j] = null;
            }
        }
    }

    @Override
    protected void writeCacheMetaData(DataOutputStream output, byte[] usableBuffer, byte[] integerByteBuffer) throws IOException {
        output.writeInt(this.cacheHashCode);
        output.writeInt(this.reloadVersion);
        super.writeCacheMetaData(output, usableBuffer, integerByteBuffer);
    }

    @Override
    protected void readCacheMetaData(DataInputStream input, int cacheSaveVersion, byte[] usableBuffer, byte[] integerByteBuffer, MapProcessor mapProcessor) throws IOException {
        if (cacheSaveVersion >= 9) {
            int saveHashCode = input.readInt();
            this.setCacheHashCode(saveHashCode);
        }
        if (cacheSaveVersion >= 11) {
            this.reloadVersion = input.readInt();
        }
        super.readCacheMetaData(input, cacheSaveVersion, usableBuffer, integerByteBuffer, mapProcessor);
    }

    public void clearRegion(MapProcessor mapProcessor) {
        this.setRecacheHasBeenRequested(false, "clearing");
        this.cancelRefresh(mapProcessor);
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                MapTileChunk c = this.getChunk(i, j);
                if (c == null) continue;
                c.setLoadState((byte)3);
                this.setLoadState((byte)3);
                c.clean(mapProcessor);
            }
        }
        if (!mapProcessor.getMapSaveLoad().toCacheContains(this)) {
            this.deleteBuffers();
        }
        this.deleteGLBuffers();
        this.setLoadState((byte)4);
        if (WorldMap.settings.debug) {
            System.out.println("Cleared region! " + this + " " + this.getWorldId() + " " + this.getDimId() + " " + this.getMwId());
        }
    }

    public boolean isResting() {
        return this.loadState != 3 && this.loadState != 1 && !this.recacheHasBeenRequested;
    }

    @Override
    public String getWorldId() {
        return this.worldId;
    }

    @Override
    public String getDimId() {
        return this.dimId;
    }

    @Override
    public String getMwId() {
        return this.mwId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
        if (WorldMap.settings.detailed_debug) {
            System.out.println("Version set to " + version + " by for " + this);
        }
    }

    public boolean isBeingWritten() {
        return this.beingWritten;
    }

    public void setBeingWritten(boolean beingWritten) {
        this.beingWritten = beingWritten;
    }

    public byte getLoadState() {
        return this.loadState;
    }

    public void setLoadState(byte loadState) {
        this.loadState = loadState;
    }

    public MapTileChunk getChunk(int x, int z) {
        return this.chunks[x][z];
    }

    public void setChunk(int x, int z, MapTileChunk chunk) {
        this.chunks[x][z] = chunk;
    }

    public int getInitialVersion() {
        return this.initialVersion;
    }

    public void setInitialVersion(int initialVersion) {
        this.initialVersion = initialVersion;
    }

    public int[] getPixelResultBuffer() {
        return this.pixelResultBuffer;
    }

    public BlockPos.MutableBlockPos getMutableGlobalPos() {
        return this.mutableGlobalPos;
    }

    @Override
    public File getRegionFile() {
        return this.regionFile;
    }

    public void setRegionFile(File loadedFromFile) {
        this.regionFile = loadedFromFile;
    }

    public Boolean getSaveExists() {
        return this.saveExists;
    }

    public void setSaveExists(Boolean saveExists) {
        this.saveExists = saveExists;
    }

    public long getLastSaveTime() {
        return this.lastSaveTime;
    }

    public void setLastSaveTime(long lastSaveTime) {
        this.lastSaveTime = lastSaveTime;
    }

    public boolean isRefreshing() {
        return this.isRefreshing;
    }

    public void setRefreshing(boolean isRefreshing) {
        this.isRefreshing = isRefreshing;
    }

    public boolean isWritingPaused() {
        return this.pauseWriting > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushWriterPause() {
        Object object = this.writerThreadPauseSync;
        synchronized (object) {
            ++this.pauseWriting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popWriterPause() {
        Object object = this.writerThreadPauseSync;
        synchronized (object) {
            --this.pauseWriting;
        }
    }

    public boolean hasVersion() {
        return this.version != -1;
    }

    public boolean isMultiplayer() {
        return this.isMultiplayer;
    }

    public long getLastVisited() {
        return this.lastVisited;
    }

    public long getTimeSinceVisit() {
        return System.currentTimeMillis() - this.lastVisited;
    }

    public void registerVisit() {
        this.lastVisited = System.currentTimeMillis();
    }

    public int countChunks() {
        int count = 0;
        for (int i = 0; i < this.chunks.length; ++i) {
            for (int j = 0; j < this.chunks.length; ++j) {
                if (this.chunks[i][j] == null) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    protected void putLeaf(int X, int Z, MapRegion leaf) {
    }

    @Override
    public void putTexture(int x, int y, LeafRegionTexture texture) {
        throw new RuntimeException(new IllegalAccessException());
    }

    @Override
    public LeafRegionTexture getTexture(int x, int y) {
        MapTileChunk chunk = this.chunks[x][y];
        if (chunk != null) {
            return chunk.getLeafTexture();
        }
        return null;
    }

    @Override
    protected LeveledRegion<?> get(int leveledX, int leveledZ, int level) {
        if (level == 0) {
            return this;
        }
        throw new RuntimeException(new IllegalArgumentException());
    }

    @Override
    protected boolean remove(int leveledX, int leveledZ, int level) {
        throw new RuntimeException(new IllegalAccessException());
    }

    @Override
    public boolean loadingAnimation() {
        return this.loadState < 2;
    }

    @Override
    public boolean cleanAndCacheRequestsBlocked() {
        return this.isRefreshing;
    }

    @Override
    public boolean shouldBeProcessed() {
        return this.loadState > 0 && this.loadState < 4;
    }

    @Override
    public boolean isLoaded() {
        return this.loadState >= 2;
    }

    @Override
    public boolean shouldEndProcessingAfterUpload() {
        return this.loadState == 3;
    }

    @Override
    public void onProcessingEnd() {
        this.loadState = (byte)4;
        this.destroyBufferUpdateObjects();
    }

    @Override
    public void preCache() {
        this.pushWriterPause();
    }

    @Override
    public void postCache(File permFile, MapSaveLoad mapSaveLoad) throws IOException {
        this.popWriterPause();
        if (permFile != null) {
            ArrayList<Path> cacheFolders = mapSaveLoad.getCacheFolders();
            for (int i = 0; i < cacheFolders.size(); ++i) {
                Path oldCacheFolder = cacheFolders.get(i);
                Path oldCacheFile = oldCacheFolder.resolve(permFile.getName());
                Path oldPngFile = oldCacheFolder.resolve(permFile.getName().substring(0, permFile.getName().indexOf(46)) + ".png");
                Files.deleteIfExists(oldCacheFile);
                Files.deleteIfExists(oldPngFile);
                if (!oldCacheFolder.getFileName().toString().startsWith("cache_")) continue;
                Stream<Path> dirContent = Files.list(oldCacheFolder);
                if (!dirContent.iterator().hasNext()) {
                    Files.deleteIfExists(oldCacheFolder);
                    cacheFolders.remove(i--);
                }
                dirContent.close();
            }
        }
    }

    @Override
    public boolean skipCaching(MapProcessor mapProcessor) {
        return this.getVersion() != mapProcessor.getGlobalVersion();
    }

    @Override
    public File findCacheFile(MapSaveLoad mapSaveLoad) throws IOException {
        return mapSaveLoad.getCacheFile(this, false, false);
    }

    @Override
    public void onCurrentDimFinish(MapSaveLoad mapSaveLoad, MapProcessor mapProcessor) {
        if (this.getLoadState() == 2) {
            if (this.isBeingWritten()) {
                mapSaveLoad.getToSave().add(this);
            } else {
                this.clearRegion(mapProcessor);
            }
        } else {
            this.setBeingWritten(false);
            if (this.isRefreshing()) {
                throw new RuntimeException("Detected non-loadstate 2 region with refreshing value being true.");
            }
        }
    }

    @Override
    public void onLimiterRemoval(MapProcessor mapProcessor) {
        this.pushWriterPause();
        RegionDetection restoredDetection = new RegionDetection(this.getWorldId(), this.getDimId(), this.getMwId(), this.getRegionX(), this.getRegionZ(), this.getRegionFile(), mapProcessor.getGlobalVersion());
        restoredDetection.transferInfoFrom(this);
        mapProcessor.addRegionDetection(this.dim, restoredDetection);
        mapProcessor.removeMapRegion(this);
    }

    @Override
    public void afterLimiterRemoval(MapProcessor mapProcessor) {
        mapProcessor.getMapSaveLoad().removeToLoad(this);
        this.popWriterPause();
    }

    @Override
    public void addDebugLines(List<String> debugLines, MapProcessor mapProcessor, int textureX, int textureY) {
        super.addDebugLines(debugLines, mapProcessor, textureX, textureY);
        debugLines.add("paused: " + this.isWritingPaused() + " loadingNeededForBranchLevel: " + this.loadingNeededForBranchLevel);
        debugLines.add(String.format("writing: %s refreshing: %s", this.isBeingWritten(), this.isRefreshing()));
        debugLines.add("saveExists: " + this.getSaveExists());
        debugLines.add(String.format("reg loadState: %s version: %d/%d hash: %d reloadVersion: %d", this.getLoadState(), this.getVersion(), mapProcessor.getGlobalVersion(), this.getCacheHashCode(), this.getReloadVersion()));
    }

    @Override
    public String getExtraInfo() {
        return this.getLoadState() + " " + this.countChunks();
    }

    @Override
    protected LeafRegionTexture createTexture(int x, int y) {
        MapTileChunk mapTileChunk = new MapTileChunk(this, this.regionX * 8 + x, this.regionZ * 8 + y);
        this.chunks[x][y] = mapTileChunk;
        return mapTileChunk.getLeafTexture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkForUpdates(MapProcessor mapProcessor, boolean prevWaitingForBranchCache, boolean[] waitingForBranchCache, ArrayList<BranchLeveledRegion> branchRegionBuffer, int viewedLevel, int minViewedLeafX, int minViewedLeafZ, int maxViewedLeafX, int maxViewedLeafZ) {
        super.checkForUpdates(mapProcessor, prevWaitingForBranchCache, waitingForBranchCache, branchRegionBuffer, viewedLevel, minViewedLeafX, minViewedLeafZ, maxViewedLeafX, maxViewedLeafZ);
        MapRegion mapRegion = this;
        synchronized (mapRegion) {
            if (!this.isLoaded()) {
                this.loadingNeededForBranchLevel = viewedLevel;
            }
        }
    }

    public int getReloadVersion() {
        return this.reloadVersion;
    }

    public void setReloadVersion(int reloadVersion) {
        this.reloadVersion = reloadVersion;
    }

    public void setCacheHashCode(int cacheHashCode) {
        this.cacheHashCode = cacheHashCode;
    }

    public int getCacheHashCode() {
        return this.cacheHashCode;
    }

    @Override
    public void processWhenLoadedChunksExist(int globalRegionCacheHashCode) {
        super.processWhenLoadedChunksExist(globalRegionCacheHashCode);
        if (this.getCacheHashCode() != globalRegionCacheHashCode) {
            this.setVersion(Math.max(0, this.getVersion() - 1));
        }
    }

    @Override
    public void updateLeafTextureVersion(int localTextureX, int localTextureZ, int newVersion) {
        int globalTextureX = (this.regionX << 3) + localTextureX;
        int globalTextureZ = (this.regionZ << 3) + localTextureZ;
        int oldVersion = this.leafTextureVersionSum[localTextureX][localTextureZ];
        this.leafTextureVersionSum[localTextureX][localTextureZ] = newVersion;
        BranchLeveledRegion parentRegion = this.getParent();
        if (parentRegion != null) {
            parentRegion.setShouldCheckForUpdatesRecursive(true);
        }
        int diff = newVersion - oldVersion;
        while (parentRegion != null) {
            int parentLevel = parentRegion.getLevel();
            int parentTextureX = globalTextureX >> parentLevel & 7;
            int parentTextureY = globalTextureZ >> parentLevel & 7;
            int[] nArray = parentRegion.leafTextureVersionSum[parentTextureX];
            int n = parentTextureY;
            nArray[n] = nArray[n] + diff;
            parentRegion = parentRegion.getParent();
        }
    }

    @Override
    public void onDimensionClear(MapProcessor mapProcessor) {
        super.onDimensionClear(mapProcessor);
        if (this.loadState == 3) {
            this.clean(mapProcessor);
        }
    }

    public void restoreMetaData(int[][] cachedTextureVersions, int cacheHashCode, int reloadVersion, MapProcessor mapProcessor) {
        if (cachedTextureVersions != null) {
            this.setVersion(mapProcessor.getGlobalVersion());
            this.cacheHashCode = cacheHashCode;
            this.reloadVersion = reloadVersion;
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    int storedVersion;
                    this.cachedTextureVersions[i][j] = storedVersion = cachedTextureVersions[i][j];
                    this.updateLeafTextureVersion(i, j, storedVersion);
                }
            }
            this.metaLoaded = true;
        }
    }

    @Override
    public boolean shouldAffectLoadingRequestFrequency() {
        return this.loadState > 2 && super.shouldAffectLoadingRequestFrequency();
    }

    @Override
    public boolean hasRemovableSourceData() {
        return this.loadState == 2 && !this.beingWritten;
    }
}

