/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.animation.Animation;
import xaero.map.animation.SinAnimation;
import xaero.map.animation.SlowingAnimation;
import xaero.map.controls.ControlsHandler;
import xaero.map.controls.ControlsRegister;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.gui.GuiDimensionSettings;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiWorldMapSettings;
import xaero.map.gui.MapMouseButtonPress;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.region.BranchLeveledRegion;
import xaero.map.region.LeveledRegion;
import xaero.map.region.LeveledRegionManager;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.texture.RegionTexture;

public class GuiMap
extends GuiScreen {
    public static final VertexFormat POSITION_TEX_TEX_TEX = new VertexFormat();
    public static final VertexFormatElement TEX_2F_1 = new VertexFormatElement(1, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.UV, 2);
    public static final VertexFormatElement TEX_2F_2 = new VertexFormatElement(2, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.UV, 2);
    public static final VertexFormatElement TEX_2F_3 = new VertexFormatElement(3, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.UV, 2);
    private static final double ZOOM_STEP = 1.2;
    public static final int WAYPOINT_MENU_SIZE = 7;
    private static final int white = -1;
    private static final int whiteTrans = 0x28FFFFFF;
    private static final int redTrans = 687800320;
    private static final int yellowTrans = 687865600;
    private static final int purpleTrans = 687800575;
    private static final int greenTrans = 671153920;
    private static final int black = -16777216;
    private static int lastAmountOfRegionsViewed;
    private long loadingAnimationStart;
    private EntityPlayer player;
    private int screenScale = 0;
    private int mouseDownPosX = -1;
    private int mouseDownPosY = -1;
    private double mouseDownCameraX = -1.0;
    private double mouseDownCameraZ = -1.0;
    private int mouseCheckPosX = -1;
    private int mouseCheckPosY = -1;
    private long mouseCheckTimeNano = -1L;
    private int prevMouseCheckPosX = -1;
    private int prevMouseCheckPosY = -1;
    private long prevMouseCheckTimeNano = -1L;
    private double cameraX = 0.0;
    private double cameraZ = 0.0;
    private int[] cameraDestination = null;
    private SlowingAnimation cameraDestinationAnimX = null;
    private SlowingAnimation cameraDestinationAnimZ = null;
    private double scale;
    private double userScale;
    private static double destScale;
    private boolean pauseZoomKeys;
    private Waypoint viewed = null;
    private float waypointHintAlpha = 0.0f;
    private float waypointHintAlphaDest = 0.0f;
    private Animation zoomAnim;
    private SlowingAnimation waypointHintAlphaAnim = null;
    private boolean waypointMenu = false;
    private boolean shouldRenderWaypointMenu = false;
    private int waypointMenuSelected = 0;
    private int waypointMenuOffset = 0;
    private Waypoint waypointMenuSelectedObject = null;
    private Animation waypointMenuAnimation = null;
    private StringBuilder waypointMenuSearch = new StringBuilder();
    private Pattern waypointMenuSearchPattern = null;
    private Pattern waypointMenuSearchStartPattern = null;
    private static ImprovedFramebuffer primaryScaleFBO;
    private float[] colourBuffer = new float[4];
    private ArrayList<MapRegion> regionBuffer = new ArrayList();
    private ArrayList<BranchLeveledRegion> branchRegionBuffer = new ArrayList();
    private boolean prevWaitingForBranchCache = true;
    private Integer lastViewedDimensionId;
    private String lastViewedMultiworldId;
    private int mouseBlockPosX;
    private int mouseBlockPosY;
    private int mouseBlockPosZ;
    private long lastStartTime;
    private List<GuiDropDown> dropdowns;
    private GuiDimensionSettings dimensionSettings;
    private MapMouseButtonPress leftMouseButton;
    private MapMouseButtonPress rightMouseButton;
    private boolean buttonClicked;
    private MapProcessor mapProcessor;
    private ScaledResolution scaledresolution;
    private boolean[] waitingForBranchCache = new boolean[1];

    public GuiMap(MapProcessor mapProcessor, EntityPlayer player) {
        this.player = player;
        this.cameraX = (float)player.field_70165_t;
        this.cameraZ = (float)player.field_70161_v;
        this.leftMouseButton = new MapMouseButtonPress();
        this.rightMouseButton = new MapMouseButtonPress();
        this.dimensionSettings = new GuiDimensionSettings(mapProcessor);
        this.dropdowns = new ArrayList<GuiDropDown>();
        this.userScale = destScale * (double)(WorldMap.settings.openMapAnimation ? 1.5f : 1.0f);
        this.zoomAnim = new SlowingAnimation(this.userScale, destScale, 0.88, destScale * 0.001);
        this.mapProcessor = mapProcessor;
    }

    private double getScaleMultiplier(int screenShortSide) {
        return screenShortSide <= 1080 ? 1.0 : (double)screenShortSide / 1080.0;
    }

    public void addGuiButton(GuiButton b) {
        super.func_189646_b(b);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.dropdowns.clear();
        this.dimensionSettings.init(this, this.dropdowns, this.field_146297_k, this.field_146294_l, this.field_146295_m);
        this.loadingAnimationStart = System.currentTimeMillis();
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.requestWaypointsRefresh();
        }
        this.scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        this.screenScale = this.scaledresolution.func_78325_e();
        this.pauseZoomKeys = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73863_a(int scaledMouseX, int scaledMouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        long startTime = System.currentTimeMillis();
        this.dimensionSettings.preMapRender(this, this.dropdowns, mc, this.field_146294_l, this.field_146295_m);
        if (!this.waypointMenu) {
            int direction;
            long passed = this.lastStartTime == 0L ? 16L : startTime - this.lastStartTime;
            double passedScrolls = (float)passed / 64.0f;
            int n = ControlsHandler.isDown(ControlsRegister.keyZoomIn) ? 1 : (direction = ControlsHandler.isDown(ControlsRegister.keyZoomOut) ? -1 : 0);
            if (direction != 0) {
                boolean ctrlKey = GuiMap.func_146271_m();
                if (!ctrlKey || !this.pauseZoomKeys) {
                    this.changeZoom((double)direction * passedScrolls);
                    if (ctrlKey) {
                        this.pauseZoomKeys = true;
                    }
                }
            } else {
                this.pauseZoomKeys = false;
            }
        }
        this.lastStartTime = startTime;
        if (this.cameraDestination != null) {
            this.cameraDestinationAnimX = new SlowingAnimation(this.cameraX, this.cameraDestination[0], 0.9, 0.001);
            this.cameraDestinationAnimZ = new SlowingAnimation(this.cameraZ, this.cameraDestination[1], 0.9, 0.001);
            this.cameraDestination = null;
        }
        if (this.cameraDestinationAnimX != null) {
            this.cameraX = this.cameraDestinationAnimX.getCurrent();
            if (this.cameraX == this.cameraDestinationAnimX.getDestination()) {
                this.cameraDestinationAnimX = null;
            }
        }
        if (this.cameraDestinationAnimZ != null) {
            this.cameraZ = this.cameraDestinationAnimZ.getCurrent();
            if (this.cameraZ == this.cameraDestinationAnimZ.getDestination()) {
                this.cameraDestinationAnimZ = null;
            }
        }
        this.lastViewedDimensionId = null;
        this.lastViewedMultiworldId = null;
        this.mouseBlockPosY = -1;
        Iterator<GuiDropDown> iterator = this.mapProcessor.renderThreadPauseSync;
        synchronized (iterator) {
            if (!this.mapProcessor.isRenderingPaused()) {
                if (this.mapProcessor.getCurrentWorldId() != null && this.mapProcessor.getMapSaveLoad().isRegionDetectionComplete()) {
                    LeveledRegion<?> leveledRegion;
                    double secondaryOffsetY;
                    double secondaryOffsetX;
                    RegionTexture tex;
                    if (SupportMods.vivecraft) {
                        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179086_m((int)16384);
                    }
                    this.lastViewedDimensionId = this.mapProcessor.getMapWorld().getCurrentDimension().getDimId();
                    this.lastViewedMultiworldId = this.mapProcessor.getMapWorld().getCurrentDimension().getCurrentMultiworld();
                    if (SupportMods.minimap()) {
                        SupportMods.xaeroMinimap.checkWaypoints(this.mapProcessor.getMapWorld().isMultiplayer(), this.lastViewedDimensionId, this.lastViewedMultiworldId);
                    }
                    int mouseXPos = (int)Misc.getMouseX(mc);
                    int mouseYPos = (int)Misc.getMouseY(mc);
                    double scaleMultiplier = this.getScaleMultiplier(Math.min(mc.field_71443_c, mc.field_71440_d));
                    this.scale = this.userScale * scaleMultiplier;
                    if (this.mouseCheckPosX == -1 || System.nanoTime() - this.mouseCheckTimeNano > 30000000L) {
                        this.prevMouseCheckPosX = this.mouseCheckPosX;
                        this.prevMouseCheckPosY = this.mouseCheckPosY;
                        this.prevMouseCheckTimeNano = this.mouseCheckTimeNano;
                        this.mouseCheckPosX = mouseXPos;
                        this.mouseCheckPosY = mouseYPos;
                        this.mouseCheckTimeNano = System.nanoTime();
                    }
                    if (!this.leftMouseButton.isDown) {
                        if (this.mouseDownPosX != -1) {
                            this.mouseDownPosX = -1;
                            this.mouseDownPosY = -1;
                            if (this.prevMouseCheckTimeNano != -1L) {
                                double speed_z;
                                double frameTime60FPS;
                                double downTime = 0.0;
                                int draggedX = 0;
                                int draggedY = 0;
                                draggedX = mouseXPos - this.prevMouseCheckPosX;
                                downTime = System.nanoTime() - this.prevMouseCheckTimeNano;
                                double speedScale = downTime / (frameTime60FPS = 1.6666666666666666E7);
                                double speed_x = (double)(-draggedX) / this.scale / speedScale;
                                double speed = Math.sqrt(speed_x * speed_x + (speed_z = (double)(-(draggedY = mouseYPos - this.prevMouseCheckPosY)) / this.scale / speedScale) * speed_z);
                                if (speed > 0.0) {
                                    double cos = speed_x / speed;
                                    double sin = speed_z / speed;
                                    double maxSpeed = 500.0 / this.userScale;
                                    speed = Math.abs(speed) > maxSpeed ? Math.copySign(maxSpeed, speed) : speed;
                                    double speed_factor = 0.9;
                                    double ln = Math.log(speed_factor);
                                    double move_distance = -speed / ln;
                                    double moveX = cos * move_distance;
                                    double moveZ = sin * move_distance;
                                    this.cameraDestinationAnimX = new SlowingAnimation(this.cameraX, this.cameraX + moveX, 0.9, 0.001);
                                    this.cameraDestinationAnimZ = new SlowingAnimation(this.cameraZ, this.cameraZ + moveZ, 0.9, 0.001);
                                }
                            }
                        }
                    } else if (this.mouseDownPosX != -1) {
                        this.cameraX = (double)(this.mouseDownPosX - mouseXPos) / this.scale + this.mouseDownCameraX;
                        this.cameraZ = (double)(this.mouseDownPosY - mouseYPos) / this.scale + this.mouseDownCameraZ;
                    } else {
                        this.mouseDownPosX = mouseXPos;
                        this.mouseDownPosY = mouseYPos;
                        this.mouseDownCameraX = this.cameraX;
                        this.mouseDownCameraZ = this.cameraZ;
                        this.cameraDestinationAnimX = null;
                        this.cameraDestinationAnimZ = null;
                    }
                    int mouseFromCentreX = mouseXPos - mc.field_71443_c / 2;
                    int mouseFromCentreY = mouseYPos - mc.field_71440_d / 2;
                    double oldMousePosX = (double)mouseFromCentreX / this.scale + this.cameraX;
                    double oldMousePosZ = (double)mouseFromCentreY / this.scale + this.cameraZ;
                    double preScale = this.scale;
                    if (destScale != this.userScale) {
                        if (this.zoomAnim != null) {
                            this.userScale = this.zoomAnim.getCurrent();
                            this.scale = this.userScale * scaleMultiplier;
                        }
                        if (this.zoomAnim == null || Misc.round(this.zoomAnim.getDestination(), 4) != Misc.round(destScale, 4)) {
                            this.zoomAnim = new SinAnimation(this.userScale, destScale, 100L);
                        }
                    }
                    if (this.scale > preScale) {
                        this.cameraX = oldMousePosX - (double)mouseFromCentreX / this.scale;
                        this.cameraZ = oldMousePosZ - (double)mouseFromCentreY / this.scale;
                    }
                    int textureLevel = 0;
                    double fboScale = this.scale >= 1.0 ? Math.max(1.0, Math.floor(this.scale)) : this.scale;
                    if (this.userScale < 1.0) {
                        double reversedScale = 1.0 / this.userScale;
                        double log2 = Math.floor(Math.log(reversedScale) / Math.log(2.0));
                        textureLevel = Math.min((int)log2, 3);
                    }
                    this.mapProcessor.getMapSaveLoad().mainTextureLevel = textureLevel;
                    int leveledRegionShift = 9 + textureLevel;
                    double secondaryScale = this.scale / fboScale;
                    GlStateManager.func_179094_E();
                    double mousePosX = (double)mouseFromCentreX / this.scale + this.cameraX;
                    double mousePosZ = (double)mouseFromCentreY / this.scale + this.cameraZ;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                    if (WorldMap.settings.displayZoom) {
                        this.func_73731_b(mc.field_71466_p, (double)Math.round(destScale * 100.0) / 100.0 + "x", 2, 2, -1);
                    }
                    this.mouseBlockPosX = (int)Math.floor(mousePosX);
                    this.mouseBlockPosZ = (int)Math.floor(mousePosZ);
                    int mouseRegX = this.mouseBlockPosX >> leveledRegionShift;
                    int mouseRegZ = this.mouseBlockPosZ >> leveledRegionShift;
                    LeveledRegion<?> reg = this.mapProcessor.getLeveledRegion(mouseRegX, mouseRegZ, textureLevel);
                    int maxRegBlockCoord = (1 << leveledRegionShift) - 1;
                    int mouseRegPixelX = (this.mouseBlockPosX & maxRegBlockCoord) >> textureLevel;
                    int mouseRegPixelZ = (this.mouseBlockPosZ & maxRegBlockCoord) >> textureLevel;
                    this.mouseBlockPosX = (mouseRegX << leveledRegionShift) + (mouseRegPixelX << textureLevel);
                    this.mouseBlockPosZ = (mouseRegZ << leveledRegionShift) + (mouseRegPixelZ << textureLevel);
                    MapRegion leafRegion = this.mapProcessor.getMapRegion(this.mouseBlockPosX >> 9, this.mouseBlockPosZ >> 9, false);
                    MapTileChunk chunk = leafRegion == null ? null : leafRegion.getChunk(this.mouseBlockPosX >> 6 & 7, this.mouseBlockPosZ >> 6 & 7);
                    int debugTextureX = this.mouseBlockPosX >> leveledRegionShift - 3 & 7;
                    int debugTextureY = this.mouseBlockPosZ >> leveledRegionShift - 3 & 7;
                    RegionTexture regionTexture = tex = reg != null && reg.hasTextures() ? (RegionTexture)reg.getTexture(debugTextureX, debugTextureY) : null;
                    if (WorldMap.settings.debug) {
                        if (reg != null) {
                            ArrayList<String> debugLines = new ArrayList<String>();
                            if (tex != null) {
                                MapBlock block;
                                MapTile mouseTile;
                                tex.addDebugLines(debugLines);
                                MapTile mapTile = mouseTile = chunk == null ? null : chunk.getTile(this.mouseBlockPosX >> 4 & 3, this.mouseBlockPosZ >> 4 & 3);
                                if (mouseTile != null && (block = mouseTile.getBlock(this.mouseBlockPosX & 0xF, this.mouseBlockPosZ & 0xF)) != null) {
                                    this.func_73732_a(mc.field_71466_p, block.toString(), this.field_146294_l / 2, 12, -1);
                                    if (block.getNumberOfOverlays() != 0) {
                                        for (int i = 0; i < block.getOverlays().size(); ++i) {
                                            this.func_73732_a(mc.field_71466_p, block.getOverlays().get(i).toString(), this.field_146294_l / 2, 22 + i * 10, -1);
                                        }
                                    }
                                }
                            }
                            debugLines.add("");
                            debugLines.add(mouseRegX + " " + mouseRegZ + " " + textureLevel);
                            reg.addDebugLines(debugLines, this.mapProcessor, debugTextureX, debugTextureY);
                            for (int i = 0; i < debugLines.size(); ++i) {
                                this.func_73731_b(mc.field_71466_p, (String)debugLines.get(i), 5, 15 + 10 * i, -1);
                            }
                        }
                        if (this.mapProcessor.getMapWorld().isMultiplayer()) {
                            this.func_73731_b(mc.field_71466_p, "MultiWorld ID: " + this.mapProcessor.getMapWorld().getCurrentMultiworld(), 5, 255, -1);
                        }
                        LeveledRegionManager regions = this.mapProcessor.getMapWorld().getCurrentDimension().getMapRegions();
                        this.func_73731_b(mc.field_71466_p, String.format("regions: %d loaded: %d processed: %d viewed: %d benchmarks %s", regions.size(), regions.loadedCount(), this.mapProcessor.getProcessedCount(), lastAmountOfRegionsViewed, WorldMap.textureUploadBenchmark.getTotalsString()), 5, 265, -1);
                        this.func_73731_b(mc.field_71466_p, String.format("toLoad: %d toSave: %d tile pool: %d overlays: %d toLoadBranchCache: %d ", this.mapProcessor.getMapSaveLoad().getSizeOfToLoad(), this.mapProcessor.getMapSaveLoad().getToSave().size(), this.mapProcessor.getTilePool().size(), this.mapProcessor.getOverlayManager().getNumberOfUniqueOverlays(), this.mapProcessor.getMapSaveLoad().getSizeOfToLoadBranchCache()), 5, 275, -1);
                        long i = Runtime.getRuntime().maxMemory();
                        long j = Runtime.getRuntime().totalMemory();
                        long k = Runtime.getRuntime().freeMemory();
                        long l = j - k;
                        this.func_73731_b(mc.field_71466_p, String.format("FPS: %d", Minecraft.func_175610_ah()), 5, 295, -1);
                        this.func_73731_b(mc.field_71466_p, String.format("Mem: % 2d%% %03d/%03dMB", l * 100L / i, GuiMap.bytesToMb(l), GuiMap.bytesToMb(i)), 5, 305, -1);
                        this.func_73731_b(mc.field_71466_p, String.format("Allocated: % 2d%% %03dMB", j * 100L / i, GuiMap.bytesToMb(j)), 5, 315, -1);
                        this.func_73731_b(mc.field_71466_p, String.format("Available VRAM: %dMB", this.mapProcessor.getMapLimiter().getAvailableVRAM() / 1024), 5, 325, -1);
                    }
                    if (tex != null) {
                        this.mouseBlockPosY = tex.getHeight(mouseRegPixelX & 0x3F, mouseRegPixelZ & 0x3F);
                    }
                    if (WorldMap.settings.coordinates) {
                        String coordsString = "X: " + this.mouseBlockPosX;
                        if (this.mouseBlockPosY != -1) {
                            coordsString = coordsString + " Y: " + this.mouseBlockPosY;
                        }
                        coordsString = coordsString + " Z: " + this.mouseBlockPosZ;
                        this.func_73732_a(mc.field_71466_p, coordsString, this.field_146294_l / 2, 2, -1);
                    }
                    GlStateManager.func_179121_F();
                    if (primaryScaleFBO == null || GuiMap.primaryScaleFBO.field_147621_c != mc.field_71443_c || GuiMap.primaryScaleFBO.field_147618_d != mc.field_71440_d) {
                        if (!Minecraft.func_71410_x().field_71474_y.field_151448_g) {
                            Minecraft.func_71410_x().field_71474_y.func_74306_a(GameSettings.Options.FBO_ENABLE, 0);
                            System.out.println("FBO is off. Turning it on.");
                        }
                        primaryScaleFBO = new ImprovedFramebuffer(mc.field_71443_c, mc.field_71440_d, false);
                    }
                    if (GuiMap.primaryScaleFBO.field_147616_f == -1) {
                        GlStateManager.func_179121_F();
                        return;
                    }
                    primaryScaleFBO.func_147610_a(false);
                    GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179086_m((int)16384);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179152_a((float)(1.0f / (float)this.screenScale), (float)(1.0f / (float)this.screenScale), (float)1.0f);
                    GlStateManager.func_179109_b((float)(mc.field_71443_c / 2), (float)(mc.field_71440_d / 2), (float)0.0f);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179129_p();
                    int flooredCameraX = (int)Math.floor(this.cameraX);
                    int flooredCameraZ = (int)Math.floor(this.cameraZ);
                    double primaryOffsetX = 0.0;
                    double primaryOffsetY = 0.0;
                    if (fboScale < 1.0) {
                        double pixelInBlocks = 1.0 / fboScale;
                        int xInFullPixels = (int)Math.floor(this.cameraX / pixelInBlocks);
                        int zInFullPixels = (int)Math.floor(this.cameraZ / pixelInBlocks);
                        double fboOffsetX = (double)xInFullPixels * pixelInBlocks;
                        double fboOffsetZ = (double)zInFullPixels * pixelInBlocks;
                        flooredCameraX = (int)Math.floor(fboOffsetX);
                        flooredCameraZ = (int)Math.floor(fboOffsetZ);
                        primaryOffsetX = fboOffsetX - (double)flooredCameraX;
                        primaryOffsetY = fboOffsetZ - (double)flooredCameraZ;
                        secondaryOffsetX = (this.cameraX - fboOffsetX) * fboScale;
                        secondaryOffsetY = (this.cameraZ - fboOffsetZ) * fboScale;
                    } else {
                        int offset;
                        secondaryOffsetX = (this.cameraX - (double)flooredCameraX) * fboScale;
                        secondaryOffsetY = (this.cameraZ - (double)flooredCameraZ) * fboScale;
                        if (secondaryOffsetX >= 1.0) {
                            offset = (int)secondaryOffsetX;
                            GlStateManager.func_179109_b((float)(-offset), (float)0.0f, (float)0.0f);
                            secondaryOffsetX -= (double)offset;
                        }
                        if (secondaryOffsetY >= 1.0) {
                            offset = (int)secondaryOffsetY;
                            GlStateManager.func_179109_b((float)0.0f, (float)offset, (float)0.0f);
                            secondaryOffsetY -= (double)offset;
                        }
                    }
                    GlStateManager.func_179139_a((double)fboScale, (double)(-fboScale), (double)1.0);
                    GlStateManager.func_179137_b((double)(-primaryOffsetX), (double)(-primaryOffsetY), (double)0.0);
                    GlStateManager.func_179098_w();
                    double leftBorder = this.cameraX - (double)(mc.field_71443_c / 2) / this.scale;
                    double rightBorder = leftBorder + (double)mc.field_71443_c / this.scale;
                    double topBorder = this.cameraZ - (double)(mc.field_71440_d / 2) / this.scale;
                    double bottomBorder = topBorder + (double)mc.field_71440_d / this.scale;
                    int minRegX = (int)leftBorder >> leveledRegionShift;
                    int maxRegX = (int)rightBorder >> leveledRegionShift;
                    int minRegZ = (int)topBorder >> leveledRegionShift;
                    int maxRegZ = (int)bottomBorder >> leveledRegionShift;
                    int minLeafRegX = (int)leftBorder >> 9;
                    int maxLeafRegX = (int)rightBorder >> 9;
                    int minLeafRegZ = (int)topBorder >> 9;
                    int maxLeafRegZ = (int)bottomBorder >> 9;
                    lastAmountOfRegionsViewed = (maxRegX - minRegX + 1) * (maxRegZ - minRegZ + 1);
                    if (this.mapProcessor.getMapLimiter().getMostRegionsAtATime() < lastAmountOfRegionsViewed) {
                        this.mapProcessor.getMapLimiter().setMostRegionsAtATime(lastAmountOfRegionsViewed);
                    }
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179118_c();
                    this.regionBuffer.clear();
                    this.branchRegionBuffer.clear();
                    float brightness = this.mapProcessor.getBrightness();
                    int globalRegionCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                    boolean reloadEverything = WorldMap.settings.reloadEverything;
                    int globalReloadVersion = WorldMap.settings.reloadVersion;
                    this.waitingForBranchCache[0] = false;
                    GuiMap.setupTextureMatricesAndTextures(brightness);
                    LeveledRegion.setComparison(this.mouseBlockPosX >> leveledRegionShift, this.mouseBlockPosZ >> leveledRegionShift, textureLevel, this.mouseBlockPosX >> 9, this.mouseBlockPosZ >> 9);
                    for (int leveledRegX = minRegX; leveledRegX <= maxRegX; ++leveledRegX) {
                        for (int leveledRegZ = minRegZ; leveledRegZ <= maxRegZ; ++leveledRegZ) {
                            boolean rootHasTextures;
                            int leveledSideInRegions = 1 << textureLevel;
                            int leveledSideInBlocks = leveledSideInRegions * 512;
                            int leafRegionMinX = leveledRegX * leveledSideInRegions;
                            int leafRegionMinZ = leveledRegZ * leveledSideInRegions;
                            leveledRegion = null;
                            for (int leafX = 0; leafX < leveledSideInRegions; ++leafX) {
                                for (int leafZ = 0; leafZ < leveledSideInRegions; ++leafZ) {
                                    int regZ;
                                    int regX = leafRegionMinX + leafX;
                                    if (regX < minLeafRegX || regX > maxLeafRegX || (regZ = leafRegionMinZ + leafZ) < minLeafRegZ || regZ > maxLeafRegZ) continue;
                                    MapRegion region = this.mapProcessor.getMapRegion(regX, regZ, false);
                                    if (region == null) {
                                        region = this.mapProcessor.getMapRegion(regX, regZ, this.mapProcessor.regionExists(regX, regZ));
                                    }
                                    if (region == null) continue;
                                    if (leveledRegion == null) {
                                        leveledRegion = this.mapProcessor.getLeveledRegion(leveledRegX, leveledRegZ, textureLevel);
                                    }
                                    if (this.prevWaitingForBranchCache) continue;
                                    MapRegion mapRegion = region;
                                    synchronized (mapRegion) {
                                        if (textureLevel != 0 && region.getLoadState() == 0 && region.loadingNeededForBranchLevel != 0 && region.loadingNeededForBranchLevel != textureLevel) {
                                            region.loadingNeededForBranchLevel = 0;
                                            region.getParent().setShouldCheckForUpdatesRecursive(true);
                                        }
                                        if (!region.recacheHasBeenRequested() && !region.reloadHasBeenRequested() && (region.getLoadState() == 4 || region.getLoadState() == 2 && region.isBeingWritten() || region.getLoadState() == 0) && (reloadEverything && region.getReloadVersion() != globalReloadVersion || region.getCacheHashCode() != globalRegionCacheHashCode || region.getVersion() != this.mapProcessor.getGlobalVersion() || region.getLoadState() != 2 && region.shouldCache() || region.getLoadState() == 0 && (textureLevel == 0 || region.loadingNeededForBranchLevel == textureLevel))) {
                                            if (region.getLoadState() == 2) {
                                                region.requestRefresh(this.mapProcessor);
                                            } else {
                                                region.calculateSortingDistance();
                                                Misc.addToListOfSmallest(10, this.regionBuffer, region);
                                            }
                                        }
                                        continue;
                                    }
                                }
                            }
                            if (leveledRegion == null) continue;
                            LeveledRegion<?> rootLeveledRegion = leveledRegion.getRootRegion();
                            if (rootLeveledRegion == leveledRegion) {
                                rootLeveledRegion = null;
                            }
                            if (rootLeveledRegion != null && !rootLeveledRegion.isLoaded()) {
                                if (!rootLeveledRegion.recacheHasBeenRequested() && !rootLeveledRegion.reloadHasBeenRequested()) {
                                    rootLeveledRegion.calculateSortingDistance();
                                    Misc.addToListOfSmallest(10, this.branchRegionBuffer, (BranchLeveledRegion)rootLeveledRegion);
                                }
                                this.waitingForBranchCache[0] = true;
                                rootLeveledRegion = null;
                            }
                            if (!this.mapProcessor.isUploadingPaused() && !WorldMap.settings.pauseRequests) {
                                if (leveledRegion instanceof BranchLeveledRegion) {
                                    BranchLeveledRegion branchRegion = (BranchLeveledRegion)leveledRegion;
                                    branchRegion.checkForUpdates(this.mapProcessor, this.prevWaitingForBranchCache, this.waitingForBranchCache, this.branchRegionBuffer, textureLevel, leafRegionMinX, leafRegionMinZ, maxLeafRegX, maxLeafRegZ);
                                }
                                this.mapProcessor.getMapWorld().getCurrentDimension().getMapRegions().bumpLoadedRegion(leveledRegion);
                                if (rootLeveledRegion != null) {
                                    this.mapProcessor.getMapWorld().getCurrentDimension().getMapRegions().bumpLoadedRegion(rootLeveledRegion);
                                }
                            } else {
                                this.waitingForBranchCache[0] = this.prevWaitingForBranchCache;
                            }
                            int minXBlocks = leveledRegX * leveledSideInBlocks;
                            int minZBlocks = leveledRegZ * leveledSideInBlocks;
                            int textureSize = 64 * leveledSideInRegions;
                            int firstTextureX = leveledRegX << 3;
                            int firstTextureZ = leveledRegZ << 3;
                            int levelDiff = 3 - textureLevel;
                            int rootSize = 1 << levelDiff;
                            int maxInsideCoord = rootSize - 1;
                            int firstRootTextureX = firstTextureX >> levelDiff & 7;
                            int firstRootTextureZ = firstTextureZ >> levelDiff & 7;
                            int firstInsideTextureX = firstTextureX & maxInsideCoord;
                            int firstInsideTextureZ = firstTextureZ & maxInsideCoord;
                            boolean hasTextures = leveledRegion.hasTextures();
                            boolean bl = rootHasTextures = rootLeveledRegion != null && rootLeveledRegion.hasTextures();
                            if (hasTextures || rootHasTextures) {
                                for (int o = 0; o < 8; ++o) {
                                    int textureX = minXBlocks + o * textureSize;
                                    if ((double)textureX > rightBorder || (double)(textureX + textureSize) < leftBorder) continue;
                                    for (int p = 0; p < 8; ++p) {
                                        RegionTexture<Object> regionTexture2;
                                        int textureZ = minZBlocks + p * textureSize;
                                        if ((double)textureZ > bottomBorder || (double)(textureZ + textureSize) < topBorder) continue;
                                        RegionTexture regionTexture3 = regionTexture2 = hasTextures ? (RegionTexture)leveledRegion.getTexture(o, p) : null;
                                        if (regionTexture2 == null || regionTexture2.getGlColorTexture() == -1) {
                                            int insideZ;
                                            int rootTextureZ;
                                            int insideX;
                                            int rootTextureX;
                                            if (!rootHasTextures || (regionTexture2 = rootLeveledRegion.getTexture(rootTextureX = firstRootTextureX + ((insideX = firstInsideTextureX + o) >> levelDiff), rootTextureZ = firstRootTextureZ + ((insideZ = firstInsideTextureZ + p) >> levelDiff))) == null || regionTexture2.getGlColorTexture() == -1) continue;
                                            int insideTextureX = insideX & maxInsideCoord;
                                            int insideTextureZ = insideZ & maxInsideCoord;
                                            float textureX1 = (float)insideTextureX / (float)rootSize;
                                            float textureX2 = (float)(insideTextureX + 1) / (float)rootSize;
                                            float textureY1 = (float)insideTextureZ / (float)rootSize;
                                            float textureY2 = (float)(insideTextureZ + 1) / (float)rootSize;
                                            GuiMap.bindMapTextureWithLighting3(regionTexture2, 9728, 0);
                                            GuiMap.renderTexturedModalSubRectWithLighting(textureX - flooredCameraX, textureZ - flooredCameraZ, textureX1, textureY1, textureX2, textureY2, textureSize, textureSize);
                                            continue;
                                        }
                                        GuiMap.bindMapTextureWithLighting3(regionTexture2, 9728, 0);
                                        GuiMap.renderTexturedModalRectWithLighting(textureX - flooredCameraX, textureZ - flooredCameraZ, textureSize, textureSize);
                                    }
                                }
                            }
                            if (leveledRegion.loadingAnimation()) {
                                GlStateManager.func_179094_E();
                                GlStateManager.func_179137_b((double)((double)leveledSideInBlocks * ((double)leveledRegX + 0.5) - (double)flooredCameraX), (double)((double)leveledSideInBlocks * ((double)leveledRegZ + 0.5) - (double)flooredCameraZ), (double)0.0);
                                float loadingAnimationPassed = System.currentTimeMillis() - this.loadingAnimationStart;
                                if (loadingAnimationPassed > 0.0f) {
                                    GuiMap.restoreTextureStates();
                                    int period = 2000;
                                    int numbersOfActors = 3;
                                    float loadingAnimation = loadingAnimationPassed % (float)period / (float)period * 360.0f;
                                    float step = 360.0f / (float)numbersOfActors;
                                    GlStateManager.func_179114_b((float)loadingAnimation, (float)0.0f, (float)0.0f, (float)1.0f);
                                    int numberOfVisibleActors = 1 + (int)loadingAnimationPassed % (3 * period) / period;
                                    GlStateManager.func_179152_a((float)leveledSideInRegions, (float)leveledSideInRegions, (float)1.0f);
                                    for (int i = 0; i < numberOfVisibleActors; ++i) {
                                        GlStateManager.func_179114_b((float)step, (float)0.0f, (float)0.0f, (float)1.0f);
                                        GuiMap.func_73734_a((int)16, (int)-8, (int)32, (int)8, (int)-1);
                                    }
                                    GlStateManager.func_179084_k();
                                    GuiMap.setupTextureMatricesAndTextures(brightness);
                                }
                                GlStateManager.func_179121_F();
                            }
                            if (WorldMap.settings.debug && leveledRegion instanceof MapRegion) {
                                MapRegion region = (MapRegion)leveledRegion;
                                GuiMap.restoreTextureStates();
                                GlStateManager.func_179094_E();
                                GlStateManager.func_179109_b((float)(512 * region.getRegionX() + 32 - flooredCameraX), (float)(512 * region.getRegionZ() + 32 - flooredCameraZ), (float)0.0f);
                                GlStateManager.func_179152_a((float)10.0f, (float)10.0f, (float)1.0f);
                                this.func_73731_b(mc.field_71466_p, "" + region.getLoadState(), 0, 0, -1);
                                GlStateManager.func_179121_F();
                                GlStateManager.func_179084_k();
                                GuiMap.setupTextureMatricesAndTextures(brightness);
                            }
                            if (!WorldMap.settings.debug || textureLevel <= 0) continue;
                            GuiMap.restoreTextureStates();
                            for (int leafX = 0; leafX < leveledSideInRegions; ++leafX) {
                                for (int leafZ = 0; leafZ < leveledSideInRegions; ++leafZ) {
                                    boolean currentlyLoading;
                                    int regX = leafRegionMinX + leafX;
                                    int regZ = leafRegionMinZ + leafZ;
                                    MapRegion region = this.mapProcessor.getMapRegion(regX, regZ, false);
                                    if (region == null) continue;
                                    boolean bl2 = currentlyLoading = this.mapProcessor.getMapSaveLoad().getNextToLoadByViewing() == region;
                                    if (!currentlyLoading && !region.isLoaded() && !region.isMetaLoaded()) continue;
                                    GlStateManager.func_179094_E();
                                    GlStateManager.func_179109_b((float)(512 * region.getRegionX() - flooredCameraX), (float)(512 * region.getRegionZ() - flooredCameraZ), (float)0.0f);
                                    GuiMap.func_73734_a((int)0, (int)0, (int)512, (int)512, (int)(currentlyLoading ? 687800575 : (region.isLoaded() ? 671153920 : 687865600)));
                                    GlStateManager.func_179121_F();
                                }
                            }
                            GlStateManager.func_179084_k();
                            GuiMap.setupTextureMatricesAndTextures(brightness);
                        }
                    }
                    GuiMap.restoreTextureStates();
                    LeveledRegion<?> nextToLoad = this.mapProcessor.getMapSaveLoad().getNextToLoadByViewing();
                    boolean shouldRequest = false;
                    if (nextToLoad != null) {
                        LeveledRegion<?> leveledSideInRegions = nextToLoad;
                        synchronized (leveledSideInRegions) {
                            if (!nextToLoad.reloadHasBeenRequested() && !nextToLoad.hasRemovableSourceData()) {
                                shouldRequest = true;
                            }
                        }
                    } else {
                        shouldRequest = true;
                    }
                    boolean bl = shouldRequest = shouldRequest && this.mapProcessor.getAffectingLoadingFrequencyCount() < 16;
                    if (shouldRequest && !WorldMap.settings.pauseRequests) {
                        int i;
                        int toRequest = 2;
                        int counter = 0;
                        for (i = 0; i < this.branchRegionBuffer.size() && counter < toRequest; ++i) {
                            BranchLeveledRegion region = this.branchRegionBuffer.get(i);
                            if (region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region.isLoaded()) continue;
                            region.setReloadHasBeenRequested(true, "Gui");
                            this.mapProcessor.getMapSaveLoad().requestBranchCache(region, "Gui");
                            if (counter == 0) {
                                this.mapProcessor.getMapSaveLoad().setNextToLoadByViewing(region);
                            }
                            ++counter;
                        }
                        toRequest = 1;
                        counter = 0;
                        if (!this.prevWaitingForBranchCache) {
                            for (i = 0; i < this.regionBuffer.size() && counter < toRequest; ++i) {
                                MapRegion region = this.regionBuffer.get(i);
                                if (region == nextToLoad && this.regionBuffer.size() > 1) continue;
                                leveledRegion = region;
                                synchronized (leveledRegion) {
                                    if (region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region.getLoadState() != 0 && region.getLoadState() != 4) {
                                        continue;
                                    }
                                    this.mapProcessor.getMapSaveLoad().requestLoad(region, "Gui");
                                    if (counter == 0) {
                                        this.mapProcessor.getMapSaveLoad().setNextToLoadByViewing(region);
                                    }
                                    ++counter;
                                    if (region.getLoadState() == 4) {
                                        break;
                                    }
                                    continue;
                                }
                            }
                        }
                    }
                    this.prevWaitingForBranchCache = this.waitingForBranchCache[0];
                    GuiMap.func_73734_a((int)((this.mouseBlockPosX >> 4) * 16 - flooredCameraX), (int)((this.mouseBlockPosZ >> 4) * 16 - flooredCameraZ), (int)(((this.mouseBlockPosX >> 4) + 1) * 16 - flooredCameraX), (int)(((this.mouseBlockPosZ >> 4) + 1) * 16 - flooredCameraZ), (int)0x28FFFFFF);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179118_c();
                    primaryScaleFBO.func_147609_e();
                    Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
                    GlStateManager.func_179089_o();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)secondaryScale, (double)secondaryScale, (double)1.0);
                    primaryScaleFBO.func_147612_c();
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                    int lineX = -mc.field_71443_c / 2;
                    int lineY = mc.field_71440_d / 2 - 5;
                    int lineW = mc.field_71443_c;
                    int lineH = 6;
                    GuiMap.func_73734_a((int)lineX, (int)lineY, (int)(lineX + lineW), (int)(lineY + lineH), (int)-16777216);
                    lineX = mc.field_71443_c / 2 - 5;
                    lineY = -mc.field_71440_d / 2;
                    lineW = 6;
                    lineH = mc.field_71440_d;
                    GuiMap.func_73734_a((int)lineX, (int)lineY, (int)(lineX + lineW), (int)(lineY + lineH), (int)-16777216);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179126_j();
                    if (SupportMods.vivecraft) {
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179120_a((int)1, (int)0, (int)0, (int)1);
                    }
                    GuiMap.renderTexturedModalRect((float)(-mc.field_71443_c / 2) - (float)secondaryOffsetX, (float)(-mc.field_71440_d / 2) - (float)secondaryOffsetY, mc.field_71443_c, mc.field_71440_d);
                    if (SupportMods.vivecraft) {
                        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                    }
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179139_a((double)this.scale, (double)this.scale, (double)1.0);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179141_d();
                    double minGuiScale = 4.0;
                    float guiBasedScale = 1.0f;
                    if ((double)this.screenScale > minGuiScale) {
                        guiBasedScale = (float)((double)this.screenScale / minGuiScale);
                    }
                    ArrayList<Waypoint> renderResult = null;
                    if (SupportMods.minimap() && WorldMap.settings.waypoints) {
                        boolean waypointMenuReal;
                        GlStateManager.func_179129_p();
                        Waypoint oldViewed = this.viewed;
                        renderResult = SupportMods.xaeroMinimap.renderWaypoints(this, this.cameraX, this.cameraZ, mc.field_71443_c, mc.field_71440_d, guiBasedScale, this.scale, mousePosX, mousePosZ, this.waypointMenuSearchPattern, this.waypointMenuSearchStartPattern, brightness, this.scaledresolution);
                        boolean bl3 = waypointMenuReal = renderResult != null && (renderResult.size() > 1 || this.waypointMenu) && scaledMouseX > this.field_146294_l - 20 && scaledMouseY > this.field_146295_m - 20;
                        if (this.waypointMenu != waypointMenuReal) {
                            int animationEnd;
                            this.waypointMenu = waypointMenuReal;
                            int animationStart = this.waypointMenuAnimation != null ? (int)this.waypointMenuAnimation.getCurrent() : (this.waypointMenu ? 500 : 0);
                            int n = animationEnd = this.waypointMenu ? 0 : 500;
                            if (this.waypointMenu) {
                                this.waypointMenuAnimation = new SlowingAnimation(animationStart, animationEnd, 0.7, 0.001);
                                this.shouldRenderWaypointMenu = true;
                            } else {
                                this.waypointMenuAnimation = new Animation(animationStart, animationEnd, 500L);
                            }
                        }
                        if (!this.shouldRenderWaypointMenu) {
                            this.waypointMenuSelected = 0;
                            this.waypointMenuOffset = 0;
                        }
                        Waypoint waypoint = this.viewed = renderResult != null ? renderResult.remove(0) : null;
                        if (this.viewed != oldViewed) {
                            this.waypointHintAlphaDest = this.viewed != null ? 255.0f : 0.0f;
                            this.waypointHintAlphaAnim = new SlowingAnimation(this.waypointHintAlpha, this.waypointHintAlphaDest, this.waypointHintAlpha < this.waypointHintAlphaDest ? 0.9 : 0.95, 1.0);
                        }
                        if (this.waypointHintAlphaAnim != null) {
                            this.waypointHintAlpha = (float)this.waypointHintAlphaAnim.getCurrent();
                        }
                        GlStateManager.func_179089_o();
                        GlStateManager.func_179147_l();
                    } else {
                        this.viewed = null;
                    }
                    if (WorldMap.settings.footsteps) {
                        for (int i = 0; i < this.mapProcessor.getFootprints().size(); ++i) {
                            Double[] coords = this.mapProcessor.getFootprints().get(i);
                            this.setColourBuffer(1.0f, 0.1f, 0.1f, 1.0f);
                            this.drawDotOnMap(coords[0] - this.cameraX, coords[1] - this.cameraZ, 0.0f, 1.0 / this.scale);
                        }
                    }
                    if (WorldMap.settings.renderArrow) {
                        boolean toTheLeft = this.player.field_70165_t < leftBorder;
                        boolean toTheRight = this.player.field_70165_t > rightBorder;
                        boolean down = this.player.field_70161_v > bottomBorder;
                        boolean up = this.player.field_70161_v < topBorder;
                        GlStateManager.func_179147_l();
                        if (toTheLeft || toTheRight || up || down) {
                            double arrowX = this.player.field_70165_t;
                            double arrowZ = this.player.field_70161_v;
                            float a = 0.0f;
                            if (toTheLeft) {
                                a = up ? 1.5f : (down ? 0.5f : 1.0f);
                                arrowX = leftBorder;
                            } else if (toTheRight) {
                                a = up ? 2.5f : (down ? 3.5f : 3.0f);
                                arrowX = rightBorder;
                            }
                            if (down) {
                                arrowZ = bottomBorder;
                            } else if (up) {
                                if (a == 0.0f) {
                                    a = 2.0f;
                                }
                                arrowZ = topBorder;
                            }
                            this.setColourBuffer(0.0f, 0.0f, 0.0f, 0.9f);
                            this.drawFarArrowOnMap(arrowX - this.cameraX, arrowZ + (double)(2.0f * guiBasedScale) / this.scale - this.cameraZ, a, (double)guiBasedScale / this.scale);
                            this.setColourBuffer(0.8f, 0.1f, 0.1f, 1.0f);
                            this.drawFarArrowOnMap(arrowX - this.cameraX, arrowZ - this.cameraZ, a, (double)guiBasedScale / this.scale);
                        } else {
                            this.setColourBuffer(0.0f, 0.0f, 0.0f, 0.9f);
                            this.drawArrowOnMap(this.player.field_70165_t - this.cameraX, this.player.field_70161_v + (double)(2.0f * guiBasedScale) / this.scale - this.cameraZ, this.player.field_70177_z, (double)guiBasedScale / this.scale);
                            this.setColourBuffer(0.8f, 0.1f, 0.1f, 1.0f);
                            this.drawArrowOnMap(this.player.field_70165_t - this.cameraX, this.player.field_70161_v - this.cameraZ, this.player.field_70177_z, (double)guiBasedScale / this.scale);
                        }
                    }
                    GlStateManager.func_179121_F();
                    if (this.shouldRenderWaypointMenu && renderResult != null) {
                        if (this.waypointMenuSelected >= renderResult.size()) {
                            this.waypointMenuSelected = renderResult.size() - 1;
                            this.waypointMenuOffset = Math.max(this.waypointMenuSelected - 7 + 2, 0);
                        }
                        if (this.waypointMenuSelected < 0) {
                            this.waypointMenuSelected = 0;
                        }
                        this.waypointMenuSelectedObject = renderResult.size() > 0 ? (Waypoint)renderResult.get(this.waypointMenuSelected) : null;
                        SupportMods.xaeroMinimap.renderSideWaypoints(this, renderResult, this.scale, this.field_146294_l + (int)this.waypointMenuAnimation.getCurrent(), this.field_146295_m, this.waypointMenuOffset, this.waypointMenuSelected);
                        if (this.waypointMenu && this.waypointMenuSearch != null && this.waypointMenuSearch.length() > 0) {
                            this.func_73732_a(mc.field_71466_p, this.waypointMenuSearch.toString(), this.field_146294_l / 2, this.field_146295_m - 15, -1);
                        }
                        if (!this.waypointMenu && this.waypointMenuAnimation.getCurrent() == this.waypointMenuAnimation.getDestination()) {
                            this.shouldRenderWaypointMenu = false;
                            this.waypointMenuSearch = new StringBuilder();
                            this.waypointMenuSearchPattern = null;
                            this.waypointMenuSearchStartPattern = null;
                        }
                    }
                    this.dimensionSettings.renderText(mc, scaledMouseX, scaledMouseY, this.field_146294_l, this.field_146295_m);
                    if ((int)this.waypointHintAlpha > 3) {
                        int hintColour = (int)this.waypointHintAlpha << 24 | 0xFF0000 | 0xFF00 | 0xFF;
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179141_d();
                        if (SupportMods.xaeroMinimap.canTeleport()) {
                            this.func_73732_a(mc.field_71466_p, "Edit - Right Click     Teleport - T     Disable - H     Delete - Delete", this.field_146294_l / 2, this.field_146295_m - 25, hintColour);
                        } else {
                            this.func_73732_a(mc.field_71466_p, "Edit - Right Click     Disable - H     Delete - Delete", this.field_146294_l / 2, this.field_146295_m - 25, hintColour);
                        }
                    }
                    if (SupportMods.minimap()) {
                        SupportMods.xaeroMinimap.drawSetChange(this.scaledresolution);
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    this.renderLoadingScreen();
                }
            } else {
                this.renderLoadingScreen();
            }
            mc.func_110434_K().func_110577_a(WorldMap.guiTextures);
            this.func_73729_b(this.field_146294_l - 35, 2, 0, 37, 32, 32);
        }
        GlStateManager.func_179126_j();
        super.func_73863_a(scaledMouseX, scaledMouseY, partialTicks);
        for (GuiDropDown d : this.dropdowns) {
            if (!d.isClosed()) continue;
            d.drawButton(scaledMouseX, scaledMouseY, this.field_146295_m);
        }
        for (GuiDropDown d : this.dropdowns) {
            if (d.isClosed()) continue;
            d.drawButton(scaledMouseX, scaledMouseY, this.field_146295_m);
        }
        this.dimensionSettings.postMapRender(mc, scaledMouseX, scaledMouseY, this.field_146294_l, this.field_146295_m);
    }

    private void renderLoadingScreen() {
        GuiMap.func_73734_a((int)0, (int)0, (int)this.field_146297_k.field_71443_c, (int)this.field_146297_k.field_71440_d, (int)-16777216);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
        this.func_73732_a(this.field_146297_k.field_71466_p, "Preparing World Map...", this.scaledresolution.func_78326_a() / 2, this.scaledresolution.func_78328_b() / 2, -1);
        GlStateManager.func_179121_F();
    }

    public void drawDotOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle, sc, 2.5f, 2.5f, 0, 69, 5, 5, 9729);
    }

    public void drawArrowOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle, sc, 13.0f, 5.0f, 0, 0, 26, 28, 9729);
    }

    public void drawFarArrowOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle * 90.0f, sc, 27.0f, 13.0f, 26, 0, 54, 13, 9729);
    }

    public void drawObjectOnMap(double x, double z, float angle, double sc, float offX, float offY, int textureX, int textureY, int w, int h, int filter) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)this.colourBuffer[0], (float)this.colourBuffer[1], (float)this.colourBuffer[2], (float)this.colourBuffer[3]);
        GlStateManager.func_179137_b((double)x, (double)z, (double)0.0);
        GlStateManager.func_179139_a((double)sc, (double)sc, (double)1.0);
        if (angle != 0.0f) {
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.field_146297_k.func_110434_K().func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
        GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
        this.func_175174_a(-offX, -offY, textureX, textureY, w, h);
        if (filter != 9728) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    @Deprecated
    public static void renderTexturedModalRectWithLighting(float x, float y, int textureX, int textureY, float width, float height) {
        GL14.glBlendFuncSeparate((int)1, (int)0, (int)0, (int)1);
        GuiMap.renderTexturedModalRectWithLighting(x, y, width, height);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
    }

    public static void renderTexturedModalRectWithLighting(float x, float y, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, POSITION_TEX_TEX_TEX);
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_187315_a(0.0, 1.0).func_187315_a(0.0, 1.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_187315_a(1.0, 1.0).func_187315_a(1.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_187315_a(1.0, 0.0).func_187315_a(1.0, 0.0).func_187315_a(1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_187315_a(0.0, 0.0).func_187315_a(0.0, 0.0).func_187315_a(0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderTexturedModalSubRectWithLighting(float x, float y, float textureX1, float textureY1, float textureX2, float textureY2, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, POSITION_TEX_TEX_TEX);
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_187315_a((double)textureX1, (double)textureY2).func_187315_a((double)textureX1, (double)textureY2).func_187315_a((double)textureX1, (double)textureY2).func_187315_a((double)textureX1, (double)textureY2).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)textureX2, (double)textureY2).func_187315_a((double)textureX2, (double)textureY2).func_187315_a((double)textureX2, (double)textureY2).func_187315_a((double)textureX2, (double)textureY2).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_187315_a((double)textureX2, (double)textureY1).func_187315_a((double)textureX2, (double)textureY1).func_187315_a((double)textureX2, (double)textureY1).func_187315_a((double)textureX2, (double)textureY1).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_187315_a((double)textureX1, (double)textureY1).func_187315_a((double)textureX1, (double)textureY1).func_187315_a((double)textureX1, (double)textureY1).func_187315_a((double)textureX1, (double)textureY1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderTexturedModalRect(float x, float y, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public void mapClicked(int button, int x, int y) {
        if (!this.waypointMenu && this.viewed != null) {
            SupportMods.xaeroMinimap.openWaypoint(this, this.viewed);
            this.mouseDownPosX = -1;
            this.mouseDownPosY = -1;
        }
        if (this.waypointMenu && this.waypointMenuSelectedObject != null) {
            this.cameraDestination = new int[]{this.waypointMenuSelectedObject.getX(), this.waypointMenuSelectedObject.getZ()};
        }
    }

    private void setSearch(String search, String preChange) {
        try {
            this.waypointMenuSearchPattern = Pattern.compile(search.toLowerCase());
            if (search.length() > 0) {
                this.waypointMenuSearchStartPattern = search.charAt(0) == '^' ? this.waypointMenuSearchPattern : Pattern.compile('^' + search.toString().toLowerCase());
            } else {
                this.waypointMenuSearchPattern = null;
                this.waypointMenuSearchStartPattern = null;
            }
        }
        catch (PatternSyntaxException e) {
            if (preChange != null) {
                this.waypointMenuSearch = new StringBuilder(preChange);
                this.setSearch(preChange, null);
            }
            throw e;
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        if (par2 == ControlsRegister.keyOpenSettings.func_151463_i()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiWorldMapSettings(this));
        } else if (this.waypointMenu) {
            if (par2 == ControlsRegister.keyZoomIn.func_151463_i()) {
                this.scrollWaypoints(1);
            } else if (par2 == ControlsRegister.keyZoomOut.func_151463_i()) {
                this.scrollWaypoints(-1);
            } else if (par1 != '\u0000') {
                String preChange = this.waypointMenuSearch.toString();
                if (par1 == '\b') {
                    if (this.waypointMenuSearch.length() > 0) {
                        this.waypointMenuSearch.deleteCharAt(this.waypointMenuSearch.length() - 1);
                    }
                } else if (par1 == '\r') {
                    this.waypointMenuSearch = new StringBuilder();
                } else {
                    this.waypointMenuSearch.append(par1);
                }
                this.setSearch(this.waypointMenuSearch.toString(), preChange);
            }
        } else {
            if (par2 == ControlsRegister.keyOpenMap.func_151463_i()) {
                super.func_73869_a(par1, 1);
            }
            if (par1 == '\r' && this.dimensionSettings.active) {
                this.dimensionSettings.confirm(this, this.field_146297_k, this.field_146294_l, this.field_146295_m);
            }
            if (SupportMods.minimap()) {
                SupportMods.xaeroMinimap.onMapKeyPressed(par1, par2);
            }
            if (SupportMods.minimap() && this.lastViewedDimensionId != null) {
                if (this.viewed != null) {
                    switch (par2) {
                        case 20: {
                            SupportMods.xaeroMinimap.teleportToWaypoint(this, this.viewed);
                            break;
                        }
                        case 35: {
                            SupportMods.xaeroMinimap.disableWaypoint(this.viewed);
                            break;
                        }
                        case 211: {
                            SupportMods.xaeroMinimap.deleteWaypoint(this.viewed);
                        }
                    }
                }
                if (par2 == SupportMods.xaeroMinimap.getWaypointKeyCode() && WorldMap.settings.waypoints && this.mouseBlockPosY != -1) {
                    SupportMods.xaeroMinimap.createWaypoint(this, this.mouseBlockPosX, this.mouseBlockPosY + 1, this.mouseBlockPosZ);
                }
                if (par2 == SupportMods.xaeroMinimap.getTempWaypointKeyCode() && WorldMap.settings.waypoints && this.mouseBlockPosY != -1) {
                    SupportMods.xaeroMinimap.createTempWaypoint(this.mouseBlockPosX, this.mouseBlockPosY + 1, this.mouseBlockPosZ);
                }
            }
        }
    }

    public void func_73864_a(int par1, int par2, int par3) throws IOException {
        this.buttonClicked = false;
        for (GuiDropDown d : this.dropdowns) {
            if (!d.isClosed() && d.onDropDown(par1, par2, this.field_146295_m)) {
                d.mouseClicked(par1, par2, par3, this.field_146295_m);
                return;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropdowns) {
            if (d.onDropDown(par1, par2, this.field_146295_m)) {
                d.mouseClicked(par1, par2, par3, this.field_146295_m);
                return;
            }
            d.setClosed(true);
        }
        super.func_73864_a(par1, par2, par3);
        if (!this.buttonClicked) {
            if (par3 == 0) {
                this.leftMouseButton.isDown = true;
                this.leftMouseButton.pressedAtX = Mouse.getX();
                this.leftMouseButton.pressedAtY = Mouse.getY();
            } else if (par3 == 1) {
                this.rightMouseButton.isDown = true;
                this.rightMouseButton.pressedAtX = Mouse.getX();
                this.rightMouseButton.pressedAtY = Mouse.getY();
            } else if (par3 == ControlsRegister.keyOpenMap.func_151463_i() + 100) {
                super.func_73869_a(' ', 1);
            }
        }
    }

    public void func_146286_b(int par1, int par2, int par3) {
        for (GuiDropDown d : this.dropdowns) {
            d.mouseReleased(par1, par2, par3, this.field_146295_m);
        }
        int mouseX = Mouse.getX();
        int mouseY = Mouse.getY();
        if (this.leftMouseButton.isDown && par3 == 0) {
            this.leftMouseButton.isDown = false;
            if (Math.abs(this.leftMouseButton.pressedAtX - mouseX) < 5 && Math.abs(this.leftMouseButton.pressedAtY - mouseY) < 5) {
                this.mapClicked(0, this.leftMouseButton.pressedAtX, this.leftMouseButton.pressedAtY);
            }
            this.leftMouseButton.pressedAtX = -1;
            this.leftMouseButton.pressedAtY = -1;
        }
        if (this.rightMouseButton.isDown && par3 == 1) {
            this.rightMouseButton.isDown = false;
            if (Math.abs(this.rightMouseButton.pressedAtX - mouseX) < 5 && Math.abs(this.rightMouseButton.pressedAtY - mouseY) < 5) {
                this.mapClicked(1, this.rightMouseButton.pressedAtX, this.rightMouseButton.pressedAtY);
            }
            this.rightMouseButton.pressedAtX = -1;
            this.rightMouseButton.pressedAtY = -1;
        }
        super.func_146286_b(par1, par2, par3);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.dimensionSettings.actionPerformed(this, this.field_146297_k, this.field_146294_l, this.field_146295_m, button);
        this.buttonClicked = true;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel() / 120;
        if (wheel != 0) {
            int direction;
            if (wheel != 0) {
                ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
                int mouseXScaled = (int)(Misc.getMouseX(Minecraft.func_71410_x()) / (double)scaledresolution.func_78325_e());
                int mouseYScaled = (int)(Misc.getMouseY(Minecraft.func_71410_x()) / (double)scaledresolution.func_78325_e());
                for (GuiDropDown d : this.dropdowns) {
                    if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.field_146295_m)) continue;
                    d.mouseScrolled(wheel, mouseXScaled, mouseYScaled, this.field_146295_m);
                    return;
                }
            }
            int n = direction = wheel > 0 ? 1 : -1;
            if (this.waypointMenu) {
                this.scrollWaypoints(direction);
            } else {
                this.changeZoom(wheel);
            }
        }
    }

    private void scrollWaypoints(int direction) {
        this.waypointMenuSelected += direction;
        if (this.waypointMenuSelected < 0) {
            this.waypointMenuSelected = 0;
        }
        if (this.waypointMenuSelected == this.waypointMenuOffset + 7 - 1) {
            ++this.waypointMenuOffset;
        }
        if (this.waypointMenuOffset > 0 && this.waypointMenuSelected == this.waypointMenuOffset) {
            --this.waypointMenuOffset;
        }
    }

    private void changeZoom(double factor) {
        this.cameraDestinationAnimX = null;
        this.cameraDestinationAnimZ = null;
        if (GuiMap.func_146271_m()) {
            double destScaleBefore = destScale;
            if (destScale >= 1.0) {
                destScale = factor > 0.0 ? Math.ceil(destScale) : Math.floor(destScale);
                if (destScaleBefore == destScale) {
                    destScale += factor > 0.0 ? 1.0 : -1.0;
                }
                if (destScale == 0.0) {
                    destScale = 0.5;
                }
            } else {
                double reversedScale = 1.0 / destScale;
                double log2 = Math.log(reversedScale) / Math.log(2.0);
                log2 = factor > 0.0 ? Math.floor(log2) : Math.ceil(log2);
                destScale = 1.0 / Math.pow(2.0, log2);
                if (destScaleBefore == destScale) {
                    destScale = 1.0 / Math.pow(2.0, log2 + (double)(factor > 0.0 ? -1 : 1));
                }
            }
        } else {
            destScale *= Math.pow(1.2, factor);
        }
        if (destScale < 0.0625) {
            destScale = 0.0625;
        } else if (destScale > 50.0) {
            destScale = 50.0;
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.leftMouseButton.isDown = false;
        this.rightMouseButton.isDown = false;
    }

    public static void bindMapTextureWithLighting(float brightness, MapTileChunk chunk, int magFilter, int lod) {
        GuiMap.setupTextureMatricesAndTextures(brightness);
        GuiMap.bindMapTextureWithLighting3(brightness, chunk, magFilter, lod);
    }

    @Deprecated
    public static void bindMapTextureWithLighting2(float brightness, MapTileChunk chunk, int magFilter, int lod) {
    }

    @Deprecated
    public static void bindMapTextureWithLighting3(float brightness, MapTileChunk chunk, int magFilter, int lod) {
        GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        GuiMap.bindMapTextureWithLighting3(chunk.getLeafTexture(), magFilter, lod);
    }

    public static void bindMapTextureWithLighting3(MapTileChunk chunk, int magFilter, int lod) {
        GuiMap.bindMapTextureWithLighting3(chunk.getLeafTexture(), magFilter, lod);
    }

    public static void bindMapTextureWithLighting3(RegionTexture<?> regionTexture, int magFilter, int lod) {
        boolean hasLight = regionTexture.getTextureHasLight();
        GlStateManager.func_179138_g((int)33984);
        int glTexture = regionTexture.bindColorTexture(false, magFilter);
        if (hasLight) {
            GlStateManager.func_187399_a((int)8960, (int)8704, (int)34160);
        } else {
            GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
        }
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33986);
        if (hasLight) {
            GlStateManager.func_179098_w();
            GlStateManager.func_179144_i((int)glTexture);
        } else {
            GlStateManager.func_179090_x();
        }
        GlStateManager.func_179138_g((int)33987);
        if (hasLight) {
            GlStateManager.func_179098_w();
            GlStateManager.func_179144_i((int)glTexture);
        } else {
            GlStateManager.func_179090_x();
        }
    }

    @Deprecated
    public static void setupTextureMatrices() {
    }

    private static void setupTexture0(float brightness) {
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)34160);
        GlStateManager.func_187399_a((int)8960, (int)34161, (int)34023);
        GlStateManager.func_187399_a((int)8960, (int)34176, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)34192, (int)771);
        GlStateManager.func_187399_a((int)8960, (int)34177, (int)34167);
        GlStateManager.func_187399_a((int)8960, (int)34193, (int)769);
        GlStateManager.func_187399_a((int)8960, (int)34162, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)34184, (int)34167);
        GlStateManager.func_187399_a((int)8960, (int)34200, (int)770);
    }

    private static void setupTexture2() {
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)34160);
        GlStateManager.func_187399_a((int)8960, (int)34161, (int)260);
        GlStateManager.func_187399_a((int)8960, (int)34176, (int)34168);
        GlStateManager.func_187399_a((int)8960, (int)34192, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)34177, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)34193, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)34162, (int)7681);
        GlStateManager.func_187399_a((int)8960, (int)34184, (int)34167);
        GlStateManager.func_187399_a((int)8960, (int)34200, (int)770);
    }

    private static void setupTexture3() {
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
    }

    public static void setupTextures(float brightness) {
        GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179138_g((int)33984);
        GlStateManager.func_179098_w();
        GuiMap.setupTexture0(brightness);
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33986);
        GuiMap.setupTexture2();
        GlStateManager.func_179138_g((int)33987);
        GuiMap.setupTexture3();
        GlStateManager.func_179138_g((int)33984);
    }

    public static void setupTextureMatricesAndTextures(float brightness) {
        GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        GlStateManager.func_179118_c();
        GlStateManager.func_179138_g((int)33984);
        GlStateManager.func_179098_w();
        GuiMap.setupTexture0(brightness);
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33986);
        GuiMap.setupTexture2();
        GlStateManager.func_179138_g((int)33987);
        GuiMap.setupTexture3();
        GlStateManager.func_179138_g((int)33984);
    }

    public static void restoreTextureStates() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179138_g((int)33987);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33986);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33984);
        GlStateManager.func_187399_a((int)8960, (int)34161, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)34192, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)34177, (int)34168);
        GlStateManager.func_187399_a((int)8960, (int)34162, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)34184, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    private void setColourBuffer(float r, float g, float b, float a) {
        this.colourBuffer[0] = r;
        this.colourBuffer[1] = g;
        this.colourBuffer[2] = b;
        this.colourBuffer[3] = a;
    }

    static {
        POSITION_TEX_TEX_TEX.func_181721_a(DefaultVertexFormats.field_181713_m).func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(TEX_2F_1).func_181721_a(TEX_2F_2).func_181721_a(TEX_2F_3);
        lastAmountOfRegionsViewed = 1;
        destScale = 3.0;
        primaryScaleFBO = null;
    }
}

