/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import xaero.map.MapProcessor;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.TextureUploader;
import xaero.map.region.BranchLeveledRegion;
import xaero.map.region.LeveledRegion;
import xaero.map.region.texture.BranchTextureRenderer;
import xaero.map.region.texture.RegionTexture;

public class BranchRegionTexture
extends RegionTexture<BranchRegionTexture> {
    private boolean updating;
    private boolean colorAllocationRequested;
    private ChildTextureInfo topLeftInfo;
    private ChildTextureInfo topRightInfo;
    private ChildTextureInfo bottomLeftInfo;
    private ChildTextureInfo bottomRightInfo;
    private boolean checkForUpdatesAfterDownload;

    public BranchRegionTexture(LeveledRegion<BranchRegionTexture> region) {
        super(region);
        this.reset();
    }

    private void reset() {
        this.updating = false;
        this.colorAllocationRequested = false;
        this.topLeftInfo = new ChildTextureInfo();
        this.topRightInfo = new ChildTextureInfo();
        this.bottomLeftInfo = new ChildTextureInfo();
        this.bottomRightInfo = new ChildTextureInfo();
        this.checkForUpdatesAfterDownload = false;
    }

    public boolean checkForUpdates(RegionTexture<?> topLeft, RegionTexture<?> topRight, RegionTexture<?> bottomLeft, RegionTexture<?> bottomRight, LeveledRegion<?> childRegion) {
        boolean needsUpdating = false;
        needsUpdating = needsUpdating || this.isChildUpdated(this.topLeftInfo, topLeft);
        needsUpdating = needsUpdating || this.isChildUpdated(this.topRightInfo, topRight);
        needsUpdating = needsUpdating || this.isChildUpdated(this.bottomLeftInfo, bottomLeft);
        boolean bl = needsUpdating = needsUpdating || this.isChildUpdated(this.bottomRightInfo, bottomRight);
        if (needsUpdating) {
            if (this.toUpload) {
                if (this.shouldDownloadFromPBO) {
                    this.checkForUpdatesAfterDownload = true;
                    return false;
                }
                if (this.topLeftInfo.temporaryReference == topLeft && this.topRightInfo.temporaryReference == topRight && this.bottomLeftInfo.temporaryReference == bottomLeft && this.bottomRightInfo.temporaryReference == bottomRight) {
                    return false;
                }
            } else {
                ++childRegion.activeBranchUpdateReferences;
            }
            this.setCachePrepared(false);
            this.region.setAllCachePrepared(false);
            this.colorBufferFormat = -1;
            this.toUpload = true;
            this.updating = true;
            this.topLeftInfo.temporaryReference = topLeft;
            this.topRightInfo.temporaryReference = topRight;
            this.bottomLeftInfo.temporaryReference = bottomLeft;
            this.bottomRightInfo.temporaryReference = bottomRight;
        }
        return needsUpdating;
    }

    private boolean isChildUpdated(ChildTextureInfo info, RegionTexture<?> texture) {
        return texture != null && texture.canUpload() && texture.getRegion().isLoaded() && texture.glColorTexture != -1 && texture.textureVersion != info.usedTextureVersion;
    }

    @Override
    public void preUpload(MapProcessor mapProcessor, LeveledRegion<BranchRegionTexture> region, boolean detailedDebug) {
    }

    @Override
    public void postUpload(MapProcessor mapProcessor, LeveledRegion<BranchRegionTexture> leveledRegion, boolean cleanAndCacheRequestsBlocked) {
    }

    @Override
    public long uploadBuffer(TextureUploader textureUploader, LeveledRegion<BranchRegionTexture> inRegion, BranchTextureRenderer branchTextureRenderer, int x, int y, ScaledResolution scaledRes) throws OpenGLException, IllegalArgumentException, IllegalAccessException {
        return super.uploadBuffer(textureUploader, inRegion, branchTextureRenderer, x, y, scaledRes);
    }

    private void copyHeights(RegionTexture<?> childTexture, int offX, int offZ) {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                this.putHeight(offX + i, offZ + j, childTexture.getHeight(i << 1, j << 1));
            }
        }
    }

    @Override
    protected long uploadNonCache(TextureUploader textureUploader, BranchTextureRenderer renderer, ScaledResolution scaledRes) {
        this.timer = 5;
        this.prepareBuffer();
        this.shouldDownloadFromPBO = true;
        if (this.updating) {
            this.bindPackPBO();
            this.unbindPackPBO();
            this.bindColorTexture(true, 9728);
            OpenGLException.checkGLError();
            ChildTextureInfo topLeftInfo = this.topLeftInfo;
            ChildTextureInfo topRightInfo = this.topRightInfo;
            ChildTextureInfo bottomLeftInfo = this.bottomLeftInfo;
            ChildTextureInfo bottomRightInfo = this.bottomRightInfo;
            Integer topLeftColor = topLeftInfo.getColorTextureForUpdate();
            Integer topRightColor = topRightInfo.getColorTextureForUpdate();
            Integer bottomLeftColor = bottomLeftInfo.getColorTextureForUpdate();
            Integer bottomRightColor = bottomRightInfo.getColorTextureForUpdate();
            long estimatedTime = textureUploader.requestBranchUpdate(!this.colorAllocationRequested, this.glColorTexture, this.unpackPbo[0], 3553, 0, 32856, 64, 64, 0, 0L, 32993, 32821, topLeftColor, topRightColor, bottomLeftColor, bottomRightColor, renderer, this.packPbo, 0, scaledRes);
            if (topLeftColor != null) {
                this.copyHeights(topLeftInfo.temporaryReference, 0, 0);
            }
            if (topRightColor != null) {
                this.copyHeights(topRightInfo.temporaryReference, 32, 0);
            }
            if (bottomLeftColor != null) {
                this.copyHeights(bottomLeftInfo.temporaryReference, 0, 32);
            }
            if (bottomRightColor != null) {
                this.copyHeights(bottomRightInfo.temporaryReference, 32, 32);
            }
            int textureVersionSum = 0;
            textureVersionSum += topLeftInfo.getTextureVersion();
            textureVersionSum += topRightInfo.getTextureVersion();
            textureVersionSum += bottomLeftInfo.getTextureVersion();
            this.updateTextureVersion(textureVersionSum += bottomRightInfo.getTextureVersion());
            this.colorAllocationRequested = true;
            this.textureHasLight = topLeftInfo.hasLight() || topRightInfo.hasLight() || bottomLeftInfo.hasLight() || bottomRightInfo.hasLight();
            LeveledRegion childRegion = null;
            if (topLeftInfo.temporaryReference != null) {
                childRegion = ((ChildTextureInfo)topLeftInfo).temporaryReference.region;
            } else if (topRightInfo.temporaryReference != null) {
                childRegion = ((ChildTextureInfo)topRightInfo).temporaryReference.region;
            } else if (bottomLeftInfo.temporaryReference != null) {
                childRegion = ((ChildTextureInfo)bottomLeftInfo).temporaryReference.region;
            } else if (bottomRightInfo.temporaryReference != null) {
                childRegion = ((ChildTextureInfo)bottomRightInfo).temporaryReference.region;
            }
            --childRegion.activeBranchUpdateReferences;
            topLeftInfo.onUpdate();
            topRightInfo.onUpdate();
            bottomLeftInfo.onUpdate();
            bottomRightInfo.onUpdate();
            BranchLeveledRegion branchRegion = (BranchLeveledRegion)this.region;
            branchRegion.postTextureUpdate();
            return estimatedTime;
        }
        this.bindPackPBO();
        this.unbindPackPBO();
        return textureUploader.requestBranchDownload(this.glColorTexture, 3553, this.packPbo, 0);
    }

    @Override
    protected void onCacheUpload() {
        super.onCacheUpload();
        this.colorAllocationRequested = true;
    }

    @Override
    protected void onDownloadedBuffer(ByteBuffer mappedPBO, int isCompressed) {
        this.colorBuffer.clear();
        this.colorBuffer.put(mappedPBO);
        this.colorBuffer.flip();
        if (this.checkForUpdatesAfterDownload) {
            ((BranchLeveledRegion)this.region).setShouldCheckForUpdatesRecursive(true);
            this.checkForUpdatesAfterDownload = false;
        }
    }

    @Override
    public boolean hasSourceData() {
        return false;
    }

    @Override
    public void addDebugLines(List<String> lines) {
        super.addDebugLines(lines);
        lines.add("updating: " + this.updating);
        lines.add("colorAllocationRequested: " + this.colorAllocationRequested);
        lines.add("topLeftInfo: " + this.topLeftInfo);
        lines.add("topRightInfo: " + this.topRightInfo);
        lines.add("bottomLeftInfo: " + this.bottomLeftInfo);
        lines.add("bottomRightInfo: " + this.bottomRightInfo);
    }

    @Override
    public void onTextureDeletion() {
        super.onTextureDeletion();
        if (this.topLeftInfo.temporaryReference != null) {
            --((ChildTextureInfo)this.topLeftInfo).temporaryReference.getRegion().activeBranchUpdateReferences;
        }
        this.topLeftInfo.onParentDeletion();
        this.topRightInfo.onParentDeletion();
        this.bottomLeftInfo.onParentDeletion();
        this.bottomRightInfo.onParentDeletion();
        this.reset();
    }

    public void requestDownload() {
        this.toUpload = true;
        this.updating = false;
    }

    @Override
    public void writeCacheMapData(DataOutputStream output, byte[] usableBuffer, byte[] integerByteBuffer, LeveledRegion<BranchRegionTexture> inRegion) throws IOException {
        super.writeCacheMapData(output, usableBuffer, integerByteBuffer, inRegion);
        output.writeInt(this.topLeftInfo.usedTextureVersion);
        output.writeInt(this.topRightInfo.usedTextureVersion);
        output.writeInt(this.bottomLeftInfo.usedTextureVersion);
        output.writeInt(this.bottomRightInfo.usedTextureVersion);
    }

    @Override
    public void readCacheData(int cacheSaveVersion, DataInputStream input, byte[] usableBuffer, byte[] integerByteBuffer, LeveledRegion<BranchRegionTexture> inRegion, MapProcessor mapProcessor, int x, int y) throws IOException {
        super.readCacheData(cacheSaveVersion, input, usableBuffer, integerByteBuffer, inRegion, mapProcessor, x, y);
        if (cacheSaveVersion >= 15) {
            this.topLeftInfo.usedTextureVersion = input.readInt();
            this.topRightInfo.usedTextureVersion = input.readInt();
            this.bottomLeftInfo.usedTextureVersion = input.readInt();
            this.bottomRightInfo.usedTextureVersion = input.readInt();
        }
    }

    public class ChildTextureInfo {
        private int usedTextureVersion;
        private RegionTexture<?> temporaryReference;

        private Integer getColorTextureForUpdate() {
            if (this.temporaryReference == null || !this.temporaryReference.shouldBeUsedForBranchUpdate(this.usedTextureVersion)) {
                return null;
            }
            return this.temporaryReference.glColorTexture;
        }

        private int getTextureVersion() {
            if (this.temporaryReference == null) {
                return 0;
            }
            return this.temporaryReference.textureVersion;
        }

        private boolean hasLight() {
            return this.temporaryReference != null && this.temporaryReference.textureHasLight;
        }

        public void onUpdate() {
            if (this.temporaryReference != null) {
                this.usedTextureVersion = this.temporaryReference.textureVersion;
                this.temporaryReference = null;
            }
        }

        public void onParentDeletion() {
            if (this.temporaryReference != null) {
                this.temporaryReference = null;
            }
        }

        public Integer getReferenceColorTexture() {
            return this.temporaryReference == null ? null : Integer.valueOf(this.temporaryReference.glColorTexture);
        }

        public String toString() {
            return "tv " + this.usedTextureVersion + ", ct " + this.getReferenceColorTexture();
        }
    }
}

