/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.settings;

import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import xaero.map.gui.CursorBox;

public enum ModOptions {
    DEBUG("gui.xaero_debug", false, true),
    COLOURS("gui.xaero_block_colours", false, true),
    LIGHTING("gui.xaero_lighting", false, true),
    UPDATE("gui.xaero_update_chunks", false, true),
    LOAD("gui.xaero_load_chunks", false, true),
    DEPTH("gui.xaero_terrain_depth", false, true),
    SLOPES("gui.xaero_terrain_slopes", false, true),
    STEPS("gui.xaero_footsteps", false, true),
    FLOWERS("gui.xaero_flowers", false, true),
    COMPRESSION("gui.xaero_texture_compression", false, true),
    COORDINATES("gui.xaero_wm_coordinates", false, true),
    BIOMES("gui.xaero_biome_colors", false, true),
    WAYPOINTS("gui.xaero_worldmap_waypoints", false, true),
    ARROW("gui.xaero_render_arrow", false, true),
    DISPLAY_ZOOM("gui.xaero_display_zoom", false, true),
    IGNORE_HEIGHTMAPS("gui.xaero_wm_ignore_heightmaps", false, true, new CursorBox("gui.xaero_wm_box_ignore_heightmaps")),
    WAYPOINT_SCALE("gui.xaero_wm_waypoint_scale", true, false, 0.5f, 5.0f, 0.5f),
    OPEN_ANIMATION("gui.xaero_open_map_animation", false, true),
    RELOAD("gui.xaero_reload_everything", false, true),
    PAUSE_REQUESTS("pause_requests", false, true),
    EXTRA_DEBUG("extra_debug", false, true);

    private final boolean enumFloat;
    private final boolean enumBoolean;
    private final String enumString;
    private float valueMin;
    private float valueMax;
    private float valueStep;
    private CursorBox tooltip;

    public static ModOptions getModOptions(int par0) {
        for (ModOptions enumoptions : ModOptions.values()) {
            if (enumoptions.returnEnumOrdinal() != par0) continue;
            return enumoptions;
        }
        return null;
    }

    private ModOptions(String par3Str, boolean par4, boolean par5) {
        this(par3Str, par4, par5, null);
    }

    private ModOptions(String p_i45004_3_, boolean p_i45004_4_, boolean p_i45004_5_, float p_i45004_6_, float p_i45004_7_, float p_i45004_8_) {
        this(p_i45004_3_, p_i45004_4_, p_i45004_5_, p_i45004_6_, p_i45004_7_, p_i45004_8_, null);
    }

    private ModOptions(String par3Str, boolean par4, boolean par5, CursorBox tooltip) {
        this.tooltip = tooltip;
        this.enumString = par3Str;
        this.enumFloat = par4;
        this.enumBoolean = par5;
    }

    private ModOptions(String p_i45004_3_, boolean p_i45004_4_, boolean p_i45004_5_, float p_i45004_6_, float p_i45004_7_, float p_i45004_8_, CursorBox tooltip) {
        this.tooltip = tooltip;
        this.enumString = p_i45004_3_;
        this.enumFloat = p_i45004_4_;
        this.enumBoolean = p_i45004_5_;
        this.valueMin = p_i45004_6_;
        this.valueMax = p_i45004_7_;
        this.valueStep = p_i45004_8_;
    }

    public boolean getEnumFloat() {
        return this.enumFloat;
    }

    public boolean getEnumBoolean() {
        return this.enumBoolean;
    }

    public int returnEnumOrdinal() {
        return this.ordinal();
    }

    public float getValueMax() {
        return this.valueMax;
    }

    public void setValueMax(float p_148263_1_) {
        this.valueMax = p_148263_1_;
    }

    public float normalizeValue(float p_148266_1_) {
        return MathHelper.func_76131_a((float)((this.snapToStepClamp(p_148266_1_) - this.valueMin) / (this.valueMax - this.valueMin)), (float)0.0f, (float)1.0f);
    }

    public float denormalizeValue(float p_148262_1_) {
        return this.snapToStepClamp(this.valueMin + (this.valueMax - this.valueMin) * MathHelper.func_76131_a((float)p_148262_1_, (float)0.0f, (float)1.0f));
    }

    public float snapToStepClamp(float p_148268_1_) {
        p_148268_1_ = this.snapToStep(p_148268_1_);
        return MathHelper.func_76131_a((float)p_148268_1_, (float)this.valueMin, (float)this.valueMax);
    }

    protected float snapToStep(float p_148264_1_) {
        if (this.valueStep > 0.0f) {
            p_148264_1_ = this.valueStep * (float)Math.round(p_148264_1_ / this.valueStep);
        }
        return p_148264_1_;
    }

    public String getEnumString() {
        return I18n.func_135052_a((String)this.enumString, (Object[])new Object[0]);
    }

    public CursorBox getTooltip() {
        return this.tooltip;
    }
}

