/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.bensam.tpworks.TeleportationWorks;
import org.bensam.tpworks.capability.teleportation.ITeleportationHandler;
import org.bensam.tpworks.capability.teleportation.TeleportationHandler;
import org.bensam.tpworks.capability.teleportation.TeleportationHandlerCapabilityProvider;

@Mod.EventBusSubscriber(modid="tpworks")
public class PlayerEventSubscriber {
    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            EntityPlayer oldPlayer = event.getOriginal();
            ITeleportationHandler oldTeleportationHandler = (ITeleportationHandler)oldPlayer.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
            if (oldTeleportationHandler == null) {
                return;
            }
            EntityPlayer clonePlayer = event.getEntityPlayer();
            TeleportationHandler cloneTeleportationHandler = (TeleportationHandler)clonePlayer.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
            cloneTeleportationHandler.deserializeNBT(((TeleportationHandler)oldTeleportationHandler).serializeNBT());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        ITeleportationHandler teleportationHandler = (ITeleportationHandler)player.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
        if (teleportationHandler == null) {
            return;
        }
        teleportationHandler.updateSpawnBed(player, 0);
        teleportationHandler.validateAllDestinations((Entity)player);
    }

    @SubscribeEvent
    public static void onPlayerSetSpawn(PlayerSetSpawnEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        int dimension = player.field_71093_bK;
        BlockPos newSpawnPos = event.getNewSpawn();
        boolean isForced = event.isForced();
        TeleportationWorks.MOD_LOGGER.info("New spawn pos for " + player.getDisplayNameString() + ": " + newSpawnPos + "; isForced = " + isForced);
        if (dimension != 0 && isForced) {
            return;
        }
        ITeleportationHandler teleportationHandler = (ITeleportationHandler)player.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
        if (teleportationHandler == null) {
            return;
        }
        if (dimension == 0 && isForced) {
            teleportationHandler.updateSpawnBed(BlockPos.field_177992_a, dimension);
        } else {
            teleportationHandler.updateSpawnBed(newSpawnPos, dimension);
        }
    }
}

