/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.block.teleportbeacon;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.bensam.tpworks.TeleportationWorks;
import org.bensam.tpworks.block.teleportbeacon.TileEntityTeleportBeacon;
import org.bensam.tpworks.capability.teleportation.ITeleportationBlock;
import org.bensam.tpworks.capability.teleportation.ITeleportationHandler;
import org.bensam.tpworks.capability.teleportation.ITeleportationTileEntity;
import org.bensam.tpworks.capability.teleportation.TeleportDestination;
import org.bensam.tpworks.capability.teleportation.TeleportationHandlerCapabilityProvider;
import org.bensam.tpworks.capability.teleportation.TeleportationHelper;
import org.bensam.tpworks.item.ModItems;
import org.bensam.tpworks.network.PacketUpdateTeleportTileEntity;
import org.bensam.tpworks.sound.ModSounds;
import org.bensam.tpworks.util.ModSetup;
import org.bensam.tpworks.util.ModUtil;

public class BlockTeleportBeacon
extends Block
implements ITeleportationBlock {
    public static final PropertyBool SENDER = PropertyBool.func_177716_a((String)"sender");
    protected static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);

    public BlockTeleportBeacon(@Nonnull String name) {
        super(Material.field_151576_e);
        ModSetup.setRegistryNames(this, name);
        ModSetup.setCreativeTab(this);
        this.func_149711_c(5.0f);
        this.func_149752_b(2000.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SENDER, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityTeleportBeacon();
    }

    public TileEntityTeleportBeacon getTileEntity(@Nonnull IBlockAccess world, BlockPos pos) {
        return (TileEntityTeleportBeacon)world.func_175625_s(pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SENDER});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        boolean isSender = false;
        TileEntity tileEntity = te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (te instanceof ITeleportationTileEntity) {
            isSender = ((ITeleportationTileEntity)te).isSender();
        }
        return state.func_177226_a((IProperty)SENDER, (Comparable)Boolean.valueOf(isSender));
    }

    public boolean func_181623_g() {
        return true;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BLOCK_AABB;
    }

    @Deprecated
    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151654_J;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 13;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntityTeleportBeacon te = this.getTileEntity((IBlockAccess)world, pos);
            UUID uuid = te.getUniqueID();
            String name = te.getTeleportName();
            if (uuid == null || uuid.equals(new UUID(0L, 0L)) || name == null || name.isEmpty()) {
                TeleportationWorks.MOD_LOGGER.warn("Something went wrong! Teleport Beacon block activated with invalid UUID or name fields. Setting to defaults...");
                te.setDefaultUUID();
                te.setTeleportName(null);
                uuid = te.getUniqueID();
                name = te.getTeleportName();
            }
            if (player.func_184586_b(hand).func_77973_b() != ModItems.TELEPORTATION_WAND) {
                TeleportDestination destination = te.teleportationHandler.getActiveDestination();
                TeleportationHelper.displayTeleportBlockName(player, te, destination);
            }
        }
        return true;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            TileEntityTeleportBeacon te = this.getTileEntity((IBlockAccess)world, pos);
            if (player.func_70093_af() && player.func_184614_ca().func_77973_b() == ModItems.TELEPORTATION_WAND) {
                if (te.teleportationHandler.hasActiveDestination()) {
                    te.teleportationHandler.removeDestination(0);
                    te.setSender(false);
                    te.func_70296_d();
                    TeleportationWorks.network.sendToAll((IMessage)new PacketUpdateTeleportTileEntity(pos, world.field_73011_w.getDimension(), null, Boolean.FALSE));
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.destination.cleared.confirmation", new Object[0]));
            } else {
                TeleportDestination destination = te.teleportationHandler.getActiveDestination();
                TeleportationHelper.displayTeleportBlockName(player, te, destination);
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityTeleportBeacon te = this.getTileEntity((IBlockAccess)world, pos);
        if (world.field_72995_K) {
            te.blockPlacedTime = world.func_82737_E();
            double centerX = (double)pos.func_177958_n() + 0.5;
            double centerY = (double)pos.func_177956_o() + 1.0;
            double centerZ = (double)pos.func_177952_p() + 0.5;
            for (int i = 0; i < 64; ++i) {
                double xSpeed = (ModUtil.RANDOM.nextBoolean() ? 1.0 : -1.0) * (1.0 + ModUtil.RANDOM.nextDouble() * 3.0);
                double ySpeed = (ModUtil.RANDOM.nextBoolean() ? 1.0 : -1.0) * (1.0 + ModUtil.RANDOM.nextDouble() * 3.0);
                double zSpeed = (ModUtil.RANDOM.nextBoolean() ? 1.0 : -1.0) * (1.0 + ModUtil.RANDOM.nextDouble() * 3.0);
                world.func_175688_a(EnumParticleTypes.PORTAL, centerX, centerY, centerZ, xSpeed, ySpeed, zSpeed, new int[0]);
            }
        } else {
            if (stack.func_82837_s()) {
                te.setTeleportName(stack.func_82833_r());
            }
            String name = te.getTeleportName();
            UUID uuid = te.getUniqueID();
            if (uuid == null || uuid.equals(new UUID(0L, 0L))) {
                te.setDefaultUUID();
                if (name == null || name.isEmpty()) {
                    te.setTeleportName(null);
                    TeleportationWorks.MOD_LOGGER.info("New Teleport Beacon placed: name = {}", (Object)te.getTeleportName());
                }
            } else {
                TeleportDestination destination = te.teleportationHandler.getActiveDestination();
                TeleportationWorks.MOD_LOGGER.info("Teleport Beacon placed: name = {}, destination = {}", (Object)name, destination == null ? "EMPTY" : destination);
                ITeleportationHandler teleportationHandler = (ITeleportationHandler)placer.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
                if (teleportationHandler != null) {
                    int dimension = world.field_73011_w.getDimension();
                    TeleportDestination destinationInNetwork = teleportationHandler.getDestinationFromUUID(uuid);
                    if (destinationInNetwork != null) {
                        teleportationHandler.setDestinationAsPlaced(uuid, null, dimension, pos);
                        if (placer instanceof EntityPlayerMP) {
                            TeleportationWorks.network.sendTo((IMessage)new PacketUpdateTeleportTileEntity(pos, dimension, Boolean.TRUE, te.isSender()), (EntityPlayerMP)placer);
                        }
                        placer.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.beacon.found", new Object[]{TextFormatting.DARK_GREEN + name}));
                    } else {
                        TeleportationWorks.network.sendTo((IMessage)new PacketUpdateTeleportTileEntity(pos, dimension, Boolean.FALSE, te.isSender()), (EntityPlayerMP)placer);
                    }
                }
            }
            world.func_184133_a((EntityPlayer)null, pos, ModSounds.ACTIVATE_TELEPORT_BEACON, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            double centerX = (double)pos.func_177958_n() + 0.5;
            double centerY = (double)pos.func_177956_o() + 0.1;
            double centerZ = (double)pos.func_177952_p() + 0.5;
            for (int i = 0; i < 64; ++i) {
                double xSpeed = ModUtil.RANDOM.nextBoolean() ? 1.0 : -1.0;
                double ySpeed = (ModUtil.RANDOM.nextBoolean() ? 1.0 : -1.0) * (1.0 + ModUtil.RANDOM.nextDouble());
                double zSpeed = ModUtil.RANDOM.nextBoolean() ? 1.0 : -1.0;
                world.func_175688_a(EnumParticleTypes.PORTAL, centerX, centerY, centerZ, xSpeed, ySpeed, zSpeed, new int[0]);
            }
        } else {
            TileEntityTeleportBeacon te = this.getTileEntity((IBlockAccess)world, pos);
            UUID uuid = te.getUniqueID();
            ITeleportationHandler teleportationHandler = (ITeleportationHandler)player.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
            if (teleportationHandler != null) {
                teleportationHandler.setDestinationAsRemoved(uuid);
            }
            world.func_184133_a(null, pos, ModSounds.DEACTIVATE_TELEPORT_BEACON, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityTeleportBeacon te = this.getTileEntity(world, pos);
        ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)this));
        itemStack.func_151001_c(te.getTeleportName());
        itemStack.func_77983_a("BlockEntityTag", (NBTBase)te.serializeNBT());
        drops.add((Object)itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String sneakBind = Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName();
        String attackBind = Minecraft.func_71410_x().field_71474_y.field_74312_F.getDisplayName();
        String useItemBind = Minecraft.func_71410_x().field_71474_y.field_74313_G.getDisplayName();
        tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tile.teleport_beacon.tipLine1", (Object[])new Object[0]));
        tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tile.teleport_beacon.tipLine2", (Object[])new Object[]{sneakBind, useItemBind}));
        tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tile.teleport_beacon.tipLine3", (Object[])new Object[]{sneakBind, attackBind}));
        tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tile.teleport_beacon.tipLine4", (Object[])new Object[0]));
    }
}

