/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.capability.teleportation;

import com.google.common.base.MoreObjects;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import org.bensam.tpworks.TeleportationWorks;

public class TeleportDestination
implements INBTSerializable<NBTTagCompound> {
    public DestinationType destinationType;
    public int dimension;
    public String friendlyName;
    public BlockPos position;
    private UUID uuid;
    private int flags;

    public TeleportDestination(NBTTagCompound nbt) {
        this.deserializeNBT(nbt);
    }

    public TeleportDestination(@Nonnull String friendlyName, DestinationType destinationType, int dimension, @Nonnull BlockPos position) {
        this(UUID.randomUUID(), friendlyName, destinationType, dimension, position);
    }

    public TeleportDestination(@Nonnull UUID uuid, @Nonnull String friendlyName, DestinationType destinationType, int dimension, @Nonnull BlockPos position) {
        this.uuid = uuid;
        this.friendlyName = friendlyName;
        this.destinationType = destinationType;
        this.dimension = dimension;
        this.position = position;
        this.flags = 0;
        if (this.uuid == null) {
            this.uuid = new UUID(0L, 0L);
        }
        if (this.friendlyName == null) {
            this.friendlyName = "<Invalid Destination Name>";
        }
        if (this.position == null) {
            this.position = BlockPos.field_177992_a;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TeleportDestination)) {
            return false;
        }
        return this.uuid != null && this.uuid.equals(((TeleportDestination)obj).getUUID());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Type", (Object)this.destinationType).add("UUID", (Object)this.uuid).add("Name", (Object)this.friendlyName).add("Dimension", this.dimension).add("Position", (Object)this.position).add("Flags", (Object)Integer.toBinaryString(this.flags)).toString();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public NBTTagCompound serializeNBT() {
        TeleportationWorks.MOD_LOGGER.debug("TeleportDestination.serializeNBT called for " + this.friendlyName);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("DestinationType", this.destinationType.getDestinationValue());
        nbt.func_74768_a("Dimension", this.dimension);
        nbt.func_74778_a("FriendlyName", this.friendlyName);
        nbt.func_74772_a("Position", this.position.func_177986_g());
        nbt.func_186854_a("UUID", this.uuid);
        nbt.func_74768_a("Flags", this.flags);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        TeleportationWorks.MOD_LOGGER.debug("TeleportDestination.deserializeNBT called for " + nbt.func_74779_i("FriendlyName"));
        this.destinationType = DestinationType.values()[nbt.func_74762_e("DestinationType")];
        this.dimension = nbt.func_74762_e("Dimension");
        this.friendlyName = nbt.func_74779_i("FriendlyName");
        this.position = BlockPos.func_177969_a((long)nbt.func_74763_f("Position"));
        this.uuid = nbt.func_186857_a("UUID");
        this.flags = nbt.func_74762_e("Flags");
    }

    public static enum DestinationType {
        BLOCKPOS(0, "Block"),
        SPAWNBED(1, "Spawn Bed"),
        BEACON(2, "Beacon"),
        RAIL(3, "Rail");

        private final int destinationValue;
        private final String valueName;

        private DestinationType(int destinationValue, String name) {
            this.destinationValue = destinationValue;
            this.valueName = name;
        }

        public String toString() {
            return this.valueName;
        }

        int getDestinationValue() {
            return this.destinationValue;
        }
    }
}

