/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.capability.teleportation;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.NotImplementedException;
import org.bensam.tpworks.TeleportationWorks;
import org.bensam.tpworks.block.ModBlocks;
import org.bensam.tpworks.block.teleportbeacon.TileEntityTeleportBeacon;
import org.bensam.tpworks.block.teleportrail.TileEntityTeleportRail;
import org.bensam.tpworks.capability.teleportation.ITeleportationHandler;
import org.bensam.tpworks.capability.teleportation.TeleportDestination;
import org.bensam.tpworks.capability.teleportation.TeleportationHelper;
import org.bensam.tpworks.network.PacketUpdateTeleportTileEntity;
import org.bensam.tpworks.util.ModUtil;

public class TeleportationHandler
implements ITeleportationHandler,
INBTSerializable<NBTTagCompound> {
    public static final String OVERWORLD_SPAWNBED_DISPLAY_NAME = "Overworld Spawn Bed";
    protected LinkedList<TeleportDestination> destinations = new LinkedList();
    protected int activeDestinationIndex = -1;
    protected TeleportDestination specialDestination = null;

    @Override
    public TeleportDestination getActiveDestination() {
        if (this.activeDestinationIndex >= 0 && this.activeDestinationIndex < this.destinations.size()) {
            return this.destinations.get(this.activeDestinationIndex);
        }
        return null;
    }

    @Override
    public int getActiveDestinationIndex() {
        return this.activeDestinationIndex;
    }

    @Override
    public int getDestinationCount() {
        return this.destinations.size();
    }

    @Override
    public TeleportDestination getDestinationFromIndex(int index) {
        if (index >= 0 && index < this.destinations.size()) {
            return this.destinations.get(index);
        }
        return null;
    }

    @Override
    public TeleportDestination getDestinationFromUUID(UUID uuid) {
        for (TeleportDestination destination : this.destinations) {
            if (!destination.getUUID().equals(uuid)) continue;
            return destination;
        }
        return null;
    }

    @Override
    public int getDestinationLimit() {
        return 32;
    }

    @Override
    @Nullable
    public TeleportDestination getNextDestination(@Nullable TeleportDestination afterDestination, @Nullable Predicate<TeleportDestination> filter) {
        if (afterDestination == null) {
            return this.getNextDestination(this.activeDestinationIndex, filter);
        }
        return this.getNextDestination(this.destinations.indexOf(afterDestination), filter);
    }

    @Override
    @Nullable
    public TeleportDestination getNextDestination(@Nullable Integer afterIndex, @Nullable Predicate<TeleportDestination> filter) {
        int destinationCount = this.destinations.size();
        if (destinationCount == 0 || this.activeDestinationIndex < 0) {
            return null;
        }
        int index = 0;
        if (afterIndex == null || afterIndex <= -1) {
            index = this.activeDestinationIndex;
        } else if (afterIndex < destinationCount - 1) {
            index = afterIndex + 1;
        } else {
            return null;
        }
        while (index < destinationCount) {
            TeleportDestination destination = this.destinations.get(index);
            this.validateDestination(null, destination);
            if (filter == null || filter.test(destination)) {
                return destination;
            }
            ++index;
        }
        return null;
    }

    @Override
    public String getShortFormattedName(@Nullable EntityPlayer player, TeleportDestination destination) {
        return this.getShortFormattedName(player, destination, TextFormatting.RESET);
    }

    @Override
    public String getShortFormattedName(@Nullable EntityPlayer player, TeleportDestination destination, TextFormatting defaultFormat) {
        TextFormatting beaconNameFormat = TextFormatting.RESET;
        if (player != null) {
            boolean isValid = this.validateDestination((Entity)player, destination);
            beaconNameFormat = isValid ? TextFormatting.DARK_GREEN : TextFormatting.DARK_GRAY;
        }
        return beaconNameFormat + destination.friendlyName + defaultFormat + " (" + (Object)((Object)destination.destinationType) + " in " + ModUtil.getDimensionName(destination.dimension) + ")";
    }

    @Override
    public String getLongFormattedName(@Nullable EntityPlayer player, TeleportDestination destination) {
        return this.getLongFormattedName(player, destination, TextFormatting.RESET);
    }

    @Override
    public String getLongFormattedName(@Nullable EntityPlayer player, TeleportDestination destination, TextFormatting defaultFormat) {
        TextFormatting beaconNameFormat = TextFormatting.RESET;
        if (player != null) {
            boolean isValid = this.validateDestination((Entity)player, destination);
            beaconNameFormat = isValid ? TextFormatting.DARK_GREEN : TextFormatting.DARK_GRAY;
        }
        return TeleportationHandler.getLongFormattedName(destination, beaconNameFormat, defaultFormat);
    }

    public static String getLongFormattedName(TeleportDestination destination, TextFormatting beaconNameFormat, TextFormatting defaultFormat) {
        return beaconNameFormat + destination.friendlyName + defaultFormat + " (" + (Object)((Object)destination.destinationType) + ")  at {" + destination.position.func_177958_n() + ", " + destination.position.func_177956_o() + ", " + destination.position.func_177952_p() + "} in " + ModUtil.getDimensionName(destination.dimension);
    }

    @Override
    @Nullable
    public TeleportDestination getSpecialDestination() {
        return this.specialDestination;
    }

    @Override
    public boolean hasActiveDestination() {
        return this.destinations.size() > 0 && this.activeDestinationIndex >= 0;
    }

    @Override
    public boolean hasDestination(UUID uuid) {
        for (TeleportDestination destination : this.destinations) {
            if (!destination.getUUID().equals(uuid)) continue;
            return true;
        }
        return false;
    }

    protected boolean insertDestination(int index, TeleportDestination destination) {
        if (this.destinations.size() >= this.getDestinationLimit()) {
            return false;
        }
        this.destinations.add(index, destination);
        if (this.activeDestinationIndex >= index) {
            ++this.activeDestinationIndex;
        } else if (this.activeDestinationIndex < 0) {
            this.activeDestinationIndex = 0;
        }
        return true;
    }

    @Override
    public void removeAllDestinations(@Nullable EntityPlayer player, boolean includeOverworldSpawnBed) {
        if (player == null && includeOverworldSpawnBed) {
            this.destinations.clear();
        } else {
            Iterator it = this.destinations.iterator();
            while (it.hasNext()) {
                TeleportDestination destination = (TeleportDestination)it.next();
                if (!includeOverworldSpawnBed && destination.destinationType == TeleportDestination.DestinationType.SPAWNBED && destination.dimension == 0) continue;
                if (player instanceof EntityPlayerMP && this.validateDestination((Entity)player, destination)) {
                    TeleportationWorks.network.sendTo((IMessage)new PacketUpdateTeleportTileEntity(destination.position, destination.dimension, Boolean.FALSE, null), (EntityPlayerMP)player);
                }
                it.remove();
            }
        }
        this.activeDestinationIndex = this.destinations.size() >= 1 ? 0 : -1;
    }

    @Override
    public void removeDestination(int index) {
        if (index >= 0 && index < this.destinations.size()) {
            this.destinations.remove(index);
            if (this.activeDestinationIndex > index || this.activeDestinationIndex >= this.destinations.size()) {
                --this.activeDestinationIndex;
            }
        }
    }

    @Override
    public void removeDestination(UUID uuid) {
        int index = 0;
        Iterator it = this.destinations.iterator();
        while (it.hasNext()) {
            TeleportDestination destination = (TeleportDestination)it.next();
            if (destination.getUUID().equals(uuid)) {
                it.remove();
                if (this.activeDestinationIndex <= index && this.activeDestinationIndex < this.destinations.size()) break;
                --this.activeDestinationIndex;
                break;
            }
            ++index;
        }
    }

    @Override
    public void replaceDestination(int index, TeleportDestination destination) {
        if (index >= 0 && index < this.destinations.size()) {
            this.destinations.remove(index);
            this.destinations.add(index, destination);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean replaceOrAddDestination(TeleportDestination destination) {
        int index = this.destinations.indexOf(destination);
        if (index == -1) {
            if (this.destinations.size() >= this.getDestinationLimit()) return false;
            this.destinations.add(destination);
            if (this.activeDestinationIndex >= 0) return true;
            this.activeDestinationIndex = 0;
            return true;
        } else {
            this.replaceDestination(index, destination);
        }
        return true;
    }

    @Override
    public void replaceOrAddFirstDestination(TeleportDestination destination) {
        if (this.destinations.isEmpty()) {
            this.insertDestination(0, destination);
        } else {
            this.replaceDestination(0, destination);
        }
    }

    @Override
    public TeleportDestination setActiveDestination(int index) {
        if (index >= 0 && index < this.destinations.size()) {
            this.activeDestinationIndex = index;
            return this.getActiveDestination();
        }
        return null;
    }

    @Override
    public TeleportDestination setActiveDestinationToNext() {
        if (this.destinations.size() > 0) {
            this.activeDestinationIndex = (this.activeDestinationIndex + 1) % this.destinations.size();
            return this.getActiveDestination();
        }
        return null;
    }

    @Override
    public TeleportDestination setActiveDestinationToPrevious() {
        if (this.destinations.size() > 0) {
            this.activeDestinationIndex = (this.activeDestinationIndex + this.destinations.size() - 1) % this.destinations.size();
            return this.getActiveDestination();
        }
        return null;
    }

    @Override
    public void setDestinationAsPlaced(UUID uuid, @Nullable String newName, int newDimension, @Nullable BlockPos newPos) {
        for (TeleportDestination destination : this.destinations) {
            if (!destination.getUUID().equals(uuid)) continue;
            destination.dimension = newDimension;
            if (newName != null) {
                destination.friendlyName = newName;
            }
            if (newPos == null) break;
            destination.position = newPos;
            break;
        }
    }

    @Override
    public void setDestinationAsRemoved(UUID uuid) {
        for (TeleportDestination destination : this.destinations) {
            if (!destination.getUUID().equals(uuid)) continue;
            destination.position = BlockPos.field_177992_a;
            break;
        }
    }

    @Override
    public void setSpecialDestination(TeleportDestination destination) {
        this.specialDestination = destination;
    }

    @Override
    public void updateSpawnBed(BlockPos position, int dimension) {
        TeleportDestination spawnBedDestination = null;
        for (TeleportDestination destination : this.destinations) {
            if (destination.destinationType != TeleportDestination.DestinationType.SPAWNBED || destination.dimension != dimension) continue;
            spawnBedDestination = destination;
            break;
        }
        if (spawnBedDestination != null) {
            spawnBedDestination.position = position;
        } else if (dimension == 0) {
            spawnBedDestination = new TeleportDestination(OVERWORLD_SPAWNBED_DISPLAY_NAME, TeleportDestination.DestinationType.SPAWNBED, dimension, position);
            this.insertDestination(0, spawnBedDestination);
        } else {
            spawnBedDestination = new TeleportDestination(TeleportDestination.DestinationType.SPAWNBED.toString(), TeleportDestination.DestinationType.SPAWNBED, dimension, position);
            if (this.destinations.size() > 0) {
                this.insertDestination(1, spawnBedDestination);
            } else {
                this.insertDestination(0, spawnBedDestination);
            }
        }
    }

    @Override
    public void updateSpawnBed(EntityPlayer player, int dimension) {
        BlockPos spawnBed = player.getBedLocation(dimension);
        if (spawnBed == null) {
            spawnBed = BlockPos.field_177992_a;
        }
        this.updateSpawnBed(spawnBed, dimension);
    }

    @Override
    public void validateAllDestinations(@Nullable Entity entity) {
        for (TeleportDestination destination : this.destinations) {
            this.validateDestination(entity, destination);
        }
    }

    @Override
    public boolean validateDestination(@Nullable Entity entity, TeleportDestination destination) {
        boolean isValid = false;
        WorldServer destinationWorld = ModUtil.getWorldServerForDimension(destination.dimension);
        IBlockState destinationBlockState = destinationWorld.func_180495_p(destination.position);
        Block destinationBlock = destinationBlockState.func_177230_c();
        switch (destination.destinationType) {
            case BLOCKPOS: {
                if (destination.position.equals((Object)BlockPos.field_177992_a)) break;
                isValid = destinationBlock.func_181623_g();
                break;
            }
            case SPAWNBED: {
                if (destination.position.equals((Object)BlockPos.field_177992_a) || destinationBlock != Blocks.field_150324_C) {
                    BlockPos spawnBedPos = null;
                    if (entity != null && entity instanceof EntityPlayer) {
                        spawnBedPos = ((EntityPlayer)entity).getBedLocation(destination.dimension);
                    }
                    destination.position = spawnBedPos == null ? BlockPos.field_177992_a : ((destinationBlock = (destinationBlockState = destinationWorld.func_180495_p(spawnBedPos)).func_177230_c()) == Blocks.field_150324_C ? spawnBedPos : BlockPos.field_177992_a);
                }
                isValid = !destination.position.equals((Object)BlockPos.field_177992_a);
                break;
            }
            case BEACON: {
                TileEntity teBeacon = destinationWorld.func_175625_s(destination.position);
                UUID destinationUUID = destination.getUUID();
                if (destination.position.equals((Object)BlockPos.field_177992_a) || destinationBlock != ModBlocks.TELEPORT_BEACON || !(teBeacon instanceof TileEntityTeleportBeacon) || !((TileEntityTeleportBeacon)teBeacon).getUniqueID().equals(destinationUUID)) {
                    int[] dimensions;
                    destination.position = BlockPos.field_177992_a;
                    BlockPos beaconPos = null;
                    for (int dimension : dimensions = DimensionManager.getRegisteredDimensions().values().stream().flatMap(Collection::stream).mapToInt(Integer::intValue).toArray()) {
                        WorldServer world = ModUtil.getWorldServerForDimension(dimension);
                        beaconPos = TeleportationHelper.findTeleportBeacon((World)world, destinationUUID);
                        if (beaconPos == null) continue;
                        teBeacon = world.func_175625_s(beaconPos);
                        destination.position = beaconPos;
                        destination.dimension = dimension;
                        break;
                    }
                }
                boolean bl = isValid = !destination.position.equals((Object)BlockPos.field_177992_a);
                if (!isValid) break;
                destination.friendlyName = ((TileEntityTeleportBeacon)teBeacon).getTeleportName();
                break;
            }
            case RAIL: {
                TileEntity teRail = destinationWorld.func_175625_s(destination.position);
                UUID destinationUUID = destination.getUUID();
                if (destination.position.equals((Object)BlockPos.field_177992_a) || destinationBlock != ModBlocks.TELEPORT_RAIL || !(teRail instanceof TileEntityTeleportRail) || !((TileEntityTeleportRail)teRail).getUniqueID().equals(destinationUUID)) {
                    int[] dimensions;
                    destination.position = BlockPos.field_177992_a;
                    BlockPos railPos = null;
                    for (int dimension : dimensions = DimensionManager.getRegisteredDimensions().values().stream().flatMap(Collection::stream).mapToInt(Integer::intValue).toArray()) {
                        WorldServer world = ModUtil.getWorldServerForDimension(dimension);
                        railPos = TeleportationHelper.findTeleportRail((World)world, destinationUUID);
                        if (railPos == null) continue;
                        teRail = world.func_175625_s(railPos);
                        destination.position = railPos;
                        destination.dimension = dimension;
                        break;
                    }
                }
                boolean bl = isValid = !destination.position.equals((Object)BlockPos.field_177992_a);
                if (!isValid) break;
                destination.friendlyName = ((TileEntityTeleportRail)teRail).getTeleportName();
                break;
            }
        }
        return isValid;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeToNBT(compound);
        return compound;
    }

    protected NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("activeDestinationIndex", this.activeDestinationIndex);
        NBTTagList nbtTagList = new NBTTagList();
        for (TeleportDestination destination : this.destinations) {
            nbtTagList.func_74742_a((NBTBase)destination.serializeNBT());
        }
        compound.func_74782_a("destinations", (NBTBase)nbtTagList);
        if (this.specialDestination != null) {
            compound.func_74782_a("specialDestination", (NBTBase)this.specialDestination.serializeNBT());
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    protected void readFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("activeDestinationIndex")) {
            this.activeDestinationIndex = compound.func_74762_e("activeDestinationIndex");
        }
        if (compound.func_74764_b("destinations")) {
            NBTTagList nbtTagList = (NBTTagList)compound.func_74781_a("destinations");
            for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                NBTTagCompound destinationTag = nbtTagList.func_150305_b(i);
                this.replaceOrAddDestination(new TeleportDestination(destinationTag));
            }
        }
        if (compound.func_74764_b("specialDestination")) {
            this.specialDestination = new TeleportDestination(compound.func_74775_l("specialDestination"));
        }
    }

    protected void onDestinationValuesChanged(int index) {
        throw new NotImplementedException("To help the mod author prioritize their work, contact the author if you wish to override this method in your mod");
    }
}

