/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.capability.teleportation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketMoveVehicle;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.bensam.tpworks.TeleportationWorks;
import org.bensam.tpworks.block.teleportbeacon.TileEntityTeleportBeacon;
import org.bensam.tpworks.block.teleportrail.TileEntityTeleportRail;
import org.bensam.tpworks.capability.teleportation.CustomTeleporter;
import org.bensam.tpworks.capability.teleportation.ITeleportationHandler;
import org.bensam.tpworks.capability.teleportation.ITeleportationTileEntity;
import org.bensam.tpworks.capability.teleportation.TeleportDestination;
import org.bensam.tpworks.capability.teleportation.TeleportationHandlerCapabilityProvider;
import org.bensam.tpworks.item.ItemTeleportationBow;
import org.bensam.tpworks.network.PacketUpdateTeleportIncoming;
import org.bensam.tpworks.potion.ModPotions;
import org.bensam.tpworks.util.ModConfig;
import org.bensam.tpworks.util.ModUtil;

public class TeleportationHelper {
    public static void displayTeleportBlockName(EntityPlayer player, ITeleportationTileEntity teleportBlock, @Nullable TeleportDestination destination) {
        if (teleportBlock instanceof TileEntityTeleportBeacon) {
            if (destination == null) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.beacon.display.no_destination", new Object[]{TextFormatting.DARK_GREEN + teleportBlock.getTeleportName()}));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.beacon.display.with_destination", new Object[]{TextFormatting.DARK_GREEN + teleportBlock.getTeleportName(), TextFormatting.DARK_GREEN + destination.friendlyName}));
            }
        } else if (teleportBlock instanceof TileEntityTeleportRail) {
            if (destination == null) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.rail.display.no_destination", new Object[]{TextFormatting.DARK_GREEN + teleportBlock.getTeleportName()}));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.rail.display.with_destination", new Object[]{TextFormatting.DARK_GREEN + teleportBlock.getTeleportName(), TextFormatting.DARK_GREEN + destination.friendlyName}));
            }
        }
    }

    @Nullable
    public static BlockPos findSafeTeleportPosNearBed(int dimension, BlockPos bedPos) {
        if (bedPos.equals((Object)BlockPos.field_177992_a)) {
            return null;
        }
        WorldServer world = ModUtil.getWorldServerForDimension(dimension);
        IBlockState blockState = world.func_180495_p(bedPos);
        Block block = blockState.func_177230_c();
        if (block != Blocks.field_150324_C) {
            return null;
        }
        return BlockBed.func_176468_a((World)world, (BlockPos)bedPos, (int)0);
    }

    @Nullable
    public static BlockPos findTeleportBeacon(World world, UUID beaconUUID) {
        if (world == null) {
            return null;
        }
        List tileEntityList = world.field_147482_g;
        for (TileEntity te : tileEntityList) {
            if (!(te instanceof TileEntityTeleportBeacon) || !((TileEntityTeleportBeacon)te).getUniqueID().equals(beaconUUID)) continue;
            return te.func_174877_v();
        }
        return null;
    }

    @Nullable
    public static BlockPos findTeleportRail(World world, UUID railUUID) {
        if (world == null) {
            return null;
        }
        List tileEntityList = world.field_147482_g;
        for (TileEntity te : tileEntityList) {
            if (!(te instanceof TileEntityTeleportRail) || !((TileEntityTeleportRail)te).getUniqueID().equals(railUUID)) continue;
            return te.func_174877_v();
        }
        return null;
    }

    @Nullable
    public static TeleportDestination getActiveDestination(Entity entity) {
        return TeleportationHelper.getActiveDestination(entity, false);
    }

    @Nullable
    public static TeleportDestination getActiveDestination(Entity entity, boolean validate) {
        TeleportDestination activeDestination = null;
        ITeleportationHandler teleportationHandler = (ITeleportationHandler)entity.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
        if (teleportationHandler != null) {
            activeDestination = entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_184614_ca().func_77973_b() instanceof ItemTeleportationBow ? teleportationHandler.getSpecialDestination() : teleportationHandler.getActiveDestination();
            if (validate && activeDestination != null) {
                teleportationHandler.validateDestination(entity, activeDestination);
            }
        }
        return activeDestination;
    }

    @Nullable
    public static TeleportDestination getActiveDestination(TileEntity tileEntity, boolean validate) {
        TeleportDestination activeDestination = null;
        ITeleportationHandler teleportationHandler = (ITeleportationHandler)tileEntity.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
        if (teleportationHandler != null) {
            activeDestination = teleportationHandler.getActiveDestination();
            if (validate && activeDestination != null) {
                teleportationHandler.validateDestination(null, activeDestination);
            }
        }
        return activeDestination;
    }

    @Nullable
    public static TeleportDestination getNextDestination(Entity entity, @Nullable TeleportDestination.DestinationType destinationType, @Nullable TeleportDestination afterDestination, @Nullable UUID notThisID) {
        ITeleportationHandler teleportationHandler = (ITeleportationHandler)entity.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
        if (teleportationHandler != null) {
            if (afterDestination == null && (afterDestination = teleportationHandler.getDestinationFromIndex(0)) == null) {
                return null;
            }
            Predicate<TeleportDestination> filter = destinationType != null ? d -> d.destinationType == destinationType && !d.getUUID().equals(notThisID) : d -> (d.destinationType == TeleportDestination.DestinationType.BEACON || d.destinationType == TeleportDestination.DestinationType.RAIL) && !d.getUUID().equals(notThisID);
            return teleportationHandler.getNextDestination(afterDestination, filter);
        }
        return null;
    }

    public static void remountRider(Entity rider, Entity entityRidden) {
        if (!rider.func_184218_aH() && rider.field_71093_bK == entityRidden.field_71093_bK && rider.func_180425_c().func_177957_d(entityRidden.field_70165_t, entityRidden.field_70163_u, entityRidden.field_70161_v) < 4.0) {
            rider.func_184205_a(entityRidden, true);
            if (rider instanceof EntityPlayerMP) {
                ((EntityPlayerMP)rider).field_71135_a.field_147371_a.func_179290_a((Packet)new SPacketMoveVehicle(entityRidden));
            }
        }
    }

    public static void teleportEntityAndPassengers(Entity entity, TeleportDestination destination) {
        ArrayList<Entity> teleportingEntities = new ArrayList<Entity>();
        teleportingEntities.add(entity);
        if (entity.func_184218_aH()) {
            teleportingEntities.add(entity.func_184187_bx());
        }
        for (Entity passenger : entity.func_184188_bt()) {
            teleportingEntities.add(passenger);
            for (Entity passengerOfPassenger : passenger.func_184188_bt()) {
                teleportingEntities.add(passengerOfPassenger);
            }
        }
        HashMap<Entity, Entity> riderMap = ModUtil.getRiders(teleportingEntities);
        for (Entity entity2 : teleportingEntities) {
            Entity teleportedEntity = null;
            boolean hasPassengers = riderMap.containsValue(entity2);
            teleportedEntity = TeleportationHelper.teleport(entity2, destination);
            if (!hasPassengers || entity2 == teleportedEntity) continue;
            for (Map.Entry<Entity, Entity> riderSet : riderMap.entrySet()) {
                if (riderSet.getValue() != entity2) continue;
                riderSet.setValue(teleportedEntity);
            }
        }
        for (Map.Entry entry : riderMap.entrySet()) {
            Entity rider = (Entity)entry.getKey();
            Entity entityRidden = (Entity)entry.getValue();
            TeleportationHelper.remountRider(rider, entityRidden);
        }
    }

    public static Entity teleport(Entity entityToTeleport, TeleportDestination destination) {
        TileEntity te;
        World currentWorld = entityToTeleport.field_70170_p;
        int teleportDimension = destination.dimension;
        WorldServer teleportWorld = ModUtil.getWorldServerForDimension(teleportDimension);
        BlockPos safePos = null;
        float rotationYaw = entityToTeleport.field_70177_z;
        switch (destination.destinationType) {
            case SPAWNBED: {
                safePos = TeleportationHelper.findSafeTeleportPosNearBed(teleportDimension, destination.position);
                break;
            }
            case BEACON: 
            case RAIL: {
                if (teleportWorld.func_180495_p(destination.position.func_177984_a()).func_185904_a().func_76220_a()) break;
                safePos = destination.position;
                break;
            }
            case BLOCKPOS: {
                IBlockState state = teleportWorld.func_180495_p(destination.position);
                Block block = state.func_177230_c();
                if (!block.func_181623_g()) break;
                safePos = destination.position;
                break;
            }
        }
        if (safePos == null) {
            return entityToTeleport;
        }
        if (destination.destinationType == TeleportDestination.DestinationType.BEACON && (te = teleportWorld.func_175625_s(safePos)) instanceof TileEntityTeleportBeacon) {
            ((TileEntityTeleportBeacon)te).setCoolDownTime(ModConfig.teleportBlockSettings.beaconCooldownTime);
        }
        return TeleportationHelper.teleport(currentWorld, entityToTeleport, teleportDimension, safePos, rotationYaw);
    }

    public static Entity teleport(World currentWorld, Entity entityToTeleport, int teleportDimension, BlockPos teleportPos, float playerRotationYaw) {
        if (currentWorld.field_72995_K) {
            return entityToTeleport;
        }
        int entityCurrentDimension = entityToTeleport.field_71093_bK;
        WorldServer teleportWorld = ModUtil.getWorldServerForDimension(teleportDimension);
        TeleportationWorks.network.sendToAllAround((IMessage)new PacketUpdateTeleportIncoming(teleportPos, teleportDimension), new NetworkRegistry.TargetPoint(teleportDimension, (double)teleportPos.func_177958_n(), (double)teleportPos.func_177956_o(), (double)teleportPos.func_177952_p(), 50.0));
        if (entityToTeleport.func_184218_aH()) {
            entityToTeleport.func_184210_p();
        }
        if (entityToTeleport.func_184207_aI()) {
            entityToTeleport.func_184226_ay();
        }
        BlockPos preTeleportPosition = entityToTeleport.func_180425_c();
        entityToTeleport.func_70080_a(entityToTeleport.field_70165_t, entityToTeleport.field_70163_u, entityToTeleport.field_70161_v, playerRotationYaw, entityToTeleport.field_70125_A);
        if (entityCurrentDimension != teleportDimension) {
            TeleportationWorks.MOD_LOGGER.info("Using CustomTeleporter to teleport {} to dimension {}", (Object)entityToTeleport.func_145748_c_().func_150254_d(), (Object)teleportDimension);
            entityToTeleport = entityToTeleport.changeDimension(teleportDimension, (ITeleporter)new CustomTeleporter(teleportWorld, teleportPos));
        } else if (entityToTeleport instanceof EntityLivingBase && ((EntityLivingBase)entityToTeleport).func_184595_k((double)teleportPos.func_177958_n() + 0.5, (double)teleportPos.func_177984_a().func_177956_o() + 0.25, (double)teleportPos.func_177952_p() + 0.5)) {
            TeleportationWorks.MOD_LOGGER.info("attemptTeleport succeeded");
        } else {
            TeleportationWorks.MOD_LOGGER.info("Calling setPositionAndUpdate...");
            entityToTeleport.func_70634_a((double)teleportPos.func_177958_n() + 0.5, (double)teleportPos.func_177956_o() + 0.25, (double)teleportPos.func_177952_p() + 0.5);
        }
        currentWorld.func_184133_a((EntityPlayer)null, preTeleportPosition, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
        teleportWorld.func_184133_a((EntityPlayer)null, teleportPos, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (entityToTeleport instanceof EntityLivingBase) {
            ((EntityLivingBase)entityToTeleport).func_70690_d(new PotionEffect((Potion)ModPotions.TELEPORTATION_POTION, 200, 0));
        }
        return entityToTeleport;
    }
}

