/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.entity;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.bensam.tpworks.capability.teleportation.TeleportDestination;
import org.bensam.tpworks.capability.teleportation.TeleportationHelper;
import org.bensam.tpworks.item.ItemTeleportationSplashPotion;
import org.bensam.tpworks.potion.ModPotions;
import org.bensam.tpworks.potion.PotionTeleportation;
import org.bensam.tpworks.util.ModConfig;
import org.bensam.tpworks.util.ModUtil;

public class EntityTeleportationSplashPotion
extends EntityThrowable {
    protected TileEntity sourceTileEntity;
    protected Vec3d splashRange = ItemTeleportationSplashPotion.NORMAL_RANGE;
    protected boolean setDeadNextUpdate;
    protected TeleportDestination teleportDestination;
    public static final Predicate<Entity> TELEPORTABLE_ENTITIES = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof EntityPlayer && !((EntityPlayer)entity).func_175149_v() && (ModConfig.splashPotionSettings.teleportPlayerThrower || ModConfig.splashPotionSettings.teleportPlayersOther) || entity instanceof IAnimals && !(entity instanceof IMob) && ModConfig.splashPotionSettings.teleportPassiveCreatures || entity instanceof IMob && ModConfig.splashPotionSettings.teleportHostileCreatures || entity instanceof EntityBoat && ModConfig.splashPotionSettings.teleportBoats && !ModConfig.splashPotionSettings.teleportBoatsOnlyWhenRiddenByTeleportableEntity || entity instanceof EntityMinecart && ModConfig.splashPotionSettings.teleportMinecarts && !ModConfig.splashPotionSettings.teleportMinecartsOnlyWhenRiddenByTeleportableEntity || (entity instanceof IProjectile || entity instanceof EntityFireball) && ModConfig.splashPotionSettings.teleportProjectiles || entity instanceof EntityItem && ModConfig.splashPotionSettings.teleportDroppedItems || entity instanceof EntityTNTPrimed && ModConfig.splashPotionSettings.teleportTNTLit;
        }
    };
    public static final Predicate<Entity> TELEPORTABLE_RIDDEN_ENTITIES = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof EntityPlayer && !((EntityPlayer)entity).func_175149_v() && (ModConfig.splashPotionSettings.teleportPlayerThrower || ModConfig.splashPotionSettings.teleportPlayersOther) || entity instanceof IAnimals && !(entity instanceof IMob) && ModConfig.splashPotionSettings.teleportPassiveCreatures || entity instanceof IMob && ModConfig.splashPotionSettings.teleportHostileCreatures || entity instanceof EntityBoat && ModConfig.splashPotionSettings.teleportBoats || entity instanceof EntityMinecart && ModConfig.splashPotionSettings.teleportMinecarts;
        }
    };

    public EntityTeleportationSplashPotion(World world) {
        super(world);
    }

    public EntityTeleportationSplashPotion(World world, double x, double y, double z, IBlockSource source, boolean rangeExtended) {
        super(world, x, y, z);
        this.sourceTileEntity = source.func_150835_j();
        if (this.sourceTileEntity != null) {
            this.teleportDestination = TeleportationHelper.getActiveDestination(this.sourceTileEntity, true);
        }
        if (rangeExtended) {
            this.splashRange = ItemTeleportationSplashPotion.EXTENDED_RANGE;
        }
    }

    public EntityTeleportationSplashPotion(World world, EntityLivingBase thrower, boolean rangeExtended) {
        super(world, thrower);
        if (thrower != null) {
            this.teleportDestination = TeleportationHelper.getActiveDestination((Entity)thrower, true);
        }
        if (rangeExtended) {
            this.splashRange = ItemTeleportationSplashPotion.EXTENDED_RANGE;
        }
    }

    public TileEntity getSourceTileEntity() {
        return this.sourceTileEntity;
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    public void func_70071_h_() {
        if (this.setDeadNextUpdate) {
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && !this.setDeadNextUpdate) {
            PotionTeleportation potion = ModPotions.TELEPORTATION_POTION;
            this.applySplash(result, potion);
            this.field_70170_p.func_175718_b(2007, new BlockPos((Entity)this), potion.func_76401_j());
        }
    }

    protected void applySplash(RayTraceResult result, PotionTeleportation potion) {
        AxisAlignedBB splashEffectBB = this.func_174813_aQ().func_72314_b(this.splashRange.field_72450_a, this.splashRange.field_72448_b, this.splashRange.field_72449_c);
        List entitiesInBB = this.field_70170_p.func_175647_a(Entity.class, splashEffectBB, TELEPORTABLE_ENTITIES);
        ArrayList<Entity> teleportingEntities = new ArrayList<Entity>();
        for (Entity entityInBB : entitiesInBB) {
            if (entityInBB == this.field_70192_c) {
                if (!ModConfig.splashPotionSettings.teleportPlayerThrower) continue;
                teleportingEntities.add(entityInBB);
                continue;
            }
            if (entityInBB instanceof EntityPlayer) {
                if (!ModConfig.splashPotionSettings.teleportPlayersOther) continue;
                teleportingEntities.add(entityInBB);
                continue;
            }
            teleportingEntities.add(entityInBB);
        }
        if (teleportingEntities.isEmpty()) {
            this.func_70106_y();
        } else {
            HashMap<Entity, Entity> riderMap = ModUtil.getRiders(teleportingEntities);
            for (Entity entity : riderMap.values()) {
                if (teleportingEntities.contains(entity) || !TELEPORTABLE_RIDDEN_ENTITIES.apply((Object)entity)) continue;
                teleportingEntities.add(entity);
            }
            for (Entity entity : teleportingEntities) {
                if (entity == this) continue;
                Entity teleportedEntity = null;
                boolean hasPassengers = riderMap.containsValue(entity);
                EntityLivingBase thrower = this.func_85052_h();
                if (thrower != null && this.teleportDestination != null) {
                    teleportedEntity = potion.affectEntity((Entity)this, (Entity)thrower, entity, this.teleportDestination);
                } else if (this.sourceTileEntity != null && this.teleportDestination != null) {
                    teleportedEntity = potion.affectEntity((Entity)this, this.sourceTileEntity, entity, this.teleportDestination);
                }
                if (!hasPassengers || entity == teleportedEntity) continue;
                for (Map.Entry<Entity, Entity> riderSet : riderMap.entrySet()) {
                    if (riderSet.getValue() != entity) continue;
                    riderSet.setValue(teleportedEntity);
                }
            }
            for (Map.Entry entry : riderMap.entrySet()) {
                Entity rider = (Entity)entry.getKey();
                Entity entityRidden = (Entity)entry.getValue();
                TeleportationHelper.remountRider(rider, entityRidden);
            }
            this.setDeadNextUpdate = true;
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74757_a("SetDeadNextUpdate", this.setDeadNextUpdate);
        if (this.sourceTileEntity != null) {
            compound.func_74772_a("SourceTileEntityPos", this.sourceTileEntity.func_174877_v().func_177986_g());
        }
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.setDeadNextUpdate = compound.func_74767_n("SetDeadNextUpdate");
        if (compound.func_74764_b("SourceTileEntityPos")) {
            BlockPos sourceTileEntityPos = BlockPos.func_177969_a((long)compound.func_74763_f("SourceTileEntityPos"));
            this.sourceTileEntity = this.field_70170_p.func_175625_s(sourceTileEntityPos);
        }
        super.func_70037_a(compound);
    }
}

