/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.bensam.tpworks.capability.teleportation.ITeleportationHandler;
import org.bensam.tpworks.capability.teleportation.TeleportDestination;
import org.bensam.tpworks.capability.teleportation.TeleportationHandlerCapabilityProvider;
import org.bensam.tpworks.capability.teleportation.TeleportationHelper;
import org.bensam.tpworks.util.ModConfig;
import org.bensam.tpworks.util.ModSetup;

public class ItemTeleportationBow
extends ItemBow {
    public ItemTeleportationBow(@Nonnull String name) {
        ModSetup.setRegistryNames(this, name);
        ModSetup.setCreativeTab(this);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity == null) {
                    return 0.0f;
                }
                return !(entity.func_184607_cu().func_77973_b() instanceof ItemBow) ? 0.0f : (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f;
            }
        });
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        Item repairIngredient = repair.func_77973_b();
        return repairIngredient == Items.field_151079_bi || repairIngredient == Items.field_151061_bv || repairIngredient == Items.field_151100_aR && repair.func_77960_j() == 4;
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public boolean hasAmmo(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND)) || this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return true;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        ITeleportationHandler playerTeleportationHandler;
        if (!entityLiving.field_70170_p.field_72995_K && (playerTeleportationHandler = (ITeleportationHandler)entityLiving.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null)) != null && entityLiving.func_70093_af()) {
            playerTeleportationHandler.setSpecialDestination(null);
            entityLiving.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.destination.cleared.confirmation", new Object[0]));
            return true;
        }
        return super.onEntitySwing(entityLiving, stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ITeleportationHandler playerTeleportationHandler = (ITeleportationHandler)player.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null);
        if (playerTeleportationHandler != null) {
            if (player.func_70093_af()) {
                if (!world.field_72995_K) {
                    TeleportDestination destination = playerTeleportationHandler.getSpecialDestination();
                    TeleportDestination nextDestination = null;
                    nextDestination = ModConfig.equippedItemSettings.bowDestinationsIncludeRails ? TeleportationHelper.getNextDestination((Entity)player, null, destination, null) : TeleportationHelper.getNextDestination((Entity)player, TeleportDestination.DestinationType.BEACON, destination, null);
                    if (nextDestination != null) {
                        playerTeleportationHandler.setSpecialDestination(nextDestination);
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.destination.set.confirmation", new Object[]{TextFormatting.DARK_GREEN + nextDestination.friendlyName}));
                    } else if (destination == null) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.destination.none_available", new Object[0]));
                    } else {
                        playerTeleportationHandler.setSpecialDestination(null);
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.destination.cleared.confirmation", new Object[0]));
                    }
                }
                return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
            }
            if (!player.field_71075_bZ.field_75098_d && !this.hasAmmo(player)) {
                if (!world.field_72995_K) {
                    TeleportDestination destination = playerTeleportationHandler.getSpecialDestination();
                    if (destination != null) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.active.confirmation", new Object[]{TextFormatting.DARK_GREEN + destination.friendlyName}));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.destination.no_destination", new Object[0]));
                    }
                }
                return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entityLiving, int timeLeft) {
        int useTimeElapsed;
        if (!entityLiving.func_70093_af() && (useTimeElapsed = this.func_77626_a(stack) - timeLeft) <= 5) {
            ITeleportationHandler playerTeleportationHandler;
            if (!world.field_72995_K && (playerTeleportationHandler = (ITeleportationHandler)entityLiving.getCapability(TeleportationHandlerCapabilityProvider.TELEPORTATION_CAPABILITY, null)) != null) {
                TeleportDestination destination = playerTeleportationHandler.getSpecialDestination();
                if (destination != null) {
                    entityLiving.func_145747_a((ITextComponent)new TextComponentTranslation("command.td.active.confirmation", new Object[]{TextFormatting.DARK_GREEN + destination.friendlyName}));
                } else {
                    entityLiving.func_145747_a((ITextComponent)new TextComponentTranslation("message.td.destination.no_destination", new Object[0]));
                }
            }
            return;
        }
        super.func_77615_a(stack, world, entityLiving, timeLeft);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        String sneakBind = Minecraft.func_71410_x().field_71474_y.field_74311_E.getDisplayName();
        String attackBind = Minecraft.func_71410_x().field_71474_y.field_74312_F.getDisplayName();
        String useItemBind = Minecraft.func_71410_x().field_71474_y.field_74313_G.getDisplayName();
        tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"item.teleportation_bow.tipLine1", (Object[])new Object[0]));
        tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"item.teleportation_bow.tipLine2", (Object[])new Object[0]));
        tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"item.teleportation_bow.tipLine3", (Object[])new Object[]{sneakBind, useItemBind}));
        tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"item.teleportation_bow.tipLine4", (Object[])new Object[]{sneakBind, attackBind}));
    }
}

