/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.util;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="tpworks", category="")
public final class ModConfig {
    private static final String LANG_PREFIX = "config.tpworks";
    @Config.Name(value="Equipped Item Settings")
    @Config.LangKey(value="config.tpworks.equipped_item")
    public static EquippedItemSettings equippedItemSettings = new EquippedItemSettings();
    @Config.Name(value="Splash Potion Settings")
    @Config.LangKey(value="config.tpworks.splash_potion")
    public static SplashPotionSettings splashPotionSettings = new SplashPotionSettings();
    @Config.Name(value="Teleport Block Settings")
    @Config.LangKey(value="config.tpworks.teleport_block")
    public static TeleportBlockSettings teleportBlockSettings = new TeleportBlockSettings();
    @Config.Name(value="World Settings")
    @Config.LangKey(value="config.tpworks.world")
    public static WorldSettings worldSettings = new WorldSettings();

    @Mod.EventBusSubscriber(modid="tpworks")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("tpworks")) {
                ConfigManager.sync((String)"tpworks", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class WorldSettings {
        @Config.Comment(value={"Add basic Teleportation items to Spawn Chest", "Must be set BEFORE generating a new world"})
        @Config.LangKey(value="config.tpworks.world.spawn_chest")
        @Config.RequiresWorldRestart
        public boolean addItemsToSpawnChest = false;
        @Config.Comment(value={"HARD difficulty requires an Eye of Ender instead of an Ender Pearl in wands, bows, and beacons"})
        @Config.LangKey(value="config.tpworks.world.crafting_difficulty")
        public CraftingDifficulty craftingDifficulty = CraftingDifficulty.NORMAL;

        public static enum CraftingDifficulty {
            NORMAL,
            HARD;

        }
    }

    public static class TeleportBlockSettings {
        @Config.Comment(value={"Cooldown time (in ticks) after a Teleport Beacon receives an entity before it can teleport an entity"})
        @Config.LangKey(value="config.tpworks.teleport_block.beacon_cooldown_ticks")
        @Config.RangeInt(min=0, max=100)
        public int beaconCooldownTime = 30;
        @Config.Comment(value={"When cycling through Teleport Beacon destinations, include saved Teleport Rails"})
        @Config.LangKey(value="config.tpworks.teleport_block.beacon_destinations_include_rails")
        public boolean beaconDestinationsIncludeRails = false;
        @Config.Comment(value={"When cycling through Teleport Beacon destinations, include same beacon as an option"})
        @Config.LangKey(value="config.tpworks.teleport_block.beacon_destinations_include_self")
        public boolean beaconDestinationsIncludeSelf = false;
        @Config.Comment(value={"Cooldown time (in ticks) after a Teleport Rail teleports a minecart, during which it will not teleport another cart"})
        @Config.LangKey(value="config.tpworks.teleport_block.rail_cooldown_ticks")
        @Config.RangeInt(min=0, max=20)
        public int railCooldownTime = 5;
        @Config.Comment(value={"When cycling through Teleport Rail destinations, include saved Teleport Beacons"})
        @Config.LangKey(value="config.tpworks.teleport_block.rail_destinations_include_beacons")
        public boolean railDestinationsIncludeBeacons = false;
    }

    public static class SplashPotionSettings {
        @Config.Comment(value={"Teleport any boats within the potion splash radius"})
        @Config.LangKey(value="config.tpworks.splash_potion.teleport_boats")
        public boolean teleportBoats = true;
        @Config.Comment(value={"Teleport boats only when they have passengers who can also be teleported"})
        @Config.LangKey(value="config.tpworks.splash_potion.teleport_boats_when_ridden")
        public boolean teleportBoatsOnlyWhenRiddenByTeleportableEntity = true;
        @Config.Comment(value={"Teleport any dropped items within the potion splash radius"})
        @Config.LangKey(value="config.tpworks.splash_potion.teleport_dropped_items")
        public boolean teleportDroppedItems = true;
        @Config.Comment(value={"Teleport any hostile creatures (mobs) within the potion splash radius"})
        @Config.LangKey(value="config.tpworks.splash_potion.teleport_hostiles")
        public boolean teleportHostileCreatures = true;
        @Config.Comment(value={"Teleport any minecarts within the potion splash radius"})
        @Config.LangKey(value="config.tpworks.splash_potion.teleport_minecarts")
        public boolean teleportMinecarts = true;
        @Config.Comment(value={"Teleport minecarts only when they have passengers who can also be teleported"})
        @Config.LangKey(value="config.tpworks.splash_potion.teleport_minecarts_when_ridden")
        public boolean teleportMinecartsOnlyWhenRiddenByTeleportableEntity = true;
        @Config.Comment(value={"Teleport any passive creatures within the potion splash radius"})
        @Config.LangKey(value="config.tpworks.splash_potion.teleport_passives")
        public boolean teleportPassiveCreatures = true;
        @Config.Comment(value={"Teleport thrower if within the potion splash radius"})
        @Config.LangKey(value="config.tpworks.splash_potion.teleport_player_thrower")
        public boolean teleportPlayerThrower = true;
        @Config.Comment(value={"Teleport other players within the potion splash radius"})
        @Config.LangKey(value="config.tpworks.splash_potion.teleport_players_other")
        public boolean teleportPlayersOther = true;
        @Config.Comment(value={"Teleport any projectiles within the potion splash radius"})
        @Config.LangKey(value="config.tpworks.splash_potion.teleport_projectiles")
        public boolean teleportProjectiles = false;
        @Config.Comment(value={"Teleport any lit TNT within the potion splash radius"})
        @Config.LangKey(value="config.tpworks.splash_potion.teleport_tnt_lit")
        public boolean teleportTNTLit = false;
    }

    public static class EquippedItemSettings {
        @Config.Comment(value={"When cycling through Bow of Teleportation destinations, include saved Teleport Rails"})
        @Config.LangKey(value="config.tpworks.equipped_item.bow_destinations_include_rails")
        public boolean bowDestinationsIncludeRails = false;
        @Config.Comment(value={"Wand of Teleportation also teleports boats that a player is riding"})
        @Config.LangKey(value="config.tpworks.equipped_item.wand_teleports_boats_ridden")
        public boolean wandTeleportsBoatsRidden = true;
        @Config.Comment(value={"Wand of Teleportation also teleports creatures that a player is riding"})
        @Config.LangKey(value="config.tpworks.equipped_item.wand_teleports_creatures_ridden")
        public boolean wandTeleportsCreaturesRidden = true;
        @Config.Comment(value={"Wand of Teleportation also teleports minecarts that a player is riding"})
        @Config.LangKey(value="config.tpworks.equipped_item.wand_teleports_minecarts_ridden")
        public boolean wandTeleportsMinecartsRidden = true;
    }
}

