/*
 * Decompiled with CFR 0.152.
 */
package org.bensam.tpworks.util;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public final class ModUtil {
    public static final Random RANDOM = new Random();

    public static String getDimensionName(int dimension) {
        return DimensionManager.getProviderType((int)dimension).toString();
    }

    public static String getRandomLetter() {
        return Character.toString((char)(65 + RANDOM.nextInt(26)));
    }

    public static double getEntitySpeed(Entity entity) {
        return MathHelper.func_76133_a((double)ModUtil.getEntitySpeedSq(entity));
    }

    public static double getEntitySpeedSq(Entity entity) {
        return entity.field_70159_w * entity.field_70159_w + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y;
    }

    public static HashMap<Entity, Entity> getRiders(List<Entity> list) {
        HashMap<Entity, Entity> riderMap = new HashMap<Entity, Entity>();
        for (Entity entity : list) {
            if (!entity.func_184218_aH()) continue;
            riderMap.put(entity, entity.func_184187_bx());
        }
        return riderMap;
    }

    public static float getRotationFromFacing(EnumFacing facing) {
        switch (facing) {
            case UP: {
                return -90.0f;
            }
            case DOWN: {
                return 90.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case NORTH: {
                return 180.0f;
            }
            case EAST: {
                return 270.0f;
            }
        }
        return 0.0f;
    }

    public static WorldServer getWorldServerForDimension(int dimension) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
    }
}

