/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;

public class CursorBox {
    private ArrayList<String> strings;
    private String language;
    private String fullCode = "";
    private Object[] parameters;
    private String formatting;
    private int boxWidth = 150;
    private static final int color = -939524096;
    private boolean customLines;

    public CursorBox(String code) {
        this(code, "", new Object[0]);
    }

    public CursorBox(String code, String formatting, Object ... parameters) {
        this.fullCode = code;
        this.parameters = parameters;
        this.formatting = formatting;
    }

    public CursorBox(int size) {
        this.strings = new ArrayList();
        for (int i = 0; i < size; ++i) {
            this.strings.add("");
        }
        this.customLines = true;
    }

    private String currentLanguage() {
        return Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
    }

    public void createLines(String text) {
        try {
            this.language = this.currentLanguage();
        }
        catch (NullPointerException e) {
            this.language = "en_us";
        }
        this.strings = new ArrayList();
        String[] words = text.split(" ");
        int spaceWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(" ");
        StringBuilder line = new StringBuilder();
        int width = 0;
        for (int i = 0; i < words.length; ++i) {
            int wordWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(words[i]);
            if (width == 0 && wordWidth > this.boxWidth - 15) {
                this.boxWidth = wordWidth + 15;
            }
            if (!words[i].equals("\\n") && width + wordWidth <= this.boxWidth - 15) {
                width += spaceWidth + wordWidth;
                line.append(words[i]).append(" ");
            } else {
                this.strings.add(this.formatting + line.toString());
                line.delete(0, line.length());
                width = 0;
                if (!words[i].equals("\\n")) {
                    --i;
                }
            }
            if (i != words.length - 1) continue;
            this.strings.add(this.formatting + line.toString());
        }
    }

    public String getString(int line) {
        return this.strings.get(line);
    }

    public void drawBox(int x, int y, int width, int height) {
        try {
            if (!(this.customLines || this.language != null && this.language.equals(this.currentLanguage()))) {
                this.createLines(I18n.func_135052_a((String)this.fullCode, (Object[])this.parameters));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int fix = x + this.boxWidth > width ? x + this.boxWidth - width : 0;
        int h = 5 + this.strings.size() * 10 + 5;
        int fiy = y + h > height ? y + h - height : 0;
        Gui.func_73734_a((int)(x - fix), (int)(y - fiy), (int)(x + this.boxWidth - fix), (int)(y + h - fiy), (int)-939524096);
        for (int i = 0; i < this.strings.size(); ++i) {
            String s = this.getString(i);
            Minecraft.func_71410_x().field_71466_p.func_78276_b("\u00a7f" + s, x + 10 - fix, y + 5 + 10 * i - fiy, 0xFFFFFF);
        }
    }

    public CursorBox withWidth(int boxWidth) {
        this.boxWidth = boxWidth;
        return this;
    }
}

