/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.EnumDifficulty;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.settings.ModSettings;

public class MinimapRadar {
    public static final int radarPlayers = -1;
    public static final int radarShadow = -16777216;
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private ArrayList<Entity> players;
    private ArrayList<Entity> living;
    private ArrayList<Entity> livingTamed;
    private ArrayList<Entity> hostile;
    private ArrayList<Entity> items;
    private ArrayList<Entity> entities;
    private ArrayList<Entity> playersOtherTeams;

    public MinimapRadar(IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.players = new ArrayList();
        this.living = new ArrayList();
        this.livingTamed = new ArrayList();
        this.hostile = new ArrayList();
        this.items = new ArrayList();
        this.entities = new ArrayList();
        this.playersOtherTeams = new ArrayList();
    }

    public int getType(Entity e, EntityPlayer p, boolean ignoreTamed) {
        if (e instanceof EntityPlayer) {
            if (p.func_96124_cp() != ((EntityLivingBase)e).func_96124_cp()) {
                return 6;
            }
            return 1;
        }
        if (!ignoreTamed && e instanceof EntityTameable && ((EntityTameable)e).func_70909_n()) {
            return 7;
        }
        if (e.getEntityData().func_74764_b("hostileMinimap") ? e.getEntityData().func_74767_n("hostileMinimap") : Minecraft.func_71410_x().field_71441_e.func_175659_aa() != EnumDifficulty.PEACEFUL && !this.hostileException(e) && (e instanceof EntityMob || e instanceof IMob || e.func_184176_by() == SoundCategory.HOSTILE)) {
            return 2;
        }
        if (e instanceof EntityLiving) {
            return 3;
        }
        if (e instanceof EntityItem) {
            return 4;
        }
        return 0;
    }

    public void updateRadar(WorldClient world, EntityPlayer p, Entity renderEntity) {
        this.players.clear();
        this.hostile.clear();
        this.living.clear();
        this.items.clear();
        this.entities.clear();
        this.playersOtherTeams.clear();
        this.livingTamed.clear();
        if (p.func_70644_a(Effects.NO_RADAR)) {
            return;
        }
        List worldEntities = world.field_72996_f;
        ModSettings settings = this.modMain.getSettings();
        for (Entity e : worldEntities) {
            try {
                int type = this.getType(e, p, false);
                if (type == 1 ? e != p && !settings.getShowPlayers() : (type == 2 ? !settings.getShowHostile() : (type == 3 ? !settings.getShowMobs() : (type == 4 ? !settings.getShowItems() : (type == 6 ? !settings.getShowOtherTeam() : (type == 7 ? !settings.getShowTamedMobs() : !settings.getShowOther() || e instanceof EntityItemFrame && !settings.itemFramesOnRadar)))))) continue;
                double offx = e.field_70165_t - renderEntity.field_70165_t;
                double offy = e.field_70161_v - renderEntity.field_70161_v;
                double offh = renderEntity.field_70163_u - e.field_70163_u;
                double offheight2 = offh * offh;
                double offx2 = offx * offx;
                double offy2 = offy * offy;
                double maxDistance = 50625.0 / (this.minimapSession.getMinimapProcessor().getMinimapZoom() * this.minimapSession.getMinimapProcessor().getMinimapZoom());
                if (offx2 > maxDistance || offy2 > maxDistance || offheight2 > (double)(settings.heightLimit * settings.heightLimit)) continue;
                ArrayList<Entity> typeList = this.entities;
                switch (type) {
                    case 1: {
                        typeList = this.players;
                        break;
                    }
                    case 2: {
                        typeList = this.hostile;
                        break;
                    }
                    case 3: {
                        typeList = this.living;
                        break;
                    }
                    case 4: {
                        typeList = this.items;
                        break;
                    }
                    case 6: {
                        typeList = this.playersOtherTeams;
                        break;
                    }
                    case 7: {
                        typeList = this.livingTamed;
                    }
                }
                if (settings.entityAmount != 0 && typeList.size() >= 100 * settings.entityAmount) continue;
                typeList.add(e);
            }
            catch (Exception ex) {}
        }
    }

    private boolean hostileException(Entity e) {
        return false;
    }

    public double getEntityX(Entity e, float partial) {
        return e.field_70142_S + (e.field_70165_t - e.field_70142_S) * (double)partial;
    }

    public double getEntityZ(Entity e, float partial) {
        return e.field_70136_U + (e.field_70161_v - e.field_70136_U) * (double)partial;
    }

    public boolean shouldRenderEntity(Entity e) {
        return !e.func_70093_af() && !e.func_82150_aj();
    }

    public int getPlayerTeamColour(EntityPlayer p) {
        int teamColour = -1;
        if (p.func_96124_cp() != null && ((ScorePlayerTeam)p.func_96124_cp()).func_96668_e() != null && ((ScorePlayerTeam)p.func_96124_cp()).func_96668_e().length() >= 2) {
            String prefix = ((ScorePlayerTeam)p.func_96124_cp()).func_96668_e();
            try {
                teamColour = Minecraft.func_71410_x().field_71466_p.func_175064_b(prefix.charAt(prefix.length() - 1));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return teamColour;
    }

    public int getEntityColour(EntityPlayer p, Entity e, float offh, boolean cave, ModSettings settings) {
        int entityTeamColour;
        int type = this.getType(e, p, settings.tamedMobsColor == -1);
        if (type == 6 && settings.otherTeamColor == -1) {
            type = 1;
        }
        int color = type == 1 ? (settings.playersColor != -1 ? ModSettings.COLORS[settings.playersColor] : ((entityTeamColour = this.getPlayerTeamColour((EntityPlayer)e)) != -1 ? entityTeamColour : -1)) : (type == 2 ? ModSettings.COLORS[settings.hostileColor] : (type == 3 ? ModSettings.COLORS[settings.mobsColor] : (type == 4 ? ModSettings.COLORS[settings.itemsColor] : (type == 6 ? ModSettings.COLORS[settings.otherTeamColor] : (type == 7 ? ModSettings.COLORS[settings.tamedMobsColor] : ModSettings.COLORS[settings.otherColor])))));
        float brightness = this.getEntityBrightness(offh, settings);
        if (brightness < 1.0f) {
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int a = 255;
            if (cave) {
                a = (int)((float)a * brightness);
            } else {
                r = (int)((float)r * brightness);
                g = (int)((float)g * brightness);
                b = (int)((float)b * brightness);
            }
            color = a << 24 | r << 16 | g << 8 | b;
        }
        return color;
    }

    public float getEntityBrightness(float offh, ModSettings settings) {
        float level = (float)settings.heightLimit - offh;
        if (level < 0.0f) {
            level = 0.0f;
        }
        float brightness = 1.0f;
        if (level <= (float)(settings.heightLimit / 2) && settings.showEntityHeight) {
            brightness = 0.25f + 0.5f * level / (float)settings.heightLimit;
        }
        return brightness;
    }

    public Iterator<Entity> getEntitiesIterator() {
        return this.entities.iterator();
    }

    public Iterator<Entity> getItemsIterator() {
        return this.items.iterator();
    }

    public Iterator<Entity> getLivingIterator() {
        return this.living.iterator();
    }

    public Iterator<Entity> getLivingTamedIterator() {
        return this.livingTamed.iterator();
    }

    public Iterator<Entity> getHostileIterator() {
        return this.hostile.iterator();
    }

    public Iterator<Entity> getPlayersIterator() {
        return this.players.iterator();
    }

    public Iterator<Entity> getPlayersOtherTeamsIterator() {
        return this.playersOtherTeams.iterator();
    }
}

