/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.MinimapSafeModeRenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;

public abstract class MinimapRenderer {
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    protected IXaeroMinimap modMain;
    protected Minecraft mc;
    protected MinimapInterface minimapInterface;
    protected MinimapRendererHelper helper;
    protected WaypointsGuiRenderer waypointsGuiRenderer;
    private int lastMinimapSize;
    private ArrayList<String> underText;
    protected double zoom = 1.0;
    private BlockPos.MutableBlockPos mutableBlockPos;

    public MinimapRenderer(IXaeroMinimap modMain, Minecraft mc, WaypointsGuiRenderer waypointsGuiRenderer, MinimapInterface minimapInterface) {
        this.modMain = modMain;
        this.mc = mc;
        this.waypointsGuiRenderer = waypointsGuiRenderer;
        this.minimapInterface = minimapInterface;
        this.underText = new ArrayList();
        this.helper = new MinimapRendererHelper();
        this.mutableBlockPos = new BlockPos.MutableBlockPos();
    }

    public float getEntityYaw(Entity e, float partial) {
        if (e == this.mc.field_71439_g) {
            return e.field_70177_z;
        }
        if (e instanceof EntityLivingBase) {
            return ((EntityLivingBase)e).field_70758_at + (((EntityLivingBase)e).field_70759_as - ((EntityLivingBase)e).field_70758_at) * partial;
        }
        return e.field_70126_B + (e.field_70177_z - e.field_70126_B) * partial;
    }

    public double getRenderAngle(Entity player, boolean lockedNorth, float partial) {
        if (lockedNorth) {
            return 90.0;
        }
        return this.getActualAngle(player, partial);
    }

    public double getActualAngle(Entity player, float partial) {
        double angle;
        double rotation = this.getEntityYaw(player, partial);
        if (rotation < 0.0 || rotation > 360.0) {
            rotation %= 360.0;
        }
        if ((angle = 270.0 - rotation) < 0.0 || angle > 360.0) {
            angle %= 360.0;
        }
        return angle;
    }

    protected abstract void renderChunks(XaeroMinimapSession var1, MinimapProcessor var2, int var3, int var4, float var5, float var6, int var7, boolean var8, boolean var9, int var10, double var11, double var13, boolean var15, boolean var16, ModSettings var17);

    public void renderMinimap(XaeroMinimapSession minimapSession, MinimapProcessor minimap, int x, int y, int width, int height, int scale, int size, float partial) {
        int specW;
        int frameTextureX;
        boolean renderFrame;
        ModSettings settings = this.modMain.getSettings();
        if (settings.getMinimapSize(scale) != this.lastMinimapSize) {
            this.lastMinimapSize = settings.getMinimapSize(scale);
            minimap.setToResetImage(true);
        }
        ArrayList<String> underText = this.underText;
        int mapSize = minimapSession.getMinimapProcessor().getMinimapSize(scale);
        int bufferSize = minimapSession.getMinimapProcessor().getMinimapBufferSize(mapSize);
        if (this.minimapInterface.usingFBO()) {
            bufferSize = minimap.getFBOBufferSize();
        }
        float minimapScale = settings.getMinimapScale(scale);
        float mapScale = (float)scale / minimapScale;
        minimap.updateZoom();
        this.zoom = minimap.getMinimapZoom();
        RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187425_g((int)3317, (int)4);
        GlStateManager.func_187425_g((int)3316, (int)0);
        GlStateManager.func_187425_g((int)3315, (int)0);
        GlStateManager.func_187425_g((int)3314, (int)0);
        float sizeFix = (float)bufferSize / 512.0f;
        int shape = settings.minimapShape;
        boolean lockedNorth = settings.getLockNorth(mapSize / 2, shape);
        double angle = Math.toRadians(this.getRenderAngle(this.mc.func_175606_aa(), lockedNorth, partial));
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        boolean useWorldMap = this.modMain.getSupportMods().shouldUseWorldMapChunks() && minimap.getMinimapWriter().getLoadedCaving() == -1 && minimap.getMinimapWriter().loadedLightOverlayType <= 0;
        int lightLevel = (int)((1.0f - Math.min(1.0f, this.getSunBrightness())) * (float)(minimap.getMinimapWriter().getLoadedLevels() - 1));
        boolean cave = !useWorldMap && minimap.getMinimapWriter().getLoadedCaving() != -1;
        boolean circleShape = shape == 1;
        this.renderChunks(minimapSession, minimap, mapSize, bufferSize, sizeFix, partial, lightLevel, useWorldMap, lockedNorth, shape, ps, pc, cave, circleShape, settings);
        if (this.minimapInterface.usingFBO()) {
            sizeFix = 1.0f;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glScalef((float)(1.0f / mapScale), (float)(1.0f / mapScale), (float)1.0f);
        int scaledX = (int)((float)x * mapScale);
        int scaledY = (int)((float)y * mapScale);
        int minimapFrameSize = (int)((float)(mapSize / 2) / sizeFix);
        int circleSides = Math.max(32, (int)Math.ceil(Math.PI * (double)(minimapFrameSize + 8) / 8.0));
        if (!circleShape) {
            this.helper.drawMyTexturedModalRect((int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, minimapFrameSize, 256.0f);
        } else {
            this.helper.drawTexturedElipseInsideRectangle(circleSides, (int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 256 - minimapFrameSize, minimapFrameSize, 256.0f);
        }
        if (!this.minimapInterface.usingFBO()) {
            GL11.glScalef((float)(1.0f / sizeFix), (float)(1.0f / sizeFix), (float)1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        int frameType = settings.minimapFrame;
        boolean bl = renderFrame = frameType < ModSettings.FRAME_OPTIONS.length - 1;
        int n = frameType == 0 ? 0 : (frameTextureX = frameType == 1 ? 76 : 93);
        if (frameType > 0) {
            int frameColor = ModSettings.COLORS[settings.minimapFrameColor];
            GlStateManager.func_179131_c((float)((float)(frameColor >> 16 & 0xFF) / 255.0f), (float)((float)(frameColor >> 8 & 0xFF) / 255.0f), (float)((float)(frameColor & 0xFF) / 255.0f), (float)1.0f);
        }
        if (renderFrame && !circleShape) {
            int rightCornerStartX = scaledX + 9 + mapSize / 2 + 4 - 17;
            int bottomCornerStartY = scaledY + 9 + mapSize / 2 + 4 - 15;
            this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, scaledY + 9 - 4, frameTextureX, 0, 17, 15);
            this.mc.field_71456_v.func_73729_b(rightCornerStartX, scaledY + 9 - 4, frameTextureX, 15, 17, 15);
            this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, bottomCornerStartY, frameTextureX, 30, 17, 15);
            this.mc.field_71456_v.func_73729_b(rightCornerStartX, bottomCornerStartY, frameTextureX, 45, 17, 15);
            int horLineStartX = scaledX + 9 - 4 + 17;
            int horLineWidth = rightCornerStartX - horLineStartX;
            int horLineLength = (int)Math.ceil((double)horLineWidth / 16.0);
            for (int i = 0; i < horLineLength; ++i) {
                int lineX = scaledX + 9 - 4 + 17 + i * 16;
                int lineW = 16;
                if (i == horLineLength - 1 && lineX + lineW > rightCornerStartX) {
                    lineW = rightCornerStartX - lineX;
                }
                this.mc.field_71456_v.func_73729_b(lineX, scaledY + 9 - 4, frameTextureX, 60, lineW, 4);
                this.mc.field_71456_v.func_73729_b(lineX, scaledY + 9 - 4 + mapSize / 2 + 9 - 5, frameTextureX, 64, lineW, 4);
            }
            int verLineStartY = scaledY + 9 - 4 + 15;
            int verLineHeight = bottomCornerStartY - verLineStartY;
            int vertLineLength = (int)Math.ceil((double)verLineHeight / 5.0);
            for (int i = 0; i < vertLineLength; ++i) {
                int lineY = scaledY + 9 - 4 + 15 + i * 5;
                int lineH = 5;
                if (i == vertLineLength - 1 && lineY + lineH > bottomCornerStartY) {
                    lineH = bottomCornerStartY - lineY;
                }
                this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4, lineY, frameTextureX, 68, 4, lineH);
                this.mc.field_71456_v.func_73729_b(scaledX + 9 - 4 + mapSize / 2 + 9 - 5, lineY, frameTextureX, 73, 4, lineH);
            }
        } else if (renderFrame) {
            this.helper.drawTexturedElipseInsideRectangleFrame(circleSides, 4.0f, scaledX + 9, scaledY + 9, frameTextureX + 1, 60, mapSize / 2, 4.0f, 256.0f);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(scaledX + 9), (float)(scaledY + 9), (float)0.0f);
        GlStateManager.func_179152_a((float)(1.0f / minimapScale), (float)(1.0f / minimapScale), (float)1.0f);
        int halfFrame = (int)((float)mapSize * minimapScale / 2.0f / 2.0f);
        GlStateManager.func_179109_b((float)halfFrame, (float)halfFrame, (float)0.0f);
        int specH = specW = halfFrame + (int)(3.0f * minimapScale);
        double playerX = minimap.getEntityRadar().getEntityX(this.mc.func_175606_aa(), partial);
        double playerZ = minimap.getEntityRadar().getEntityZ(this.mc.func_175606_aa(), partial);
        this.waypointsGuiRenderer.render(minimapSession, playerX, playerZ, specW, specH, ps, pc, partial, this.zoom * (double)minimapScale / 2.0, circleShape, minimapScale, this instanceof MinimapSafeModeRenderer);
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        if (settings.mainEntityAs == 0 && !lockedNorth) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(scaledX + 9), (float)(scaledY + 9), (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179109_b((float)(mapSize / 2), (float)(mapSize / 2), (float)0.0f);
            GlStateManager.func_179120_a((int)775, (int)0, (int)1, (int)0);
            this.helper.drawMyColoredRect(-5.0f, -1.0f, 5.0f, 1.0f);
            this.helper.drawMyColoredRect(-1.0f, 3.0f, 1.0f, 5.0f);
            this.helper.drawMyColoredRect(-1.0f, -5.0f, 1.0f, -3.0f);
            GlStateManager.func_179112_b((int)770, (int)771);
            int crosshairColor = minimap.getEntityRadar().getEntityColour((EntityPlayer)this.mc.field_71439_g, this.mc.func_175606_aa(), 0.0f, false, settings);
            GlStateManager.func_179131_c((float)((float)(crosshairColor >> 16 & 0xFF) / 255.0f), (float)((float)(crosshairColor >> 8 & 0xFF) / 255.0f), (float)((float)(crosshairColor & 0xFF) / 255.0f), (float)1.0f);
            this.helper.drawMyColoredRect(1.0f, -1.0f, 3.0f, 1.0f);
            this.helper.drawMyColoredRect(-3.0f, -1.0f, -1.0f, 1.0f);
            this.helper.drawMyColoredRect(-1.0f, 1.0f, 1.0f, 3.0f);
            this.helper.drawMyColoredRect(-1.0f, -3.0f, 1.0f, -1.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            GlStateManager.func_179147_l();
            GlStateManager.func_179121_F();
        }
        this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        if (lockedNorth || settings.mainEntityAs == 2) {
            float a;
            float b;
            float g;
            float r;
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            double arrowX = 2 * scaledX + 18 + mapSize / 2;
            double arrowY = 2 * scaledY + 18 + mapSize / 2;
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            float arrowAngle = lockedNorth ? this.getEntityYaw(this.mc.func_175606_aa(), partial) : 180.0f;
            float arrowOpacity = (float)settings.playerArrowOpacity / 100.0f;
            if (arrowOpacity == 1.0f) {
                this.drawArrow(arrowAngle, arrowX, arrowY + 1.0, 0.0f, 0.0f, 0.0f, 0.5f, settings);
            }
            if (settings.arrowColour != -1) {
                float[] c = settings.arrowColours[settings.arrowColour];
                r = c[0];
                g = c[1];
                b = c[2];
                a = c[3];
            } else {
                int rgb = minimap.getEntityRadar().getPlayerTeamColour((EntityPlayer)this.mc.field_71439_g);
                if (rgb != -1) {
                    r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                    g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                    b = (float)(rgb & 0xFF) / 255.0f;
                    a = 1.0f;
                } else {
                    float[] c = settings.arrowColours[0];
                    r = c[0];
                    g = c[1];
                    b = c[2];
                    a = c[3];
                }
            }
            this.drawArrow(arrowAngle, arrowX, arrowY, r, g, b, a *= arrowOpacity, settings);
            GL11.glPopMatrix();
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        if (settings.getShowCoords()) {
            int interfaceSize = size;
            String coords = OptimizedMath.myFloor(this.mc.func_175606_aa().field_70165_t) + ", " + OptimizedMath.myFloor(this.mc.func_175606_aa().field_70163_u) + ", " + OptimizedMath.myFloor(this.mc.func_175606_aa().field_70161_v);
            if (this.mc.field_71466_p.func_78256_a(coords) >= interfaceSize) {
                String stringLevel = "" + OptimizedMath.myFloor(this.mc.func_175606_aa().field_70163_u);
                coords = OptimizedMath.myFloor(this.mc.func_175606_aa().field_70165_t) + ", " + OptimizedMath.myFloor(this.mc.func_175606_aa().field_70161_v);
                underText.add(coords);
                underText.add(stringLevel);
            } else {
                underText.add(coords);
            }
        }
        int playerBlockX = OptimizedMath.myFloor(this.mc.func_175606_aa().field_70165_t);
        int playerBlockY = OptimizedMath.myFloor(this.mc.func_175606_aa().func_174813_aQ().field_72338_b);
        int playerBlockZ = OptimizedMath.myFloor(this.mc.func_175606_aa().field_70161_v);
        BlockPos.MutableBlockPos pos = this.mutableBlockPos.func_181079_c(playerBlockX, playerBlockY, playerBlockZ);
        Chunk chunk = this.mc.field_71441_e.func_175726_f((BlockPos)pos);
        if (settings.showBiome) {
            String biomeText;
            Biome biome = chunk.func_177411_a((BlockPos)pos, this.mc.field_71441_e.func_72959_q());
            String string = biomeText = biome == null ? "Unknown Biome" : biome.func_185359_l();
            if (this.mc.field_71466_p.func_78256_a(biomeText) <= size) {
                underText.add(biomeText);
            } else {
                String[] biomeWords = biomeText.split(" ");
                StringBuilder lineBuilder = new StringBuilder();
                for (int i = 0; i < biomeWords.length; ++i) {
                    int lineWidth;
                    int wordStart = lineBuilder.length();
                    if (i > 0) {
                        lineBuilder.append(' ');
                    }
                    lineBuilder.append(biomeWords[i]);
                    if (i == 0 || (lineWidth = this.mc.field_71466_p.func_78256_a(lineBuilder.toString())) <= size) continue;
                    lineBuilder.delete(wordStart, lineBuilder.length());
                    underText.add(lineBuilder.toString());
                    lineBuilder.delete(0, lineBuilder.length());
                    lineBuilder.append(biomeWords[i]);
                }
                underText.add(lineBuilder.toString());
            }
        }
        if (settings.showLightLevel > 0) {
            boolean lightFetchable;
            int playerBlockLightLevel = 0;
            int playerSkyLightLevel = 0;
            boolean bl2 = lightFetchable = playerBlockY >= 0 && playerBlockY < 256;
            if (settings.showLightLevel == 1 || settings.showLightLevel == 3) {
                int n2 = playerBlockLightLevel = lightFetchable ? chunk.func_177413_a(EnumSkyBlock.BLOCK, (BlockPos)pos) : 0;
            }
            if (settings.showLightLevel == 2 || settings.showLightLevel == 3) {
                playerSkyLightLevel = lightFetchable ? chunk.func_177413_a(EnumSkyBlock.SKY, (BlockPos)pos) : 15;
            }
            underText.add(String.format("Light: %d", Math.max(playerBlockLightLevel, playerSkyLightLevel)));
        }
        if (settings.showTime != 0) {
            long totalTime = 6000L + this.mc.field_71441_e.func_72820_D();
            int dayNumber = (int)(totalTime / 24000L) + 1;
            int dayTimeSinceMidnight = (int)(totalTime % 24000L);
            int timeHours = dayTimeSinceMidnight / 1000;
            int minutes = (int)((double)(dayTimeSinceMidnight % 1000) / 1000.0 * 60.0);
            if ((settings.showTime - 1) % 2 == 0) {
                if (settings.showTime < 3) {
                    underText.add(I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d", dayNumber, timeHours, minutes));
                } else {
                    underText.add(String.format("%02d:%02d", timeHours, minutes));
                }
            } else {
                String half = "AM";
                if (timeHours >= 12) {
                    timeHours -= 12;
                    half = "PM";
                }
                if (timeHours == 0) {
                    timeHours = 12;
                }
                if (settings.showTime < 3) {
                    underText.add(I18n.func_135052_a((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d %s", dayNumber, timeHours, minutes, half));
                } else {
                    underText.add(String.format("%02d:%02d %s", timeHours, minutes, half));
                }
            }
        }
        if (minimap.getMinimapWriter().debugTotalTime) {
            underText.add(String.format("Min Time %d", minimap.getMinimapWriter().minTimeDebug));
            underText.add(String.format("Average %d", minimap.getMinimapWriter().averageTimeDebug));
            underText.add(String.format("Max Time %d", minimap.getMinimapWriter().maxTimeDebug));
        }
        if (settings.showAngles) {
            underText.add(String.format("%.1f / %.1f", Float.valueOf(MathHelper.func_76142_g((float)this.mc.func_175606_aa().field_70177_z)), Float.valueOf(MathHelper.func_76142_g((float)this.mc.func_175606_aa().field_70125_A))));
        }
        if (settings.lightOverlayType > 0) {
            underText.add(I18n.func_135052_a((String)"gui.xaero_light_overlay_status", (Object[])new Object[0]));
        }
        this.drawTextUnderMinimap(underText, scaledX, scaledY, height, size, mapScale, settings);
        GL11.glScalef((float)mapScale, (float)mapScale, (float)1.0f);
    }

    private void drawArrow(float angle, double arrowX, double arrowY, float r, float g, float b, float a, ModSettings settings) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)arrowX, (double)arrowY, (double)0.0);
        GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScaled((double)(0.5 * settings.arrowScale), (double)(0.5 * settings.arrowScale), (double)1.0);
        int offsetY = -6;
        int h = 28;
        int ty = 0;
        GL11.glTranslated((double)-13.0, (double)offsetY, (double)0.0);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        this.mc.field_71456_v.func_73729_b(0, 0, 49, ty, 26, h);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void drawTextUnderMinimap(ArrayList<String> underText, int scaledX, int scaledY, int height, int size, float mapScale, ModSettings settings) {
        int interfaceSize = size;
        int scaledHeight = (int)((float)height * mapScale);
        GlStateManager.func_179097_i();
        int align = settings.minimapTextAlign;
        for (int i = 0; i < underText.size(); ++i) {
            String s = underText.get(i);
            int stringWidth = this.mc.field_71466_p.func_78256_a(s);
            boolean under = scaledY + interfaceSize / 2 < scaledHeight / 2;
            int stringY = scaledY + (under ? interfaceSize : -9) + i * 10 * (under ? 1 : -1);
            int stringX = scaledX + (align == 0 ? interfaceSize / 2 - stringWidth / 2 : (align == 1 ? 6 : interfaceSize - 6 - stringWidth));
            Minecraft.func_71410_x().field_71466_p.func_175063_a(s, (float)stringX, (float)stringY, -1);
        }
        underText.clear();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    private float getSunBrightness() {
        return MathHelper.func_76131_a((float)this.mc.field_71441_e.getSunBrightnessFactor(1.0f), (float)0.0f, (float)1.0f);
    }
}

