/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.lwjgl.opengl.GL11;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.resource.EntityIconDefinition;

public class EntityIconManager {
    private EntityIconPrerenderer prerenderer;
    private Map<ResourceLocation, EntityIconDefinition> iconDefinitions;
    private Map<String, Integer> cachedTextures;
    private Map<String, Integer> cachedResourceTextures;
    private boolean canPrerender;
    private Gson gson;
    private StringBuilder entityStringBuilder;

    public EntityIconManager(EntityIconPrerenderer prerenderer) {
        this.prerenderer = prerenderer;
        this.iconDefinitions = new HashMap<ResourceLocation, EntityIconDefinition>();
        this.cachedTextures = new HashMap<String, Integer>();
        this.cachedResourceTextures = new HashMap<String, Integer>();
        this.gson = new Gson();
        this.resetResources();
        this.entityStringBuilder = new StringBuilder();
    }

    public <T extends Entity> int getEntityHeadTexture(T entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper, float scale, boolean[] spriteBased, boolean debug) {
        Method variantIdMethod;
        ResourceLocation entityId = EntityList.func_191301_a(entity);
        EntityIconDefinition iconDefinition = this.iconDefinitions.get(entityId);
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        Render entityRenderer = renderManager.func_78713_a(entity);
        String entityVariantString = null;
        if (iconDefinition != null && (variantIdMethod = iconDefinition.getVariantIdMethod()) != null) {
            try {
                entityVariantString = (String)variantIdMethod.invoke(null, entityRenderer, entity);
            }
            catch (Exception e) {
                System.out.println("Exception while using the variant ID method " + iconDefinition.getVariantIdMethodString() + " defined for " + entityId);
                e.printStackTrace();
                iconDefinition.setVariantIdMethod(null);
            }
        }
        if (entityVariantString == null) {
            entityVariantString = EntityIconDefinitions.getVariantString(entityRenderer, entity);
        }
        StringBuilder entityStringBuilder = this.entityStringBuilder;
        entityStringBuilder.setLength(0);
        entityStringBuilder.append(entityId).append("%").append(entityVariantString);
        String entityString = entityStringBuilder.toString();
        Integer cachedValue = this.cachedTextures.get(entityString);
        spriteBased[0] = false;
        if (cachedValue == null) {
            cachedValue = this.cachedResourceTextures.get(entityString);
            if (cachedValue == null) {
                ResourceLocation iconType = iconDefinition != null ? iconDefinition.getVariantType(entityVariantString) : EntityIconDefinition.MODEL_TYPE;
                if (iconType == EntityIconDefinition.MODEL_TYPE) {
                    if (this.canPrerender) {
                        cachedValue = this.prerenderer.prerender(entityRenderer, entity, defaultFramebuffer, helper, scale, debug);
                        this.cachedTextures.put(entityString, cachedValue);
                        if (cachedValue != -1) {
                            this.canPrerender = false;
                        }
                    } else {
                        cachedValue = -1;
                    }
                } else if (iconType == EntityIconDefinition.DOT_TYPE) {
                    cachedValue = -1;
                    this.cachedTextures.put(entityString, cachedValue);
                } else {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(iconType);
                    GL11.glTexParameteri((int)3553, (int)33085, (int)3);
                    GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                    GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
                    GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9985);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
                    GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
                    this.prerenderer.generateMipmaps();
                    cachedValue = GL11.glGetInteger((int)32873);
                    this.cachedResourceTextures.put(entityString, cachedValue);
                    spriteBased[0] = true;
                }
            } else {
                spriteBased[0] = true;
            }
        }
        return cachedValue;
    }

    public void reset() {
        for (Integer value : this.cachedTextures.values()) {
            if (value == null || value <= 0) continue;
            GL11.glDeleteTextures((int)value);
        }
        this.cachedTextures.clear();
        System.out.println("Entity icon manager reset!");
    }

    public void resetResources() {
        System.out.println("Reloading entity icon resources...");
        Set entityIds = ForgeRegistries.ENTITIES.getKeys();
        Gson gson = this.gson;
        int attempts = 5;
        for (int i = 0; i < attempts; ++i) {
            try {
                this.resetResourcesAttempt(gson, entityIds);
                break;
            }
            catch (IOException ioe) {
                if (i != attempts - 1) continue;
                throw new RuntimeException(ioe);
            }
        }
        System.out.println("Done!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetResourcesAttempt(Gson gson, Set<ResourceLocation> entityIds) throws IOException {
        this.cachedResourceTextures.clear();
        this.iconDefinitions.clear();
        for (ResourceLocation id : entityIds) {
            InputStream resourceInput = null;
            BufferedReader reader = null;
            String entityDefinitionJson = null;
            IResource resource = null;
            try {
                resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("xaerominimap", "entity/icon/definition/" + id.func_110624_b() + "/" + id.func_110623_a() + ".json"));
            }
            catch (FileNotFoundException fnfe) {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                if (resource == null) continue;
                resourceInput = resource.func_110527_b();
                reader = new BufferedReader(new InputStreamReader(resourceInput));
                final StringBuilder stringBuilder = new StringBuilder();
                reader.lines().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String line) {
                        stringBuilder.append(line);
                        stringBuilder.append('\n');
                    }
                });
                entityDefinitionJson = stringBuilder.toString();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (resourceInput == null) continue;
                resourceInput.close();
                continue;
            }
            try {
                EntityIconDefinition entityIconDefinition = (EntityIconDefinition)gson.fromJson(entityDefinitionJson, EntityIconDefinition.class);
                entityIconDefinition.onConstruct(id);
                this.iconDefinitions.put(id, entityIconDefinition);
            }
            catch (JsonSyntaxException jse) {
                System.out.println("Json syntax exception when loading the entity icon definition for " + id + ".");
                jse.printStackTrace();
            }
        }
    }

    public void allowPrerender() {
        this.canPrerender = true;
    }
}

