/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network.packet.server;

import io.netty.buffer.ByteBuf;
import jds.bibliocraft.items.ItemAtlas;
import jds.bibliocraft.network.packet.Utils;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BiblioAtlasWPT
implements IMessage {
    boolean toMapFrame;
    BlockPos pos;
    ItemStack atlasStack;

    public BiblioAtlasWPT() {
    }

    public BiblioAtlasWPT(boolean toMapFrame, BlockPos pos, ItemStack atlasStack) {
        this.toMapFrame = toMapFrame;
        this.pos = pos;
        this.atlasStack = atlasStack;
    }

    public void fromBytes(ByteBuf buf) {
        this.toMapFrame = buf.readBoolean();
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.atlasStack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.toMapFrame);
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.atlasStack);
    }

    public static class Handler
    implements IMessageHandler<BiblioAtlasWPT, IMessage> {
        public IMessage onMessage(BiblioAtlasWPT message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(() -> {
                TileEntity tile;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (Utils.hasPointLoaded(player, message.pos) && (tile = player.field_70170_p.func_175625_s(message.pos)) != null && tile instanceof TileEntityMapFrame && message.atlasStack != ItemStack.field_190927_a && message.atlasStack.func_77973_b() instanceof ItemAtlas) {
                    TileEntityMapFrame frameTile = (TileEntityMapFrame)tile;
                    if (message.toMapFrame) {
                        this.transferWaypointsToMapFrame(frameTile, message.atlasStack);
                        frameTile.func_145831_w().func_184138_a(frameTile.func_174877_v(), frameTile.func_145831_w().func_180495_p(frameTile.func_174877_v()), frameTile.func_145831_w().func_180495_p(frameTile.func_174877_v()), 3);
                    } else {
                        this.transferWaypointsToAtlas(frameTile, message.atlasStack, player);
                    }
                }
            });
            return null;
        }

        private void transferWaypointsToMapFrame(TileEntityMapFrame frameTile, ItemStack atlasStack) {
            InventoryBasic inv = Utils.getInventory(atlasStack);
            NBTTagCompound atlasTags = atlasStack.func_77978_p();
            ItemStack mapStack = Utils.getCurrentMapStack(atlasStack);
            if (atlasTags != null && inv != null && mapStack != ItemStack.field_190927_a && atlasTags.func_74764_b("maps")) {
                NBTTagList maps = atlasTags.func_150295_c("maps", 10);
                NBTTagCompound mapTag = null;
                String mapName = "Map_" + mapStack.func_77952_i();
                for (int n = 0; n < maps.func_74745_c(); ++n) {
                    mapTag = maps.func_150305_b(n);
                    if (mapTag == null || !mapTag.func_74764_b("mapName") || !mapTag.func_74779_i("mapName").contentEquals(mapName)) continue;
                    frameTile.addMapPinDataFromAtlas(mapTag);
                    for (int i = 0; i < frameTile.getRotation(); ++i) {
                        frameTile.rotateWaypoints();
                    }
                }
            }
        }

        private void transferWaypointsToAtlas(TileEntityMapFrame frameTile, ItemStack atlasStack, EntityPlayerMP player) {
            InventoryBasic inv = Utils.getInventory(atlasStack);
            ItemStack newMap = frameTile.func_70301_a(0);
            NBTTagCompound tags = atlasStack.func_77978_p();
            if (inv != null && tags != null) {
                String newMapName = "Map_" + newMap.func_77952_i();
                NBTTagList atlasMapsDatas = new NBTTagList();
                if (tags.func_74764_b("maps")) {
                    atlasMapsDatas = tags.func_150295_c("maps", 10);
                    for (int i = 0; i < atlasMapsDatas.func_74745_c(); ++i) {
                        String oldMap;
                        NBTTagCompound testTag = atlasMapsDatas.func_150305_b(i);
                        if (testTag == null || !testTag.func_74764_b("mapName") || !(oldMap = testTag.func_74779_i("mapName")).contentEquals(newMapName)) continue;
                        atlasMapsDatas.func_74744_a(i);
                    }
                }
                atlasMapsDatas.func_74742_a((NBTBase)Utils.getNewMapDataCompound(frameTile, newMapName));
                tags.func_74782_a("maps", (NBTBase)atlasMapsDatas);
                atlasStack.func_77982_d(tags);
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, atlasStack);
            }
        }
    }
}

