/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.gui.inventory;

import com.tiviacz.travelersbackpack.common.InventoryRecipesRegistry;
import com.tiviacz.travelersbackpack.gui.inventory.IInventoryTanks;
import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.util.FluidUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class InventoryActions {
    public static boolean transferContainerTank(IInventoryTanks inventory, FluidTank tank, int slotIn, EntityPlayer player) {
        ItemStack stackIn = inventory.func_70301_a(slotIn);
        int slotOut = slotIn + 1;
        ItemStack currentStackOut = inventory.func_70301_a(slotOut);
        if (tank == null || stackIn.func_190926_b()) {
            return false;
        }
        if (InventoryRecipesRegistry.hasStackInInventoryRecipeAndCanProcess(player, inventory, stackIn, tank, slotIn)) {
            return true;
        }
        if (stackIn.func_77973_b() != Items.field_151069_bo) {
            IFluidHandlerItem container;
            if (stackIn.func_77973_b() instanceof ItemPotion) {
                int amount = 250;
                FluidStack fluidStack = new FluidStack((Fluid)ModFluids.POTION, amount);
                FluidUtils.setFluidStackNBT(stackIn, fluidStack);
                if ((tank.getFluid() == null || FluidStack.areFluidStackTagsEqual((FluidStack)tank.getFluid(), (FluidStack)fluidStack)) && tank.getFluidAmount() + amount <= tank.getCapacity()) {
                    ItemStack bottle = new ItemStack(Items.field_151069_bo);
                    if (currentStackOut.func_190926_b() || currentStackOut.func_77973_b() == bottle.func_77973_b()) {
                        if (currentStackOut.func_77973_b() == bottle.func_77973_b()) {
                            if (currentStackOut.func_190916_E() + 1 > currentStackOut.func_77976_d()) {
                                return false;
                            }
                            bottle.func_190920_e(inventory.func_70301_a(slotOut).func_190916_E() + 1);
                        }
                        tank.fill(fluidStack, true);
                        inventory.func_70298_a(slotIn, 1);
                        inventory.func_70299_a(slotOut, bottle);
                        inventory.markTankDirty();
                        if (player != null) {
                            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, SoundEvents.field_187621_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                        return true;
                    }
                }
            }
            if ((container = FluidUtil.getFluidHandler((ItemStack)stackIn)) == null) {
                return false;
            }
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stackIn);
            if (fluid != null) {
                int amount = fluid.amount;
                if (amount <= 0) {
                    return false;
                }
                ItemStack stackOut = FluidUtil.tryEmptyContainer((ItemStack)stackIn, (IFluidHandler)tank, (int)amount, (EntityPlayer)player, (boolean)false).getResult();
                if (stackOut.func_190926_b()) {
                    return false;
                }
                if (tank.getFluidAmount() + amount > tank.getCapacity()) {
                    return false;
                }
                if (tank.getFluidAmount() > 0 && !tank.getFluid().isFluidEqual(fluid)) {
                    return false;
                }
                if (currentStackOut.func_190926_b() || currentStackOut.func_77973_b() == stackOut.func_77973_b()) {
                    if (currentStackOut.func_77973_b() == stackOut.func_77973_b()) {
                        if (currentStackOut.func_190916_E() + 1 > currentStackOut.func_77976_d()) {
                            return false;
                        }
                        stackOut.func_190920_e(currentStackOut.func_190916_E() + 1);
                    }
                    FluidUtil.tryEmptyContainer((ItemStack)stackIn, (IFluidHandler)tank, (int)amount, (EntityPlayer)player, (boolean)true);
                    inventory.func_70298_a(slotIn, 1);
                    inventory.func_70299_a(slotOut, stackOut);
                    inventory.markTankDirty();
                    return true;
                }
            }
        }
        if (tank.getFluid() == null || tank.getFluidAmount() <= 0) {
            return false;
        }
        if (stackIn.func_77973_b() == Items.field_151069_bo) {
            if (tank.getFluid().getFluid() == ModFluids.POTION && tank.getFluidAmount() >= 250) {
                ItemStack stackOut = FluidUtils.getItemStackFromFluidStack(tank.getFluid());
                if (currentStackOut.func_190926_b()) {
                    tank.drain(250, true);
                    inventory.func_70298_a(slotIn, 1);
                    inventory.func_70299_a(slotOut, stackOut);
                    inventory.markTankDirty();
                    if (player != null) {
                        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, SoundEvents.field_187621_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    return true;
                }
            }
        } else if (InventoryActions.isFluidEqual(stackIn, tank)) {
            if (tank.getFluid().getFluid() == ModFluids.POTION) {
                return false;
            }
            int amount = FluidUtil.getFluidHandler((ItemStack)stackIn).getTankProperties()[0].getCapacity();
            ItemStack stackOut = FluidUtil.tryFillContainer((ItemStack)stackIn, (IFluidHandler)tank, (int)amount, (EntityPlayer)player, (boolean)false).getResult();
            if (stackOut.func_190926_b()) {
                return false;
            }
            if (currentStackOut.func_190926_b() || currentStackOut.func_77973_b() == stackOut.func_77973_b()) {
                if (currentStackOut.func_77973_b() == stackOut.func_77973_b()) {
                    if (currentStackOut.func_190916_E() + 1 > currentStackOut.func_77976_d()) {
                        return false;
                    }
                    stackOut.func_190920_e(currentStackOut.func_190916_E() + 1);
                }
                FluidUtil.tryFillContainer((ItemStack)stackIn, (IFluidHandler)tank, (int)amount, (EntityPlayer)player, (boolean)true);
                inventory.func_70298_a(slotIn, 1);
                inventory.func_70299_a(slotOut, stackOut);
                inventory.markTankDirty();
                return true;
            }
        }
        return false;
    }

    private static boolean isFluidEqual(ItemStack stackIn, FluidTank tank) {
        if (FluidUtil.getFluidContained((ItemStack)stackIn) != null && FluidUtil.getFluidContained((ItemStack)stackIn).amount > 0) {
            return FluidUtil.getFluidContained((ItemStack)stackIn).isFluidEqual(tank.getFluid());
        }
        return FluidUtil.getFluidContained((ItemStack)stackIn) == null;
    }
}

