/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RandomHelper {
    public static final Random rand = new Random();

    public static int getRandomNumberBetween(int min, int max) {
        return RandomHelper.useRandomForNumberBetween(rand, min, max);
    }

    public static float getRandomNumberBetween(float min, float max) {
        return RandomHelper.useRandomForNumberBetween(rand, min, max);
    }

    public static int[] getRandomDistinctNumbersBetween(int min, int max, int numElements) {
        int i;
        int totalNumbers = max - min + 1;
        if (numElements < 1) {
            return new int[0];
        }
        if (numElements > totalNumbers) {
            numElements = totalNumbers;
        }
        int[] randomNumbers = new int[numElements];
        ArrayList<Integer> allNumbers = new ArrayList<Integer>(totalNumbers);
        for (i = 0; i < totalNumbers; ++i) {
            allNumbers.add(min + i);
        }
        for (i = 0; i < numElements; ++i) {
            randomNumbers[i] = (Integer)RandomHelper.getRandomElementFromList(allNumbers);
            allNumbers.remove(new Integer(randomNumbers[i]));
        }
        return randomNumbers;
    }

    public static int useRandomForNumberBetween(Random random, int min, int max) {
        return random.nextInt(Math.max(1, max - min + 1)) + min;
    }

    public static float useRandomForNumberBetween(Random random, float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static <T> T getRandomElementFromList(List<T> list) {
        return RandomHelper.getRandomElementFromCollection(list);
    }

    public static <T> T getRandomElementFromCollection(Collection<T> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        int index = rand.nextInt(collection.size());
        Iterator<T> iterator = collection.iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    public static <T> T getRandomElementFromArray(T[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array[RandomHelper.getRandomNumberBetween(0, array.length - 1)];
    }

    public static <T> T removeRandomElementFromList(List<T> list) {
        if (!list.isEmpty()) {
            return list.remove(RandomHelper.getRandomNumberBetween(0, list.size() - 1));
        }
        return null;
    }

    public static <T> T removeRandomElementFromCollection(Collection<T> collection) {
        T element = RandomHelper.getRandomElementFromCollection(collection);
        if (element != null) {
            collection.remove(element);
            return element;
        }
        return null;
    }

    public static boolean getRandomChance(double chance) {
        return rand.nextDouble() < chance;
    }

    public static boolean getRandomChance(float chance) {
        return rand.nextFloat() < chance;
    }

    public static boolean getRandomChance(int chance) {
        return RandomHelper.getRandomChance((float)chance / 100.0f);
    }

    public static boolean getRandomChance() {
        return RandomHelper.getRandomChance(0.5f);
    }

    public static boolean getRandomChance(Random random, int chance) {
        return random.nextFloat() < (float)chance / 100.0f;
    }

    public static int getFortuneAmount(int fortune) {
        return fortune > 0 ? Math.max(1, rand.nextInt(fortune + 2)) : 1;
    }

    public static void initXZSeed(Random random, World world, int chunkX, int chunkZ) {
        long seed = world == null ? 0L : world.func_72905_C();
        seed *= seed * 6364136223846793005L + 1442695040888963407L;
        seed += (long)chunkX;
        seed *= seed * 6364136223846793005L + 1442695040888963407L;
        seed += (long)chunkZ;
        seed *= seed * 6364136223846793005L + 1442695040888963407L;
        seed += (long)chunkX;
        seed *= seed * 6364136223846793005L + 1442695040888963407L;
        random.setSeed(seed += (long)chunkZ);
    }

    public static Random staticRandomWithXZSeed(World world, int chunkX, int chunkZ) {
        RandomHelper.initXZSeed(rand, world, chunkX, chunkZ);
        return rand;
    }

    public static int getRandomIndexFromWeights(List<Integer> weights) {
        int totalWeight = 0;
        for (Integer weight : weights) {
            totalWeight += weight.intValue();
        }
        if (totalWeight > 0) {
            int num = RandomHelper.getRandomNumberBetween(0, totalWeight - 1);
            int sum = 0;
            for (int i = 0; i < weights.size(); ++i) {
                if (num >= (sum += weights.get(i).intValue())) continue;
                return i;
            }
        }
        return -1;
    }

    public static Color getRandomHighSaturationColor() {
        return Color.getHSBColor(rand.nextFloat() * 360.0f, 1.0f, 1.0f);
    }

    public static Vec3d nextSpherePoint(double radius) {
        double theta = rand.nextDouble() * 2.0 * Math.PI;
        double phi = (rand.nextDouble() - 0.5) * Math.PI;
        double rad = rand.nextDouble() * radius;
        double x = rad * Math.cos(theta) * Math.cos(phi);
        double y = rad * Math.sin(phi);
        double z = rad * Math.sin(theta) * Math.cos(phi);
        return new Vec3d(x, y, z);
    }
}

