/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.exceptions.ShowdownImportException;
import com.pixelmonmod.pixelmon.api.pokemon.ImportExportForm;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.HiddenPower;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.FormData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.LakeTrioStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.MeltanStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.MewStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.MiniorStats;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public class ImportExportConverter {
    public static final String SPECIES_TEXT = "Pok\u00e9mon";
    public static final String GENDER_TEXT = "Gender";
    public static final String ABILITY_TEXT = "Ability";
    public static final String LEVEL_TEXT = "Level";
    public static final String SHINY_TEXT = "Shiny";
    public static final String HAPPINESS_TEXT = "Happiness";
    public static final String EV_TEXT = "EVs";
    public static final String NATURE_TEXT = "Nature";
    public static final String IV_TEXT = "IVs";
    public static final String POKE_BALL_TEXT = "Poke Ball";
    public static final String GROWTH_TEXT = "Growth";
    public static final String CLONES_TEXT = "Clones";
    public static final String RUBY_TEXT = "Rubies";
    public static final String MINIOR_CORE_TEXT = "MiniorCore";
    public static final String SMELT_TEXT = "Smelts";
    public static final String MOVE_TEXT = "Moves";
    public static final String[] STAT_TEXT = new String[]{"hp", "Atk", "Def", "SpA", "SpD", "Spe"};
    public static final char MALE_SYMBOL = 'M';
    public static final char FEMALE_SYMBOL = 'F';
    public static final String SHINY_YES = "Yes";
    private static Map<String, String> importNameMap;

    private ImportExportConverter() {
    }

    public static String getExportText(Pokemon data) {
        StringBuilder exportText = new StringBuilder();
        String exportName = ImportExportForm.getInstance().getFormName(data.getSpecies(), (short)data.getForm());
        String nickname = data.getNickname();
        if (nickname == null || nickname.equals(exportName)) {
            exportText.append(exportName);
        } else {
            exportText.append(nickname);
            exportText.append(" (");
            exportText.append(exportName);
            exportText.append(")");
        }
        if (data.getGender() != Gender.None) {
            exportText.append(" (");
            exportText.append(data.getGender() == Gender.Male ? (char)'M' : 'F');
            exportText.append(")");
        }
        if (!data.getHeldItem().func_190926_b()) {
            exportText.append(" @ ");
            exportText.append(I18n.func_150826_b((String)(data.getHeldItem().func_77977_a() + ".name")));
        }
        exportText.append("\n");
        ImportExportConverter.addColonSeparated(exportText, ABILITY_TEXT, ImportExportConverter.convertCamelCaseToWords(data.getAbilityName()));
        if (data.getLevel() != PixelmonServerConfig.maxLevel) {
            ImportExportConverter.addColonSeparated(exportText, LEVEL_TEXT, data.getLevel());
        }
        if (data.isShiny()) {
            ImportExportConverter.addColonSeparated(exportText, SHINY_TEXT, data.isShiny() ? SHINY_YES : "NO");
        }
        if (data.getFriendship() < 255) {
            ImportExportConverter.addColonSeparated(exportText, HAPPINESS_TEXT, data.getFriendship());
        }
        ImportExportConverter.writeStats(exportText, data.getEVs().getArray(), EV_TEXT, 0);
        exportText.append(data.getBaseNature().toString());
        exportText.append(" ");
        exportText.append(NATURE_TEXT);
        exportText.append("\n");
        ImportExportConverter.writeStats(exportText, data.getIVs().getArray(), IV_TEXT, 31);
        if (data.getCaughtBall() != EnumPokeballs.PokeBall) {
            ImportExportConverter.addColonSeparated(exportText, POKE_BALL_TEXT, data.getCaughtBall());
        }
        ImportExportConverter.addColonSeparated(exportText, GROWTH_TEXT, data.getGrowth());
        if (data.getExtraStats(MewStats.class) != null && data.getExtraStats(MewStats.class).numCloned > 0) {
            ImportExportConverter.addColonSeparated(exportText, CLONES_TEXT, data.getExtraStats(MewStats.class).numCloned);
        }
        if (data.getExtraStats(LakeTrioStats.class) != null && data.getExtraStats(LakeTrioStats.class).numEnchanted > 0) {
            ImportExportConverter.addColonSeparated(exportText, RUBY_TEXT, data.getExtraStats(LakeTrioStats.class).numEnchanted);
        }
        if (data.getExtraStats(MeltanStats.class) != null && data.getExtraStats(MeltanStats.class).oresSmelted > 0) {
            ImportExportConverter.addColonSeparated(exportText, SMELT_TEXT, data.getExtraStats(MeltanStats.class).oresSmelted);
        }
        if (data.getExtraStats(MiniorStats.class) != null) {
            ImportExportConverter.addColonSeparated(exportText, MINIOR_CORE_TEXT, data.getExtraStats(MiniorStats.class).color);
        }
        for (int i = 0; i < data.getMoveset().size(); ++i) {
            Attack attack;
            if (data.getMoveset().get(i) == null || (attack = data.getMoveset().get(i)) == null) continue;
            exportText.append("- ");
            exportText.append(attack.getMove().getAttackName());
            exportText.append("\n");
        }
        return exportText.toString();
    }

    public static void addLine(StringBuilder builder, String label) {
        builder.append(label);
        builder.append("\n");
    }

    public static void addColonSeparated(StringBuilder builder, String label, Object value) {
        builder.append(label);
        builder.append(": ");
        builder.append(value.toString());
        builder.append("\n");
    }

    private static String convertCamelCaseToWords(String text) {
        if (text == null || text.length() < 2) {
            return text;
        }
        StringBuilder newText = new StringBuilder();
        int textLength = text.length();
        for (int i = 0; i < textLength; ++i) {
            char currentChar = text.charAt(i);
            if (currentChar >= 'A' && currentChar <= 'Z' && i > 0 && i < textLength) {
                newText.append(' ');
            }
            newText.append(currentChar);
        }
        return newText.toString();
    }

    private static void writeStats(StringBuilder exportText, int[] statArray, String statType, int defaultValue) {
        boolean defaultStats = true;
        for (int stat : statArray) {
            if (stat == defaultValue) continue;
            defaultStats = false;
            break;
        }
        if (!defaultStats) {
            exportText.append(statType);
            exportText.append(": ");
            boolean hasPrevious = false;
            for (int i = 0; i < statArray.length; ++i) {
                if (statArray[i] == defaultValue) continue;
                if (hasPrevious) {
                    exportText.append(" / ");
                }
                exportText.append(statArray[i]);
                exportText.append(" ");
                exportText.append(STAT_TEXT[i]);
                hasPrevious = true;
            }
            exportText.append("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pokemon importText(String importText) throws ShowdownImportException {
        Gender gender = null;
        String speciesName = null;
        String nickname = "";
        int form = -2;
        int nationalPokedexNumber = -1;
        NoItem heldItem = NoItem.noItem;
        int friendship = -1;
        int[] ivs = new int[6];
        int[] evs = new int[6];
        String ability = null;
        Attack[] moves = new Attack[4];
        int numMoves = 0;
        EnumNature nature = null;
        int level = 0;
        boolean shiny = false;
        EnumGrowth growth = null;
        EnumPokeballs caughtBall = null;
        int numClones = -1;
        int miniorCore = -1;
        int numEnchants = -1;
        int numSmelts = -1;
        String[] importTextSplit = importText.split("\n");
        try {
            BaseStats stats;
            EnumSpecies species;
            int atIndex;
            int rightParenthesesIndex;
            String nextField;
            String currentLine = importTextSplit[0];
            int leftParenthesesIndex = currentLine.lastIndexOf(40);
            int genderIndex = -1;
            if (leftParenthesesIndex > -1 && (nextField = currentLine.substring(leftParenthesesIndex + 1, rightParenthesesIndex = currentLine.indexOf(41, leftParenthesesIndex)).trim()).length() == 1) {
                genderIndex = leftParenthesesIndex;
                char genderChar = nextField.charAt(0);
                if (genderChar == 'M') {
                    gender = Gender.Male;
                } else if (genderChar == 'F') {
                    gender = Gender.Female;
                } else {
                    throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.GENDER, "" + genderChar);
                }
                leftParenthesesIndex = currentLine.lastIndexOf(40, leftParenthesesIndex - 1);
            }
            if (leftParenthesesIndex > -1) {
                nickname = currentLine.substring(0, leftParenthesesIndex).trim();
                rightParenthesesIndex = currentLine.indexOf(41, leftParenthesesIndex);
                speciesName = currentLine.substring(leftParenthesesIndex + 1, rightParenthesesIndex);
                atIndex = currentLine.indexOf(64, rightParenthesesIndex);
            } else {
                atIndex = currentLine.indexOf(64);
                speciesName = genderIndex > -1 ? currentLine.substring(0, genderIndex) : (atIndex > -1 ? currentLine.substring(0, atIndex) : currentLine);
                nickname = "";
            }
            speciesName = speciesName.trim();
            Optional<FormData> formDataOptional = ImportExportForm.getInstance().getFormData(speciesName);
            if (formDataOptional.isPresent()) {
                FormData formData = formDataOptional.get();
                speciesName = formData.species.name;
                form = formData.form;
            } else {
                speciesName = speciesName.trim();
                speciesName = ImportExportConverter.convertName(speciesName);
            }
            try {
                species = EnumSpecies.getFromNameAnyCase(speciesName);
                stats = species.getBaseStats(species.getFormEnum(form));
            }
            catch (NullPointerException | NoSuchElementException e) {
                throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.SPECIES, currentLine);
            }
            nationalPokedexNumber = stats.getSpecies().getNationalPokedexInteger();
            if (atIndex > -1) {
                String heldItemName = currentLine.substring(atIndex + 1).trim();
                heldItem = PixelmonItems.getItemFromName(heldItemName);
            }
            friendship = -1;
            for (int i = 0; i < 6; ++i) {
                ivs[i] = 31;
            }
            boolean setIVs = false;
            for (int currentIndex = 1; currentIndex < importTextSplit.length; ++currentIndex) {
                currentLine = importTextSplit[currentIndex];
                if (ability == null && currentLine.startsWith(ABILITY_TEXT)) {
                    String parsedAbility = ImportExportConverter.getStringAfterColon(currentLine).replace(" ", "");
                    if (parsedAbility.equals("BattleArmor") || parsedAbility.equals("ShellArmor")) {
                        parsedAbility = parsedAbility.replaceAll("o", "ou");
                    }
                    if (parsedAbility.equals("BattleBond")) {
                        form = 1;
                        stats = species.getBaseStats(species.getFormEnum(form));
                    }
                    for (String testability : stats.getAbilitiesArray()) {
                        if (!parsedAbility.equals(testability)) continue;
                        ability = parsedAbility;
                        break;
                    }
                    if (ability != null) continue;
                    throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.ABILITY, currentLine);
                }
                if (level == 0 && currentLine.startsWith(LEVEL_TEXT)) {
                    try {
                        level = Integer.parseInt(ImportExportConverter.getStringAfterColon(currentLine));
                        continue;
                    }
                    finally {
                        if (level <= 0 || level > PixelmonServerConfig.maxLevel) {
                            level = 0;
                            throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.LEVEL, currentLine);
                        }
                    }
                }
                if (!shiny && currentLine.startsWith(SHINY_TEXT)) {
                    String shinyText = ImportExportConverter.getStringAfterColon(currentLine);
                    if (SHINY_YES.equals(shinyText)) {
                        shiny = true;
                        continue;
                    }
                    if ("No".equals(shinyText)) continue;
                    throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.SHINY, currentLine);
                }
                if (friendship == -1 && currentLine.startsWith(HAPPINESS_TEXT)) {
                    try {
                        friendship = Integer.parseInt(ImportExportConverter.getStringAfterColon(currentLine));
                        continue;
                    }
                    finally {
                        if (friendship < 0 || friendship > 255) {
                            throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.FRIENDSHIP, ImportExportConverter.getStringAfterColon(currentLine));
                        }
                    }
                }
                if (currentLine.startsWith(EV_TEXT)) {
                    ImportExportConverter.parseStats(currentLine, evs, (statValue, totalStats) -> {
                        int limitedStatValue = Math.max(0, Math.min(255, statValue));
                        return Math.min(limitedStatValue, 510 - totalStats);
                    });
                    continue;
                }
                if (nature == null && currentLine.trim().endsWith(NATURE_TEXT)) {
                    String natureText = currentLine.substring(0, currentLine.indexOf(32));
                    nature = EnumNature.natureFromString(natureText);
                    if (nature != null) continue;
                    throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.NATURE, currentLine);
                }
                if (currentLine.startsWith(IV_TEXT)) {
                    setIVs = true;
                    ImportExportConverter.parseStats(currentLine, ivs, (statValue, totalStats) -> Math.max(0, Math.min(31, statValue)));
                    continue;
                }
                if (caughtBall == null && currentLine.startsWith(POKE_BALL_TEXT)) {
                    try {
                        caughtBall = EnumPokeballs.valueOf(ImportExportConverter.getStringAfterColon(currentLine));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.CAUGHT_BALL, currentLine);
                    }
                }
                if (growth == null && currentLine.startsWith(GROWTH_TEXT)) {
                    growth = EnumGrowth.growthFromString(ImportExportConverter.getStringAfterColon(currentLine));
                    if (growth != null) continue;
                    throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.GROWTH, currentLine);
                }
                if (currentLine.startsWith(CLONES_TEXT)) {
                    numClones = Integer.parseInt(ImportExportConverter.getStringAfterColon(currentLine));
                    if (stats.getSpecies() == EnumSpecies.Mew && numClones >= 0 && numClones <= 3) continue;
                    throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.CLONES, currentLine);
                }
                if (currentLine.startsWith(RUBY_TEXT)) {
                    numEnchants = Integer.parseInt(ImportExportConverter.getStringAfterColon(currentLine));
                    if ((stats.getSpecies() == EnumSpecies.Azelf || stats.getSpecies() == EnumSpecies.Mesprit || stats.getSpecies() == EnumSpecies.Uxie) && numEnchants >= 0 && numEnchants <= PixelmonConfig.lakeTrioMaxEnchants) continue;
                    throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.RUBY, currentLine);
                }
                if (currentLine.startsWith(MINIOR_CORE_TEXT)) {
                    miniorCore = Integer.parseInt(ImportExportConverter.getStringAfterColon(currentLine));
                    if (stats.getSpecies() == EnumSpecies.Minior) continue;
                    throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.SPECIES, currentLine);
                }
                if (currentLine.startsWith(SMELT_TEXT)) {
                    numSmelts = Integer.parseInt(ImportExportConverter.getStringAfterColon(currentLine));
                    if (stats.getSpecies() == EnumSpecies.Meltan && numSmelts >= 0) continue;
                    throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.SMELTS, currentLine);
                }
                if (currentLine.isEmpty() || currentLine.charAt(0) != '-' || (currentLine = currentLine.trim()).length() <= 1) continue;
                if (numMoves >= 4) {
                    throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.ATTACKS, currentLine);
                }
                String moveText = currentLine.substring(1).trim();
                if ((moveText = ImportExportConverter.convertName(moveText)).contains("Hidden Power")) {
                    if (!setIVs) {
                        String typeText = moveText.replace("Hidden Power ", "").replace("[", "").replace("]", "");
                        EnumType hiddenPowerType = EnumType.parseType(typeText);
                        if (hiddenPowerType == null) {
                            throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.ATTACKS, currentLine);
                        }
                        ivs = HiddenPower.getOptimalIVs(hiddenPowerType).getArray();
                    }
                    moveText = "Hidden Power";
                }
                if (!Attack.hasAttack(moveText)) {
                    throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.ATTACKS, currentLine);
                }
                Attack move = new Attack(moveText);
                moves[numMoves++] = move;
            }
            if (ability == null) {
                ability = species.getBaseStats().getAbilitiesArray()[0];
            }
            if (numMoves == 0) {
                throw new ShowdownImportException(ShowdownImportException.ShowdownFieldType.ATTACKS, "No moves");
            }
            if (gender == null) {
                gender = Gender.getRandomGender(stats);
            }
            if (level == 0) {
                level = PixelmonServerConfig.maxLevel;
            }
            if (friendship == -1) {
                friendship = 255;
            }
            if (nature == null) {
                nature = EnumNature.Hardy;
            }
            if (caughtBall == null) {
                caughtBall = EnumPokeballs.PokeBall;
            }
            if (growth == null) {
                growth = EnumGrowth.Ordinary;
            }
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException | NoSuchElementException e) {
            e.printStackTrace();
            return null;
        }
        Pokemon pokemon = Pixelmon.pokemonFactory.create(EnumSpecies.getFromNameAnyCase(speciesName));
        pokemon.setForm(form);
        pokemon.setGender(gender);
        pokemon.setGrowth(growth);
        pokemon.setNickname(nickname);
        pokemon.setLevel(level);
        pokemon.setHeldItem(heldItem == null ? ItemStack.field_190927_a : new ItemStack((Item)heldItem));
        pokemon.setAbility(ability);
        pokemon.setShiny(shiny);
        pokemon.setFriendship(friendship);
        pokemon.getMoveset().clear();
        pokemon.getMoveset().addAll(Arrays.asList(moves));
        pokemon.getEVs().fillFromArray(evs);
        pokemon.getIVs().fillFromArray(ivs);
        pokemon.setNature(nature);
        if (pokemon.getSpecies() == EnumSpecies.Mew) {
            pokemon.getExtraStats(MewStats.class).numCloned = numClones;
        }
        if (pokemon.getSpecies() == EnumSpecies.Azelf || pokemon.getSpecies() == EnumSpecies.Mesprit || pokemon.getSpecies() == EnumSpecies.Uxie) {
            pokemon.getExtraStats(LakeTrioStats.class).numEnchanted = numEnchants;
        }
        if (pokemon.getSpecies() == EnumSpecies.Meltan) {
            pokemon.getExtraStats(MeltanStats.class).oresSmelted = numSmelts;
        }
        return pokemon;
    }

    public static int getIntAfterColon(String string) {
        return Integer.parseInt(ImportExportConverter.getStringAfterColon(string));
    }

    public static String getStringAfterColon(String string) {
        return string.substring(string.indexOf(58) + 1).trim();
    }

    private static void parseStats(String statString, int[] statArray, StatValidator validator) {
        String[] splitStats = ImportExportConverter.getStringAfterColon(statString).split("\\/");
        int totalStats = 0;
        for (String stat : splitStats) {
            stat = stat.trim();
            String statType = stat.substring(stat.lastIndexOf(32) + 1, stat.length());
            for (int i = 0; i < STAT_TEXT.length; ++i) {
                if (!STAT_TEXT[i].equalsIgnoreCase(statType)) continue;
                int statAmount = Integer.parseInt(stat.substring(0, stat.indexOf(32)));
                statArray[i] = statAmount = validator.validateStat(statAmount, totalStats);
                totalStats += statAmount;
            }
        }
    }

    private static String convertName(String nameText) {
        importNameMap = null;
        if (importNameMap == null) {
            ImportExportConverter.initializeNameMap();
        }
        return importNameMap.containsKey(nameText) ? importNameMap.get(nameText) : nameText;
    }

    private static void initializeNameMap() {
        importNameMap = new HashMap<String, String>();
        importNameMap.put("Mime Jr.", "Mime_Jr.");
        importNameMap.put("Mr. Mime", "MrMime");
        importNameMap.put("Nidoran-F", "Nidoranfemale");
        importNameMap.put("Nidoran-M", "Nidoranmale");
        importNameMap.put("AncientPower", "Ancient Power");
        importNameMap.put("BubbleBeam", "Bubble Beam");
        importNameMap.put("DoubleSlap", "Double Slap");
        importNameMap.put("DragonBreath", "Dragon Breath");
        importNameMap.put("DynamicPunch", "Dynamic Punch");
        importNameMap.put("ExtremeSpeed", "Extreme speed");
        importNameMap.put("FeatherDance", "Feather Dance");
        importNameMap.put("Faint attack", "Feint attack");
        importNameMap.put("GrassWhistle", "Grass Whistle");
        importNameMap.put("Hi Jump Kick", "High Jump Kick");
        importNameMap.put("Sand-attack", "Sand attack");
        importNameMap.put("Selfdestruct", "Self-Destruct");
        importNameMap.put("SmellingSalt", "Smelling Salts");
        importNameMap.put("SmokeScreen", "Smokescreen");
        importNameMap.put("Softboiled", "Soft-Boiled");
        importNameMap.put("SolarBeam", "Solar Beam");
        importNameMap.put("SonicBoom", "Sonic Boom");
        importNameMap.put("ThunderShock", "Thunder Shock");
        importNameMap.put("U-Turn", "U-turn");
    }

    private static interface StatValidator {
        public int validateStat(int var1, int var2);
    }
}

