/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.recipe;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.enums.EnumBerry;
import com.pixelmonmod.pixelmon.items.ItemJuiceShoppe;
import com.pixelmonmod.pixelmon.items.heldItems.ItemBerry;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import org.apache.commons.lang3.tuple.Pair;

public class InfuserRecipes {
    private static final InfuserRecipes INFUSER_BASE = new InfuserRecipes();
    private final Map<Tuple<ItemStack, ItemStack>, Tuple<ItemStack, Integer>> resultsList = Maps.newHashMap();

    public static InfuserRecipes instance() {
        return INFUSER_BASE;
    }

    void addRecipeForIngredients(ItemStack ingredient1, ItemStack ingredient2, int ticks, ItemStack itemStack) {
        this.resultsList.put((Tuple<ItemStack, ItemStack>)new Tuple((Object)ingredient1, (Object)ingredient2), (Tuple<ItemStack, Integer>)new Tuple((Object)itemStack, (Object)ticks));
    }

    public Pair<Tuple<ItemStack, ItemStack>, Tuple<ItemStack, Integer>> getRecipe(ItemStack stack1, ItemStack stack2) {
        if (PixelmonConfig.berryJuiceCrafting && stack1.func_77973_b() instanceof ItemBerry && stack2.func_77973_b() instanceof ItemBerry) {
            EnumBerry essence = ((ItemBerry)stack1.func_77973_b()).getBerry();
            EnumBerry solvent = ((ItemBerry)stack2.func_77973_b()).getBerry();
            if (essence.color == solvent.color) {
                Item juice = null;
                switch (essence.color) {
                    case RED: {
                        juice = PixelmonItems.redJuice;
                        break;
                    }
                    case PURPLE: {
                        juice = PixelmonItems.purpleJuice;
                        break;
                    }
                    case PINK: {
                        juice = PixelmonItems.pinkJuice;
                        break;
                    }
                    case GREEN: {
                        juice = PixelmonItems.greenJuice;
                        break;
                    }
                    case YELLOW: {
                        juice = PixelmonItems.yellowJuice;
                        break;
                    }
                    case BLUE: {
                        juice = PixelmonItems.blueJuice;
                    }
                }
                NBTTagCompound base = new NBTTagCompound();
                base.func_74768_a("Stats_Boost", ItemJuiceShoppe.getJuiceTag(essence, solvent));
                ItemStack juiceStack = new ItemStack(juice, 1, 0);
                juiceStack.func_77982_d(base);
                return Pair.of((Object)new Tuple((Object)new ItemStack(stack1.func_77973_b()), (Object)new ItemStack(stack2.func_77973_b())), (Object)new Tuple((Object)juiceStack, (Object)200));
            }
            NBTTagCompound base = new NBTTagCompound();
            base.func_74768_a("Stats_Boost", this.getShakeTag(essence, solvent));
            ItemStack shakeStack = new ItemStack(PixelmonItems.colorfulShake, 1, 0);
            shakeStack.func_77982_d(base);
            return Pair.of((Object)new Tuple((Object)new ItemStack(stack1.func_77973_b()), (Object)new ItemStack(stack2.func_77973_b())), (Object)new Tuple((Object)shakeStack, (Object)200));
        }
        for (Map.Entry<Tuple<ItemStack, ItemStack>, Tuple<ItemStack, Integer>> s : this.resultsList.entrySet()) {
            if (!((ItemStack)s.getKey().func_76341_a()).func_77969_a(stack1) || stack1.func_190916_E() < ((ItemStack)s.getKey().func_76341_a()).func_190916_E() || !((ItemStack)s.getKey().func_76340_b()).func_77969_a(stack2) || stack2.func_190916_E() < ((ItemStack)s.getKey().func_76340_b()).func_190916_E()) continue;
            return Pair.of(s.getKey(), s.getValue());
        }
        return null;
    }

    private int getShakeTag(EnumBerry essence, EnumBerry solvent) {
        if (essence.juiceGroup == 1) {
            switch (solvent.juiceGroup) {
                case 1: {
                    return 12;
                }
                case 2: {
                    return 16;
                }
                case 3: {
                    return 24;
                }
            }
        }
        if (essence.juiceGroup == 2) {
            switch (solvent.juiceGroup) {
                case 1: {
                    return 16;
                }
                case 2: {
                    return 24;
                }
                case 3: {
                    return 32;
                }
            }
        }
        if (essence.juiceGroup == 3) {
            switch (solvent.juiceGroup) {
                case 1: {
                    return 24;
                }
                case 2: 
                case 3: {
                    return 32;
                }
            }
        }
        return 10;
    }

    public boolean isValidEssence(ItemStack stack) {
        for (Tuple<ItemStack, ItemStack> in : this.resultsList.keySet()) {
            if (!((ItemStack)in.func_76341_a()).func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidSolvent(ItemStack stack) {
        for (Tuple<ItemStack, ItemStack> in : this.resultsList.keySet()) {
            if (!((ItemStack)in.func_76340_b()).func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }
}

